/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.qubership.atp.ram.dto.response.LabelNodeReportResponse;
import org.qubership.atp.ram.entities.treenodes.labelparams.ReportLabelParam;
import org.qubership.atp.ram.entities.treenodes.labelparams.TestingReportLabelParam;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.models.Comment;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.utils.StreamUtils;
import org.qubership.atp.ram.utils.Utils;

public class TestCaseWidgetCsvExportLine {
    public static final String DASH = "-";
    private List<String> cells = new ArrayList<String>();

    public TestCaseWidgetCsvExportLine(LabelNodeReportResponse node, List<String> validationLabels, Map<String, Boolean> columnVisibilityMap, int depth) {
        this.add("NAME", this.name(node, LabelNodeReportResponse::getLabelName, depth), columnVisibilityMap);
        this.add("STATUS", this.getStatus(() -> ((LabelNodeReportResponse)node).getStatus()), columnVisibilityMap);
        this.add("PASSED RATE", DASH, columnVisibilityMap);
        this.add("ISSUE", DASH, columnVisibilityMap);
        this.add("DURATION", this.getDuration(() -> ((LabelNodeReportResponse)node).getDuration()), columnVisibilityMap);
        this.add("FAILURE REASON", DASH, columnVisibilityMap);
        this.add("FAILED STEP", DASH, columnVisibilityMap);
        this.add("LABELS", DASH, columnVisibilityMap);
        this.add("DATA SET", DASH, columnVisibilityMap);
        this.add("JIRA TICKET", DASH, columnVisibilityMap);
        this.add("COMMENT", DASH, columnVisibilityMap);
        this.setValidationLabels(node.getLabelParams(), validationLabels);
    }

    public TestCaseWidgetCsvExportLine(LabelNodeReportResponse.TestRunNodeResponse node, List<String> validationLabels, Map<String, Boolean> columnVisibilityMap, int depth) {
        this.add("NAME", this.name(node, LabelNodeReportResponse.TestRunNodeResponse::getName, depth), columnVisibilityMap);
        this.add("STATUS", this.getStatus(() -> ((LabelNodeReportResponse.TestRunNodeResponse)node).getTestingStatus()), columnVisibilityMap);
        this.add("PASSED RATE", this.percent(node.getPassedRate()), columnVisibilityMap);
        this.add("ISSUE", this.join(node.getIssues()), columnVisibilityMap);
        this.add("DURATION", this.getDuration(() -> ((LabelNodeReportResponse.TestRunNodeResponse)node).getDuration()), columnVisibilityMap);
        this.add("FAILURE REASON", node.getFailureReason(), columnVisibilityMap);
        this.add("FAILED STEP", this.join(node.getFailedStep(), LabelNodeReportResponse.FailedLogRecordNodeResponse::getName), columnVisibilityMap);
        this.add("LABELS", this.join(node.getLabels(), RamObject::getName), columnVisibilityMap);
        this.add("DATA SET", node.getDataSetName(), columnVisibilityMap);
        this.add("JIRA TICKET", node.getJiraTicket(), columnVisibilityMap);
        this.add("COMMENT", this.get(node.getComment(), Comment::getText), columnVisibilityMap);
        this.setValidationLabels(node.getLabelParams(), validationLabels);
    }

    private void add(String columnName, String cellValue, Map<String, Boolean> columnVisibilityMap) {
        if (this.isColumnVisible(columnName, columnVisibilityMap)) {
            this.cells.add(cellValue);
        }
    }

    private boolean isColumnVisible(String columnName, Map<String, Boolean> columnVisibilityMap) {
        return columnVisibilityMap.getOrDefault(columnName, true);
    }

    private <T> String name(T node, Function<T, String> func, int depth) {
        return IntStream.range(0, depth).mapToObj(num -> "    ").collect(Collectors.joining("", "", func.apply(node)));
    }

    private <T> String get(T entity, Function<T, String> func) {
        if (Objects.nonNull(entity)) {
            return func.apply(entity);
        }
        return DASH;
    }

    private String percent(int value) {
        return String.valueOf(value).concat("%");
    }

    private String join(Collection<String> entities) {
        if (CollectionUtils.isNotEmpty(entities)) {
            return String.join((CharSequence)", ", entities);
        }
        return DASH;
    }

    private <T> String join(Collection<T> entities, Function<T, String> func) {
        if (CollectionUtils.isNotEmpty(entities)) {
            return entities.stream().map(func).collect(Collectors.joining(", "));
        }
        return DASH;
    }

    private String getStatus(Supplier<TestingStatuses> statusSupplier) {
        TestingStatuses status = statusSupplier.get();
        return Objects.isNull(status) ? DASH : status.getName();
    }

    private String getDuration(Supplier<Long> durationSupplier) {
        long duration = durationSupplier.get();
        if (duration != 0L) {
            return DurationFormatUtils.formatDuration((long)(duration * 1000L), (String)"HH:mm:ss", (boolean)true);
        }
        return DASH;
    }

    public String[] getContent() {
        return this.cells.toArray(new String[0]);
    }

    public void setValidationLabels(List<TestingReportLabelParam> labelParams, List<String> validationLabels) {
        Map<String, TestingReportLabelParam> paramsMap = StreamUtils.toEntityMap(labelParams, ReportLabelParam::getName);
        HashSet ignoredLabels = new HashSet();
        validationLabels.forEach(validationLabel -> {
            if (paramsMap.containsKey(validationLabel)) {
                TestingReportLabelParam labelParam = (TestingReportLabelParam)paramsMap.get(validationLabel);
                this.cells.add(labelParam.getStatus().getName());
                this.addErArColumns(labelParam, ignoredLabels);
            } else if (!ignoredLabels.contains(validationLabel)) {
                this.cells.add(DASH);
            }
        });
    }

    private void addErArColumns(TestingReportLabelParam param, Set<String> ignoredLabels) {
        String expectedResult = Utils.cleanXmlTags(param.getExpectedResult());
        String actualResult = Utils.cleanXmlTags(param.getActualResult());
        boolean isExpectedResultPresent = Objects.nonNull(expectedResult);
        boolean isActualResultPresent = Objects.nonNull(actualResult);
        if (isExpectedResultPresent || isActualResultPresent) {
            this.cells.add(Objects.nonNull(expectedResult) ? expectedResult : DASH);
            ignoredLabels.add(param.getName() + "-[ER]");
            this.cells.add(Objects.nonNull(actualResult) ? actualResult : DASH);
            ignoredLabels.add(param.getName() + "-[AR]");
        }
    }
}

