/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.models.Issue;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.data.mongodb.repository.Update;
import org.springframework.stereotype.Repository;

@Repository
public interface IssueRepository
extends MongoRepository<Issue, UUID> {
    public List<Issue> findByExecutionRequestId(UUID var1);

    @Query(fields="{'_id': 1, 'logRecordIds': 1}")
    public List<Issue> findShortByExecutionRequestId(UUID var1);

    public List<Issue> findByExecutionRequestIdAndFailPatternIdIn(UUID var1, Collection<UUID> var2);

    public List<Issue> findByExecutionRequestIdAndFailedTestRunIdsIn(UUID var1, Collection<UUID> var2);

    public List<Issue> findByFailPatternIdAndExecutionRequestId(UUID var1, UUID var2);

    public List<Issue> findByFailPatternId(UUID var1);

    @Query(value="{failPatternId: ?0 }")
    @Update(value="{ '$set' : { priority: null, failPatternId: null, failReasonId:  null} }")
    public void updateByRemovedPatternId(UUID var1);

    public long countByExecutionRequestId(UUID var1);

    public long countBylogRecordIds(UUID var1);

    public void deleteAllByExecutionRequestIdIn(List<UUID> var1);
}

