/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.List;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpEntityNotFoundException;
import org.qubership.atp.auth.springbootstarter.utils.ReflectionUtils;
import org.qubership.atp.ram.models.RamObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.repository.MongoRepository;

public abstract class CrudService<T extends RamObject> {
    private static final Logger log = LoggerFactory.getLogger(CrudService.class);

    protected abstract MongoRepository<T, UUID> repository();

    public T get(UUID id) {
        return (T)((RamObject)this.repository().findById((Object)id).orElseThrow(() -> {
            String entityName = ReflectionUtils.getGenericClassSimpleName((Object)this);
            log.error("Failed to found {} entity with id: {}", (Object)entityName, (Object)id);
            return new AtpEntityNotFoundException(entityName, (Object)id);
        }));
    }

    public T save(T object) {
        return (T)((RamObject)this.repository().save(object));
    }

    public List<T> getAll() {
        return this.repository().findAll();
    }

    public List<T> saveAll(List<T> objects) {
        return this.repository().saveAll(objects);
    }
}

