/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.List;
import java.util.UUID;
import org.modelmapper.ModelMapper;
import org.qubership.atp.ram.client.DataSetFeignClient;
import org.qubership.atp.ram.converter.DtoConvertService;
import org.qubership.atp.ram.model.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DataSetService {
    private static final Logger log = LoggerFactory.getLogger(DataSetService.class);
    private DataSetFeignClient dataSetFeignClient;

    public DataSetService(DataSetFeignClient dataSetFeignClient) {
        this.dataSetFeignClient = dataSetFeignClient;
    }

    public List<DataSet> getDataSetsByIds(List<UUID> ids) {
        List<DataSet> dataSet = new DtoConvertService(new ModelMapper()).convertList((List)this.dataSetFeignClient.getDataSetsByIds(ids).getBody(), DataSet.class);
        log.debug("Get dataset: {} by id {}", dataSet, ids);
        return dataSet;
    }
}

