/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ram.models.Defect;
import org.qubership.atp.ram.repositories.DefectsRepository;
import org.qubership.atp.ram.services.CrudService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;

@Service
public class DefectsService
extends CrudService<Defect> {
    private static final Logger log = LoggerFactory.getLogger(DefectsService.class);
    private static final Logger LOG = LoggerFactory.getLogger(DefectsService.class);
    private final DefectsRepository repository;

    @Override
    protected MongoRepository<Defect, UUID> repository() {
        return this.repository;
    }

    @Override
    public List<Defect> getAll() {
        return this.repository.findAll();
    }

    public List<Defect> getDefectsByProjectUuid(UUID projectUuid) {
        return this.repository.findAllByProjectId(projectUuid);
    }

    public UUID getProjectIdByDefectId(UUID id) {
        return this.repository.findProjectIdByUuid(id).getProjectId();
    }

    public Set<UUID> getSetProjectIdByListDefectId(List<UUID> idList) {
        return idList.stream().map(this::getProjectIdByDefectId).collect(Collectors.toSet());
    }

    public Defect getByUuid(UUID defectUuid) {
        return this.repository.findByUuid(defectUuid);
    }

    public void deleteByUuid(UUID uuid) {
        this.repository.deleteByUuid(uuid);
    }

    public DefectsService(DefectsRepository repository) {
        this.repository = repository;
    }
}

