/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.UUID;
import org.qubership.atp.ram.dto.event.ExecutionRequestEvent;
import org.qubership.atp.ram.dto.event.WebSocketEventType;
import org.qubership.atp.ram.dto.request.StatusUpdateRequest;
import org.qubership.atp.ram.dto.response.StatusUpdateResponse;
import org.qubership.atp.ram.services.TestRunService;
import org.qubership.atp.ram.services.WebSocketNotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExecutionRequestNotificationService {
    private static final Logger log = LoggerFactory.getLogger(ExecutionRequestNotificationService.class);
    private final WebSocketNotificationService notificationService;
    private final TestRunService testRunService;

    public void sendStatusUpdate(UUID executionRequestId, StatusUpdateRequest request) {
        log.info("Send status update event for execution request '{}' with filter: {}", (Object)executionRequestId, (Object)request);
        StatusUpdateResponse statusUpdateResponse = this.testRunService.getStatusUpdate(request);
        ExecutionRequestEvent event = new ExecutionRequestEvent(WebSocketEventType.EXECUTION_REQUEST_STATUS_UPDATE, executionRequestId, (Object)statusUpdateResponse);
        log.debug("Event: {}", (Object)event);
        this.notificationService.sendEvent(event);
    }

    public ExecutionRequestNotificationService(WebSocketNotificationService notificationService, TestRunService testRunService) {
        this.notificationService = notificationService;
        this.testRunService = testRunService;
    }
}

