/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.models.ExecutionRequestReporting;
import org.qubership.atp.ram.repositories.ExecutionRequestReportingRepository;
import org.qubership.atp.ram.services.CrudService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExecutionRequestReportingService
extends CrudService<ExecutionRequestReporting> {
    private static final Logger log = LoggerFactory.getLogger(ExecutionRequestReportingService.class);
    private static final String E_MAIL_REPORTING = "E-mail Reporting";
    private final ExecutionRequestReportingRepository reportingRepository;

    @Override
    protected MongoRepository<ExecutionRequestReporting, UUID> repository() {
        return this.reportingRepository;
    }

    public ExecutionRequestReporting createReporting(UUID executionRequestId, ExecutionRequestReporting reporting) {
        log.debug("Create email reporting for execution request with id '{}'", (Object)reporting.getExecutionRequestId());
        reporting.setUuid(UUID.randomUUID());
        reporting.setName(E_MAIL_REPORTING);
        reporting.setExecutionRequestId(executionRequestId);
        ExecutionRequestReporting savedReporting = (ExecutionRequestReporting)this.reportingRepository.save(reporting);
        log.debug("Email reporting for execution request successfully created");
        return savedReporting;
    }

    public ExecutionRequestReporting getReporting(UUID executionRequestId) {
        return this.reportingRepository.findByExecutionRequestId(executionRequestId);
    }

    public List<ExecutionRequestReporting> getEmailReportings(Collection<UUID> executionRequestIds) {
        return this.reportingRepository.findByExecutionRequestIdIn(executionRequestIds);
    }

    public Set<String> getEmailRecipients(Collection<UUID> executionRequestIds) {
        List<ExecutionRequestReporting> reportings = this.getEmailReportings(executionRequestIds);
        if (!CollectionUtils.isEmpty(reportings)) {
            return reportings.stream().flatMap(emailReporting -> emailReporting.getRecipients().stream()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public ExecutionRequestReporting updateReportingStatus(UUID executionRequestId, TestingStatuses testingStatuses) {
        ExecutionRequestReporting executionRequestReporting = this.reportingRepository.findByExecutionRequestId(executionRequestId);
        if (Objects.nonNull(executionRequestReporting)) {
            log.debug("Update reporting section for ER {}, new status {}", (Object)executionRequestId, (Object)testingStatuses);
            executionRequestReporting.setStatus(testingStatuses);
            return (ExecutionRequestReporting)this.reportingRepository.save(executionRequestReporting);
        }
        log.warn("Reporting section for ER {} is null", (Object)executionRequestId);
        return null;
    }

    private List<String> getRecipientsFromString(String recipients) {
        return Arrays.asList(recipients.split(","));
    }

    public ExecutionRequestReporting updateReportingInfo(UUID executionRequestId, String subject, String recipients) {
        ExecutionRequestReporting executionRequestReporting = this.reportingRepository.findByExecutionRequestId(executionRequestId);
        if (Objects.nonNull(executionRequestReporting)) {
            executionRequestReporting.setSubject(subject);
            executionRequestReporting.setRecipients(this.getRecipientsFromString(recipients));
            log.debug("Update reporting section for ER {}, new subject {}, new recipients {}", new Object[]{executionRequestId, subject, recipients});
            return (ExecutionRequestReporting)this.reportingRepository.save(executionRequestReporting);
        }
        log.warn("Reporting section for ER {} is null", (Object)executionRequestId);
        return null;
    }

    public void deleteAllByExecutionRequestDetailsIdIn(List<UUID> executionRequestIds) {
        this.reportingRepository.deleteAllByExecutionRequestIdIn(executionRequestIds);
    }

    public ExecutionRequestReportingService(ExecutionRequestReportingRepository reportingRepository) {
        this.reportingRepository = reportingRepository;
    }
}

