/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ram.models.GlobalAkbRecord;
import org.qubership.atp.ram.models.RootCause;
import org.qubership.atp.ram.repositories.GlobalAkbRecordsRepository;
import org.qubership.atp.ram.services.CrudService;
import org.qubership.atp.ram.services.RootCauseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;

@Service
public class GlobalAkbRecordsService
extends CrudService<GlobalAkbRecord> {
    private static final Logger log = LoggerFactory.getLogger(GlobalAkbRecordsService.class);
    private final RootCauseService rootCauseService;
    private final GlobalAkbRecordsRepository recordsRepository;

    @Override
    protected MongoRepository<GlobalAkbRecord, UUID> repository() {
        return this.recordsRepository;
    }

    public List<GlobalAkbRecord> getAllWithRootCauseName() {
        List allGlobalAkbRecords = this.getAll();
        List<RootCause> allRootCauses = this.rootCauseService.getAllRootCauses();
        return allGlobalAkbRecords.stream().map(globalAkbRecord -> this.replaceRootCauseIdWithName((GlobalAkbRecord)globalAkbRecord, allRootCauses)).collect(Collectors.toList());
    }

    private GlobalAkbRecord replaceRootCauseIdWithName(GlobalAkbRecord globalAkbRecord, List<RootCause> allRootCauses) {
        for (RootCause cause : allRootCauses) {
            if (!cause.getUuid().equals(globalAkbRecord.getRootCauseId())) continue;
            globalAkbRecord.setRootCauseId(cause.getUuid());
            return globalAkbRecord;
        }
        globalAkbRecord.setRootCauseId(null);
        return globalAkbRecord;
    }

    public void deleteByUuid(UUID uuid) {
        this.recordsRepository.deleteByUuid(uuid);
    }

    public GlobalAkbRecord findByUuid(UUID uuid) {
        return this.recordsRepository.findByUuid(uuid);
    }

    public UUID getProjectIdByGlobalAkbRecordId(UUID uuid) {
        GlobalAkbRecord globalAkbRecord = this.recordsRepository.findByUuid(uuid);
        RootCause rootCause = (RootCause)this.rootCauseService.get(globalAkbRecord.getRootCauseId());
        return rootCause.getProjectId();
    }

    public UUID getProjectIdByGlobalAkbRecord(GlobalAkbRecord globalAkbRecord) {
        RootCause rootCause = (RootCause)this.rootCauseService.get(globalAkbRecord.getRootCauseId());
        return rootCause.getProjectId();
    }

    public GlobalAkbRecordsService(RootCauseService rootCauseService, GlobalAkbRecordsRepository recordsRepository) {
        this.rootCauseService = rootCauseService;
        this.recordsRepository = recordsRepository;
    }
}

