/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpIllegalNullableArgumentException;
import org.qubership.atp.auth.springbootstarter.utils.ExceptionUtils;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.exceptions.labeltemplates.RamLabelTemplateInconsistentLabelsPathGapException;
import org.qubership.atp.ram.exceptions.labeltemplates.RamLabelTemplateMultipleOneLevelNodeInclusionException;
import org.qubership.atp.ram.exceptions.labeltemplates.RamLabelTemplateWithoutChildrenNodesException;
import org.qubership.atp.ram.models.LabelTemplate;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.models.WidgetConfigTemplate;
import org.qubership.atp.ram.services.CatalogueService;
import org.qubership.atp.ram.services.WidgetConfigTemplateService;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LabelTemplateNodeService {
    private static final Logger log = LoggerFactory.getLogger(LabelTemplateNodeService.class);
    private final CatalogueService catalogueService;
    private final WidgetConfigTemplateService widgetConfigTemplateService;

    public LabelTemplate populateLabelTemplateWithTestRuns(List<TestRun> testRuns, UUID labelTemplateId) {
        LabelTemplate labelTemplate = this.getLabelTemplate(labelTemplateId);
        return this.populateLabelTemplateWithTestRuns(testRuns, labelTemplate);
    }

    public LabelTemplate populateLabelTemplateWithTestRuns(List<TestRun> testRuns, LabelTemplate labelTemplate) {
        Set<UUID> testRunTestCaseIds = StreamUtils.extractIds(testRuns, TestRun::getTestCaseId);
        log.debug("Found test run test case references with ids '{}'", testRunTestCaseIds);
        this.processLabelTemplateWithTestRuns(testRuns, labelTemplate);
        return labelTemplate;
    }

    public LabelTemplate getLabelTemplate(UUID labelTemplateId) {
        if (Objects.isNull(labelTemplateId)) {
            log.error("Found illegal nullable label template id");
            throw new AtpIllegalNullableArgumentException("label template id", "method parameter");
        }
        LabelTemplate labelTemplate = this.catalogueService.getLabelTemplateById(labelTemplateId);
        if (CollectionUtils.isEmpty((Collection)labelTemplate.getLabelNodes())) {
            log.error("Found label template '{}' without any children nodes", (Object)labelTemplateId);
            throw new RamLabelTemplateWithoutChildrenNodesException();
        }
        return labelTemplate;
    }

    public UUID getProjectIdByLabelTemplateId(UUID labelTemplateId) {
        LabelTemplate labelTemplate = this.catalogueService.getLabelTemplateById(labelTemplateId);
        return labelTemplate.getProjectId();
    }

    public void deleteLabelTemplate(UUID labelTemplateId) {
        log.info("Delete validation label config template '{}'", (Object)labelTemplateId);
        this.catalogueService.deleteLabelTemplateById(labelTemplateId);
        List<WidgetConfigTemplate> referencedWidgetConfigTemplates = this.widgetConfigTemplateService.getWidgetConfigTemplatesWithLabelTemplateId(labelTemplateId);
        referencedWidgetConfigTemplates.stream().flatMap(template -> template.getWidgets().stream().filter(widgetConfig -> Objects.nonNull(widgetConfig.getLabelTemplateId()))).filter(widgetConfig -> labelTemplateId.equals(widgetConfig.getLabelTemplateId())).forEach(widgetConfig -> widgetConfig.setLabelTemplateId(null));
        this.widgetConfigTemplateService.updateAll(referencedWidgetConfigTemplates);
    }

    private void processLabelTemplateWithTestRuns(List<TestRun> testRuns, LabelTemplate labelTemplate) {
        UUID labelTemplateId = labelTemplate.getUuid();
        log.debug("Process label template with id '{}' with test runs '{}'", (Object)labelTemplateId, StreamUtils.extractIds(testRuns));
        this.defineLabelTemplateNodeForRuns(testRuns, labelTemplate.createUnknownNode());
    }

    private void defineLabelTemplateNodeForRuns(List<TestRun> testRuns, LabelTemplate labelTemplate) {
        testRuns.forEach(testRun -> {
            UUID testRunId = testRun.getUuid();
            log.info("Defining label template node for test run '{}'", (Object)testRunId);
            UUID testCaseId = testRun.getTestCaseId();
            Set caseLabelIds = testRun.getLabelIds();
            if (CollectionUtils.isEmpty((Collection)caseLabelIds)) {
                log.warn("Found test case '{}' without labels", (Object)testCaseId);
                labelTemplate.addToUnknown(testRunId, "Referenced test case without labels");
            } else {
                log.info("Found referenced test case '{}' with labels '{}' for test run '{}'", new Object[]{testCaseId, caseLabelIds, testRunId});
                List labelNodes = labelTemplate.getLabelNodes();
                LabelTemplate.LabelTemplateNode unknownNode = labelTemplate.getUnknownNode();
                this.defineLabelTemplateNodeForRun((TestRun)testRun, caseLabelIds, labelTemplate, unknownNode, labelNodes);
            }
        });
        Map<UUID, TestRun> testRunMap = StreamUtils.toIdEntityMap(testRuns);
        this.calculateRatesForLabelNodes(labelTemplate.getLabelNodes(), testRunMap);
    }

    public void calculateRatesForLabelNodes(List<LabelTemplate.LabelTemplateNode> labelNodes, Map<UUID, TestRun> testRunMap) {
        Predicate<TestRun> calcSkipPredicate = testRun -> !TestingStatuses.SKIPPED.equals((Object)testRun.getTestingStatus());
        labelNodes.forEach(labelTemplateNode -> {
            int passedCount = 0;
            int warningCount = 0;
            int failedCount = 0;
            int childrenTestRunsSum = 0;
            List children = labelTemplateNode.getChildren();
            if (!CollectionUtils.isEmpty((Collection)children)) {
                this.calculateRatesForLabelNodes(children, testRunMap);
                passedCount = children.stream().mapToInt(LabelTemplate.LabelTemplateNode::getTestRunPassedCount).sum();
                warningCount = children.stream().mapToInt(LabelTemplate.LabelTemplateNode::getTestRunWarnedCount).sum();
                failedCount = children.stream().mapToInt(LabelTemplate.LabelTemplateNode::getTestRunFailedCount).sum();
                childrenTestRunsSum = children.stream().mapToInt(LabelTemplate.LabelTemplateNode::getTestRunCount).sum();
            }
            int totalTestRuns = childrenTestRunsSum;
            Set testRunsIds = labelTemplateNode.getTestRunIds();
            if (!CollectionUtils.isEmpty((Collection)testRunsIds)) {
                List testRuns = StreamUtils.getEntitiesFromMap(testRunsIds, testRunMap).stream().filter(calcSkipPredicate).collect(Collectors.toList());
                totalTestRuns += testRuns.size();
                passedCount = (int)((long)passedCount + testRuns.stream().filter(testRun -> TestingStatuses.PASSED.equals((Object)testRun.getTestingStatus())).count());
                warningCount = (int)((long)warningCount + testRuns.stream().filter(testRun -> TestingStatuses.WARNING.equals((Object)testRun.getTestingStatus())).count());
                failedCount = (int)((long)failedCount + testRuns.stream().filter(testRun -> TestingStatuses.FAILED.equals((Object)testRun.getTestingStatus())).count());
            }
            int failedRate = (int)Math.round((double)failedCount / (double)totalTestRuns * 100.0);
            labelTemplateNode.setFailedRate(failedRate);
            labelTemplateNode.setTestRunFailedCount(failedCount);
            int warningRate = (int)Math.round((double)warningCount / (double)totalTestRuns * 100.0);
            labelTemplateNode.setWarningRate(warningRate);
            labelTemplateNode.setTestRunWarnedCount(warningCount);
            int passedRate = (int)Math.round((double)passedCount / (double)totalTestRuns * 100.0);
            labelTemplateNode.setPassedRate(passedRate);
            labelTemplateNode.setTestRunPassedCount(passedCount);
            labelTemplateNode.setTestRunCount(totalTestRuns);
        });
    }

    private void defineLabelTemplateNodeForRun(TestRun testRun, Set<UUID> labelIds, LabelTemplate labelTemplate, LabelTemplate.LabelTemplateNode rootLabelNode, List<LabelTemplate.LabelTemplateNode> labelNodes) {
        UUID testRunId = testRun.getUuid();
        try {
            log.debug("Validate multiple one level node inclusions for test run '{}'", (Object)testRunId);
            this.validateMultipleOneLevelNodeInclusions(labelNodes, labelIds);
        }
        catch (RamLabelTemplateMultipleOneLevelNodeInclusionException e) {
            log.error("Failed to define label template node for test run: {}. Reason: {}", (Object)testRunId, (Object)e);
            labelTemplate.addToUnknown(testRunId, e.getMessage());
            return;
        }
        if (CollectionUtils.isEmpty(labelNodes)) {
            log.debug("Add test run '{}' into label node '{}'", (Object)testRunId, (Object)rootLabelNode.getLabelId());
            rootLabelNode.addTestRun(testRunId);
        } else {
            Optional<LabelTemplate.LabelTemplateNode> foundedLabelNode = labelNodes.stream().filter(node -> labelIds.contains(node.getLabelId())).findFirst();
            if (foundedLabelNode.isPresent()) {
                LabelTemplate.LabelTemplateNode labelNode = foundedLabelNode.get();
                List labelNodeChildren = labelNode.getChildren();
                this.defineLabelTemplateNodeForRun(testRun, labelIds, labelTemplate, labelNode, labelNodeChildren);
            } else {
                try {
                    log.debug("Validate test run '{}' for labels path gap", (Object)testRunId);
                    this.validateForLabelsPathGap(labelIds, labelNodes);
                    log.debug("Add test run '{}' into label node '{}'", (Object)testRunId, (Object)rootLabelNode.getLabelId());
                    rootLabelNode.addTestRun(testRunId);
                }
                catch (RamLabelTemplateInconsistentLabelsPathGapException e) {
                    log.error("Failed to define label template node for test run: {}. Reason: {}", (Object)testRunId, (Object)e);
                    labelTemplate.addToUnknown(testRunId, e.getMessage());
                }
            }
        }
    }

    private void validateMultipleOneLevelNodeInclusions(List<LabelTemplate.LabelTemplateNode> labelNodes, Set<UUID> labelIds) throws IllegalStateException {
        if (!CollectionUtils.isEmpty(labelNodes)) {
            Set<UUID> labelNodeIds = StreamUtils.extractIds(labelNodes, LabelTemplate.LabelTemplateNode::getLabelId);
            labelNodeIds.retainAll(labelIds);
            if (labelNodeIds.size() > 1) {
                String inclusionNames = labelNodes.stream().filter(labelNode -> labelNodeIds.contains(labelNode.getLabelId())).map(LabelTemplate.LabelTemplateNode::getLabelName).collect(Collectors.joining(", "));
                ExceptionUtils.throwWithLog((Logger)log, (AtpException)new RamLabelTemplateMultipleOneLevelNodeInclusionException(inclusionNames));
            }
        }
    }

    private void validateForLabelsPathGap(Set<UUID> labelIds, List<LabelTemplate.LabelTemplateNode> labelNodes) throws IllegalStateException {
        Optional<LabelTemplate.LabelTemplateNode> foundedLabelNode = labelNodes.stream().filter(node -> labelIds.contains(node.getLabelId())).findFirst();
        if (foundedLabelNode.isPresent()) {
            ExceptionUtils.throwWithLog((Logger)log, (AtpException)new RamLabelTemplateInconsistentLabelsPathGapException());
        } else {
            List currentNotEmptyChildrenNodes = labelNodes.stream().filter(node -> !CollectionUtils.isEmpty((Collection)node.getChildren())).collect(Collectors.toList());
            for (LabelTemplate.LabelTemplateNode node2 : currentNotEmptyChildrenNodes) {
                this.validateForLabelsPathGap(labelIds, node2.getChildren());
            }
        }
    }

    public LabelTemplateNodeService(CatalogueService catalogueService, WidgetConfigTemplateService widgetConfigTemplateService) {
        this.catalogueService = catalogueService;
        this.widgetConfigTemplateService = widgetConfigTemplateService;
    }
}

