/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.List;
import java.util.UUID;
import org.qubership.atp.orchestrator.clients.dto.TerminateRequestDto;
import org.qubership.atp.ram.client.OrchestratorFeignClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Service
public class OrchestratorService {
    private static final Logger log = LoggerFactory.getLogger(OrchestratorService.class);
    private final OrchestratorFeignClient orchestratorFeignClient;

    public void terminate(TerminateRequestDto terminateRequestDto) {
        this.orchestratorFeignClient.terminateProcess(terminateRequestDto);
    }

    public void stop(List<UUID> executionRequestsIds) {
        this.orchestratorFeignClient.stopProcess(executionRequestsIds);
    }

    public void resume(List<UUID> executionRequestsIds) {
        this.orchestratorFeignClient.resumeProcess(executionRequestsIds);
    }

    public void rerun(List<UUID> executionRequestsIds) {
        this.orchestratorFeignClient.restartProcess(executionRequestsIds);
    }

    public void terminateTestRun(List<UUID> testRunIds) {
        this.orchestratorFeignClient.terminateTestRunProcess(testRunIds);
    }

    public void stopTestRun(@RequestBody List<UUID> testRunIds, @RequestParam(name="executionRequestId") UUID executionRequestId) {
        this.orchestratorFeignClient.stopTestRunProcess(executionRequestId, testRunIds);
    }

    public void resumeTestRun(List<UUID> testRunIds, @RequestParam(name="executionRequestId") UUID executionRequestId) {
        this.orchestratorFeignClient.resumeTestRunProcess(executionRequestId, testRunIds);
    }

    public void rerunTestRun(@RequestBody List<UUID> testRunIds, @RequestParam(name="executionRequestId") UUID executionRequestId) {
        this.orchestratorFeignClient.restartTestRunProcess(executionRequestId, testRunIds);
    }

    public UUID rerunTestRuns(@PathVariable(value="uuid") UUID executionRequestId, String token, List<UUID> testRunIds) {
        return (UUID)this.orchestratorFeignClient.rerunTestRunsProcess(executionRequestId, token, testRunIds).getBody();
    }

    public UUID getProcessIdByExecutionRequestId(@PathVariable(value="id") UUID id) {
        return (UUID)this.orchestratorFeignClient.getRunnerProcessIdByExecutionRequestId(id).getBody();
    }

    public OrchestratorService(OrchestratorFeignClient orchestratorFeignClient) {
        this.orchestratorFeignClient = orchestratorFeignClient;
    }
}

