/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpIllegalNullableArgumentException;
import org.qubership.atp.ram.dto.request.WidgetConfigTemplateSearchRequest;
import org.qubership.atp.ram.dto.response.ExecutionRequestWidgetConfigTemplateResponse;
import org.qubership.atp.ram.models.ColumnVisibility;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.ExecutionRequestConfig;
import org.qubership.atp.ram.models.WidgetConfigTemplate;
import org.qubership.atp.ram.repositories.ExecutionRequestConfigRepository;
import org.qubership.atp.ram.repositories.WidgetConfigTemplateRepository;
import org.qubership.atp.ram.services.CrudService;
import org.qubership.atp.ram.services.ExecutionRequestService;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class WidgetConfigTemplateService
extends CrudService<WidgetConfigTemplate> {
    private static final Logger log = LoggerFactory.getLogger(WidgetConfigTemplateService.class);
    public static final String DEFAULT_TEMPLATE_UUID = "578a9810-8e8d-49ec-ba9a-6b26a22d5d70";
    private final WidgetConfigTemplateRepository repository;
    private final ExecutionRequestConfigRepository executionRequestConfigRepository;
    private final ExecutionRequestService executionRequestService;
    private final ModelMapper modelMapper;

    public WidgetConfigTemplateService(WidgetConfigTemplateRepository repository, ExecutionRequestConfigRepository executionRequestConfigRepository, @Lazy ExecutionRequestService executionRequestService, ModelMapper modelMapper) {
        this.repository = repository;
        this.executionRequestConfigRepository = executionRequestConfigRepository;
        this.executionRequestService = executionRequestService;
        this.modelMapper = modelMapper;
    }

    @Override
    protected MongoRepository<WidgetConfigTemplate, UUID> repository() {
        return this.repository;
    }

    public ExecutionRequestWidgetConfigTemplateResponse getWidgetConfigTemplateForEr(UUID executionRequestId) {
        ExecutionRequest executionRequest = (ExecutionRequest)this.executionRequestService.get(executionRequestId);
        return this.getWidgetConfigTemplateForEr(executionRequest);
    }

    public ExecutionRequestWidgetConfigTemplateResponse getWidgetConfigTemplateForEr(ExecutionRequest request) {
        log.info("Get widget config template for execution request '{}'", (Object)request.getUuid());
        ExecutionRequestConfig executionRequestConfig = this.executionRequestService.getExecutionRequestConfig(request);
        UUID erWidgetConfigTemplateId = executionRequestConfig.getWidgetConfigTemplateId();
        log.debug("Execution request widget config template id: {}", (Object)erWidgetConfigTemplateId);
        WidgetConfigTemplate executionRequestWidgetConfigTemplate = null;
        if (Objects.nonNull(erWidgetConfigTemplateId)) {
            executionRequestWidgetConfigTemplate = (WidgetConfigTemplate)this.get(erWidgetConfigTemplateId);
            log.debug("Found execution request widget config template: {}", (Object)executionRequestWidgetConfigTemplate);
        }
        log.debug("Result template: {}", executionRequestWidgetConfigTemplate);
        return new ExecutionRequestWidgetConfigTemplateResponse(executionRequestWidgetConfigTemplate, executionRequestConfig.isDefaultLabelTemplateChanged());
    }

    public Map<String, Boolean> getWidgetColumnVisibilityMap(UUID executionRequestId, UUID widgetId) {
        WidgetConfigTemplate template = this.getWidgetConfigTemplateForEr(executionRequestId).getTemplate();
        WidgetConfigTemplate.WidgetConfig widgetConfig = Objects.nonNull(template) ? template.getWidgetConfig(widgetId) : this.getDefaultTemplate().getWidgetConfig(widgetId);
        List widgetConfigColumnVisibilities = widgetConfig.getColumnVisibilities();
        List columnVisibilities = !CollectionUtils.isEmpty((Collection)widgetConfigColumnVisibilities) ? widgetConfigColumnVisibilities : Collections.emptyList();
        return columnVisibilities.stream().peek(columnVisibility -> {
            String name = columnVisibility.getName();
            columnVisibility.setName(name.replaceAll("_", " "));
        }).collect(Collectors.toMap(ColumnVisibility::getName, ColumnVisibility::isVisible));
    }

    public List<WidgetConfigTemplate> getAll(WidgetConfigTemplateSearchRequest searchRequest) {
        log.info("Find all widget config templates, filters: '{}'", (Object)searchRequest);
        String name = searchRequest.getName();
        UUID projectId = searchRequest.getProjectId();
        UUID labelTemplateId = searchRequest.getLabelTemplateId();
        UUID validationTemplateId = searchRequest.getValidationTemplateId();
        if (!StringUtils.isEmpty((Object)name) && Objects.nonNull(projectId)) {
            return this.repository.findAllByProjectIdAndNameContains(projectId, name);
        }
        if (!StringUtils.isEmpty((Object)name)) {
            return this.repository.findAllByNameContains(name);
        }
        if (Objects.nonNull(projectId)) {
            return this.repository.findAllByProjectId(projectId);
        }
        if (Objects.nonNull(labelTemplateId)) {
            return this.repository.findAllByWidgetsLabelTemplateId(labelTemplateId);
        }
        if (Objects.nonNull(validationTemplateId)) {
            return this.repository.findAllByWidgets_validationTemplateId(validationTemplateId);
        }
        return this.getAll();
    }

    public WidgetConfigTemplate create(WidgetConfigTemplate template) {
        log.info("Create new widget config template: {}", (Object)template);
        this.validateWidgetConfigTemplate(template);
        return this.save(template);
    }

    public WidgetConfigTemplate update(UUID id, WidgetConfigTemplate updatedTemplate) {
        log.info("Update widget config template '{}' with new content: {}", (Object)id, (Object)updatedTemplate);
        WidgetConfigTemplate existedTemplate = (WidgetConfigTemplate)this.get(id);
        this.modelMapper.map((Object)updatedTemplate, (Object)existedTemplate);
        this.validateWidgetConfigTemplate(existedTemplate);
        return this.save(existedTemplate);
    }

    public void updateAll(List<WidgetConfigTemplate> templates) {
        log.info("Update widget config templates '{}'", StreamUtils.extractIds(templates));
        this.repository.saveAll(templates);
    }

    public List<WidgetConfigTemplate> getWidgetConfigTemplatesWithLabelTemplateId(UUID labelTemplateId) {
        return this.repository.findAllByWidgetsLabelTemplateId(labelTemplateId);
    }

    public List<WidgetConfigTemplate> getWidgetConfigTemplatesWithValidationTemplateId(UUID validationTemplateId) {
        return this.repository.findAllByWidgets_validationTemplateId(validationTemplateId);
    }

    public void delete(UUID id) {
        log.info("Delete widget config template '{}'", (Object)id);
        this.repository.deleteById(id);
        log.debug("Unset all widget config templates references in execution request configs");
        List<ExecutionRequestConfig> configs = this.executionRequestConfigRepository.findAllByWidgetConfigTemplateId(id);
        configs.forEach(config -> config.setWidgetConfigTemplateId(null));
        log.debug("Updated configs: {}", StreamUtils.extractIds(configs));
        this.executionRequestConfigRepository.saveAll(configs);
    }

    private void validateWidgetConfigTemplate(WidgetConfigTemplate template) {
        log.debug("Validate widget config template: {}", (Object)template);
        if (Objects.isNull(template.getProjectId())) {
            log.error("Failed to create widget config template: project id should be specified");
            throw new AtpIllegalNullableArgumentException("project id", "widget config template");
        }
        if (Objects.isNull(template.getName())) {
            log.error("Failed to create widget config template: name should be specified");
            throw new AtpIllegalNullableArgumentException("name", "widget config template");
        }
    }

    public UUID getValidationTemplateIdByErWidget(ExecutionRequest executionRequest, UUID widgetId) {
        UUID validationTemplateId = null;
        WidgetConfigTemplate widgetConfigTemplate = this.getWidgetConfigTemplateForEr(executionRequest).getTemplate();
        if (Objects.nonNull(widgetConfigTemplate)) {
            WidgetConfigTemplate.WidgetConfig widgetConfig = widgetConfigTemplate.getWidgetConfig(widgetId);
            return widgetConfig.getValidationTemplateId();
        }
        return validationTemplateId;
    }

    public UUID defineLabelTemplateId(ExecutionRequest executionRequest, UUID widgetId) {
        UUID labelTemplateId = executionRequest.getLabelTemplateId();
        WidgetConfigTemplate widgetConfigTemplate = this.getWidgetConfigTemplateForEr(executionRequest).getTemplate();
        if (Objects.nonNull(widgetConfigTemplate)) {
            WidgetConfigTemplate.WidgetConfig widgetConfig = widgetConfigTemplate.getWidgetConfig(widgetId);
            return widgetConfig.getLabelTemplateId();
        }
        return labelTemplateId;
    }

    public WidgetConfigTemplate getDefaultTemplate() {
        WidgetConfigTemplate defaultTemplate = this.repository.findByUuid(UUID.fromString(DEFAULT_TEMPLATE_UUID));
        defaultTemplate.setUuid(null);
        return defaultTemplate;
    }

    public UUID getProjectIdByTemplateId(UUID templateId) {
        Optional template = this.repository.findById(templateId);
        return template.map(WidgetConfigTemplate::getProjectId).orElse(null);
    }

    public void deleteAllByExecutionRequestIdIn(List<UUID> executionRequestIds) {
        this.executionRequestConfigRepository.deleteAllByExecutionRequestIdIn(executionRequestIds);
    }
}

