/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.collections.CollectionUtils;
import org.modelmapper.ModelMapper;
import org.qubership.atp.ram.enums.TestScopeSections;
import org.qubership.atp.ram.models.RamObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamUtils {
    private static final Logger log = LoggerFactory.getLogger(StreamUtils.class);
    private static final ModelMapper modelMapper = new ModelMapper();

    private StreamUtils() {
    }

    public static <T> Set<UUID> extractIds(Collection<T> entities, Function<T, UUID> extractor) {
        if (entities == null) {
            return Collections.emptySet();
        }
        return StreamUtils.getIdsStream(entities, extractor).collect(Collectors.toSet());
    }

    public static <T extends RamObject> Set<UUID> extractIds(Collection<T> entities) {
        return StreamUtils.extractIds(entities, RamObject::getUuid);
    }

    public static <T> Set<UUID> extractFlatIds(Collection<T> entities, Function<T, Collection<UUID>> extractor) {
        if (entities == null) {
            return Collections.emptySet();
        }
        return StreamUtils.getFlatIdsStream(entities, extractor).collect(Collectors.toSet());
    }

    public static <T, E> List<E> extractFlatEntities(Collection<T> entities, Function<T, Collection<E>> extractor) {
        if (entities == null) {
            return Collections.emptyList();
        }
        return StreamUtils.getFlatStream(entities, extractor).collect(Collectors.toList());
    }

    public static <T extends RamObject> List<String> extractNames(Collection<T> entities) {
        return entities == null ? Collections.emptyList() : entities.stream().map(RamObject::getName).collect(Collectors.toList());
    }

    private static <T> Stream<UUID> getIdsStream(Collection<T> entities, Function<T, UUID> extractor) {
        return entities.stream().map(extractor).filter(Objects::nonNull);
    }

    private static <T> Stream<UUID> getFlatIdsStream(Collection<T> entities, Function<T, Collection<UUID>> extractor) {
        return entities.stream().filter(elem -> !CollectionUtils.isEmpty((Collection)((Collection)extractor.apply(elem)))).flatMap(elem -> ((Collection)extractor.apply(elem)).stream());
    }

    private static <T, E> Stream<E> getFlatStream(Collection<T> entities, Function<T, Collection<E>> extractor) {
        return entities.stream().filter(elem -> !CollectionUtils.isEmpty((Collection)((Collection)extractor.apply(elem)))).flatMap(elem -> ((Collection)extractor.apply(elem)).stream());
    }

    public static <T extends RamObject> List<UUID> extractIdsToList(Collection<T> entities) {
        return StreamUtils.getIdsStream(entities, RamObject::getUuid).collect(Collectors.toList());
    }

    public static <T> Stream<T> stream(Iterable<T> entities) {
        return StreamSupport.stream(entities.spliterator(), false);
    }

    public static <T> Map<UUID, T> toKeyEntityMap(Iterable<T> entities, Function<T, UUID> keyExtractor) {
        return StreamUtils.stream(entities).collect(Collectors.toMap(keyExtractor, Function.identity()));
    }

    public static <T> Map<UUID, T> toIdEntityMap(Iterable<T> entities, Function<T, UUID> keyExtractor) {
        return StreamUtils.stream(entities).collect(Collectors.toMap(keyExtractor, Function.identity()));
    }

    public static <T extends RamObject> Map<UUID, T> toIdEntityMap(Iterable<T> entities) {
        return StreamUtils.stream(entities).collect(Collectors.toMap(RamObject::getUuid, Function.identity()));
    }

    public static <T, R> Map<R, T> toEntityMap(Iterable<T> entities, Function<T, R> keyExtractor) {
        return StreamUtils.stream(entities).collect(Collectors.toMap(keyExtractor, Function.identity()));
    }

    public static <T extends RamObject> Map<UUID, String> toIdNameEntityMap(Iterable<T> entities) {
        return StreamUtils.stream(entities).collect(Collectors.toMap(RamObject::getUuid, RamObject::getName));
    }

    public static <T> Map<UUID, List<T>> toMapWithListEntitiesValues(Iterable<T> entities, Function<T, UUID> keyExtractor) {
        return StreamUtils.stream(entities).collect(Collectors.groupingBy(keyExtractor));
    }

    public static <T> Map<UUID, List<T>> toEntityListMap(Iterable<T> entities, Function<T, UUID> keyExtractor) {
        return StreamUtils.stream(entities).collect(Collectors.groupingBy(keyExtractor));
    }

    public static <T, R> List<R> mapToClazz(Iterable<T> entities, Class<R> clazz) {
        return StreamUtils.stream(entities).map(entity -> modelMapper.map(entity, clazz)).collect(Collectors.toList());
    }

    public static <T, R> R mapToClazz(T entity, Class<R> clazz) {
        return (R)modelMapper.map(entity, clazz);
    }

    public static <T, R> List<R> map(Collection<T> entities, Function<T, R> mapFunc) {
        return entities.stream().map(mapFunc).collect(Collectors.toList());
    }

    public static <T, R> Set<R> extractFields(Collection<T> entities, Function<T, R> extractor) {
        if (entities == null) {
            return Collections.emptySet();
        }
        return entities.stream().map(extractor).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static <T> List<T> filterList(Collection<T> entities, Predicate<T> predicate) {
        return entities.stream().filter(predicate).collect(Collectors.toList());
    }

    public static <T extends RamObject> List<T> filterList(Collection<T> entities, Predicate<T> predicate, Comparator<T> sort) {
        return entities.stream().filter(predicate).sorted(sort).collect(Collectors.toList());
    }

    public static <T extends RamObject> List<T> filterList(Collection<T> entities, Collection<UUID> containKeys) {
        return entities.stream().filter(entity -> containKeys.contains(entity.getUuid())).collect(Collectors.toList());
    }

    public static <T> List<T> filterList(Collection<T> entities, Function<T, UUID> entityKeyExtractFunc, Collection<UUID> containKeys) {
        return entities.stream().filter(entity -> containKeys.contains(entityKeyExtractFunc.apply(entity))).collect(Collectors.toList());
    }

    public static <T> T findFirstInList(Collection<T> entities, Predicate<T> predicate) {
        return entities.stream().filter(predicate).findFirst().get();
    }

    public static <T> List<T> filterByTestScopeSection(Collection<T> entities, Function<T, TestScopeSections> entityKeyExtractFunc, TestScopeSections testScopeSection) {
        return entities.stream().filter(entity -> testScopeSection.equals(entityKeyExtractFunc.apply(entity))).collect(Collectors.toList());
    }

    public static <T> boolean isAllListIdsPresent(Collection<T> entities, Collection<UUID> ids, Function<T, UUID> entityKeyExtractFunc) {
        return StreamUtils.extractIds(entities, entityKeyExtractFunc).containsAll(ids);
    }

    public static <T> List<T> getEntitiesFromMap(Set<UUID> ids, Map<UUID, T> entitiesMap) {
        return ids.stream().map(entitiesMap::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> T checkAndReturnSingular(Collection<T> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            throw new IllegalStateException("Provided entities collection is nullable");
        }
        if (entities.size() != 1) {
            throw new IllegalStateException("Expect one entity in the provided collection");
        }
        return entities.iterator().next();
    }

    public static Collection<String> toUpperCase(Collection<String> input) {
        return input.stream().map(String::toUpperCase).collect(Collectors.toList());
    }
}

