/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.validators;

import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpIllegalNullableArgumentException;
import org.qubership.atp.ram.exceptions.rootcauses.RamRootCauseIllegalTypeException;
import org.qubership.atp.ram.exceptions.rootcauses.RamRootCauseInvalidTreeStructureException;
import org.qubership.atp.ram.model.request.RootCauseUpsertRequest;
import org.qubership.atp.ram.models.RootCause;
import org.qubership.atp.ram.models.RootCauseType;
import org.qubership.atp.ram.repositories.RootCauseRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class RootCauseUpsertRequestValidator
implements Validator {
    private static final Logger log = LoggerFactory.getLogger(RootCauseUpsertRequestValidator.class);
    private final RootCauseRepository repository;

    public boolean supports(Class<?> clazz) {
        return RootCauseUpsertRequest.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        RootCauseUpsertRequest rootCause = (RootCauseUpsertRequest)target;
        log.debug("Validate root cause: {}", (Object)rootCause);
        RootCauseType rootCauseType = rootCause.getType();
        if (Objects.isNull(rootCauseType)) {
            log.error("Found illegal nullable root cause type for the validated request");
            throw new AtpIllegalNullableArgumentException("environment id", "request");
        }
        switch (rootCauseType) {
            case CUSTOM: {
                this.validateCustomRootCause(rootCause);
                break;
            }
            case GLOBAL: {
                this.validateGlobalRootCause(rootCause);
                break;
            }
            default: {
                log.error("Found illegal root cause type: {}", (Object)rootCauseType);
                throw new RamRootCauseIllegalTypeException(rootCauseType);
            }
        }
    }

    private void validateCustomRootCause(RootCauseUpsertRequest rootCause) {
        UUID projectId = rootCause.getProjectId();
        if (Objects.isNull(projectId)) {
            log.error("Found illegal nullable project id for the validated RootCauseUpsertRequest");
            throw new AtpIllegalNullableArgumentException("project id", "RootCauseUpsertRequest");
        }
    }

    private void validateGlobalRootCause(RootCauseUpsertRequest rootCause) {
        RootCause parentRootCause;
        RootCauseType parentRootCauseType;
        boolean isParentCustom;
        UUID projectId = rootCause.getProjectId();
        String rootCauseName = rootCause.getName();
        UUID parentId = rootCause.getParentId();
        if (Objects.nonNull(parentId) && (isParentCustom = RootCauseType.CUSTOM.equals((Object)(parentRootCauseType = (parentRootCause = this.repository.findByUuid(parentId)).getType())))) {
            log.error("Global root cause '{}' cannot be set under custom '{}'", (Object)rootCauseName, (Object)parentId);
            throw new RamRootCauseInvalidTreeStructureException();
        }
        if (Objects.nonNull(projectId)) {
            log.error("Found illegal nullable project id for the validated RootCauseUpsertRequest");
            throw new AtpIllegalNullableArgumentException("project id", "RootCauseUpsertRequest");
        }
    }

    public RootCauseUpsertRequestValidator(RootCauseRepository repository) {
        this.repository = repository;
    }
}

