package org.qubership.atp.orchestrator.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestingStrategyDto
 */

@JsonTypeName("TestingStrategy")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:34:56.979423481Z[Etc/UTC]")
public class TestingStrategyDto {

  @JsonProperty("executeExecution")
  private Boolean executeExecution;

  @JsonProperty("executePrerequisites")
  private Boolean executePrerequisites;

  @JsonProperty("executeValidation")
  private Boolean executeValidation;

  @JsonProperty("testCaseIds")
  @Valid
  private List<UUID> testCaseIds = null;

  @JsonProperty("testScopeId")
  private UUID testScopeId;

  @JsonProperty("filteredByLabels")
  @Valid
  private Set<UUID> filteredByLabels = null;

  public TestingStrategyDto executeExecution(Boolean executeExecution) {
    this.executeExecution = executeExecution;
    return this;
  }

  /**
   * Get executeExecution
   * @return executeExecution
  */
  
  @Schema(name = "executeExecution", required = false)
  public Boolean getExecuteExecution() {
    return executeExecution;
  }

  public void setExecuteExecution(Boolean executeExecution) {
    this.executeExecution = executeExecution;
  }

  public TestingStrategyDto executePrerequisites(Boolean executePrerequisites) {
    this.executePrerequisites = executePrerequisites;
    return this;
  }

  /**
   * Get executePrerequisites
   * @return executePrerequisites
  */
  
  @Schema(name = "executePrerequisites", required = false)
  public Boolean getExecutePrerequisites() {
    return executePrerequisites;
  }

  public void setExecutePrerequisites(Boolean executePrerequisites) {
    this.executePrerequisites = executePrerequisites;
  }

  public TestingStrategyDto executeValidation(Boolean executeValidation) {
    this.executeValidation = executeValidation;
    return this;
  }

  /**
   * Get executeValidation
   * @return executeValidation
  */
  
  @Schema(name = "executeValidation", required = false)
  public Boolean getExecuteValidation() {
    return executeValidation;
  }

  public void setExecuteValidation(Boolean executeValidation) {
    this.executeValidation = executeValidation;
  }

  public TestingStrategyDto testCaseIds(List<UUID> testCaseIds) {
    this.testCaseIds = testCaseIds;
    return this;
  }

  public TestingStrategyDto addTestCaseIdsItem(UUID testCaseIdsItem) {
    if (this.testCaseIds == null) {
      this.testCaseIds = new ArrayList<>();
    }
    this.testCaseIds.add(testCaseIdsItem);
    return this;
  }

  /**
   * Get testCaseIds
   * @return testCaseIds
  */
  @Valid 
  @Schema(name = "testCaseIds", required = false)
  public List<UUID> getTestCaseIds() {
    return testCaseIds;
  }

  public void setTestCaseIds(List<UUID> testCaseIds) {
    this.testCaseIds = testCaseIds;
  }

  public TestingStrategyDto testScopeId(UUID testScopeId) {
    this.testScopeId = testScopeId;
    return this;
  }

  /**
   * Get testScopeId
   * @return testScopeId
  */
  @Valid 
  @Schema(name = "testScopeId", required = false)
  public UUID getTestScopeId() {
    return testScopeId;
  }

  public void setTestScopeId(UUID testScopeId) {
    this.testScopeId = testScopeId;
  }

  public TestingStrategyDto filteredByLabels(Set<UUID> filteredByLabels) {
    this.filteredByLabels = filteredByLabels;
    return this;
  }

  public TestingStrategyDto addFilteredByLabelsItem(UUID filteredByLabelsItem) {
    if (this.filteredByLabels == null) {
      this.filteredByLabels = new LinkedHashSet<>();
    }
    this.filteredByLabels.add(filteredByLabelsItem);
    return this;
  }

  /**
   * Get filteredByLabels
   * @return filteredByLabels
  */
  @Valid 
  @Schema(name = "filteredByLabels", required = false)
  public Set<UUID> getFilteredByLabels() {
    return filteredByLabels;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setFilteredByLabels(Set<UUID> filteredByLabels) {
    this.filteredByLabels = filteredByLabels;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestingStrategyDto testingStrategy = (TestingStrategyDto) o;
    return Objects.equals(this.executeExecution, testingStrategy.executeExecution) &&
        Objects.equals(this.executePrerequisites, testingStrategy.executePrerequisites) &&
        Objects.equals(this.executeValidation, testingStrategy.executeValidation) &&
        Objects.equals(this.testCaseIds, testingStrategy.testCaseIds) &&
        Objects.equals(this.testScopeId, testingStrategy.testScopeId) &&
        Objects.equals(this.filteredByLabels, testingStrategy.filteredByLabels);
  }

  @Override
  public int hashCode() {
    return Objects.hash(executeExecution, executePrerequisites, executeValidation, testCaseIds, testScopeId, filteredByLabels);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestingStrategyDto {\n");
    sb.append("    executeExecution: ").append(toIndentedString(executeExecution)).append("\n");
    sb.append("    executePrerequisites: ").append(toIndentedString(executePrerequisites)).append("\n");
    sb.append("    executeValidation: ").append(toIndentedString(executeValidation)).append("\n");
    sb.append("    testCaseIds: ").append(toIndentedString(testCaseIds)).append("\n");
    sb.append("    testScopeId: ").append(toIndentedString(testScopeId)).append("\n");
    sb.append("    filteredByLabels: ").append(toIndentedString(filteredByLabels)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

