/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.ram.clients.api;

import org.qubership.atp.ram.clients.api.dto.catalogue.CaseCreationRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CasePatchUpdateRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CaseSearchRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CaseUpdateRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompareCopyRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompareItemCopyRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompareTestCasesDatasetsRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompareTestCasesDatasetsResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CopyRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.EnrichedCaseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraComponentDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelsRequestDto;
import java.util.List;
import org.qubership.atp.ram.clients.api.dto.catalogue.MoveRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.PageAbstractEntityResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.PaginationResponseDto;
import java.util.Set;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseCompareCopyResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseComponentsDeleteRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseComponentsDeleteResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseComponentsSearchRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseComponentsSetRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseDatasetsSetRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseDependenciesResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseLabelResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseLastStatusDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseSearchRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCasesCopyRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCasesDataSetReplaceRequestDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:34:54.723924663Z[Etc/UTC]")
@Validated
@Tag(name = "TestCaseController", description = "Test Case Controller")
public interface TestCaseControllerApi {

    /**
     * POST /catalog/api/v1/testcases/labels : addLabelsToTestCases
     *
     * @param labelsRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "addLabelsToTestCases",
        summary = "addLabelsToTestCases",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/labels",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> addLabelsToTestCases(
        @Parameter(name = "LabelsRequestDto", description = "") @Valid @RequestBody(required = false) LabelsRequestDto labelsRequestDto
    );


    /**
     * POST /catalog/api/v1/testcases/compare/copy/bulk : bulkCopyTestCasesWhileTestPlansCompare
     *
     * @param compareCopyRequestDto  (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "bulkCopyTestCasesWhileTestPlansCompare",
        summary = "bulkCopyTestCasesWhileTestPlansCompare",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/compare/copy/bulk",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> bulkCopyTestCasesWhileTestPlansCompare(
        @Parameter(name = "CompareCopyRequestDto", description = "") @Valid @RequestBody(required = false) CompareCopyRequestDto compareCopyRequestDto
    );


    /**
     * POST /catalog/api/v1/testcases/calculate-dependencies : calculateDependencies
     *
     * @param dataSetId dataSetId (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "calculateDependencies",
        summary = "calculateDependencies",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseDependenciesResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/calculate-dependencies",
        produces = { "application/json" }
    )
    ResponseEntity<TestCaseDependenciesResponseDto> calculateDependencies(
        @NotNull @Parameter(name = "dataSetId", description = "dataSetId", required = true) @Valid @RequestParam(value = "dataSetId", required = true) UUID dataSetId
    );


    /**
     * POST /catalog/api/v1/testcases/datasets/compare : compareTestCasesDatasets
     *
     * @param compareTestCasesDatasetsRequestDto  (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "compareTestCasesDatasets",
        summary = "compareTestCasesDatasets",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = CompareTestCasesDatasetsResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/datasets/compare",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<CompareTestCasesDatasetsResponseDto> compareTestCasesDatasets(
        @Parameter(name = "CompareTestCasesDatasetsRequestDto", description = "") @Valid @RequestBody(required = false) CompareTestCasesDatasetsRequestDto compareTestCasesDatasetsRequestDto
    );


    /**
     * POST /catalog/api/v1/testcases/compare/copy : copyTestCaseWhileTestPlansCompare
     *
     * @param compareItemCopyRequestDto  (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "copyTestCaseWhileTestPlansCompare",
        summary = "copyTestCaseWhileTestPlansCompare",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseCompareCopyResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/compare/copy",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<TestCaseCompareCopyResponseDto> copyTestCaseWhileTestPlansCompare(
        @Parameter(name = "CompareItemCopyRequestDto", description = "") @Valid @RequestBody(required = false) CompareItemCopyRequestDto compareItemCopyRequestDto
    );


    /**
     * POST /catalog/api/v1/testcases/copy : copyTestCases
     *
     * @param copyRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "copyTestCases",
        summary = "copyTestCases",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/copy",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> copyTestCases(
        @Parameter(name = "CopyRequestDto", description = "") @Valid @RequestBody(required = false) CopyRequestDto copyRequestDto
    );


    /**
     * GET /catalog/api/v1/testcases/testscenarios/copy : copyTestCasesWithScenarios
     *
     * @param testCasesCopyRequestDto  (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "copyTestCasesWithScenarios",
        summary = "copyTestCasesWithScenarios",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testcases/testscenarios/copy",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> copyTestCasesWithScenarios(
        @Parameter(name = "TestCasesCopyRequestDto", description = "") @Valid @RequestBody(required = false) TestCasesCopyRequestDto testCasesCopyRequestDto
    );


    /**
     * POST /catalog/api/v1/testcases : create
     *
     * @param caseCreationRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "create",
        summary = "create",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<UUID>> create(
        @Parameter(name = "CaseCreationRequestDto", description = "") @Valid @RequestBody(required = false) CaseCreationRequestDto caseCreationRequestDto
    );


    /**
     * DELETE /catalog/api/v1/testcases : delete
     *
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "delete",
        summary = "delete",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/catalog/api/v1/testcases",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> delete(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) Set<UUID> UUID
    );


    /**
     * DELETE /catalog/api/v1/testcases/labels : deleteLabelsFromTestCases
     *
     * @param labelsRequestDto  (optional)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "deleteLabelsFromTestCases",
        summary = "deleteLabelsFromTestCases",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/catalog/api/v1/testcases/labels",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> deleteLabelsFromTestCases(
        @Parameter(name = "LabelsRequestDto", description = "") @Valid @RequestBody(required = false) LabelsRequestDto labelsRequestDto
    );


    /**
     * DELETE /catalog/api/v1/testcases/components : delete test case components
     *
     * @param testCaseComponentsDeleteRequestDto  (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "deleteTestCaseComponents",
        summary = "delete test case components",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseComponentsDeleteResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/catalog/api/v1/testcases/components",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<TestCaseComponentsDeleteResponseDto> deleteTestCaseComponents(
        @Parameter(name = "TestCaseComponentsDeleteRequestDto", description = "") @Valid @RequestBody(required = false) TestCaseComponentsDeleteRequestDto testCaseComponentsDeleteRequestDto
    );


    /**
     * GET /catalog/api/v1/testcases : getAll
     *
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAll",
        summary = "getAll",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testcases",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestCaseDto>> getAll(
        
    );


    /**
     * GET /catalog/api/v1/testcases/find-name-pagination : getAllNamesByNameWithPagination
     *
     * @param projectId projectId (required)
     * @param testPlanId testPlanId (required)
     * @param name name (required)
     * @param offset  (optional)
     * @param pageNumber  (optional)
     * @param pageSize  (optional)
     * @param paged  (optional)
     * @param sortSorted  (optional)
     * @param sortUnsorted  (optional)
     * @param unpaged  (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAllNamesByNameWithPagination",
        summary = "getAllNamesByNameWithPagination",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = PageAbstractEntityResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testcases/find-name-pagination",
        produces = { "application/json" }
    )
    ResponseEntity<PageAbstractEntityResponseDto> getAllNamesByNameWithPagination(
        @NotNull @Parameter(name = "projectId", description = "projectId", required = true) @Valid @RequestParam(value = "projectId", required = true) UUID projectId,
        @NotNull @Parameter(name = "testPlanId", description = "testPlanId", required = true) @Valid @RequestParam(value = "testPlanId", required = true) UUID testPlanId,
        @NotNull @Parameter(name = "name", description = "name", required = true) @Valid @RequestParam(value = "name", required = true) String name,
        @Parameter(name = "offset", description = "") @Valid @RequestParam(value = "offset", required = false) Long offset,
        @Parameter(name = "pageNumber", description = "") @Valid @RequestParam(value = "pageNumber", required = false) Integer pageNumber,
        @Parameter(name = "pageSize", description = "") @Valid @RequestParam(value = "pageSize", required = false) Integer pageSize,
        @Parameter(name = "paged", description = "") @Valid @RequestParam(value = "paged", required = false) Boolean paged,
        @Parameter(name = "sort.sorted", description = "") @Valid @RequestParam(value = "sort.sorted", required = false) Boolean sortSorted,
        @Parameter(name = "sort.unsorted", description = "") @Valid @RequestParam(value = "sort.unsorted", required = false) Boolean sortUnsorted,
        @Parameter(name = "unpaged", description = "") @Valid @RequestParam(value = "unpaged", required = false) Boolean unpaged
    );


    /**
     * POST /catalog/api/v1/testcases/labels/search : getCaseLabels
     *
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getCaseLabels",
        summary = "getCaseLabels",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseLabelResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/labels/search",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<TestCaseLabelResponseDto>> getCaseLabels(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) Set<UUID> UUID
    );


    /**
     * GET /catalog/api/v1/testcases/dataSetLists/{dslId}/usages : getDataSetListTestCasesUsages
     *
     * @param dslId data set list id (required)
     * @param page page number (required)
     * @param size size number (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetListTestCasesUsages",
        summary = "getDataSetListTestCasesUsages",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = PaginationResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testcases/dataSetLists/{dslId}/usages",
        produces = { "application/json" }
    )
    ResponseEntity<PaginationResponseDto> getDataSetListTestCasesUsages(
        @Parameter(name = "dslId", description = "data set list id", required = true) @PathVariable("dslId") UUID dslId,
        @NotNull @Parameter(name = "page", description = "page number", required = true) @Valid @RequestParam(value = "page", required = true) Integer page,
        @NotNull @Parameter(name = "size", description = "size number", required = true) @Valid @RequestParam(value = "size", required = true) Integer size
    );


    /**
     * GET /catalog/api/v1/testcases/dataSetLists/{dslId}/usages/count : getDataSetListTestCasesUsagesCount
     *
     * @param dslId data set list id (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetListTestCasesUsagesCount",
        summary = "getDataSetListTestCasesUsagesCount",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Integer.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testcases/dataSetLists/{dslId}/usages/count",
        produces = { "application/json" }
    )
    ResponseEntity<Integer> getDataSetListTestCasesUsagesCount(
        @Parameter(name = "dslId", description = "data set list id", required = true) @PathVariable("dslId") UUID dslId
    );


    /**
     * GET /catalog/api/v1/testcases/datasets/{dslId}/usages : getDataSetTestCasesUsages
     *
     * @param dslId data set list id (required)
     * @param page page number (required)
     * @param size size number (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetTestCasesUsages",
        summary = "getDataSetTestCasesUsages",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = PaginationResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testcases/datasets/{dslId}/usages",
        produces = { "application/json" }
    )
    ResponseEntity<PaginationResponseDto> getDataSetTestCasesUsages(
        @Parameter(name = "dslId", description = "data set list id", required = true) @PathVariable("dslId") UUID dslId,
        @NotNull @Parameter(name = "page", description = "page number", required = true) @Valid @RequestParam(value = "page", required = true) Integer page,
        @NotNull @Parameter(name = "size", description = "size number", required = true) @Valid @RequestParam(value = "size", required = true) Integer size
    );


    /**
     * GET /catalog/api/v1/testcases/datasets/{dsId}/usages/count : getDataSetTestCasesUsagesCount
     *
     * @param dsId data set id (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDataSetTestCasesUsagesCount",
        summary = "getDataSetTestCasesUsagesCount",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Integer.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testcases/datasets/{dsId}/usages/count",
        produces = { "application/json" }
    )
    ResponseEntity<Integer> getDataSetTestCasesUsagesCount(
        @Parameter(name = "dsId", description = "data set id", required = true) @PathVariable("dsId") UUID dsId
    );


    /**
     * GET /catalog/api/v1/testcases/{uuid}/detailed : getDetailedCase
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDetailedCase",
        summary = "getDetailedCase",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testcases/{uuid}/detailed",
        produces = { "application/json" }
    )
    ResponseEntity<TestCaseResponseDto> getDetailedCase(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /catalog/api/v1/testcases/detailed : getDetailedCases
     *
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getDetailedCases",
        summary = "getDetailedCases",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/detailed",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<TestCaseResponseDto>> getDetailedCases(
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) Set<UUID> UUID
    );


    /**
     * GET /catalog/api/v1/testcases/{uuid}/enriched : getEnrichedCase
     *
     * @param uuid uuid (required)
     * @param testscopeid testscopeid (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnrichedCase",
        summary = "getEnrichedCase",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnrichedCaseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testcases/{uuid}/enriched",
        produces = { "application/json" }
    )
    ResponseEntity<EnrichedCaseDto> getEnrichedCase(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid,
        @Parameter(name = "testscopeid", description = "testscopeid") @Valid @RequestParam(value = "testscopeid", required = false) UUID testscopeid
    );


    /**
     * POST /catalog/api/v1/testcases/enriched : getEnrichedCases
     *
     * @param testscopeid testscopeid (optional)
     * @param UUID  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getEnrichedCases",
        summary = "getEnrichedCases",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnrichedCaseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/enriched",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<EnrichedCaseDto>> getEnrichedCases(
        @Parameter(name = "testscopeid", description = "testscopeid") @Valid @RequestParam(value = "testscopeid", required = false) UUID testscopeid,
        @Parameter(name = "UUID", description = "") @Valid @RequestBody(required = false) Set<UUID> UUID
    );


    /**
     * GET /catalog/api/v1/testcases/{uuid}/testscenario-id : getScenarioIdByTestCaseId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getScenarioIdByTestCaseId",
        summary = "getScenarioIdByTestCaseId",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = UUID.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testcases/{uuid}/testscenario-id",
        produces = { "application/json" }
    )
    ResponseEntity<UUID> getScenarioIdByTestCaseId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /catalog/api/v1/testcases/components/search : search test case components
     *
     * @param testCaseComponentsSearchRequestDto  (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestCaseComponents",
        summary = "search test case components",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = JiraComponentDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/components/search",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<JiraComponentDto>> getTestCaseComponents(
        @Parameter(name = "TestCaseComponentsSearchRequestDto", description = "") @Valid @RequestBody(required = false) TestCaseComponentsSearchRequestDto testCaseComponentsSearchRequestDto
    );


    /**
     * GET /catalog/api/v1/testcases/{uuid} : getTestCaseWithLabelsByUuid
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestCaseWithLabelsByUuid",
        summary = "getTestCaseWithLabelsByUuid",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testcases/{uuid}",
        produces = { "application/json" }
    )
    ResponseEntity<TestCaseDto> getTestCaseWithLabelsByUuid(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /catalog/api/v1/testcases/search/DS/{uuid} : getTestCasesByDsId
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestCasesByDsId",
        summary = "getTestCasesByDsId",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Integer.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/search/DS/{uuid}",
        produces = { "application/json" }
    )
    ResponseEntity<Integer> getTestCasesByDsId(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /catalog/api/v1/testcases/search/by_ids : getTestCasesByIds
     *
     * @param caseSearchRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestCasesByIds",
        summary = "getTestCasesByIds",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/search/by_ids",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<TestCaseDto>> getTestCasesByIds(
        @Parameter(name = "CaseSearchRequestDto", description = "") @Valid @RequestBody(required = false) CaseSearchRequestDto caseSearchRequestDto
    );


    /**
     * GET /catalog/api/v1/testcases/project/{uuid} : getTestCasesByProjectUuid
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getTestCasesByProjectUuid",
        summary = "getTestCasesByProjectUuid",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/testcases/project/{uuid}",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestCaseResponseDto>> getTestCasesByProjectUuid(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /catalog/api/v1/testcases/move : moveTestCases
     *
     * @param moveRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "moveTestCases",
        summary = "moveTestCases",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/move",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> moveTestCases(
        @Parameter(name = "MoveRequestDto", description = "") @Valid @RequestBody(required = false) MoveRequestDto moveRequestDto
    );


    /**
     * PATCH /catalog/api/v1/testcases/{uuid} : patch
     *
     * @param uuid uuid (required)
     * @param casePatchUpdateRequestDto  (optional)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "patch",
        summary = "patch",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.PATCH,
        value = "/catalog/api/v1/testcases/{uuid}",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> patch(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid,
        @Parameter(name = "CasePatchUpdateRequestDto", description = "") @Valid @RequestBody(required = false) CasePatchUpdateRequestDto casePatchUpdateRequestDto
    );


    /**
     * PUT /catalog/api/v1/testcases/{uuid}/patch : patchUpdate
     *
     * @param uuid uuid (required)
     * @param casePatchUpdateRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     * @deprecated
     */
    @Deprecated
    @Operation(
        operationId = "patchUpdate",
        summary = "patchUpdate",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/catalog/api/v1/testcases/{uuid}/patch",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> patchUpdate(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid,
        @Parameter(name = "CasePatchUpdateRequestDto", description = "") @Valid @RequestBody(required = false) CasePatchUpdateRequestDto casePatchUpdateRequestDto
    );


    /**
     * POST /catalog/api/v1/testcases/dataset/replace : replaceTestCasesDataset
     *
     * @param testCasesDataSetReplaceRequestDto  (optional)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "replaceTestCasesDataset",
        summary = "replaceTestCasesDataset",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/dataset/replace",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> replaceTestCasesDataset(
        @Parameter(name = "TestCasesDataSetReplaceRequestDto", description = "") @Valid @RequestBody(required = false) TestCasesDataSetReplaceRequestDto testCasesDataSetReplaceRequestDto
    );


    /**
     * POST /catalog/api/v1/testcases/search : search test cases
     *
     * @param testCaseSearchRequestDto  (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "search",
        summary = "search test cases",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/search",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<TestCaseDto> search(
        @Parameter(name = "TestCaseSearchRequestDto", description = "") @Valid @RequestBody(required = false) TestCaseSearchRequestDto testCaseSearchRequestDto
    );


    /**
     * POST /catalog/api/v1/testcases/enriched/search : searchEnrichedCases
     *
     * @param testscopeid testscopeid (optional)
     * @param caseSearchRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "searchEnrichedCases",
        summary = "searchEnrichedCases",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = EnrichedCaseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/enriched/search",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<EnrichedCaseDto>> searchEnrichedCases(
        @Parameter(name = "testscopeid", description = "testscopeid") @Valid @RequestParam(value = "testscopeid", required = false) UUID testscopeid,
        @Parameter(name = "CaseSearchRequestDto", description = "") @Valid @RequestBody(required = false) CaseSearchRequestDto caseSearchRequestDto
    );


    /**
     * POST /catalog/api/v1/testcases/components/set : set test case components
     *
     * @param testCaseComponentsSetRequestDto  (optional)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "setTestCaseComponents",
        summary = "set test case components",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/components/set",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> setTestCaseComponents(
        @Parameter(name = "TestCaseComponentsSetRequestDto", description = "") @Valid @RequestBody(required = false) TestCaseComponentsSetRequestDto testCaseComponentsSetRequestDto
    );


    /**
     * POST /catalog/api/v1/testcases/datasets/set : setTestCaseDatasets
     *
     * @param testCaseDatasetsSetRequestDto  (optional)
     * @return No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "setTestCaseDatasets",
        summary = "setTestCaseDatasets",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/datasets/set",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> setTestCaseDatasets(
        @Parameter(name = "TestCaseDatasetsSetRequestDto", description = "") @Valid @RequestBody(required = false) TestCaseDatasetsSetRequestDto testCaseDatasetsSetRequestDto
    );


    /**
     * PUT /catalog/api/v1/testcases/{uuid} : update
     *
     * @param uuid uuid (required)
     * @param caseUpdateRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "update",
        summary = "update",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/catalog/api/v1/testcases/{uuid}",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> update(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid,
        @Parameter(name = "CaseUpdateRequestDto", description = "") @Valid @RequestBody(required = false) CaseUpdateRequestDto caseUpdateRequestDto
    );


    /**
     * POST /catalog/api/v1/testcases/status-update : updateCaseStatuses
     *
     * @param testCaseLastStatusDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "updateCaseStatuses",
        summary = "updateCaseStatuses",
        tags = { "test-case-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/testcases/status-update",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> updateCaseStatuses(
        @Parameter(name = "TestCaseLastStatusDto", description = "") @Valid @RequestBody(required = false) List<TestCaseLastStatusDto> testCaseLastStatusDto
    );

}
