package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.MetaInfoDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.UserInfoResDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * AbstractTestScenarioDto
 */

@JsonTypeName("AbstractTestScenario")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:34:55.204580639Z[Etc/UTC]")
public class AbstractTestScenarioDto {

  @JsonProperty("createdBy")
  private UserInfoResDto createdBy;

  @JsonProperty("createdWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdWhen;

  @JsonProperty("description")
  private String description;

  @JsonProperty("metainfo")
  @Valid
  private List<MetaInfoDto> metainfo = null;

  @JsonProperty("modifiedBy")
  private UserInfoResDto modifiedBy;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    COMPOUND("COMPOUND"),
    
    TESTSCENARIO("TESTSCENARIO");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  @JsonProperty("uuid")
  private UUID uuid;

  public AbstractTestScenarioDto createdBy(UserInfoResDto createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", required = false)
  public UserInfoResDto getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UserInfoResDto createdBy) {
    this.createdBy = createdBy;
  }

  public AbstractTestScenarioDto createdWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
    return this;
  }

  /**
   * Get createdWhen
   * @return createdWhen
  */
  @Valid 
  @Schema(name = "createdWhen", required = false)
  public OffsetDateTime getCreatedWhen() {
    return createdWhen;
  }

  public void setCreatedWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
  }

  public AbstractTestScenarioDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public AbstractTestScenarioDto metainfo(List<MetaInfoDto> metainfo) {
    this.metainfo = metainfo;
    return this;
  }

  public AbstractTestScenarioDto addMetainfoItem(MetaInfoDto metainfoItem) {
    if (this.metainfo == null) {
      this.metainfo = new ArrayList<>();
    }
    this.metainfo.add(metainfoItem);
    return this;
  }

  /**
   * Get metainfo
   * @return metainfo
  */
  @Valid 
  @Schema(name = "metainfo", required = false)
  public List<MetaInfoDto> getMetainfo() {
    return metainfo;
  }

  public void setMetainfo(List<MetaInfoDto> metainfo) {
    this.metainfo = metainfo;
  }

  public AbstractTestScenarioDto modifiedBy(UserInfoResDto modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  @Valid 
  @Schema(name = "modifiedBy", required = false)
  public UserInfoResDto getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(UserInfoResDto modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public AbstractTestScenarioDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public AbstractTestScenarioDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public AbstractTestScenarioDto type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  
  @Schema(name = "type", required = false)
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public AbstractTestScenarioDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AbstractTestScenarioDto abstractTestScenario = (AbstractTestScenarioDto) o;
    return Objects.equals(this.createdBy, abstractTestScenario.createdBy) &&
        Objects.equals(this.createdWhen, abstractTestScenario.createdWhen) &&
        Objects.equals(this.description, abstractTestScenario.description) &&
        Objects.equals(this.metainfo, abstractTestScenario.metainfo) &&
        Objects.equals(this.modifiedBy, abstractTestScenario.modifiedBy) &&
        Objects.equals(this.modifiedWhen, abstractTestScenario.modifiedWhen) &&
        Objects.equals(this.name, abstractTestScenario.name) &&
        Objects.equals(this.type, abstractTestScenario.type) &&
        Objects.equals(this.uuid, abstractTestScenario.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(createdBy, createdWhen, description, metainfo, modifiedBy, modifiedWhen, name, type, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AbstractTestScenarioDto {\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createdWhen: ").append(toIndentedString(createdWhen)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    metainfo: ").append(toIndentedString(metainfo)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

