package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseCompareDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CompareTestPlansResponseDto
 */

@JsonTypeName("CompareTestPlansResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:34:55.204580639Z[Etc/UTC]")
public class CompareTestPlansResponseDto {

  @JsonProperty("leftTestPlanId")
  private UUID leftTestPlanId;

  @JsonProperty("leftTestPlanName")
  private String leftTestPlanName;

  @JsonProperty("rightTestPlanId")
  private UUID rightTestPlanId;

  @JsonProperty("rightTestPlanName")
  private String rightTestPlanName;

  @JsonProperty("testCases")
  @Valid
  private List<TestCaseCompareDto> testCases = null;

  @JsonProperty("total")
  private BigDecimal total;

  public CompareTestPlansResponseDto leftTestPlanId(UUID leftTestPlanId) {
    this.leftTestPlanId = leftTestPlanId;
    return this;
  }

  /**
   * Get leftTestPlanId
   * @return leftTestPlanId
  */
  @Valid 
  @Schema(name = "leftTestPlanId", required = false)
  public UUID getLeftTestPlanId() {
    return leftTestPlanId;
  }

  public void setLeftTestPlanId(UUID leftTestPlanId) {
    this.leftTestPlanId = leftTestPlanId;
  }

  public CompareTestPlansResponseDto leftTestPlanName(String leftTestPlanName) {
    this.leftTestPlanName = leftTestPlanName;
    return this;
  }

  /**
   * Get leftTestPlanName
   * @return leftTestPlanName
  */
  
  @Schema(name = "leftTestPlanName", required = false)
  public String getLeftTestPlanName() {
    return leftTestPlanName;
  }

  public void setLeftTestPlanName(String leftTestPlanName) {
    this.leftTestPlanName = leftTestPlanName;
  }

  public CompareTestPlansResponseDto rightTestPlanId(UUID rightTestPlanId) {
    this.rightTestPlanId = rightTestPlanId;
    return this;
  }

  /**
   * Get rightTestPlanId
   * @return rightTestPlanId
  */
  @Valid 
  @Schema(name = "rightTestPlanId", required = false)
  public UUID getRightTestPlanId() {
    return rightTestPlanId;
  }

  public void setRightTestPlanId(UUID rightTestPlanId) {
    this.rightTestPlanId = rightTestPlanId;
  }

  public CompareTestPlansResponseDto rightTestPlanName(String rightTestPlanName) {
    this.rightTestPlanName = rightTestPlanName;
    return this;
  }

  /**
   * Get rightTestPlanName
   * @return rightTestPlanName
  */
  
  @Schema(name = "rightTestPlanName", required = false)
  public String getRightTestPlanName() {
    return rightTestPlanName;
  }

  public void setRightTestPlanName(String rightTestPlanName) {
    this.rightTestPlanName = rightTestPlanName;
  }

  public CompareTestPlansResponseDto testCases(List<TestCaseCompareDto> testCases) {
    this.testCases = testCases;
    return this;
  }

  public CompareTestPlansResponseDto addTestCasesItem(TestCaseCompareDto testCasesItem) {
    if (this.testCases == null) {
      this.testCases = new ArrayList<>();
    }
    this.testCases.add(testCasesItem);
    return this;
  }

  /**
   * Get testCases
   * @return testCases
  */
  @Valid 
  @Schema(name = "testCases", required = false)
  public List<TestCaseCompareDto> getTestCases() {
    return testCases;
  }

  public void setTestCases(List<TestCaseCompareDto> testCases) {
    this.testCases = testCases;
  }

  public CompareTestPlansResponseDto total(BigDecimal total) {
    this.total = total;
    return this;
  }

  /**
   * Get total
   * @return total
  */
  @Valid 
  @Schema(name = "total", required = false)
  public BigDecimal getTotal() {
    return total;
  }

  public void setTotal(BigDecimal total) {
    this.total = total;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompareTestPlansResponseDto compareTestPlansResponse = (CompareTestPlansResponseDto) o;
    return Objects.equals(this.leftTestPlanId, compareTestPlansResponse.leftTestPlanId) &&
        Objects.equals(this.leftTestPlanName, compareTestPlansResponse.leftTestPlanName) &&
        Objects.equals(this.rightTestPlanId, compareTestPlansResponse.rightTestPlanId) &&
        Objects.equals(this.rightTestPlanName, compareTestPlansResponse.rightTestPlanName) &&
        Objects.equals(this.testCases, compareTestPlansResponse.testCases) &&
        Objects.equals(this.total, compareTestPlansResponse.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(leftTestPlanId, leftTestPlanName, rightTestPlanId, rightTestPlanName, testCases, total);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompareTestPlansResponseDto {\n");
    sb.append("    leftTestPlanId: ").append(toIndentedString(leftTestPlanId)).append("\n");
    sb.append("    leftTestPlanName: ").append(toIndentedString(leftTestPlanName)).append("\n");
    sb.append("    rightTestPlanId: ").append(toIndentedString(rightTestPlanId)).append("\n");
    sb.append("    rightTestPlanName: ").append(toIndentedString(rightTestPlanName)).append("\n");
    sb.append("    testCases: ").append(toIndentedString(testCases)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

