package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.ram.clients.api.dto.catalogue.ActionParameterDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.MapActionParameterDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ComplexActionParameterDto
 */

@JsonTypeName("ComplexActionParameter")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:34:56.638351493Z[Etc/UTC]")
public class ComplexActionParameterDto {

  @JsonProperty("arrayParams")
  @Valid
  private List<ActionParameterDto> arrayParams = null;

  @JsonProperty("mapParams")
  @Valid
  private List<MapActionParameterDto> mapParams = null;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    ARRAY("ARRAY"),
    
    MAP("MAP");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  public ComplexActionParameterDto arrayParams(List<ActionParameterDto> arrayParams) {
    this.arrayParams = arrayParams;
    return this;
  }

  public ComplexActionParameterDto addArrayParamsItem(ActionParameterDto arrayParamsItem) {
    if (this.arrayParams == null) {
      this.arrayParams = new ArrayList<>();
    }
    this.arrayParams.add(arrayParamsItem);
    return this;
  }

  /**
   * Get arrayParams
   * @return arrayParams
  */
  @Valid 
  @Schema(name = "arrayParams", required = false)
  public List<ActionParameterDto> getArrayParams() {
    return arrayParams;
  }

  public void setArrayParams(List<ActionParameterDto> arrayParams) {
    this.arrayParams = arrayParams;
  }

  public ComplexActionParameterDto mapParams(List<MapActionParameterDto> mapParams) {
    this.mapParams = mapParams;
    return this;
  }

  public ComplexActionParameterDto addMapParamsItem(MapActionParameterDto mapParamsItem) {
    if (this.mapParams == null) {
      this.mapParams = new ArrayList<>();
    }
    this.mapParams.add(mapParamsItem);
    return this;
  }

  /**
   * Get mapParams
   * @return mapParams
  */
  @Valid 
  @Schema(name = "mapParams", required = false)
  public List<MapActionParameterDto> getMapParams() {
    return mapParams;
  }

  public void setMapParams(List<MapActionParameterDto> mapParams) {
    this.mapParams = mapParams;
  }

  public ComplexActionParameterDto type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  
  @Schema(name = "type", required = false)
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ComplexActionParameterDto complexActionParameter = (ComplexActionParameterDto) o;
    return Objects.equals(this.arrayParams, complexActionParameter.arrayParams) &&
        Objects.equals(this.mapParams, complexActionParameter.mapParams) &&
        Objects.equals(this.type, complexActionParameter.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(arrayParams, mapParams, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ComplexActionParameterDto {\n");
    sb.append("    arrayParams: ").append(toIndentedString(arrayParams)).append("\n");
    sb.append("    mapParams: ").append(toIndentedString(mapParams)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

