package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CompoundCopyItemDto
 */

@JsonTypeName("CompoundCopyItem")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:34:55.599097266Z[Etc/UTC]")
public class CompoundCopyItemDto {

  @JsonProperty("id")
  private UUID id;

  /**
   * Gets or Sets copyOption
   */
  public enum CopyOptionEnum {
    COPY("COPY"),
    
    OVERWRITE("OVERWRITE");

    private String value;

    CopyOptionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CopyOptionEnum fromValue(String value) {
      for (CopyOptionEnum b : CopyOptionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("copyOption")
  private CopyOptionEnum copyOption;

  public CompoundCopyItemDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public CompoundCopyItemDto copyOption(CopyOptionEnum copyOption) {
    this.copyOption = copyOption;
    return this;
  }

  /**
   * Get copyOption
   * @return copyOption
  */
  
  @Schema(name = "copyOption", required = false)
  public CopyOptionEnum getCopyOption() {
    return copyOption;
  }

  public void setCopyOption(CopyOptionEnum copyOption) {
    this.copyOption = copyOption;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompoundCopyItemDto compoundCopyItem = (CompoundCopyItemDto) o;
    return Objects.equals(this.id, compoundCopyItem.id) &&
        Objects.equals(this.copyOption, compoundCopyItem.copyOption);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, copyOption);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompoundCopyItemDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    copyOption: ").append(toIndentedString(copyOption)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

