package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseResponseDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * DetailedTestScopeResponseDto
 */

@JsonTypeName("DetailedTestScopeResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:34:55.599097266Z[Etc/UTC]")
public class DetailedTestScopeResponseDto {

  @JsonProperty("description")
  private String description;

  @JsonProperty("execution")
  @Valid
  private List<TestCaseResponseDto> execution = null;

  @JsonProperty("flagIds")
  @Valid
  private List<UUID> flagIds = null;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  @JsonProperty("prerequisites")
  @Valid
  private List<TestCaseResponseDto> prerequisites = null;

  @JsonProperty("validation")
  @Valid
  private List<TestCaseResponseDto> validation = null;

  @JsonProperty("widgetConfigTemplateId")
  private UUID widgetConfigTemplateId;

  public DetailedTestScopeResponseDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public DetailedTestScopeResponseDto execution(List<TestCaseResponseDto> execution) {
    this.execution = execution;
    return this;
  }

  public DetailedTestScopeResponseDto addExecutionItem(TestCaseResponseDto executionItem) {
    if (this.execution == null) {
      this.execution = new ArrayList<>();
    }
    this.execution.add(executionItem);
    return this;
  }

  /**
   * Get execution
   * @return execution
  */
  @Valid 
  @Schema(name = "execution", required = false)
  public List<TestCaseResponseDto> getExecution() {
    return execution;
  }

  public void setExecution(List<TestCaseResponseDto> execution) {
    this.execution = execution;
  }

  public DetailedTestScopeResponseDto flagIds(List<UUID> flagIds) {
    this.flagIds = flagIds;
    return this;
  }

  public DetailedTestScopeResponseDto addFlagIdsItem(UUID flagIdsItem) {
    if (this.flagIds == null) {
      this.flagIds = new ArrayList<>();
    }
    this.flagIds.add(flagIdsItem);
    return this;
  }

  /**
   * Get flagIds
   * @return flagIds
  */
  @Valid 
  @Schema(name = "flagIds", required = false)
  public List<UUID> getFlagIds() {
    return flagIds;
  }

  public void setFlagIds(List<UUID> flagIds) {
    this.flagIds = flagIds;
  }

  public DetailedTestScopeResponseDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public DetailedTestScopeResponseDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public DetailedTestScopeResponseDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public DetailedTestScopeResponseDto prerequisites(List<TestCaseResponseDto> prerequisites) {
    this.prerequisites = prerequisites;
    return this;
  }

  public DetailedTestScopeResponseDto addPrerequisitesItem(TestCaseResponseDto prerequisitesItem) {
    if (this.prerequisites == null) {
      this.prerequisites = new ArrayList<>();
    }
    this.prerequisites.add(prerequisitesItem);
    return this;
  }

  /**
   * Get prerequisites
   * @return prerequisites
  */
  @Valid 
  @Schema(name = "prerequisites", required = false)
  public List<TestCaseResponseDto> getPrerequisites() {
    return prerequisites;
  }

  public void setPrerequisites(List<TestCaseResponseDto> prerequisites) {
    this.prerequisites = prerequisites;
  }

  public DetailedTestScopeResponseDto validation(List<TestCaseResponseDto> validation) {
    this.validation = validation;
    return this;
  }

  public DetailedTestScopeResponseDto addValidationItem(TestCaseResponseDto validationItem) {
    if (this.validation == null) {
      this.validation = new ArrayList<>();
    }
    this.validation.add(validationItem);
    return this;
  }

  /**
   * Get validation
   * @return validation
  */
  @Valid 
  @Schema(name = "validation", required = false)
  public List<TestCaseResponseDto> getValidation() {
    return validation;
  }

  public void setValidation(List<TestCaseResponseDto> validation) {
    this.validation = validation;
  }

  public DetailedTestScopeResponseDto widgetConfigTemplateId(UUID widgetConfigTemplateId) {
    this.widgetConfigTemplateId = widgetConfigTemplateId;
    return this;
  }

  /**
   * Get widgetConfigTemplateId
   * @return widgetConfigTemplateId
  */
  @Valid 
  @Schema(name = "widgetConfigTemplateId", required = false)
  public UUID getWidgetConfigTemplateId() {
    return widgetConfigTemplateId;
  }

  public void setWidgetConfigTemplateId(UUID widgetConfigTemplateId) {
    this.widgetConfigTemplateId = widgetConfigTemplateId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DetailedTestScopeResponseDto detailedTestScopeResponse = (DetailedTestScopeResponseDto) o;
    return Objects.equals(this.description, detailedTestScopeResponse.description) &&
        Objects.equals(this.execution, detailedTestScopeResponse.execution) &&
        Objects.equals(this.flagIds, detailedTestScopeResponse.flagIds) &&
        Objects.equals(this.id, detailedTestScopeResponse.id) &&
        Objects.equals(this.modifiedWhen, detailedTestScopeResponse.modifiedWhen) &&
        Objects.equals(this.name, detailedTestScopeResponse.name) &&
        Objects.equals(this.prerequisites, detailedTestScopeResponse.prerequisites) &&
        Objects.equals(this.validation, detailedTestScopeResponse.validation) &&
        Objects.equals(this.widgetConfigTemplateId, detailedTestScopeResponse.widgetConfigTemplateId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, execution, flagIds, id, modifiedWhen, name, prerequisites, validation, widgetConfigTemplateId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DetailedTestScopeResponseDto {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    execution: ").append(toIndentedString(execution)).append("\n");
    sb.append("    flagIds: ").append(toIndentedString(flagIds)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    prerequisites: ").append(toIndentedString(prerequisites)).append("\n");
    sb.append("    validation: ").append(toIndentedString(validation)).append("\n");
    sb.append("    widgetConfigTemplateId: ").append(toIndentedString(widgetConfigTemplateId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

