package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.EnrichedScenarioDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.ItemDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ExecuteRequestDto
 */

@JsonTypeName("ExecuteRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:34:56.638351493Z[Etc/UTC]")
public class ExecuteRequestDto {

  @JsonProperty("autoSyncCasesWithJira")
  private Boolean autoSyncCasesWithJira;

  @JsonProperty("autoSyncRunsWithJira")
  private Boolean autoSyncRunsWithJira;

  @JsonProperty("contextVariables")
  private Object contextVariables;

  @JsonProperty("emailRecipients")
  @Valid
  private List<String> emailRecipients = null;

  @JsonProperty("emailSubject")
  private String emailSubject;

  @JsonProperty("emailTemplateId")
  private UUID emailTemplateId;

  @JsonProperty("environmentIds")
  @Valid
  private List<UUID> environmentIds = new ArrayList<>();

  @JsonProperty("executeExecution")
  private Boolean executeExecution;

  @JsonProperty("executePrerequisites")
  private Boolean executePrerequisites;

  @JsonProperty("executeValidation")
  private Boolean executeValidation;

  /**
   * Gets or Sets flags
   */
  public enum FlagsEnum {
    COLLECT_LOGS("COLLECT_LOGS"),
    
    COLLECT_LOGS_ON_FAIL("COLLECT_LOGS_ON_FAIL"),
    
    COLLECT_LOGS_ON_SKIPPED("COLLECT_LOGS_ON_SKIPPED"),
    
    COLLECT_LOGS_ON_WARNING("COLLECT_LOGS_ON_WARNING"),
    
    DO_NOT_PASS_INITIAL_CONTEXT("DO_NOT_PASS_INITIAL_CONTEXT"),
    
    EXECUTE_ANYWAY("EXECUTE_ANYWAY"),
    
    FAIL_IMMEDIATELY("FAIL_IMMEDIATELY"),
    
    IGNORE_PREREQUISITE_IN_PASS_RATE("IGNORE_PREREQUISITE_IN_PASS_RATE"),
    
    IGNORE_VALIDATION_IN_PASS_RATE("IGNORE_VALIDATION_IN_PASS_RATE"),
    
    INVERT_RESULT("INVERT_RESULT"),
    
    SKIP("SKIP"),
    
    SKIP_IF_DEPENDENCIES_FAIL("SKIP_IF_DEPENDENCIES_FAIL"),
    
    STOP_ON_FAIL("STOP_ON_FAIL"),
    
    SKIP_ON_PASS("SKIP_ON_PASS"),
    
    TERMINATE_IF_FAIL("TERMINATE_IF_FAIL"),
    
    TERMINATE_IF_PREREQUISITE_FAIL("TERMINATE_IF_PREREQUISITE_FAIL"),
    
    COLLECT_SSM_METRICS_ON_FAIL("COLLECT_SSM_METRICS_ON_FAIL");

    private String value;

    FlagsEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static FlagsEnum fromValue(String value) {
      for (FlagsEnum b : FlagsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("flags")
  @Valid
  private List<FlagsEnum> flags = null;

  @JsonProperty("labelTemplateId")
  private UUID labelTemplateId;

  @JsonProperty("logCollectorTemplateId")
  private UUID logCollectorTemplateId;

  @JsonProperty("name")
  private String name;

  @JsonProperty("projectId")
  private UUID projectId;

  @JsonProperty("taToolIds")
  @Valid
  private List<UUID> taToolIds = new ArrayList<>();

  @JsonProperty("testCaseIds")
  @Valid
  private List<UUID> testCaseIds = null;

  @JsonProperty("testScenarios")
  @Valid
  private List<EnrichedScenarioDto> testScenarios = null;

  @JsonProperty("testPlanId")
  private UUID testPlanId;

  @JsonProperty("testScopeId")
  private UUID testScopeId;

  @JsonProperty("threadCount")
  private Integer threadCount;

  @JsonProperty("widgetConfigTemplateId")
  private UUID widgetConfigTemplateId;

  @JsonProperty("filterLabels")
  @Valid
  private List<ItemDto> filterLabels = null;

  @JsonProperty("isMandatoryCheck")
  private Boolean isMandatoryCheck;

  @JsonProperty("isSsmCheck")
  private Boolean isSsmCheck;

  @JsonProperty("isIgnoreFailedChecks")
  private Boolean isIgnoreFailedChecks;

  @JsonProperty("jointExecutionKey")
  private UUID jointExecutionKey;

  @JsonProperty("jointExecutionCount")
  private BigDecimal jointExecutionCount;

  @JsonProperty("jointExecutionTimeout")
  private BigDecimal jointExecutionTimeout;

  @JsonProperty("dataSetStorageId")
  private UUID dataSetStorageId;

  @JsonProperty("datasetId")
  private UUID datasetId;

  public ExecuteRequestDto autoSyncCasesWithJira(Boolean autoSyncCasesWithJira) {
    this.autoSyncCasesWithJira = autoSyncCasesWithJira;
    return this;
  }

  /**
   * Get autoSyncCasesWithJira
   * @return autoSyncCasesWithJira
  */
  
  @Schema(name = "autoSyncCasesWithJira", required = false)
  public Boolean getAutoSyncCasesWithJira() {
    return autoSyncCasesWithJira;
  }

  public void setAutoSyncCasesWithJira(Boolean autoSyncCasesWithJira) {
    this.autoSyncCasesWithJira = autoSyncCasesWithJira;
  }

  public ExecuteRequestDto autoSyncRunsWithJira(Boolean autoSyncRunsWithJira) {
    this.autoSyncRunsWithJira = autoSyncRunsWithJira;
    return this;
  }

  /**
   * Get autoSyncRunsWithJira
   * @return autoSyncRunsWithJira
  */
  
  @Schema(name = "autoSyncRunsWithJira", required = false)
  public Boolean getAutoSyncRunsWithJira() {
    return autoSyncRunsWithJira;
  }

  public void setAutoSyncRunsWithJira(Boolean autoSyncRunsWithJira) {
    this.autoSyncRunsWithJira = autoSyncRunsWithJira;
  }

  public ExecuteRequestDto contextVariables(Object contextVariables) {
    this.contextVariables = contextVariables;
    return this;
  }

  /**
   * Get contextVariables
   * @return contextVariables
  */
  
  @Schema(name = "contextVariables", required = false)
  public Object getContextVariables() {
    return contextVariables;
  }

  public void setContextVariables(Object contextVariables) {
    this.contextVariables = contextVariables;
  }

  public ExecuteRequestDto emailRecipients(List<String> emailRecipients) {
    this.emailRecipients = emailRecipients;
    return this;
  }

  public ExecuteRequestDto addEmailRecipientsItem(String emailRecipientsItem) {
    if (this.emailRecipients == null) {
      this.emailRecipients = new ArrayList<>();
    }
    this.emailRecipients.add(emailRecipientsItem);
    return this;
  }

  /**
   * Get emailRecipients
   * @return emailRecipients
  */
  
  @Schema(name = "emailRecipients", required = false)
  public List<String> getEmailRecipients() {
    return emailRecipients;
  }

  public void setEmailRecipients(List<String> emailRecipients) {
    this.emailRecipients = emailRecipients;
  }

  public ExecuteRequestDto emailSubject(String emailSubject) {
    this.emailSubject = emailSubject;
    return this;
  }

  /**
   * Get emailSubject
   * @return emailSubject
  */
  
  @Schema(name = "emailSubject", required = false)
  public String getEmailSubject() {
    return emailSubject;
  }

  public void setEmailSubject(String emailSubject) {
    this.emailSubject = emailSubject;
  }

  public ExecuteRequestDto emailTemplateId(UUID emailTemplateId) {
    this.emailTemplateId = emailTemplateId;
    return this;
  }

  /**
   * Get emailTemplateId
   * @return emailTemplateId
  */
  @Valid 
  @Schema(name = "emailTemplateId", required = false)
  public UUID getEmailTemplateId() {
    return emailTemplateId;
  }

  public void setEmailTemplateId(UUID emailTemplateId) {
    this.emailTemplateId = emailTemplateId;
  }

  public ExecuteRequestDto environmentIds(List<UUID> environmentIds) {
    this.environmentIds = environmentIds;
    return this;
  }

  public ExecuteRequestDto addEnvironmentIdsItem(UUID environmentIdsItem) {
    this.environmentIds.add(environmentIdsItem);
    return this;
  }

  /**
   * Get environmentIds
   * @return environmentIds
  */
  @NotNull @Valid 
  @Schema(name = "environmentIds", required = true)
  public List<UUID> getEnvironmentIds() {
    return environmentIds;
  }

  public void setEnvironmentIds(List<UUID> environmentIds) {
    this.environmentIds = environmentIds;
  }

  public ExecuteRequestDto executeExecution(Boolean executeExecution) {
    this.executeExecution = executeExecution;
    return this;
  }

  /**
   * Get executeExecution
   * @return executeExecution
  */
  
  @Schema(name = "executeExecution", required = false)
  public Boolean getExecuteExecution() {
    return executeExecution;
  }

  public void setExecuteExecution(Boolean executeExecution) {
    this.executeExecution = executeExecution;
  }

  public ExecuteRequestDto executePrerequisites(Boolean executePrerequisites) {
    this.executePrerequisites = executePrerequisites;
    return this;
  }

  /**
   * Get executePrerequisites
   * @return executePrerequisites
  */
  
  @Schema(name = "executePrerequisites", required = false)
  public Boolean getExecutePrerequisites() {
    return executePrerequisites;
  }

  public void setExecutePrerequisites(Boolean executePrerequisites) {
    this.executePrerequisites = executePrerequisites;
  }

  public ExecuteRequestDto executeValidation(Boolean executeValidation) {
    this.executeValidation = executeValidation;
    return this;
  }

  /**
   * Get executeValidation
   * @return executeValidation
  */
  
  @Schema(name = "executeValidation", required = false)
  public Boolean getExecuteValidation() {
    return executeValidation;
  }

  public void setExecuteValidation(Boolean executeValidation) {
    this.executeValidation = executeValidation;
  }

  public ExecuteRequestDto flags(List<FlagsEnum> flags) {
    this.flags = flags;
    return this;
  }

  public ExecuteRequestDto addFlagsItem(FlagsEnum flagsItem) {
    if (this.flags == null) {
      this.flags = new ArrayList<>();
    }
    this.flags.add(flagsItem);
    return this;
  }

  /**
   * Get flags
   * @return flags
  */
  
  @Schema(name = "flags", required = false)
  public List<FlagsEnum> getFlags() {
    return flags;
  }

  public void setFlags(List<FlagsEnum> flags) {
    this.flags = flags;
  }

  public ExecuteRequestDto labelTemplateId(UUID labelTemplateId) {
    this.labelTemplateId = labelTemplateId;
    return this;
  }

  /**
   * Get labelTemplateId
   * @return labelTemplateId
  */
  @Valid 
  @Schema(name = "labelTemplateId", required = false)
  public UUID getLabelTemplateId() {
    return labelTemplateId;
  }

  public void setLabelTemplateId(UUID labelTemplateId) {
    this.labelTemplateId = labelTemplateId;
  }

  public ExecuteRequestDto logCollectorTemplateId(UUID logCollectorTemplateId) {
    this.logCollectorTemplateId = logCollectorTemplateId;
    return this;
  }

  /**
   * Get logCollectorTemplateId
   * @return logCollectorTemplateId
  */
  @Valid 
  @Schema(name = "logCollectorTemplateId", required = false)
  public UUID getLogCollectorTemplateId() {
    return logCollectorTemplateId;
  }

  public void setLogCollectorTemplateId(UUID logCollectorTemplateId) {
    this.logCollectorTemplateId = logCollectorTemplateId;
  }

  public ExecuteRequestDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ExecuteRequestDto projectId(UUID projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Get projectId
   * @return projectId
  */
  @Valid 
  @Schema(name = "projectId", required = false)
  public UUID getProjectId() {
    return projectId;
  }

  public void setProjectId(UUID projectId) {
    this.projectId = projectId;
  }

  public ExecuteRequestDto taToolIds(List<UUID> taToolIds) {
    this.taToolIds = taToolIds;
    return this;
  }

  public ExecuteRequestDto addTaToolIdsItem(UUID taToolIdsItem) {
    this.taToolIds.add(taToolIdsItem);
    return this;
  }

  /**
   * Get taToolIds
   * @return taToolIds
  */
  @NotNull @Valid 
  @Schema(name = "taToolIds", required = true)
  public List<UUID> getTaToolIds() {
    return taToolIds;
  }

  public void setTaToolIds(List<UUID> taToolIds) {
    this.taToolIds = taToolIds;
  }

  public ExecuteRequestDto testCaseIds(List<UUID> testCaseIds) {
    this.testCaseIds = testCaseIds;
    return this;
  }

  public ExecuteRequestDto addTestCaseIdsItem(UUID testCaseIdsItem) {
    if (this.testCaseIds == null) {
      this.testCaseIds = new ArrayList<>();
    }
    this.testCaseIds.add(testCaseIdsItem);
    return this;
  }

  /**
   * Get testCaseIds
   * @return testCaseIds
  */
  @Valid 
  @Schema(name = "testCaseIds", required = false)
  public List<UUID> getTestCaseIds() {
    return testCaseIds;
  }

  public void setTestCaseIds(List<UUID> testCaseIds) {
    this.testCaseIds = testCaseIds;
  }

  public ExecuteRequestDto testScenarios(List<EnrichedScenarioDto> testScenarios) {
    this.testScenarios = testScenarios;
    return this;
  }

  public ExecuteRequestDto addTestScenariosItem(EnrichedScenarioDto testScenariosItem) {
    if (this.testScenarios == null) {
      this.testScenarios = new ArrayList<>();
    }
    this.testScenarios.add(testScenariosItem);
    return this;
  }

  /**
   * Get testScenarios
   * @return testScenarios
  */
  @Valid 
  @Schema(name = "testScenarios", required = false)
  public List<EnrichedScenarioDto> getTestScenarios() {
    return testScenarios;
  }

  public void setTestScenarios(List<EnrichedScenarioDto> testScenarios) {
    this.testScenarios = testScenarios;
  }

  public ExecuteRequestDto testPlanId(UUID testPlanId) {
    this.testPlanId = testPlanId;
    return this;
  }

  /**
   * Get testPlanId
   * @return testPlanId
  */
  @Valid 
  @Schema(name = "testPlanId", required = false)
  public UUID getTestPlanId() {
    return testPlanId;
  }

  public void setTestPlanId(UUID testPlanId) {
    this.testPlanId = testPlanId;
  }

  public ExecuteRequestDto testScopeId(UUID testScopeId) {
    this.testScopeId = testScopeId;
    return this;
  }

  /**
   * Get testScopeId
   * @return testScopeId
  */
  @Valid 
  @Schema(name = "testScopeId", required = false)
  public UUID getTestScopeId() {
    return testScopeId;
  }

  public void setTestScopeId(UUID testScopeId) {
    this.testScopeId = testScopeId;
  }

  public ExecuteRequestDto threadCount(Integer threadCount) {
    this.threadCount = threadCount;
    return this;
  }

  /**
   * Get threadCount
   * @return threadCount
  */
  
  @Schema(name = "threadCount", required = false)
  public Integer getThreadCount() {
    return threadCount;
  }

  public void setThreadCount(Integer threadCount) {
    this.threadCount = threadCount;
  }

  public ExecuteRequestDto widgetConfigTemplateId(UUID widgetConfigTemplateId) {
    this.widgetConfigTemplateId = widgetConfigTemplateId;
    return this;
  }

  /**
   * Get widgetConfigTemplateId
   * @return widgetConfigTemplateId
  */
  @Valid 
  @Schema(name = "widgetConfigTemplateId", required = false)
  public UUID getWidgetConfigTemplateId() {
    return widgetConfigTemplateId;
  }

  public void setWidgetConfigTemplateId(UUID widgetConfigTemplateId) {
    this.widgetConfigTemplateId = widgetConfigTemplateId;
  }

  public ExecuteRequestDto filterLabels(List<ItemDto> filterLabels) {
    this.filterLabels = filterLabels;
    return this;
  }

  public ExecuteRequestDto addFilterLabelsItem(ItemDto filterLabelsItem) {
    if (this.filterLabels == null) {
      this.filterLabels = new ArrayList<>();
    }
    this.filterLabels.add(filterLabelsItem);
    return this;
  }

  /**
   * Get filterLabels
   * @return filterLabels
  */
  @Valid 
  @Schema(name = "filterLabels", required = false)
  public List<ItemDto> getFilterLabels() {
    return filterLabels;
  }

  public void setFilterLabels(List<ItemDto> filterLabels) {
    this.filterLabels = filterLabels;
  }

  public ExecuteRequestDto isMandatoryCheck(Boolean isMandatoryCheck) {
    this.isMandatoryCheck = isMandatoryCheck;
    return this;
  }

  /**
   * Get isMandatoryCheck
   * @return isMandatoryCheck
  */
  
  @Schema(name = "isMandatoryCheck", required = false)
  public Boolean getIsMandatoryCheck() {
    return isMandatoryCheck;
  }

  public void setIsMandatoryCheck(Boolean isMandatoryCheck) {
    this.isMandatoryCheck = isMandatoryCheck;
  }

  public ExecuteRequestDto isSsmCheck(Boolean isSsmCheck) {
    this.isSsmCheck = isSsmCheck;
    return this;
  }

  /**
   * Get isSsmCheck
   * @return isSsmCheck
  */
  
  @Schema(name = "isSsmCheck", required = false)
  public Boolean getIsSsmCheck() {
    return isSsmCheck;
  }

  public void setIsSsmCheck(Boolean isSsmCheck) {
    this.isSsmCheck = isSsmCheck;
  }

  public ExecuteRequestDto isIgnoreFailedChecks(Boolean isIgnoreFailedChecks) {
    this.isIgnoreFailedChecks = isIgnoreFailedChecks;
    return this;
  }

  /**
   * Get isIgnoreFailedChecks
   * @return isIgnoreFailedChecks
  */
  
  @Schema(name = "isIgnoreFailedChecks", required = false)
  public Boolean getIsIgnoreFailedChecks() {
    return isIgnoreFailedChecks;
  }

  public void setIsIgnoreFailedChecks(Boolean isIgnoreFailedChecks) {
    this.isIgnoreFailedChecks = isIgnoreFailedChecks;
  }

  public ExecuteRequestDto jointExecutionKey(UUID jointExecutionKey) {
    this.jointExecutionKey = jointExecutionKey;
    return this;
  }

  /**
   * Get jointExecutionKey
   * @return jointExecutionKey
  */
  @Valid 
  @Schema(name = "jointExecutionKey", required = false)
  public UUID getJointExecutionKey() {
    return jointExecutionKey;
  }

  public void setJointExecutionKey(UUID jointExecutionKey) {
    this.jointExecutionKey = jointExecutionKey;
  }

  public ExecuteRequestDto jointExecutionCount(BigDecimal jointExecutionCount) {
    this.jointExecutionCount = jointExecutionCount;
    return this;
  }

  /**
   * Get jointExecutionCount
   * @return jointExecutionCount
  */
  @Valid 
  @Schema(name = "jointExecutionCount", required = false)
  public BigDecimal getJointExecutionCount() {
    return jointExecutionCount;
  }

  public void setJointExecutionCount(BigDecimal jointExecutionCount) {
    this.jointExecutionCount = jointExecutionCount;
  }

  public ExecuteRequestDto jointExecutionTimeout(BigDecimal jointExecutionTimeout) {
    this.jointExecutionTimeout = jointExecutionTimeout;
    return this;
  }

  /**
   * Get jointExecutionTimeout
   * @return jointExecutionTimeout
  */
  @Valid 
  @Schema(name = "jointExecutionTimeout", required = false)
  public BigDecimal getJointExecutionTimeout() {
    return jointExecutionTimeout;
  }

  public void setJointExecutionTimeout(BigDecimal jointExecutionTimeout) {
    this.jointExecutionTimeout = jointExecutionTimeout;
  }

  public ExecuteRequestDto dataSetStorageId(UUID dataSetStorageId) {
    this.dataSetStorageId = dataSetStorageId;
    return this;
  }

  /**
   * Get dataSetStorageId
   * @return dataSetStorageId
  */
  @Valid 
  @Schema(name = "dataSetStorageId", required = false)
  public UUID getDataSetStorageId() {
    return dataSetStorageId;
  }

  public void setDataSetStorageId(UUID dataSetStorageId) {
    this.dataSetStorageId = dataSetStorageId;
  }

  public ExecuteRequestDto datasetId(UUID datasetId) {
    this.datasetId = datasetId;
    return this;
  }

  /**
   * Get datasetId
   * @return datasetId
  */
  @Valid 
  @Schema(name = "datasetId", required = false)
  public UUID getDatasetId() {
    return datasetId;
  }

  public void setDatasetId(UUID datasetId) {
    this.datasetId = datasetId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExecuteRequestDto executeRequest = (ExecuteRequestDto) o;
    return Objects.equals(this.autoSyncCasesWithJira, executeRequest.autoSyncCasesWithJira) &&
        Objects.equals(this.autoSyncRunsWithJira, executeRequest.autoSyncRunsWithJira) &&
        Objects.equals(this.contextVariables, executeRequest.contextVariables) &&
        Objects.equals(this.emailRecipients, executeRequest.emailRecipients) &&
        Objects.equals(this.emailSubject, executeRequest.emailSubject) &&
        Objects.equals(this.emailTemplateId, executeRequest.emailTemplateId) &&
        Objects.equals(this.environmentIds, executeRequest.environmentIds) &&
        Objects.equals(this.executeExecution, executeRequest.executeExecution) &&
        Objects.equals(this.executePrerequisites, executeRequest.executePrerequisites) &&
        Objects.equals(this.executeValidation, executeRequest.executeValidation) &&
        Objects.equals(this.flags, executeRequest.flags) &&
        Objects.equals(this.labelTemplateId, executeRequest.labelTemplateId) &&
        Objects.equals(this.logCollectorTemplateId, executeRequest.logCollectorTemplateId) &&
        Objects.equals(this.name, executeRequest.name) &&
        Objects.equals(this.projectId, executeRequest.projectId) &&
        Objects.equals(this.taToolIds, executeRequest.taToolIds) &&
        Objects.equals(this.testCaseIds, executeRequest.testCaseIds) &&
        Objects.equals(this.testScenarios, executeRequest.testScenarios) &&
        Objects.equals(this.testPlanId, executeRequest.testPlanId) &&
        Objects.equals(this.testScopeId, executeRequest.testScopeId) &&
        Objects.equals(this.threadCount, executeRequest.threadCount) &&
        Objects.equals(this.widgetConfigTemplateId, executeRequest.widgetConfigTemplateId) &&
        Objects.equals(this.filterLabels, executeRequest.filterLabels) &&
        Objects.equals(this.isMandatoryCheck, executeRequest.isMandatoryCheck) &&
        Objects.equals(this.isSsmCheck, executeRequest.isSsmCheck) &&
        Objects.equals(this.isIgnoreFailedChecks, executeRequest.isIgnoreFailedChecks) &&
        Objects.equals(this.jointExecutionKey, executeRequest.jointExecutionKey) &&
        Objects.equals(this.jointExecutionCount, executeRequest.jointExecutionCount) &&
        Objects.equals(this.jointExecutionTimeout, executeRequest.jointExecutionTimeout) &&
        Objects.equals(this.dataSetStorageId, executeRequest.dataSetStorageId) &&
        Objects.equals(this.datasetId, executeRequest.datasetId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(autoSyncCasesWithJira, autoSyncRunsWithJira, contextVariables, emailRecipients, emailSubject, emailTemplateId, environmentIds, executeExecution, executePrerequisites, executeValidation, flags, labelTemplateId, logCollectorTemplateId, name, projectId, taToolIds, testCaseIds, testScenarios, testPlanId, testScopeId, threadCount, widgetConfigTemplateId, filterLabels, isMandatoryCheck, isSsmCheck, isIgnoreFailedChecks, jointExecutionKey, jointExecutionCount, jointExecutionTimeout, dataSetStorageId, datasetId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExecuteRequestDto {\n");
    sb.append("    autoSyncCasesWithJira: ").append(toIndentedString(autoSyncCasesWithJira)).append("\n");
    sb.append("    autoSyncRunsWithJira: ").append(toIndentedString(autoSyncRunsWithJira)).append("\n");
    sb.append("    contextVariables: ").append(toIndentedString(contextVariables)).append("\n");
    sb.append("    emailRecipients: ").append(toIndentedString(emailRecipients)).append("\n");
    sb.append("    emailSubject: ").append(toIndentedString(emailSubject)).append("\n");
    sb.append("    emailTemplateId: ").append(toIndentedString(emailTemplateId)).append("\n");
    sb.append("    environmentIds: ").append(toIndentedString(environmentIds)).append("\n");
    sb.append("    executeExecution: ").append(toIndentedString(executeExecution)).append("\n");
    sb.append("    executePrerequisites: ").append(toIndentedString(executePrerequisites)).append("\n");
    sb.append("    executeValidation: ").append(toIndentedString(executeValidation)).append("\n");
    sb.append("    flags: ").append(toIndentedString(flags)).append("\n");
    sb.append("    labelTemplateId: ").append(toIndentedString(labelTemplateId)).append("\n");
    sb.append("    logCollectorTemplateId: ").append(toIndentedString(logCollectorTemplateId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    taToolIds: ").append(toIndentedString(taToolIds)).append("\n");
    sb.append("    testCaseIds: ").append(toIndentedString(testCaseIds)).append("\n");
    sb.append("    testScenarios: ").append(toIndentedString(testScenarios)).append("\n");
    sb.append("    testPlanId: ").append(toIndentedString(testPlanId)).append("\n");
    sb.append("    testScopeId: ").append(toIndentedString(testScopeId)).append("\n");
    sb.append("    threadCount: ").append(toIndentedString(threadCount)).append("\n");
    sb.append("    widgetConfigTemplateId: ").append(toIndentedString(widgetConfigTemplateId)).append("\n");
    sb.append("    filterLabels: ").append(toIndentedString(filterLabels)).append("\n");
    sb.append("    isMandatoryCheck: ").append(toIndentedString(isMandatoryCheck)).append("\n");
    sb.append("    isSsmCheck: ").append(toIndentedString(isSsmCheck)).append("\n");
    sb.append("    isIgnoreFailedChecks: ").append(toIndentedString(isIgnoreFailedChecks)).append("\n");
    sb.append("    jointExecutionKey: ").append(toIndentedString(jointExecutionKey)).append("\n");
    sb.append("    jointExecutionCount: ").append(toIndentedString(jointExecutionCount)).append("\n");
    sb.append("    jointExecutionTimeout: ").append(toIndentedString(jointExecutionTimeout)).append("\n");
    sb.append("    dataSetStorageId: ").append(toIndentedString(dataSetStorageId)).append("\n");
    sb.append("    datasetId: ").append(toIndentedString(datasetId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

