package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.AbstractEntityResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseDependencyDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseRepeatCountDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScenarioDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScopeDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.UserInfoDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.UserModelDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestCaseResponseDto
 */

@JsonTypeName("TestCaseResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-09-05T10:34:55.902210234Z[Etc/UTC]")
public class TestCaseResponseDto {

  @JsonProperty("assignee")
  private UserInfoDto assignee;

  @JsonProperty("createDate")
  private Long createDate;

  @JsonProperty("createdBy")
  private UserModelDto createdBy;

  @JsonProperty("dataset")
  private AbstractEntityResponseDto dataset;

  @JsonProperty("datasetName")
  private String datasetName;

  @JsonProperty("datasetStorageUuid")
  private UUID datasetStorageUuid;

  @JsonProperty("datasetUuid")
  private UUID datasetUuid;

  @JsonProperty("dependsOn")
  @Valid
  private List<TestCaseDependencyDto> dependsOn = null;

  @JsonProperty("description")
  private String description;

  @JsonProperty("flagIds")
  @Valid
  private List<UUID> flagIds = null;

  @JsonProperty("groupId")
  private UUID groupId;

  @JsonProperty("jiraTicketUrl")
  private String jiraTicketUrl;

  @JsonProperty("labels")
  @Valid
  private Set<LabelDto> labels = null;

  @JsonProperty("lastModifiedBy")
  private UserModelDto lastModifiedBy;

  @JsonProperty("lastRun")
  private UUID lastRun;

  @JsonProperty("lastRunStatus")
  private String lastRunStatus;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  /**
   * Gets or Sets priority
   */
  public enum PriorityEnum {
    BLOCKER("BLOCKER"),
    
    CRITICAL("CRITICAL"),
    
    LOW("LOW"),
    
    MAJOR("MAJOR"),
    
    NORMAL("NORMAL");

    private String value;

    PriorityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PriorityEnum fromValue(String value) {
      for (PriorityEnum b : PriorityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("priority")
  private PriorityEnum priority;

  @JsonProperty("projectUuid")
  private UUID projectUuid;

  @JsonProperty("sequenceNumber")
  private Integer sequenceNumber;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    BLOCKED("BLOCKED"),
    
    CANCELLED("CANCELLED"),
    
    FAILED("FAILED"),
    
    IN_PROGRESS("IN_PROGRESS"),
    
    NOT_DELIVERED("NOT_DELIVERED"),
    
    OPEN("OPEN"),
    
    PASSED("PASSED"),
    
    PASSED_WITH_MINOR_DEFECTS("PASSED_WITH_MINOR_DEFECTS");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  @JsonProperty("testCaseRepeatCounts")
  @Valid
  private List<TestCaseRepeatCountDto> testCaseRepeatCounts = null;

  @JsonProperty("testPlanUuid")
  private UUID testPlanUuid;

  @JsonProperty("testScenario")
  private TestScenarioDto testScenario;

  @JsonProperty("testScopes")
  @Valid
  private Set<TestScopeDto> testScopes = null;

  @JsonProperty("uuid")
  private UUID uuid;

  public TestCaseResponseDto assignee(UserInfoDto assignee) {
    this.assignee = assignee;
    return this;
  }

  /**
   * Get assignee
   * @return assignee
  */
  @Valid 
  @Schema(name = "assignee", required = false)
  public UserInfoDto getAssignee() {
    return assignee;
  }

  public void setAssignee(UserInfoDto assignee) {
    this.assignee = assignee;
  }

  public TestCaseResponseDto createDate(Long createDate) {
    this.createDate = createDate;
    return this;
  }

  /**
   * Get createDate
   * @return createDate
  */
  
  @Schema(name = "createDate", required = false)
  public Long getCreateDate() {
    return createDate;
  }

  public void setCreateDate(Long createDate) {
    this.createDate = createDate;
  }

  public TestCaseResponseDto createdBy(UserModelDto createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", required = false)
  public UserModelDto getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UserModelDto createdBy) {
    this.createdBy = createdBy;
  }

  public TestCaseResponseDto dataset(AbstractEntityResponseDto dataset) {
    this.dataset = dataset;
    return this;
  }

  /**
   * Get dataset
   * @return dataset
  */
  @Valid 
  @Schema(name = "dataset", required = false)
  public AbstractEntityResponseDto getDataset() {
    return dataset;
  }

  public void setDataset(AbstractEntityResponseDto dataset) {
    this.dataset = dataset;
  }

  public TestCaseResponseDto datasetName(String datasetName) {
    this.datasetName = datasetName;
    return this;
  }

  /**
   * Get datasetName
   * @return datasetName
  */
  
  @Schema(name = "datasetName", required = false)
  public String getDatasetName() {
    return datasetName;
  }

  public void setDatasetName(String datasetName) {
    this.datasetName = datasetName;
  }

  public TestCaseResponseDto datasetStorageUuid(UUID datasetStorageUuid) {
    this.datasetStorageUuid = datasetStorageUuid;
    return this;
  }

  /**
   * Get datasetStorageUuid
   * @return datasetStorageUuid
  */
  @Valid 
  @Schema(name = "datasetStorageUuid", required = false)
  public UUID getDatasetStorageUuid() {
    return datasetStorageUuid;
  }

  public void setDatasetStorageUuid(UUID datasetStorageUuid) {
    this.datasetStorageUuid = datasetStorageUuid;
  }

  public TestCaseResponseDto datasetUuid(UUID datasetUuid) {
    this.datasetUuid = datasetUuid;
    return this;
  }

  /**
   * Get datasetUuid
   * @return datasetUuid
  */
  @Valid 
  @Schema(name = "datasetUuid", required = false)
  public UUID getDatasetUuid() {
    return datasetUuid;
  }

  public void setDatasetUuid(UUID datasetUuid) {
    this.datasetUuid = datasetUuid;
  }

  public TestCaseResponseDto dependsOn(List<TestCaseDependencyDto> dependsOn) {
    this.dependsOn = dependsOn;
    return this;
  }

  public TestCaseResponseDto addDependsOnItem(TestCaseDependencyDto dependsOnItem) {
    if (this.dependsOn == null) {
      this.dependsOn = new ArrayList<>();
    }
    this.dependsOn.add(dependsOnItem);
    return this;
  }

  /**
   * Get dependsOn
   * @return dependsOn
  */
  @Valid 
  @Schema(name = "dependsOn", required = false)
  public List<TestCaseDependencyDto> getDependsOn() {
    return dependsOn;
  }

  public void setDependsOn(List<TestCaseDependencyDto> dependsOn) {
    this.dependsOn = dependsOn;
  }

  public TestCaseResponseDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public TestCaseResponseDto flagIds(List<UUID> flagIds) {
    this.flagIds = flagIds;
    return this;
  }

  public TestCaseResponseDto addFlagIdsItem(UUID flagIdsItem) {
    if (this.flagIds == null) {
      this.flagIds = new ArrayList<>();
    }
    this.flagIds.add(flagIdsItem);
    return this;
  }

  /**
   * Get flagIds
   * @return flagIds
  */
  @Valid 
  @Schema(name = "flagIds", required = false)
  public List<UUID> getFlagIds() {
    return flagIds;
  }

  public void setFlagIds(List<UUID> flagIds) {
    this.flagIds = flagIds;
  }

  public TestCaseResponseDto groupId(UUID groupId) {
    this.groupId = groupId;
    return this;
  }

  /**
   * Get groupId
   * @return groupId
  */
  @Valid 
  @Schema(name = "groupId", required = false)
  public UUID getGroupId() {
    return groupId;
  }

  public void setGroupId(UUID groupId) {
    this.groupId = groupId;
  }

  public TestCaseResponseDto jiraTicketUrl(String jiraTicketUrl) {
    this.jiraTicketUrl = jiraTicketUrl;
    return this;
  }

  /**
   * Get jiraTicketUrl
   * @return jiraTicketUrl
  */
  
  @Schema(name = "jiraTicketUrl", required = false)
  public String getJiraTicketUrl() {
    return jiraTicketUrl;
  }

  public void setJiraTicketUrl(String jiraTicketUrl) {
    this.jiraTicketUrl = jiraTicketUrl;
  }

  public TestCaseResponseDto labels(Set<LabelDto> labels) {
    this.labels = labels;
    return this;
  }

  public TestCaseResponseDto addLabelsItem(LabelDto labelsItem) {
    if (this.labels == null) {
      this.labels = new LinkedHashSet<>();
    }
    this.labels.add(labelsItem);
    return this;
  }

  /**
   * Get labels
   * @return labels
  */
  @Valid 
  @Schema(name = "labels", required = false)
  public Set<LabelDto> getLabels() {
    return labels;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setLabels(Set<LabelDto> labels) {
    this.labels = labels;
  }

  public TestCaseResponseDto lastModifiedBy(UserModelDto lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
    return this;
  }

  /**
   * Get lastModifiedBy
   * @return lastModifiedBy
  */
  @Valid 
  @Schema(name = "lastModifiedBy", required = false)
  public UserModelDto getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(UserModelDto lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  public TestCaseResponseDto lastRun(UUID lastRun) {
    this.lastRun = lastRun;
    return this;
  }

  /**
   * Get lastRun
   * @return lastRun
  */
  @Valid 
  @Schema(name = "lastRun", required = false)
  public UUID getLastRun() {
    return lastRun;
  }

  public void setLastRun(UUID lastRun) {
    this.lastRun = lastRun;
  }

  public TestCaseResponseDto lastRunStatus(String lastRunStatus) {
    this.lastRunStatus = lastRunStatus;
    return this;
  }

  /**
   * Get lastRunStatus
   * @return lastRunStatus
  */
  
  @Schema(name = "lastRunStatus", required = false)
  public String getLastRunStatus() {
    return lastRunStatus;
  }

  public void setLastRunStatus(String lastRunStatus) {
    this.lastRunStatus = lastRunStatus;
  }

  public TestCaseResponseDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public TestCaseResponseDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public TestCaseResponseDto priority(PriorityEnum priority) {
    this.priority = priority;
    return this;
  }

  /**
   * Get priority
   * @return priority
  */
  
  @Schema(name = "priority", required = false)
  public PriorityEnum getPriority() {
    return priority;
  }

  public void setPriority(PriorityEnum priority) {
    this.priority = priority;
  }

  public TestCaseResponseDto projectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
    return this;
  }

  /**
   * Get projectUuid
   * @return projectUuid
  */
  @Valid 
  @Schema(name = "projectUuid", required = false)
  public UUID getProjectUuid() {
    return projectUuid;
  }

  public void setProjectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
  }

  public TestCaseResponseDto sequenceNumber(Integer sequenceNumber) {
    this.sequenceNumber = sequenceNumber;
    return this;
  }

  /**
   * Get sequenceNumber
   * @return sequenceNumber
  */
  
  @Schema(name = "sequenceNumber", required = false)
  public Integer getSequenceNumber() {
    return sequenceNumber;
  }

  public void setSequenceNumber(Integer sequenceNumber) {
    this.sequenceNumber = sequenceNumber;
  }

  public TestCaseResponseDto status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  
  @Schema(name = "status", required = false)
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public TestCaseResponseDto testCaseRepeatCounts(List<TestCaseRepeatCountDto> testCaseRepeatCounts) {
    this.testCaseRepeatCounts = testCaseRepeatCounts;
    return this;
  }

  public TestCaseResponseDto addTestCaseRepeatCountsItem(TestCaseRepeatCountDto testCaseRepeatCountsItem) {
    if (this.testCaseRepeatCounts == null) {
      this.testCaseRepeatCounts = new ArrayList<>();
    }
    this.testCaseRepeatCounts.add(testCaseRepeatCountsItem);
    return this;
  }

  /**
   * Get testCaseRepeatCounts
   * @return testCaseRepeatCounts
  */
  @Valid 
  @Schema(name = "testCaseRepeatCounts", required = false)
  public List<TestCaseRepeatCountDto> getTestCaseRepeatCounts() {
    return testCaseRepeatCounts;
  }

  public void setTestCaseRepeatCounts(List<TestCaseRepeatCountDto> testCaseRepeatCounts) {
    this.testCaseRepeatCounts = testCaseRepeatCounts;
  }

  public TestCaseResponseDto testPlanUuid(UUID testPlanUuid) {
    this.testPlanUuid = testPlanUuid;
    return this;
  }

  /**
   * Get testPlanUuid
   * @return testPlanUuid
  */
  @Valid 
  @Schema(name = "testPlanUuid", required = false)
  public UUID getTestPlanUuid() {
    return testPlanUuid;
  }

  public void setTestPlanUuid(UUID testPlanUuid) {
    this.testPlanUuid = testPlanUuid;
  }

  public TestCaseResponseDto testScenario(TestScenarioDto testScenario) {
    this.testScenario = testScenario;
    return this;
  }

  /**
   * Get testScenario
   * @return testScenario
  */
  @Valid 
  @Schema(name = "testScenario", required = false)
  public TestScenarioDto getTestScenario() {
    return testScenario;
  }

  public void setTestScenario(TestScenarioDto testScenario) {
    this.testScenario = testScenario;
  }

  public TestCaseResponseDto testScopes(Set<TestScopeDto> testScopes) {
    this.testScopes = testScopes;
    return this;
  }

  public TestCaseResponseDto addTestScopesItem(TestScopeDto testScopesItem) {
    if (this.testScopes == null) {
      this.testScopes = new LinkedHashSet<>();
    }
    this.testScopes.add(testScopesItem);
    return this;
  }

  /**
   * Get testScopes
   * @return testScopes
  */
  @Valid 
  @Schema(name = "testScopes", required = false)
  public Set<TestScopeDto> getTestScopes() {
    return testScopes;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setTestScopes(Set<TestScopeDto> testScopes) {
    this.testScopes = testScopes;
  }

  public TestCaseResponseDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestCaseResponseDto testCaseResponse = (TestCaseResponseDto) o;
    return Objects.equals(this.assignee, testCaseResponse.assignee) &&
        Objects.equals(this.createDate, testCaseResponse.createDate) &&
        Objects.equals(this.createdBy, testCaseResponse.createdBy) &&
        Objects.equals(this.dataset, testCaseResponse.dataset) &&
        Objects.equals(this.datasetName, testCaseResponse.datasetName) &&
        Objects.equals(this.datasetStorageUuid, testCaseResponse.datasetStorageUuid) &&
        Objects.equals(this.datasetUuid, testCaseResponse.datasetUuid) &&
        Objects.equals(this.dependsOn, testCaseResponse.dependsOn) &&
        Objects.equals(this.description, testCaseResponse.description) &&
        Objects.equals(this.flagIds, testCaseResponse.flagIds) &&
        Objects.equals(this.groupId, testCaseResponse.groupId) &&
        Objects.equals(this.jiraTicketUrl, testCaseResponse.jiraTicketUrl) &&
        Objects.equals(this.labels, testCaseResponse.labels) &&
        Objects.equals(this.lastModifiedBy, testCaseResponse.lastModifiedBy) &&
        Objects.equals(this.lastRun, testCaseResponse.lastRun) &&
        Objects.equals(this.lastRunStatus, testCaseResponse.lastRunStatus) &&
        Objects.equals(this.modifiedWhen, testCaseResponse.modifiedWhen) &&
        Objects.equals(this.name, testCaseResponse.name) &&
        Objects.equals(this.priority, testCaseResponse.priority) &&
        Objects.equals(this.projectUuid, testCaseResponse.projectUuid) &&
        Objects.equals(this.sequenceNumber, testCaseResponse.sequenceNumber) &&
        Objects.equals(this.status, testCaseResponse.status) &&
        Objects.equals(this.testCaseRepeatCounts, testCaseResponse.testCaseRepeatCounts) &&
        Objects.equals(this.testPlanUuid, testCaseResponse.testPlanUuid) &&
        Objects.equals(this.testScenario, testCaseResponse.testScenario) &&
        Objects.equals(this.testScopes, testCaseResponse.testScopes) &&
        Objects.equals(this.uuid, testCaseResponse.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assignee, createDate, createdBy, dataset, datasetName, datasetStorageUuid, datasetUuid, dependsOn, description, flagIds, groupId, jiraTicketUrl, labels, lastModifiedBy, lastRun, lastRunStatus, modifiedWhen, name, priority, projectUuid, sequenceNumber, status, testCaseRepeatCounts, testPlanUuid, testScenario, testScopes, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestCaseResponseDto {\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    createDate: ").append(toIndentedString(createDate)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    dataset: ").append(toIndentedString(dataset)).append("\n");
    sb.append("    datasetName: ").append(toIndentedString(datasetName)).append("\n");
    sb.append("    datasetStorageUuid: ").append(toIndentedString(datasetStorageUuid)).append("\n");
    sb.append("    datasetUuid: ").append(toIndentedString(datasetUuid)).append("\n");
    sb.append("    dependsOn: ").append(toIndentedString(dependsOn)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    flagIds: ").append(toIndentedString(flagIds)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    jiraTicketUrl: ").append(toIndentedString(jiraTicketUrl)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    lastModifiedBy: ").append(toIndentedString(lastModifiedBy)).append("\n");
    sb.append("    lastRun: ").append(toIndentedString(lastRun)).append("\n");
    sb.append("    lastRunStatus: ").append(toIndentedString(lastRunStatus)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    projectUuid: ").append(toIndentedString(projectUuid)).append("\n");
    sb.append("    sequenceNumber: ").append(toIndentedString(sequenceNumber)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    testCaseRepeatCounts: ").append(toIndentedString(testCaseRepeatCounts)).append("\n");
    sb.append("    testPlanUuid: ").append(toIndentedString(testPlanUuid)).append("\n");
    sb.append("    testScenario: ").append(toIndentedString(testScenario)).append("\n");
    sb.append("    testScopes: ").append(toIndentedString(testScopes)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

