/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.orchestrator.clients.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.orchestrator.clients.dto.EnrichedCompoundDto;
import org.qubership.atp.orchestrator.clients.dto.FlagDto;
import org.qubership.atp.orchestrator.clients.dto.LogCollectorRequestDto;
import org.qubership.atp.orchestrator.clients.dto.TestCaseContextDto;
import org.qubership.atp.orchestrator.clients.dto.TestCaseDependencyDto;
import org.qubership.atp.orchestrator.clients.dto.TestCaseRepeatCountDto;

@JsonTypeName(value="EnrichedCase")
public class EnrichedCaseDto {
    @JsonProperty(value="compounds")
    @Valid
    private List<EnrichedCompoundDto> compounds = null;
    @JsonProperty(value="context")
    private TestCaseContextDto context;
    @JsonProperty(value="dataSetId")
    private UUID dataSetId;
    @JsonProperty(value="dataSetStorageId")
    private UUID dataSetStorageId;
    @JsonProperty(value="dependsOn")
    @Valid
    private List<TestCaseDependencyDto> dependsOn = null;
    @JsonProperty(value="flags")
    @Valid
    private List<FlagDto> flags = null;
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="initialTestRunId")
    private UUID initialTestRunId;
    @JsonProperty(value="isIgnored")
    private Boolean isIgnored;
    @JsonProperty(value="labelIds")
    @Valid
    private Set<UUID> labelIds = null;
    @JsonProperty(value="lineNumber")
    private Integer lineNumber;
    @JsonProperty(value="logCollectorRequest")
    private LogCollectorRequestDto logCollectorRequest;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="parentId")
    private UUID parentId;
    @JsonProperty(value="testScenarioId")
    private UUID testScenarioId;
    @JsonProperty(value="scenarioHashSum")
    private String scenarioHashSum;
    @JsonProperty(value="testCaseRepeatCounts")
    @Valid
    private List<TestCaseRepeatCountDto> testCaseRepeatCounts = null;
    @JsonProperty(value="testScenarioName")
    private String testScenarioName;

    public EnrichedCaseDto compounds(List<EnrichedCompoundDto> compounds) {
        this.compounds = compounds;
        return this;
    }

    public EnrichedCaseDto addCompoundsItem(EnrichedCompoundDto compoundsItem) {
        if (this.compounds == null) {
            this.compounds = new ArrayList<EnrichedCompoundDto>();
        }
        this.compounds.add(compoundsItem);
        return this;
    }

    @Valid
    @Schema(name="compounds", required=false)
    public List<EnrichedCompoundDto> getCompounds() {
        return this.compounds;
    }

    public void setCompounds(List<EnrichedCompoundDto> compounds) {
        this.compounds = compounds;
    }

    public EnrichedCaseDto context(TestCaseContextDto context) {
        this.context = context;
        return this;
    }

    @Valid
    @Schema(name="context", required=false)
    public TestCaseContextDto getContext() {
        return this.context;
    }

    public void setContext(TestCaseContextDto context) {
        this.context = context;
    }

    public EnrichedCaseDto dataSetId(UUID dataSetId) {
        this.dataSetId = dataSetId;
        return this;
    }

    @Valid
    @Schema(name="dataSetId", required=false)
    public UUID getDataSetId() {
        return this.dataSetId;
    }

    public void setDataSetId(UUID dataSetId) {
        this.dataSetId = dataSetId;
    }

    public EnrichedCaseDto dataSetStorageId(UUID dataSetStorageId) {
        this.dataSetStorageId = dataSetStorageId;
        return this;
    }

    @Valid
    @Schema(name="dataSetStorageId", required=false)
    public UUID getDataSetStorageId() {
        return this.dataSetStorageId;
    }

    public void setDataSetStorageId(UUID dataSetStorageId) {
        this.dataSetStorageId = dataSetStorageId;
    }

    public EnrichedCaseDto dependsOn(List<TestCaseDependencyDto> dependsOn) {
        this.dependsOn = dependsOn;
        return this;
    }

    public EnrichedCaseDto addDependsOnItem(TestCaseDependencyDto dependsOnItem) {
        if (this.dependsOn == null) {
            this.dependsOn = new ArrayList<TestCaseDependencyDto>();
        }
        this.dependsOn.add(dependsOnItem);
        return this;
    }

    @Valid
    @Schema(name="dependsOn", required=false)
    public List<TestCaseDependencyDto> getDependsOn() {
        return this.dependsOn;
    }

    public void setDependsOn(List<TestCaseDependencyDto> dependsOn) {
        this.dependsOn = dependsOn;
    }

    public EnrichedCaseDto flags(List<FlagDto> flags) {
        this.flags = flags;
        return this;
    }

    public EnrichedCaseDto addFlagsItem(FlagDto flagsItem) {
        if (this.flags == null) {
            this.flags = new ArrayList<FlagDto>();
        }
        this.flags.add(flagsItem);
        return this;
    }

    @Valid
    @Schema(name="flags", required=false)
    public List<FlagDto> getFlags() {
        return this.flags;
    }

    public void setFlags(List<FlagDto> flags) {
        this.flags = flags;
    }

    public EnrichedCaseDto id(UUID id) {
        this.id = id;
        return this;
    }

    @Valid
    @Schema(name="id", required=false)
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public EnrichedCaseDto initialTestRunId(UUID initialTestRunId) {
        this.initialTestRunId = initialTestRunId;
        return this;
    }

    @Valid
    @Schema(name="initialTestRunId", required=false)
    public UUID getInitialTestRunId() {
        return this.initialTestRunId;
    }

    public void setInitialTestRunId(UUID initialTestRunId) {
        this.initialTestRunId = initialTestRunId;
    }

    public EnrichedCaseDto isIgnored(Boolean isIgnored) {
        this.isIgnored = isIgnored;
        return this;
    }

    @Schema(name="isIgnored", required=false)
    public Boolean getIsIgnored() {
        return this.isIgnored;
    }

    public void setIsIgnored(Boolean isIgnored) {
        this.isIgnored = isIgnored;
    }

    public EnrichedCaseDto labelIds(Set<UUID> labelIds) {
        this.labelIds = labelIds;
        return this;
    }

    public EnrichedCaseDto addLabelIdsItem(UUID labelIdsItem) {
        if (this.labelIds == null) {
            this.labelIds = new LinkedHashSet<UUID>();
        }
        this.labelIds.add(labelIdsItem);
        return this;
    }

    @Valid
    @Schema(name="labelIds", required=false)
    public Set<UUID> getLabelIds() {
        return this.labelIds;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setLabelIds(Set<UUID> labelIds) {
        this.labelIds = labelIds;
    }

    public EnrichedCaseDto lineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    @Schema(name="lineNumber", required=false)
    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public EnrichedCaseDto logCollectorRequest(LogCollectorRequestDto logCollectorRequest) {
        this.logCollectorRequest = logCollectorRequest;
        return this;
    }

    @Valid
    @Schema(name="logCollectorRequest", required=false)
    public LogCollectorRequestDto getLogCollectorRequest() {
        return this.logCollectorRequest;
    }

    public void setLogCollectorRequest(LogCollectorRequestDto logCollectorRequest) {
        this.logCollectorRequest = logCollectorRequest;
    }

    public EnrichedCaseDto name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EnrichedCaseDto parentId(UUID parentId) {
        this.parentId = parentId;
        return this;
    }

    @Valid
    @Schema(name="parentId", required=false)
    public UUID getParentId() {
        return this.parentId;
    }

    public void setParentId(UUID parentId) {
        this.parentId = parentId;
    }

    public EnrichedCaseDto testScenarioId(UUID testScenarioId) {
        this.testScenarioId = testScenarioId;
        return this;
    }

    @Valid
    @Schema(name="testScenarioId", required=false)
    public UUID getTestScenarioId() {
        return this.testScenarioId;
    }

    public void setTestScenarioId(UUID testScenarioId) {
        this.testScenarioId = testScenarioId;
    }

    public EnrichedCaseDto scenarioHashSum(String scenarioHashSum) {
        this.scenarioHashSum = scenarioHashSum;
        return this;
    }

    @Schema(name="scenarioHashSum", required=false)
    public String getScenarioHashSum() {
        return this.scenarioHashSum;
    }

    public void setScenarioHashSum(String scenarioHashSum) {
        this.scenarioHashSum = scenarioHashSum;
    }

    public EnrichedCaseDto testCaseRepeatCounts(List<TestCaseRepeatCountDto> testCaseRepeatCounts) {
        this.testCaseRepeatCounts = testCaseRepeatCounts;
        return this;
    }

    public EnrichedCaseDto addTestCaseRepeatCountsItem(TestCaseRepeatCountDto testCaseRepeatCountsItem) {
        if (this.testCaseRepeatCounts == null) {
            this.testCaseRepeatCounts = new ArrayList<TestCaseRepeatCountDto>();
        }
        this.testCaseRepeatCounts.add(testCaseRepeatCountsItem);
        return this;
    }

    @Valid
    @Schema(name="testCaseRepeatCounts", required=false)
    public List<TestCaseRepeatCountDto> getTestCaseRepeatCounts() {
        return this.testCaseRepeatCounts;
    }

    public void setTestCaseRepeatCounts(List<TestCaseRepeatCountDto> testCaseRepeatCounts) {
        this.testCaseRepeatCounts = testCaseRepeatCounts;
    }

    public EnrichedCaseDto testScenarioName(String testScenarioName) {
        this.testScenarioName = testScenarioName;
        return this;
    }

    @Schema(name="testScenarioName", required=false)
    public String getTestScenarioName() {
        return this.testScenarioName;
    }

    public void setTestScenarioName(String testScenarioName) {
        this.testScenarioName = testScenarioName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnrichedCaseDto enrichedCase = (EnrichedCaseDto)o;
        return Objects.equals(this.compounds, enrichedCase.compounds) && Objects.equals(this.context, enrichedCase.context) && Objects.equals(this.dataSetId, enrichedCase.dataSetId) && Objects.equals(this.dataSetStorageId, enrichedCase.dataSetStorageId) && Objects.equals(this.dependsOn, enrichedCase.dependsOn) && Objects.equals(this.flags, enrichedCase.flags) && Objects.equals(this.id, enrichedCase.id) && Objects.equals(this.initialTestRunId, enrichedCase.initialTestRunId) && Objects.equals(this.isIgnored, enrichedCase.isIgnored) && Objects.equals(this.labelIds, enrichedCase.labelIds) && Objects.equals(this.lineNumber, enrichedCase.lineNumber) && Objects.equals(this.logCollectorRequest, enrichedCase.logCollectorRequest) && Objects.equals(this.name, enrichedCase.name) && Objects.equals(this.parentId, enrichedCase.parentId) && Objects.equals(this.testScenarioId, enrichedCase.testScenarioId) && Objects.equals(this.scenarioHashSum, enrichedCase.scenarioHashSum) && Objects.equals(this.testCaseRepeatCounts, enrichedCase.testCaseRepeatCounts) && Objects.equals(this.testScenarioName, enrichedCase.testScenarioName);
    }

    public int hashCode() {
        return Objects.hash(this.compounds, this.context, this.dataSetId, this.dataSetStorageId, this.dependsOn, this.flags, this.id, this.initialTestRunId, this.isIgnored, this.labelIds, this.lineNumber, this.logCollectorRequest, this.name, this.parentId, this.testScenarioId, this.scenarioHashSum, this.testCaseRepeatCounts, this.testScenarioName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnrichedCaseDto {\n");
        sb.append("    compounds: ").append(this.toIndentedString(this.compounds)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    dataSetId: ").append(this.toIndentedString(this.dataSetId)).append("\n");
        sb.append("    dataSetStorageId: ").append(this.toIndentedString(this.dataSetStorageId)).append("\n");
        sb.append("    dependsOn: ").append(this.toIndentedString(this.dependsOn)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    initialTestRunId: ").append(this.toIndentedString(this.initialTestRunId)).append("\n");
        sb.append("    isIgnored: ").append(this.toIndentedString(this.isIgnored)).append("\n");
        sb.append("    labelIds: ").append(this.toIndentedString(this.labelIds)).append("\n");
        sb.append("    lineNumber: ").append(this.toIndentedString(this.lineNumber)).append("\n");
        sb.append("    logCollectorRequest: ").append(this.toIndentedString(this.logCollectorRequest)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parentId: ").append(this.toIndentedString(this.parentId)).append("\n");
        sb.append("    testScenarioId: ").append(this.toIndentedString(this.testScenarioId)).append("\n");
        sb.append("    scenarioHashSum: ").append(this.toIndentedString(this.scenarioHashSum)).append("\n");
        sb.append("    testCaseRepeatCounts: ").append(this.toIndentedString(this.testCaseRepeatCounts)).append("\n");
        sb.append("    testScenarioName: ").append(this.toIndentedString(this.testScenarioName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

