/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api.dto.catalogue;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompoundCopyItemDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.ItemDto;

@JsonTypeName(value="TestScopesCopyRequest")
public class TestScopesCopyRequestDto {
    @JsonProperty(value="sourceTestPlanId")
    private UUID sourceTestPlanId;
    @JsonProperty(value="targetTestPlanId")
    private UUID targetTestPlanId;
    @JsonProperty(value="items")
    @Valid
    private Set<ItemDto> items = null;
    @JsonProperty(value="compounds")
    @Valid
    private List<CompoundCopyItemDto> compounds = null;
    @JsonProperty(value="copyCompounds")
    private Boolean copyCompounds;
    @JsonProperty(value="copyDatasets")
    private Boolean copyDatasets;
    @JsonProperty(value="setPostfix")
    private Boolean setPostfix;
    @JsonProperty(value="postfix")
    private String postfix;

    public TestScopesCopyRequestDto sourceTestPlanId(UUID sourceTestPlanId) {
        this.sourceTestPlanId = sourceTestPlanId;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="sourceTestPlanId", required=true)
    public UUID getSourceTestPlanId() {
        return this.sourceTestPlanId;
    }

    public void setSourceTestPlanId(UUID sourceTestPlanId) {
        this.sourceTestPlanId = sourceTestPlanId;
    }

    public TestScopesCopyRequestDto targetTestPlanId(UUID targetTestPlanId) {
        this.targetTestPlanId = targetTestPlanId;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="targetTestPlanId", required=true)
    public UUID getTargetTestPlanId() {
        return this.targetTestPlanId;
    }

    public void setTargetTestPlanId(UUID targetTestPlanId) {
        this.targetTestPlanId = targetTestPlanId;
    }

    public TestScopesCopyRequestDto items(Set<ItemDto> items) {
        this.items = items;
        return this;
    }

    public TestScopesCopyRequestDto addItemsItem(ItemDto itemsItem) {
        if (this.items == null) {
            this.items = new LinkedHashSet<ItemDto>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Valid
    @Schema(name="items", required=false)
    public Set<ItemDto> getItems() {
        return this.items;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setItems(Set<ItemDto> items) {
        this.items = items;
    }

    public TestScopesCopyRequestDto compounds(List<CompoundCopyItemDto> compounds) {
        this.compounds = compounds;
        return this;
    }

    public TestScopesCopyRequestDto addCompoundsItem(CompoundCopyItemDto compoundsItem) {
        if (this.compounds == null) {
            this.compounds = new ArrayList<CompoundCopyItemDto>();
        }
        this.compounds.add(compoundsItem);
        return this;
    }

    @Valid
    @Schema(name="compounds", required=false)
    public List<CompoundCopyItemDto> getCompounds() {
        return this.compounds;
    }

    public void setCompounds(List<CompoundCopyItemDto> compounds) {
        this.compounds = compounds;
    }

    public TestScopesCopyRequestDto copyCompounds(Boolean copyCompounds) {
        this.copyCompounds = copyCompounds;
        return this;
    }

    @Schema(name="copyCompounds", required=false)
    public Boolean getCopyCompounds() {
        return this.copyCompounds;
    }

    public void setCopyCompounds(Boolean copyCompounds) {
        this.copyCompounds = copyCompounds;
    }

    public TestScopesCopyRequestDto copyDatasets(Boolean copyDatasets) {
        this.copyDatasets = copyDatasets;
        return this;
    }

    @Schema(name="copyDatasets", required=false)
    public Boolean getCopyDatasets() {
        return this.copyDatasets;
    }

    public void setCopyDatasets(Boolean copyDatasets) {
        this.copyDatasets = copyDatasets;
    }

    public TestScopesCopyRequestDto setPostfix(Boolean setPostfix) {
        this.setPostfix = setPostfix;
        return this;
    }

    @Schema(name="setPostfix", required=false)
    public Boolean getSetPostfix() {
        return this.setPostfix;
    }

    public void setSetPostfix(Boolean setPostfix) {
        this.setPostfix = setPostfix;
    }

    public TestScopesCopyRequestDto postfix(String postfix) {
        this.postfix = postfix;
        return this;
    }

    @Schema(name="postfix", required=false)
    public String getPostfix() {
        return this.postfix;
    }

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestScopesCopyRequestDto testScopesCopyRequest = (TestScopesCopyRequestDto)o;
        return Objects.equals(this.sourceTestPlanId, testScopesCopyRequest.sourceTestPlanId) && Objects.equals(this.targetTestPlanId, testScopesCopyRequest.targetTestPlanId) && Objects.equals(this.items, testScopesCopyRequest.items) && Objects.equals(this.compounds, testScopesCopyRequest.compounds) && Objects.equals(this.copyCompounds, testScopesCopyRequest.copyCompounds) && Objects.equals(this.copyDatasets, testScopesCopyRequest.copyDatasets) && Objects.equals(this.setPostfix, testScopesCopyRequest.setPostfix) && Objects.equals(this.postfix, testScopesCopyRequest.postfix);
    }

    public int hashCode() {
        return Objects.hash(this.sourceTestPlanId, this.targetTestPlanId, this.items, this.compounds, this.copyCompounds, this.copyDatasets, this.setPostfix, this.postfix);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestScopesCopyRequestDto {\n");
        sb.append("    sourceTestPlanId: ").append(this.toIndentedString(this.sourceTestPlanId)).append("\n");
        sb.append("    targetTestPlanId: ").append(this.toIndentedString(this.targetTestPlanId)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    compounds: ").append(this.toIndentedString(this.compounds)).append("\n");
        sb.append("    copyCompounds: ").append(this.toIndentedString(this.copyCompounds)).append("\n");
        sb.append("    copyDatasets: ").append(this.toIndentedString(this.copyDatasets)).append("\n");
        sb.append("    setPostfix: ").append(this.toIndentedString(this.setPostfix)).append("\n");
        sb.append("    postfix: ").append(this.toIndentedString(this.postfix)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

