/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bson.Document;
import org.modelmapper.ModelMapper;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.enums.TypeAction;
import org.qubership.atp.ram.model.LogRecordQueryResult;
import org.qubership.atp.ram.model.LogRecordWithChildrenResponse;
import org.qubership.atp.ram.model.LogRecordWithParentListResponse;
import org.qubership.atp.ram.model.LogRecordWithParentResponse;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.logrecords.parts.FileType;
import org.qubership.atp.ram.repositories.CustomLogRecordRepository;
import org.qubership.atp.ram.repositories.impl.FieldConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.GraphLookupOperation;
import org.springframework.data.mongodb.core.aggregation.LookupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class CustomLogRecordRepositoryImpl
implements CustomLogRecordRepository,
FieldConstants {
    private static final Logger log = LoggerFactory.getLogger(CustomLogRecordRepositoryImpl.class);
    private final MongoTemplate mongoTemplate;
    private final ModelMapper modelMapper;
    private static final String LOG_RECORD_COLLECTION_NAME = LogRecord.class.getAnnotation(org.springframework.data.mongodb.core.mapping.Document.class).collection();
    private static final long SINGLE_LIMIT = 1L;

    @Override
    public List<LogRecord> getTopLogRecordsByFilterLookup(UUID testRunId, List<String> statuses, List<String> types, boolean showNotAnalyzedItemsOnly) {
        log.debug("Filter top log records by filter: statuses [{}], types [{}], showNotAnalyzedItemsOnly [{}]", new Object[]{statuses, types, showNotAnalyzedItemsOnly});
        ArrayList<Object> aggregationOperations = new ArrayList<Object>();
        aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"testRunId").is((Object)testRunId).and("parentRecordId").exists(false).and("rootCause").exists(showNotAnalyzedItemsOnly)));
        aggregationOperations.add(this.getLogRecordHierarchyGraphLookup(statuses, types));
        aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"children.0").exists(true)));
        aggregationOperations.add(Aggregation.project((String[])new String[0]).andExclude(new String[]{"children"}));
        aggregationOperations.add(Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"createdDateStamp"}));
        Aggregation aggregation = Aggregation.newAggregation(aggregationOperations);
        log.debug("Aggregation query '{}'", (Object)aggregation.toString());
        return this.mongoTemplate.aggregate(aggregation, LOG_RECORD_COLLECTION_NAME, LogRecord.class).getMappedResults();
    }

    @Override
    public List<LogRecord> getAllHierarchicalChildrenLogRecords(UUID parentLogRecord) {
        log.debug("Get all hierarchical children log records for parent log record '{}'", (Object)parentLogRecord);
        ArrayList<Object> aggregationOperations = new ArrayList<Object>();
        aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"_id").is((Object)parentLogRecord)));
        aggregationOperations.add(this.getLogRecordHierarchyGraphLookup(null, null));
        aggregationOperations.add(Aggregation.unwind((String)"$children"));
        aggregationOperations.add(Aggregation.project((String[])new String[0]).andExpression("$children._id", new Object[0]).as("_id").andExpression("$children.preview", new Object[0]).as("preview").andExpression("$children.type", new Object[0]).as("type"));
        Aggregation aggregation = Aggregation.newAggregation(aggregationOperations);
        log.debug("Aggregation query '{}'", (Object)aggregation.toString());
        return this.mongoTemplate.aggregate(aggregation, LOG_RECORD_COLLECTION_NAME, LogRecord.class).getMappedResults();
    }

    private AggregationOperation getLogRecordHierarchyGraphLookup(List<String> statuses, List<String> types) {
        GraphLookupOperation.GraphLookupOperationBuilder graphLookupBuilder = Aggregation.graphLookup((String)LOG_RECORD_COLLECTION_NAME).startWith(new String[]{"$_id"}).connectFrom("_id").connectTo("parentRecordId");
        if (!CollectionUtils.isEmpty(statuses)) {
            graphLookupBuilder.restrict((CriteriaDefinition)new Criteria("testingStatus").in(statuses));
        }
        if (!CollectionUtils.isEmpty(types)) {
            graphLookupBuilder.restrict((CriteriaDefinition)new Criteria("type").in(types));
        }
        return graphLookupBuilder.as("children");
    }

    @Override
    public List<LogRecordWithParentResponse> getTopLogRecordsIdAndChildLogRecordsByFileTypeFilterLookup(UUID testRunId, FileType fileType) {
        log.debug("Filter top log records by filter: fileType = {}", (Object)fileType);
        ArrayList<Object> aggregationOperations = new ArrayList<Object>();
        MatchOperation testRunIdMatch = Aggregation.match((Criteria)Criteria.where((String)"testRunId").is((Object)testRunId).and("fileMetadata.type").is((Object)fileType));
        AggregationOperation parentLookup = this.getParentLogRecordHierarchyGraphLookup(testRunId);
        aggregationOperations.add(testRunIdMatch);
        aggregationOperations.add(parentLookup);
        Aggregation aggregation = Aggregation.newAggregation(aggregationOperations);
        log.debug("Aggregation query for get LR with file type '{}'", (Object)aggregation.toString());
        Document document = this.mongoTemplate.aggregate(aggregation, LOG_RECORD_COLLECTION_NAME, LogRecord.class).getRawResults();
        return this.processParentAndChildLogRecordsLookupResults((List)document.get((Object)"results"));
    }

    private List<LogRecordWithParentResponse> processParentAndChildLogRecordsLookupResults(List<Document> results) {
        ArrayList<LogRecordWithParentResponse> logRecordLookupResponses = new ArrayList<LogRecordWithParentResponse>();
        results.forEach(document -> {
            LogRecordWithParentResponse logRecordLookupResponse = new LogRecordWithParentResponse();
            LogRecordQueryResult logRecordFile = (LogRecordQueryResult)((Object)((Object)this.modelMapper.map(document, LogRecordQueryResult.class)));
            logRecordFile.setUuid((UUID)document.get((Object)"_id"));
            logRecordLookupResponse.setFileLogRecord(logRecordFile);
            Optional<LogRecord> logRecordParent = this.processListDocumentsToLogRecord(logRecordFile.getParent());
            logRecordParent.ifPresent(logRecordLookupResponse::setParent);
            logRecordLookupResponses.add(logRecordLookupResponse);
        });
        return logRecordLookupResponses;
    }

    private Optional<LogRecord> processListDocumentsToLogRecord(List<Document> logRecordList) {
        Optional<Document> documentOpt = logRecordList.stream().filter(document -> document.get((Object)"parentRecordId") == null).findFirst();
        if (documentOpt.isPresent()) {
            Document document2 = documentOpt.get();
            LogRecord logRecord = (LogRecord)this.modelMapper.map((Object)document2, LogRecord.class);
            logRecord.setUuid((UUID)document2.get((Object)"_id"));
            return Optional.of(logRecord);
        }
        return Optional.empty();
    }

    private AggregationOperation getParentLogRecordHierarchyGraphLookup(UUID testRunId) {
        return this.getParentLogRecordHierarchyGraphLookup(testRunId, false);
    }

    private AggregationOperation getParentLogRecordHierarchyGraphLookup(UUID testRunId, boolean needDepthField) {
        GraphLookupOperation.GraphLookupOperationBuilder graphLookupBuilder = Aggregation.graphLookup((String)LOG_RECORD_COLLECTION_NAME).startWith(new String[]{"$parentRecordId"}).connectFrom("parentRecordId").connectTo("_id");
        if (needDepthField) {
            graphLookupBuilder.depthField("depth");
        }
        if (Objects.nonNull(testRunId)) {
            graphLookupBuilder.restrict((CriteriaDefinition)new Criteria("testRunId").is((Object)testRunId));
        }
        return graphLookupBuilder.as("parent");
    }

    @Override
    public LogRecordWithChildrenResponse getLogRecordParentAndChildrenByTestingStatusAndTestRunId(UUID tesRunId, TestingStatuses testingStatus) {
        ArrayList<Object> aggregationOperations = new ArrayList<Object>();
        aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"testRunId").is((Object)tesRunId).and("parentRecordId").exists(false)));
        aggregationOperations.add(Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"lastUpdated"}));
        aggregationOperations.add(this.getChildrenLogRecordHierarchyGraphLookup(testingStatus));
        aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"children.0").exists(true)));
        aggregationOperations.add(Aggregation.unwind((String)"$children"));
        aggregationOperations.add(Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"children.depth"}));
        aggregationOperations.add(Aggregation.limit((long)1L));
        Aggregation aggregation = Aggregation.newAggregation(aggregationOperations);
        log.debug("Aggregation query for get LR with testing status '{}'", (Object)aggregation);
        return (LogRecordWithChildrenResponse)((Object)this.mongoTemplate.aggregate(aggregation, LOG_RECORD_COLLECTION_NAME, LogRecordWithChildrenResponse.class).getUniqueMappedResult());
    }

    private AggregationOperation getChildrenLogRecordHierarchyGraphLookup(TestingStatuses testingStatuses) {
        GraphLookupOperation.GraphLookupOperationBuilder graphLookupBuilder = Aggregation.graphLookup((String)LOG_RECORD_COLLECTION_NAME).startWith(new String[]{"$_id"}).connectFrom("_id").connectTo("parentRecordId");
        if (Objects.nonNull(testingStatuses)) {
            graphLookupBuilder.restrict((CriteriaDefinition)new Criteria("testingStatus").is((Object)testingStatuses));
        }
        return graphLookupBuilder.as("children");
    }

    @Override
    public List<LogRecord> findLogRecordsByTestRunIdsAndValidationWithHint(Collection<UUID> testRunIds) {
        if (CollectionUtils.isEmpty(testRunIds)) {
            return new ArrayList<LogRecord>();
        }
        Criteria validationOr = new Criteria();
        validationOr.orOperator(new Criteria[]{Criteria.where((String)"validationLabels").exists(true).not().size(0), Criteria.where((String)"validationTable.steps.validationLabels").exists(true).not().size(0)});
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"testRunId").in(testRunIds)).addCriteria((CriteriaDefinition)validationOr).withHint(new Document("testRunId", (Object)1).toJson()).fields().include("uuid").include("name").include("testRunId").include("validationLabels").include("validationTable").include("testingStatus");
        List logRecords = this.mongoTemplate.find(query, LogRecord.class);
        return logRecords;
    }

    @Override
    public List<LogRecordWithParentListResponse> findLogRecordsWithParentsByPreviewExists(UUID testRunId) {
        ArrayList<Object> aggregationOperations = new ArrayList<Object>();
        aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"testRunId").is((Object)testRunId).and("preview").exists(true).ne((Object)"")));
        aggregationOperations.add(this.getParentLogRecordHierarchyGraphLookup(null, true));
        aggregationOperations.add(Aggregation.project((String[])new String[]{"name", "testingStatus", "startDate", "parent"}));
        aggregationOperations.add(Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"startDate"}));
        return this.mongoTemplate.aggregate(Aggregation.newAggregation(aggregationOperations), LOG_RECORD_COLLECTION_NAME, LogRecordWithParentListResponse.class).getMappedResults();
    }

    @Override
    public LogRecord findLastOrcLogRecordByTestRunAndExecutionStatus(UUID testRunId, ExecutionStatuses status) {
        ArrayList<Object> aggregationOperations = new ArrayList<Object>();
        aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"testRunId").is((Object)testRunId).and("executionStatus").is((Object)status)));
        aggregationOperations.add(Aggregation.sort((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdDateStamp"}));
        aggregationOperations.add(this.getParentLogRecordHierarchyGraphLookup(testRunId));
        Criteria validationOr = new Criteria();
        validationOr.orOperator(new Criteria[]{Criteria.where((String)"parentRecordId").exists(false).and("type").ne((Object)TypeAction.COMPOUND), Criteria.where((String)"parent").not().elemMatch(Criteria.where((String)"type").nin(new Object[]{TypeAction.COMPOUND}))});
        aggregationOperations.add(Aggregation.match((Criteria)validationOr));
        aggregationOperations.add(Aggregation.limit((long)1L));
        aggregationOperations.add(Aggregation.project((String[])new String[]{"startDate", "endDate"}));
        Aggregation aggregation = Aggregation.newAggregation(aggregationOperations);
        log.debug("Aggregation query to get last orc log record '{}'", (Object)aggregation);
        return (LogRecord)this.mongoTemplate.aggregate(aggregation, LOG_RECORD_COLLECTION_NAME, LogRecord.class).getUniqueMappedResult();
    }

    @Override
    public UUID getProjectIdByLogRecordId(UUID logRecordId) {
        ArrayList<Object> aggregationOperations = new ArrayList<Object>();
        aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"_id").is((Object)logRecordId)));
        aggregationOperations.add(LookupOperation.newLookup().from("testrun").localField("testRunId").foreignField("_id").as("testrun"));
        aggregationOperations.add(Aggregation.unwind((String)"$testrun"));
        aggregationOperations.add(LookupOperation.newLookup().from("executionRequests").localField("testrun.executionRequestId").foreignField("_id").as("executionRequest"));
        aggregationOperations.add(Aggregation.unwind((String)"$executionRequest"));
        aggregationOperations.add(Aggregation.project((String[])new String[0]).and("$executionRequest.projectId").as("_id"));
        Aggregation aggregation = Aggregation.newAggregation(aggregationOperations);
        Optional<ExecutionRequest> result = Optional.ofNullable((ExecutionRequest)this.mongoTemplate.aggregate(aggregation, LOG_RECORD_COLLECTION_NAME, ExecutionRequest.class).getUniqueMappedResult());
        return result.map(RamObject::getUuid).orElse(null);
    }

    public CustomLogRecordRepositoryImpl(MongoTemplate mongoTemplate, ModelMapper modelMapper) {
        this.mongoTemplate = mongoTemplate;
        this.modelMapper = modelMapper;
    }
}

