/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.client.result.UpdateResult;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.qubership.atp.ram.dto.response.BaseEntityResponse;
import org.qubership.atp.ram.dto.response.CompareTreeTestRunResponse;
import org.qubership.atp.ram.dto.response.PaginationResponse;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.models.AnalyzedTestRunSortedColumns;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.models.TestRunSearchRequest;
import org.qubership.atp.ram.models.logrecords.parts.FileType;
import org.qubership.atp.ram.repositories.CustomTestRunRepository;
import org.qubership.atp.ram.repositories.impl.CustomRamObjectImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.GraphLookupOperation;
import org.springframework.data.mongodb.core.aggregation.LookupOperation;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class CustomTestRunRepositoryImpl
extends CustomRamObjectImpl
implements CustomTestRunRepository {
    private static final Logger log = LoggerFactory.getLogger(CustomTestRunRepositoryImpl.class);
    private static final String REGEX_SYMBOLS = "([$.*+?~^!|\\-()\\[\\]{}\\\\])";
    private static final String OPERATOR = "$";
    private static final String ID = "_id";
    private static final String NAME = "name";
    private static final String TESTCASE_ID = "testCaseId";
    private static final String EXECUTION_REQUEST_ID = "executionRequestId";
    private static final String PARENT_TEST_RUN_ID = "parentTestRunId";
    private static final String EXECUTION_STATUS = "executionStatus";
    private static final String START_DATE = "startDate";
    private static final String FINISH_DATE = "finishDate";
    private static final String DURATION = "duration";
    private static final String TESTRUNS = "testRuns";
    private static final String TESTCASE_NAME = "testCaseName";
    private static final String TESTING_STATUS = "testingStatus";
    private static final String ROOT_CAUSE_ID = "rootCauseId";
    private static final String COMMENT_TEXT = "comment.text";
    private static final String $_ID = "$_id";
    private static final String LOG_RECORD_TEST_RUN_ID = "testRunId";
    private static final String LOG_RECORD_FILE_METADATA = "fileMetadata.type";
    private static final String CHILDREN = "children";
    private static final String CHILDREN_0 = "children.0";
    private static final String LABEL_IDS = "labelIds";
    private static final String LOG_RECORD_COLLECTION_NAME = LogRecord.class.getAnnotation(Document.class).collection();
    private static final String TEST_RUN_COLLECTION_NAME = TestRun.class.getAnnotation(Document.class).collection();
    private static final Map<AnalyzedTestRunSortedColumns, String> sortedColumns = new HashMap<AnalyzedTestRunSortedColumns, String>(){
        {
            this.put(AnalyzedTestRunSortedColumns.TESTCASE_NAME, CustomTestRunRepositoryImpl.TESTCASE_NAME);
            this.put(AnalyzedTestRunSortedColumns.TESTING_STATUS, CustomTestRunRepositoryImpl.TESTING_STATUS);
            this.put(AnalyzedTestRunSortedColumns.FAILURE_REASON, CustomTestRunRepositoryImpl.ROOT_CAUSE_ID);
        }
    };

    public CustomTestRunRepositoryImpl(MongoTemplate mongoTemplate) {
        super(mongoTemplate);
    }

    @Override
    public PaginationResponse<TestRun> findAllByFilter(int page, int size, AnalyzedTestRunSortedColumns sortColumn, Sort.Direction sortType, TestRunSearchRequest filter) {
        Query query = new Query();
        ArrayList<Criteria> criteria = new ArrayList<Criteria>();
        Criteria executionRequestCriteria = new Criteria();
        if (filter.getExecutionRequestId() != null) {
            executionRequestCriteria = Criteria.where((String)EXECUTION_REQUEST_ID).is((Object)filter.getExecutionRequestId());
        }
        if (filter.getNameContains() != null) {
            criteria.add(Criteria.where((String)NAME).regex(filter.getNameContains(), "i"));
        }
        if (filter.getTestCaseName() != null) {
            criteria.add(Criteria.where((String)TESTCASE_NAME).regex(filter.getTestCaseName(), "i"));
        }
        if (filter.getInTestingStatuses() != null) {
            criteria.add(Criteria.where((String)TESTING_STATUS).in((Collection)filter.getInTestingStatuses()));
        }
        if (filter.getNotInTestingStatuses() != null) {
            criteria.add(Criteria.where((String)TESTING_STATUS).nin((Collection)filter.getNotInTestingStatuses()));
        }
        if (filter.getFailureReasons() != null) {
            criteria.add(Criteria.where((String)ROOT_CAUSE_ID).in((Collection)filter.getFailureReasons()));
        }
        if (filter.getComment() != null && filter.getComment().getText() != null && !filter.getComment().getText().isEmpty()) {
            criteria.add(Criteria.where((String)COMMENT_TEXT).regex(filter.getComment().getText(), "i"));
        }
        if (!CollectionUtils.isEmpty((Collection)filter.getLabelIds())) {
            criteria.add(Criteria.where((String)LABEL_IDS).in((Collection)filter.getLabelIds()));
        }
        if (filter.getTestRunIds() != null) {
            ArrayList<Criteria> orCriteria = new ArrayList<Criteria>();
            orCriteria.add(Criteria.where((String)ID).in((Collection)filter.getTestRunIds()));
            if (!CollectionUtils.isEmpty(criteria)) {
                orCriteria.add(new Criteria().andOperator(criteria.toArray(new Criteria[0])));
            }
            query.addCriteria((CriteriaDefinition)executionRequestCriteria.orOperator(orCriteria.toArray(new Criteria[0])));
        } else {
            query.addCriteria((CriteriaDefinition)executionRequestCriteria);
            criteria.forEach(arg_0 -> ((Query)query).addCriteria(arg_0));
        }
        long totalCount = this.mongoTemplate.count(query, TestRun.class);
        PageRequest pageable = sortColumn != null && sortType != null ? PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)sortType, (String[])new String[]{sortedColumns.get(sortColumn)})) : PageRequest.of((int)page, (int)size);
        query.with((Pageable)pageable);
        List testRuns = this.mongoTemplate.find(query, TestRun.class);
        return new PaginationResponse(testRuns, totalCount);
    }

    @Override
    public List<TestRun> findTestRunsByExecutionRequestIdAndNamesAndLabelIds(UUID executionRequestId, List<String> testRunNames, List<UUID> labelIds) {
        ArrayList<Criteria> criteria = new ArrayList<Criteria>();
        if (executionRequestId != null) {
            criteria.add(Criteria.where((String)EXECUTION_REQUEST_ID).is((Object)executionRequestId));
        }
        if (!CollectionUtils.isEmpty(testRunNames)) {
            Criteria nameCriteria = new Criteria();
            nameCriteria.orOperator((Criteria[])testRunNames.stream().map(name -> Criteria.where((String)NAME).regex(".*" + name.replaceAll(REGEX_SYMBOLS, "\\\\$1") + ".*", "i")).toArray(Criteria[]::new));
            criteria.add(nameCriteria);
        }
        if (!CollectionUtils.isEmpty(labelIds)) {
            criteria.add(Criteria.where((String)LABEL_IDS).all(labelIds));
        }
        criteria.add(Criteria.where((String)TESTING_STATUS).in(Arrays.asList(TestingStatuses.PASSED, TestingStatuses.FAILED)));
        Query query = new Query();
        query.fields().include(ID);
        query.fields().include(NAME);
        query.fields().include(TESTING_STATUS);
        criteria.forEach(arg_0 -> ((Query)query).addCriteria(arg_0));
        return this.mongoTemplate.find(query, TestRun.class);
    }

    @Override
    public List<TestRun> findTestRunsIdNameByExecutionRequestIdAndLabelIds(UUID executionRequestId, List<UUID> labelIds) {
        Query query = new Query();
        ArrayList<Criteria> criteria = new ArrayList<Criteria>();
        if (executionRequestId != null) {
            criteria.add(Criteria.where((String)EXECUTION_REQUEST_ID).is((Object)executionRequestId));
        }
        if (!CollectionUtils.isEmpty(labelIds)) {
            criteria.add(Criteria.where((String)LABEL_IDS).all(labelIds));
        }
        criteria.forEach(arg_0 -> ((Query)query).addCriteria(arg_0));
        query.fields().include(ID);
        query.fields().include(NAME);
        return this.mongoTemplate.find(query, TestRun.class);
    }

    @Override
    public UUID findProjectIdByTestRunId(UUID testRunId) {
        return this.getProjectIdBySpecifiedConditions(Collections.singletonList(Aggregation.match((Criteria)Criteria.where((String)ID).is((Object)testRunId))));
    }

    @Override
    public UUID findProjectIdByTestCaseId(UUID testCaseId) {
        ArrayList<AggregationOperation> aggregationOperations = new ArrayList<AggregationOperation>();
        aggregationOperations.add((AggregationOperation)Aggregation.match((Criteria)Criteria.where((String)TESTCASE_ID).is((Object)testCaseId)));
        aggregationOperations.add((AggregationOperation)Aggregation.limit((long)1L));
        return this.getProjectIdBySpecifiedConditions(aggregationOperations);
    }

    private UUID getProjectIdBySpecifiedConditions(List<AggregationOperation> conditions) {
        ArrayList<AggregationOperation> aggregationOperations = new ArrayList<AggregationOperation>(conditions);
        aggregationOperations.add((AggregationOperation)LookupOperation.newLookup().from("executionRequests").localField(EXECUTION_REQUEST_ID).foreignField(ID).as("executionRequest"));
        aggregationOperations.add((AggregationOperation)Aggregation.unwind((String)"$executionRequest"));
        aggregationOperations.add((AggregationOperation)Aggregation.project((String[])new String[0]).and("$executionRequest.projectId").as(ID));
        Aggregation aggregation = Aggregation.newAggregation(aggregationOperations);
        Optional<ExecutionRequest> result = Optional.ofNullable((ExecutionRequest)this.mongoTemplate.aggregate(aggregation, TEST_RUN_COLLECTION_NAME, ExecutionRequest.class).getUniqueMappedResult());
        return result.map(RamObject::getUuid).orElse(null);
    }

    @Override
    public List<CompareTreeTestRunResponse> compareByExecutionRequestIds(List<UUID> executionRequestIds) {
        log.debug("get test runs to compare by ERs: executionRequestIds [{}]", executionRequestIds);
        ArrayList<AggregationOperation> aggregationOperations = new ArrayList<AggregationOperation>(this.getTestRunsGroupedByTestCases(executionRequestIds));
        aggregationOperations.add((AggregationOperation)Aggregation.match((Criteria)Criteria.where((String)"testRuns.executionRequestId").all(executionRequestIds)));
        aggregationOperations.addAll(this.turnTestCaseToTestRuns());
        aggregationOperations.add((AggregationOperation)Aggregation.match((Criteria)Criteria.where((String)EXECUTION_REQUEST_ID).in(executionRequestIds)));
        String testRunCollectionName = TestRun.class.getAnnotation(Document.class).collection();
        Aggregation aggregation = Aggregation.newAggregation(aggregationOperations);
        return this.mongoTemplate.aggregate(aggregation, testRunCollectionName, CompareTreeTestRunResponse.class).getMappedResults();
    }

    @Override
    public List<BaseEntityResponse> getTestRunsNotInExecutionRequestCompareTable(List<UUID> executionRequestIds) {
        log.debug("get test runs not in ER compare table: executionRequestIds [{}]", executionRequestIds);
        ArrayList<AggregationOperation> aggregationOperations = new ArrayList<AggregationOperation>(this.getTestRunsGroupedByTestCases(executionRequestIds));
        aggregationOperations.add((AggregationOperation)Aggregation.match((Criteria)new Criteria().andOperator(new Criteria[]{Criteria.where((String)"testRuns.executionRequestId").in(executionRequestIds), Criteria.where((String)"testRuns.executionRequestId").not().all(executionRequestIds)})));
        aggregationOperations.addAll(this.turnTestCaseToTestRuns());
        aggregationOperations.add((AggregationOperation)Aggregation.project((String[])new String[0]).andExpression(TESTCASE_NAME, new Object[0]).as(NAME));
        String testRunCollectionName = TestRun.class.getAnnotation(Document.class).collection();
        Aggregation aggregation = Aggregation.newAggregation(aggregationOperations);
        return this.mongoTemplate.aggregate(aggregation, testRunCollectionName, BaseEntityResponse.class).getMappedResults();
    }

    @Override
    public void updateStatusesAndFinishDateByTestRunId(UUID testRunId, ExecutionStatuses executionStatus, TestingStatuses testingStatus, Timestamp finishDate, long duration) {
        Update update = new Update().set(EXECUTION_STATUS, (Object)executionStatus).set(TESTING_STATUS, (Object)testingStatus).set(FINISH_DATE, (Object)finishDate).set(DURATION, (Object)duration);
        UpdateResult updateResult = this.mongoTemplate.updateFirst(this.queryIsId(testRunId), (UpdateDefinition)update, TestRun.class);
        log.debug("TestRun: {} was update with params executionStatus: {}, testingStatus: {}, finishDate: {}, duration: {}. {}", new Object[]{testRunId, executionStatus, testingStatus, finishDate, duration, updateResult});
    }

    private List<AggregationOperation> getTestRunsGroupedByTestCases(List<UUID> executionRequestIds) {
        ArrayList<AggregationOperation> aggregationOperations = new ArrayList<AggregationOperation>();
        aggregationOperations.add((AggregationOperation)Aggregation.match((Criteria)Criteria.where((String)EXECUTION_REQUEST_ID).in(executionRequestIds)));
        aggregationOperations.add((AggregationOperation)Aggregation.group((String[])new String[]{TESTCASE_ID}).push((Object)new BasicDBObject(ID, (Object)$_ID).append(EXECUTION_REQUEST_ID, (Object)"$executionRequestId").append(PARENT_TEST_RUN_ID, (Object)"$parentTestRunId").append(TESTCASE_ID, (Object)"$testCaseId").append(TESTCASE_NAME, (Object)"$testCaseName").append(EXECUTION_STATUS, (Object)"$executionStatus").append(TESTING_STATUS, (Object)"$testingStatus").append(START_DATE, (Object)"$startDate").append(FINISH_DATE, (Object)"$finishDate").append(DURATION, (Object)"$duration")).as(TESTRUNS));
        return aggregationOperations;
    }

    private List<AggregationOperation> turnTestCaseToTestRuns() {
        ArrayList<AggregationOperation> aggregationOperations = new ArrayList<AggregationOperation>();
        aggregationOperations.add((AggregationOperation)Aggregation.unwind((String)"$testRuns"));
        aggregationOperations.add((AggregationOperation)Aggregation.replaceRoot((String)"$testRuns"));
        return aggregationOperations;
    }

    @Override
    public List<TestRun> findTestRunsByExecutionRequestAndHasLogRecordsWithFile(UUID executionRequestId, FileType fileType) {
        log.debug("Filter test runs by filter: fileType of LR-s = {}, execution request ID = {}", (Object)fileType, (Object)executionRequestId);
        ArrayList<Object> aggregationOperations = new ArrayList<Object>();
        aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)EXECUTION_REQUEST_ID).is((Object)executionRequestId)));
        aggregationOperations.add(this.getGraphLookUpLogRecords(fileType));
        aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)CHILDREN_0).exists(true)));
        aggregationOperations.add(Aggregation.project((String[])new String[0]).andExclude(new String[]{CHILDREN}));
        Aggregation aggregation = Aggregation.newAggregation(aggregationOperations);
        return this.mongoTemplate.aggregate(aggregation, TEST_RUN_COLLECTION_NAME, TestRun.class).getMappedResults();
    }

    private AggregationOperation getGraphLookUpLogRecords(FileType fileType) {
        GraphLookupOperation.GraphLookupOperationBuilder graphLookupBuilder = Aggregation.graphLookup((String)LOG_RECORD_COLLECTION_NAME).startWith(new String[]{$_ID}).connectFrom(LOG_RECORD_TEST_RUN_ID).connectTo(LOG_RECORD_TEST_RUN_ID);
        if (Objects.nonNull(fileType)) {
            graphLookupBuilder.restrict((CriteriaDefinition)new Criteria(LOG_RECORD_FILE_METADATA).is((Object)fileType));
        }
        return graphLookupBuilder.as(CHILDREN);
    }
}

