/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.UUID;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.qubership.atp.ram.model.ExtendedFileData;
import org.qubership.atp.ram.model.FileData;
import org.qubership.atp.ram.services.FileNamesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ArchiveService {
    private static final Logger log = LoggerFactory.getLogger(ArchiveService.class);
    private static final String STORAGE_PATH = "./tmp/archives";
    private final ObjectMapper objectMapper;
    private final FileNamesService fileNamesService;

    public File writeFileDataToArchive(List<ExtendedFileData> files, UUID executionRequestId) throws IOException {
        this.logFileNamesAndExecutionRequestIdIfNecessary(files, executionRequestId);
        this.createFolderForTempArchivesIfNecessary();
        String archivePath = "./tmp/archives/all_" + executionRequestId.toString() + ".zip";
        FileOutputStream fos = this.getArchiveFileOutputStream(archivePath);
        this.writeEachFileDataToArchive(files, fos);
        return new File(archivePath);
    }

    private void writeEachFileDataToArchive(List<ExtendedFileData> extendedFilesList, FileOutputStream fos) throws IOException {
        try (ZipArchiveOutputStream zipOutputStream = new ZipArchiveOutputStream((OutputStream)fos);){
            for (ExtendedFileData extendedFile : extendedFilesList) {
                this.writeExtendedFileToArchive(zipOutputStream, extendedFile);
            }
        }
    }

    private void writeExtendedFileToArchive(ZipArchiveOutputStream zipOutputStream, ExtendedFileData potFile) {
        FileData file = potFile.getFileData();
        this.writeToZipFile(file.getContent(), zipOutputStream, file.getSource());
    }

    private FileOutputStream getArchiveFileOutputStream(String archivePath) throws IOException {
        File archive = new File(archivePath);
        if (!archive.createNewFile()) {
            log.error("Cannot create archive to store files at path: {}", (Object)archivePath);
            throw new IOException("Cannot create archive to store files at path: " + archivePath);
        }
        FileOutputStream fos = new FileOutputStream(archivePath);
        return fos;
    }

    private void createFolderForTempArchivesIfNecessary() throws IOException {
        if (Files.notExists(Paths.get(STORAGE_PATH, new String[0]), new LinkOption[0]) && !new File(STORAGE_PATH).mkdirs()) {
            log.error("Cannot create folder for temp archives at path: {}", (Object)STORAGE_PATH);
            throw new IOException("Cannot create folder structure to path: ./tmp/archives");
        }
    }

    private void logFileNamesAndExecutionRequestIdIfNecessary(List<ExtendedFileData> files, UUID executionRequestId) {
        if (log.isInfoEnabled()) {
            this.logFileNamesAndExecutionRequestId(files, executionRequestId);
        }
    }

    private void logFileNamesAndExecutionRequestId(List<ExtendedFileData> files, UUID executionRequestId) {
        try {
            List<String> fileNames = this.fileNamesService.getFileNamesFromFilesList(files);
            log.info("writeFileDataToArchive Writing files: '{}', executionRequestId: '{}'", (Object)this.objectMapper.writeValueAsString(fileNames), (Object)executionRequestId.toString());
        }
        catch (JsonProcessingException exception) {
            log.error(exception.getMessage());
        }
    }

    private void writeToZipFile(byte[] content, ZipArchiveOutputStream zipStream, String entryName) {
        try {
            ZipArchiveEntry zipEntry = new ZipArchiveEntry(entryName);
            zipStream.putArchiveEntry((ArchiveEntry)zipEntry);
            zipStream.write(content, 0, content.length);
            zipStream.closeArchiveEntry();
        }
        catch (IOException e) {
            log.error("Error while writing file {} to zip. Exception: {}", (Object)entryName, (Object)e);
        }
    }

    public ArchiveService(ObjectMapper objectMapper, FileNamesService fileNamesService) {
        this.objectMapper = objectMapper;
        this.fileNamesService = fileNamesService;
    }
}

