/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpEntityNotFoundException;
import org.qubership.atp.ram.enums.SystemStatus;
import org.qubership.atp.ram.model.GridFsFileData;
import org.qubership.atp.ram.models.EnvironmentsInfo;
import org.qubership.atp.ram.models.SsmMetricReports;
import org.qubership.atp.ram.models.SystemInfo;
import org.qubership.atp.ram.models.ToolsInfo;
import org.qubership.atp.ram.repositories.EnvironmentsInfoRepository;
import org.qubership.atp.ram.repositories.ToolsInfoRepository;
import org.qubership.atp.ram.services.CrudService;
import org.qubership.atp.ram.services.GridFsService;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;

@Service
public class EnvironmentsInfoService
extends CrudService<EnvironmentsInfo> {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentsInfoService.class);
    private final EnvironmentsInfoRepository repository;
    private final ToolsInfoRepository toolsInfoRepository;
    private final GridFsService gridFsService;
    @Lazy
    private final MongoTemplate mongoTemplate;

    @Override
    protected MongoRepository<EnvironmentsInfo, UUID> repository() {
        return this.repository;
    }

    public EnvironmentsInfo findByUuid(UUID uuid) {
        return this.repository.findByUuid(uuid);
    }

    public List<EnvironmentsInfo> findByRequestIds(Collection<UUID> requestIds) {
        return this.repository.findByExecutionRequestIdIn(requestIds);
    }

    public Map<UUID, EnvironmentsInfo> getDataForErTestResultByExecutionRequestIds(Set<UUID> erIds) {
        List environmentsInfos = this.repository.findByExecutionRequestIdInForErTestResult(erIds);
        return StreamUtils.toIdEntityMap(environmentsInfos, EnvironmentsInfo::getExecutionRequestId);
    }

    public EnvironmentsInfo findByExecutionRequestId(UUID executionRequestId) throws AtpEntityNotFoundException {
        EnvironmentsInfo envInfo = this.repository.findByExecutionRequestId(executionRequestId);
        if (Objects.isNull(envInfo)) {
            log.error("Failed to find Environment Info by execution request id: {}", (Object)executionRequestId);
            throw new AtpEntityNotFoundException("Environment Info", "execution request id", (Object)executionRequestId);
        }
        UUID toolsInfoId = envInfo.getToolsInfoUuid();
        if (Objects.nonNull(toolsInfoId)) {
            log.debug("Getting tools info by id: {}", (Object)toolsInfoId);
            ToolsInfo toolsInfo = this.toolsInfoRepository.findByUuid(toolsInfoId);
            log.debug("Founded tools info: {}", (Object)toolsInfo);
            envInfo.setToolsInfo(toolsInfo);
        }
        envInfo.setStatus(this.calculateStatus(envInfo).name());
        return envInfo;
    }

    public GridFsFileData getReportById(UUID reportId) throws FileNotFoundException {
        return this.gridFsService.getReportById(reportId);
    }

    public UUID saveMandatoryChecksReport(UUID executionRequestId, InputStream fileInputStream, String fileName) {
        UUID reportId = UUID.randomUUID();
        this.gridFsService.saveMandatoryChecksReport(reportId, executionRequestId, fileInputStream, fileName);
        return reportId;
    }

    public UUID saveSsmMetricsReport(String fileName, String type, String contentType, InputStream inputStream, UUID erId, UUID logRecordId) {
        log.debug("Uploading SSM metrics report file. Params: fileName='{}', type='{}', contentType='{}', execution request id='{}', log record if='{}'", new Object[]{fileName, type, contentType, erId, logRecordId});
        return this.gridFsService.saveSsmMetricReport(fileName, type, contentType, inputStream, erId, logRecordId);
    }

    public void updateSsmMetricReportsData(UUID executionRequestId, SsmMetricReports data) {
        UUID problemContextReportId;
        UUID microservicesReportId;
        log.info("Updating environments info SSM metric reports data for ER with id '{}'", (Object)executionRequestId);
        log.info("Updates: {}", (Object)data);
        EnvironmentsInfo environmentsInfo = this.findByExecutionRequestId(executionRequestId);
        log.debug("Found environments info with id '{}'", (Object)environmentsInfo.getUuid());
        SsmMetricReports ssmMetricReports = environmentsInfo.getSsmMetricReports();
        log.debug("SSM metric reports data: {}", (Object)ssmMetricReports);
        if (Objects.isNull(ssmMetricReports)) {
            ssmMetricReports = new SsmMetricReports();
        }
        if (Objects.nonNull(microservicesReportId = data.getMicroservicesReportId())) {
            ssmMetricReports.setMicroservicesReportId(microservicesReportId);
        }
        if (Objects.nonNull(problemContextReportId = data.getProblemContextReportId())) {
            ssmMetricReports.setProblemContextReportId(problemContextReportId);
        }
        environmentsInfo.setSsmMetricReports(ssmMetricReports);
        log.debug("Updated SSM metric reports data: {}", (Object)ssmMetricReports);
        this.save(environmentsInfo);
        log.info("Environments info has been successfully updated");
    }

    private SystemStatus calculateStatus(EnvironmentsInfo environmentsInfo) {
        ArrayList<SystemInfo> allSystems = new ArrayList<SystemInfo>(environmentsInfo.getTaSystemInfoList());
        allSystems.addAll(environmentsInfo.getQaSystemInfoList());
        return this.calculateStatus(allSystems);
    }

    SystemStatus calculateStatus(List<SystemInfo> systemInfos) {
        if (systemInfos.stream().anyMatch(systemInfo -> this.checkStatus((SystemInfo)systemInfo, SystemStatus.FAIL))) {
            return SystemStatus.FAIL;
        }
        if (systemInfos.stream().anyMatch(systemInfo -> this.checkStatus((SystemInfo)systemInfo, SystemStatus.WARN))) {
            return SystemStatus.WARN;
        }
        return SystemStatus.PASS;
    }

    private boolean checkStatus(SystemInfo info, SystemStatus systemStatus) {
        return info.getStatus() == systemStatus;
    }

    public EnvironmentsInfo findQaTaSystemsByExecutionRequestId(UUID executionRequestId) {
        EnvironmentsInfo environmentsInfo = this.repository.findQaTaSystemsByExecutionRequestId(executionRequestId);
        if (Objects.isNull(environmentsInfo)) {
            log.error("Failed to find Environment Info by execution request id: {}", (Object)executionRequestId);
            throw new AtpEntityNotFoundException("Environment Info", "execution request id", (Object)executionRequestId);
        }
        return environmentsInfo;
    }

    public void deleteAllEnvironmentsInfoByExecutionRequestId(List<UUID> executionRequestIds) {
        this.repository.deleteAllByExecutionRequestIdIn(executionRequestIds);
    }

    public void deleteAllToolsByExecutionRequestId(List<UUID> executionRequestIds) {
        this.toolsInfoRepository.deleteAllByExecutionRequestIdIn(executionRequestIds);
    }

    public EnvironmentsInfoService(EnvironmentsInfoRepository repository, ToolsInfoRepository toolsInfoRepository, GridFsService gridFsService, MongoTemplate mongoTemplate) {
        this.repository = repository;
        this.toolsInfoRepository = toolsInfoRepository;
        this.gridFsService = gridFsService;
        this.mongoTemplate = mongoTemplate;
    }
}

