/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.google.common.base.Splitter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.modelmapper.ModelMapper;
import org.modelmapper.PropertyMap;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpEntityNotFoundException;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.ram.dto.request.ExecutionRequestConfigUpdateRequest;
import org.qubership.atp.ram.dto.request.ExecutionRequestSearchRequest;
import org.qubership.atp.ram.dto.request.LogRecordRegexSearchRequest;
import org.qubership.atp.ram.dto.request.TestRunsByValidationLabelsRequest;
import org.qubership.atp.ram.dto.response.Environment;
import org.qubership.atp.ram.dto.response.ExecutionRequestMainInfoResponse;
import org.qubership.atp.ram.dto.response.LogRecordRegexSearchResponse;
import org.qubership.atp.ram.dto.response.TestCaseLabelResponse;
import org.qubership.atp.ram.dto.response.TestRunWithValidationLabelsResponse;
import org.qubership.atp.ram.dto.response.TestRunsByValidationLabelsResponse;
import org.qubership.atp.ram.entities.ComparisonExecutionRequest;
import org.qubership.atp.ram.entities.ComparisonStep;
import org.qubership.atp.ram.entities.ComparisonTestRun;
import org.qubership.atp.ram.enums.DefaultSuiteNames;
import org.qubership.atp.ram.enums.ExecutionRequestWidgets;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.exceptions.executionrequests.RamExecutionRequestIdNotFoundException;
import org.qubership.atp.ram.model.BaseSearchRequest;
import org.qubership.atp.ram.model.ExecutionRequestTestResult;
import org.qubership.atp.ram.model.TestResult;
import org.qubership.atp.ram.models.EnrichedTestRun;
import org.qubership.atp.ram.models.EnvironmentsInfo;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.ExecutionRequestConfig;
import org.qubership.atp.ram.models.ExecutionRequestRatesResponse;
import org.qubership.atp.ram.models.InitialExecutionRequest;
import org.qubership.atp.ram.models.Label;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.Project;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.RootCause;
import org.qubership.atp.ram.models.SystemInfo;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.models.UserInfo;
import org.qubership.atp.ram.models.WidgetConfigTemplate;
import org.qubership.atp.ram.models.response.ExecutionRequestResponse;
import org.qubership.atp.ram.models.response.PaginatedResponse;
import org.qubership.atp.ram.repositories.CustomExecutionRequestRepository;
import org.qubership.atp.ram.repositories.ExecutionRequestConfigRepository;
import org.qubership.atp.ram.repositories.ExecutionRequestRepository;
import org.qubership.atp.ram.services.CrudService;
import org.qubership.atp.ram.services.EnvironmentsInfoService;
import org.qubership.atp.ram.services.EnvironmentsService;
import org.qubership.atp.ram.services.JiraIntegrationService;
import org.qubership.atp.ram.services.LabelsService;
import org.qubership.atp.ram.services.LogRecordService;
import org.qubership.atp.ram.services.OrchestratorService;
import org.qubership.atp.ram.services.ProjectsService;
import org.qubership.atp.ram.services.RootCauseService;
import org.qubership.atp.ram.services.TestCaseService;
import org.qubership.atp.ram.services.TestRunService;
import org.qubership.atp.ram.services.UserService;
import org.qubership.atp.ram.services.WidgetConfigTemplateService;
import org.qubership.atp.ram.services.filtering.ExecutionRequestFilteringService;
import org.qubership.atp.ram.services.sorting.ExecutionRequestSortingService;
import org.qubership.atp.ram.utils.ListUtils;
import org.qubership.atp.ram.utils.PathsGenerator;
import org.qubership.atp.ram.utils.RateCalculator;
import org.qubership.atp.ram.utils.StepPath;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ExecutionRequestService
extends CrudService<ExecutionRequest> {
    private static final Logger log = LoggerFactory.getLogger(ExecutionRequestService.class);
    private static final String DEFAULT_DATE_FILED_NAME = "date";
    private static final String START_DATE_FILED_NAME = "startDate";
    private static final String FINISH_DATE_FILED_NAME = "finishDate";
    private static final int DEFAULT_NUMBER_PAGE = 0;
    private static final String UNKNOWN = "Unknown";
    private static final String PROJECT = "project";
    private static final String RAM = "ram";
    private static final String EXECUTION_REQUEST = "execution-request";
    private static final String A_HREF_OPEN = "<a href=\"%s\">";
    private static final String A_HREF_CLOSE = "</a>";
    private final ExecutionRequestRepository repository;
    private final CustomExecutionRequestRepository customRepository;
    private final LogRecordService logRecordService;
    private final TestRunService testRunService;
    private final TestCaseService testCaseService;
    private final RateCalculator rateCalculator;
    private final ProjectsService projectsService;
    private final UserService userService;
    private final ModelMapper modelMapper;
    private final ExecutionRequestConfigRepository configRepository;
    private final WidgetConfigTemplateService widgetConfigTemplateService;
    private final ExecutionRequestFilteringService filteringService;
    private final ExecutionRequestSortingService sortingService;
    private final JiraIntegrationService jiraIntegrationService;
    private final EnvironmentsInfoService environmentsInfoService;
    private final OrchestratorService orchestratorService;
    private final EnvironmentsService environmentsService;
    private final LabelsService labelsService;
    private final LockManager lockManager;
    private final RootCauseService rootCauseService;
    @Value(value="${limit.testresults.catalog.dashboard}")
    private int limit;
    @Value(value="${atp.ram.services.executionrequestconfig.creating.lock.duration.sec:300}")
    private Integer lockDurationForCreatingConfigSec;
    @Value(value="${catalogue.url}")
    private String catalogueUrl;

    @Override
    protected MongoRepository<ExecutionRequest, UUID> repository() {
        return this.repository;
    }

    public List<ExecutionRequest> getAllSortedExecutionRequests() {
        return this.repository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{START_DATE_FILED_NAME}));
    }

    @PostConstruct
    public void init() {
        PropertyMap<ExecutionRequest, ExecutionRequestResponse> executionRequestResponsePropertyMap = new PropertyMap<ExecutionRequest, ExecutionRequestResponse>(){

            protected void configure() {
                ((ExecutionRequestResponse)this.map(((ExecutionRequest)this.source).getUuid())).setUuid(null);
            }
        };
        this.modelMapper.addMappings((PropertyMap)executionRequestResponsePropertyMap);
    }

    public List<ComparisonExecutionRequest> getComparisonExecutionRequest(List<UUID> uuids) {
        ArrayList<ExecutionRequest> executionRequests = new ArrayList<ExecutionRequest>();
        for (UUID uuid : uuids) {
            ExecutionRequest er = this.findById(uuid);
            executionRequests.add(er);
        }
        return this.getComparisonEr(executionRequests);
    }

    public List<ComparisonExecutionRequest> getComparisonExecutionRequestWithSteps(List<UUID> uuids) {
        ArrayList<ExecutionRequest> executionRequests = new ArrayList<ExecutionRequest>();
        for (UUID uuid : uuids) {
            ExecutionRequest er = this.findById(uuid);
            executionRequests.add(er);
        }
        return this.getComparisonErWithSteps(executionRequests);
    }

    public List<TestRun> getAllTestRuns(UUID executionRequestId) {
        return this.testRunService.findAllByExecutionRequestId(executionRequestId);
    }

    public List<UUID> getAllTestRunUuidsByExecutionRequestId(UUID executionRequestId) {
        return this.testRunService.findTestRunsUuidByExecutionRequestId(executionRequestId);
    }

    public List<EnrichedTestRun> getAllEnrichedTestRuns(UUID executionRequestId) {
        return this.testRunService.getEnrichedTestRunsByExecutionRequestId(executionRequestId);
    }

    public Map<UUID, TestRun> getDataForTestResultByExecutionRequests(List<ExecutionRequest> ers) {
        List<UUID> erIds = ers.stream().map(RamObject::getUuid).collect(Collectors.toList());
        return this.testRunService.getDataForTestResultByExecutionRequestId(erIds);
    }

    public List<TestRun> getAllFailedTestRuns(UUID executionRequestId) {
        return this.testRunService.findNotPassedTestRunByErId(executionRequestId);
    }

    public void delete(UUID uuid) {
        this.repository.deleteByUuid(uuid);
    }

    public ExecutionRequest findById(UUID executionRequestId) {
        return (ExecutionRequest)this.get(executionRequestId);
    }

    public ExecutionRequestMainInfoResponse findByIdMainInfo(UUID id) {
        ExecutionRequest executionRequest = (ExecutionRequest)this.get(id);
        UUID projectId = executionRequest.getProjectId();
        Project executionRequestProject = this.projectsService.getProjectById(projectId);
        UUID executorId = executionRequest.getExecutorId();
        ExecutionRequestMainInfoResponse.Executor executor = new ExecutionRequestMainInfoResponse.Executor(executorId, executionRequest.getExecutorName());
        List<TestRun> testRuns = this.testRunService.findTestRunForExecutionSummaryByExecutionRequestId(id);
        this.rateCalculator.calculateErRates(executionRequest, testRuns);
        float passedRate = executionRequest.getPassedRate();
        int countOfTestRuns = executionRequest.getCountOfTestRuns();
        int passCount = Math.round(passedRate * (float)countOfTestRuns / 100.0f);
        UUID taToolId = executionRequest.getTaToolsGroupId();
        if (taToolId == null) {
            taToolId = this.getTaToolIdFromEnvironmentsInfo(id);
        }
        boolean isProcessAlive = this.isProcessForExecutionRequestAlive(id);
        return new ExecutionRequestMainInfoResponse(id, executionRequest.getName(), executor, executionRequest.getExecutionStatus(), Integer.valueOf(Math.round(passedRate)), Integer.valueOf(passCount), executionRequest.getStartDate(), executionRequest.getFinishDate(), executionRequest.getDuration(), Integer.valueOf(countOfTestRuns), executionRequestProject.getTroubleShooterUrl(), executionRequestProject.getMonitoringToolUrl(), executionRequestProject.getMissionControlToolUrl(), !isProcessAlive, Integer.valueOf(executionRequest.getThreads()), executionRequest.getTestScopeId(), executionRequest.getEnvironmentId(), taToolId, executionRequest.getInitialExecutionRequestId(), executionRequest.getJointExecutionKey(), executionRequest.isVirtual());
    }

    private UUID getTaToolIdFromEnvironmentsInfo(UUID id) {
        try {
            EnvironmentsInfo environmentsInfo = this.environmentsInfoService.findByExecutionRequestId(id);
            if (environmentsInfo != null) {
                return environmentsInfo.getTaToolsGroupId();
            }
        }
        catch (AtpEntityNotFoundException e) {
            log.error("Cannot find environment info for er with id {}", (Object)id, (Object)e);
        }
        return null;
    }

    private boolean isProcessForExecutionRequestAlive(UUID id) {
        UUID processId = null;
        try {
            processId = this.orchestratorService.getProcessIdByExecutionRequestId(id);
        }
        catch (Exception e) {
            log.error("Cannot get process id from orchestrator by Execution Request id", (Throwable)e);
        }
        return processId != null;
    }

    public ExecutionRequestMainInfoResponse.Executor getExecutionRequestExecutor(UUID id) {
        if (Objects.isNull(id)) {
            return new ExecutionRequestMainInfoResponse.Executor(null, UNKNOWN);
        }
        UserInfo executorUserInfo = this.userService.getUserInfoById(id);
        return this.mapUserInfoToExecutor(executorUserInfo);
    }

    private ExecutionRequestMainInfoResponse.Executor mapUserInfoToExecutor(UserInfo userInfo) {
        if (Objects.isNull(userInfo)) {
            return new ExecutionRequestMainInfoResponse.Executor(null, UNKNOWN);
        }
        UUID id = userInfo.getId();
        String username = userInfo.getUsername();
        if (username.contains("-plugin")) {
            return new ExecutionRequestMainInfoResponse.Executor(id, "Jenkins");
        }
        String fullUsername = userInfo.getFirstName() + " " + userInfo.getLastName();
        return new ExecutionRequestMainInfoResponse.Executor(id, fullUsername);
    }

    public List<UUID> getRequestsForStoppingOrTerminating(List<UUID> executionRequestsIds) {
        return executionRequestsIds.stream().filter(executionRequestsId -> ExecutionStatuses.IN_PROGRESS.equals((Object)this.findById((UUID)executionRequestsId).getExecutionStatus())).collect(Collectors.toList());
    }

    public List<UUID> getRequestsForResuming(List<UUID> executionRequestsIds) {
        return executionRequestsIds.stream().filter(executionRequestsId -> ExecutionStatuses.SUSPENDED.equals((Object)this.findById((UUID)executionRequestsId).getExecutionStatus())).collect(Collectors.toList());
    }

    public List<ExecutionRequest> getExecutionRequestsByIds(Collection<UUID> executionRequestsIds) {
        return this.repository.findAllByUuidIn(executionRequestsIds);
    }

    public List<ExecutionRequest> getOrderedExecutionRequestsByIds(Collection<UUID> executionRequestsIds) {
        return this.repository.findAllByUuidInOrderByStartDate(executionRequestsIds);
    }

    public ExecutionRequest setLabel(UUID uuid, List<UUID> uuidLabels) {
        ExecutionRequest executionRequest = this.findById(uuid);
        executionRequest.setLabels(uuidLabels);
        this.save(executionRequest);
        return executionRequest;
    }

    public ExecutionRequest removeLabel(UUID uuidRequest, List<UUID> uuidLabels) {
        ExecutionRequest executionRequest = this.findById(uuidRequest);
        List labels = executionRequest.getLabels().stream().filter(label1 -> !uuidLabels.contains(label1)).collect(Collectors.toList());
        executionRequest.setLabels(labels);
        this.save(executionRequest);
        return executionRequest;
    }

    public List<StepPath> findStepBySearchValue(UUID uuidRequest, String searchValue) {
        LinkedList<StepPath> stepPaths = new LinkedList<StepPath>();
        PathsGenerator generator = new PathsGenerator(this.logRecordService);
        List<TestRun> testRuns = this.getAllMatchesTestRuns(uuidRequest, searchValue);
        StepPath foundTestRuns = generator.generatePathToFoundTestRuns(testRuns);
        if (!foundTestRuns.getUuidSteps().isEmpty()) {
            stepPaths.add(foundTestRuns);
        }
        this.getAllTestRuns(uuidRequest).forEach(testRun -> {
            UUID uuid = testRun.getUuid();
            List<LogRecord> logRecords = this.testRunService.getAllMatchesLogRecords(uuid, searchValue);
            stepPaths.addAll(generator.generatePathToFoundLogRecords(logRecords));
        });
        return stepPaths;
    }

    public List<ExecutionRequestTestResult> getLastErsByProjectUuidWithTestRuns(UUID projectUuid) {
        List<ExecutionRequest> executionRequests = this.findFinishedErByProjectAndSortByFinishDate(projectUuid);
        return this.createErTestResultsByErs(executionRequests);
    }

    public List<TestResult> getLastErsByTestplanUuidWithQaHostsAndTaHosts(UUID testPlanUuid) {
        List<ExecutionRequest> executionRequests = this.getSortedExecutionRequestsForTestPlan(testPlanUuid);
        return this.createTestResultsByErs(executionRequests);
    }

    private List<ExecutionRequestTestResult> createErTestResultsByErs(List<ExecutionRequest> executionRequests) {
        Set<UUID> erIds = StreamUtils.extractIds(executionRequests);
        Map<UUID, EnvironmentsInfo> executionRequestMap = this.environmentsInfoService.getDataForErTestResultByExecutionRequestIds(erIds);
        List<Environment> environments = this.getExecutionRequestEnvironments(executionRequests);
        Map<UUID, Environment> environmentMap = StreamUtils.toIdEntityMap(environments, Environment::getId);
        return executionRequests.stream().map(executionRequest -> {
            EnvironmentsInfo environmentsInfo = executionRequestMap.getOrDefault(executionRequest.getUuid(), new EnvironmentsInfo());
            List<SystemInfo> systemInfos = this.getSystemInfosByEnvironmentsInfo(environmentsInfo);
            List<String> hosts = systemInfos.stream().map(SystemInfo::getUrls).flatMap(Collection::stream).collect(Collectors.toList());
            List<String> solutionBuilds = systemInfos.stream().map(SystemInfo::getVersion).filter(version -> !version.isEmpty()).distinct().collect(Collectors.toList());
            Environment environment = (Environment)environmentMap.get(executionRequest.getEnvironmentId());
            return new ExecutionRequestTestResult((ExecutionRequest)executionRequest, environment, hosts, solutionBuilds);
        }).collect(Collectors.toList());
    }

    private List<SystemInfo> getSystemInfosByEnvironmentsInfo(EnvironmentsInfo environmentsInfo) {
        Stream qaSystemInfo = Optional.ofNullable(environmentsInfo.getQaSystemInfoList()).map(Collection::stream).orElseGet(Stream::empty);
        Stream taSystemInfo = Optional.ofNullable(environmentsInfo.getTaSystemInfoList()).map(Collection::stream).orElseGet(Stream::empty);
        return Stream.concat(qaSystemInfo, taSystemInfo).collect(Collectors.toList());
    }

    public List<TestResult> getTestResultsByRestScopeUuid(UUID testScopeUuid) {
        List<ExecutionRequest> executionRequests = this.findByTestScopeUuid(testScopeUuid);
        return this.createTestResultsByErs(executionRequests);
    }

    private List<TestResult> createTestResultsByErs(List<ExecutionRequest> executionRequests) {
        Map<UUID, TestRun> testRuns = this.getDataForTestResultByExecutionRequests(executionRequests);
        return executionRequests.stream().map(executionRequest -> {
            TestResult result = new TestResult((ExecutionRequest)executionRequest);
            TestRun testRun = testRuns.getOrDefault(executionRequest.getUuid(), new TestRun());
            result.setQaHosts(testRun.getQaHost());
            result.setTaHosts(testRun.getTaHost());
            return result;
        }).collect(Collectors.toList());
    }

    private List<TestRun> getAllMatchesTestRuns(UUID uuidRequest, String searchValue) {
        return this.testRunService.getAllMatchedTestRunsByRequestId(uuidRequest, searchValue);
    }

    public List<ExecutionRequest> findByTestPlanId(UUID testPlanId) {
        return this.repository.findAllByTestPlanId(testPlanId);
    }

    public List<ExecutionRequestResponse> findByTestPlanUuid(UUID testPlanUuid) {
        List<ExecutionRequest> executionRequests = this.repository.findAllByTestPlanId(testPlanUuid);
        return this.buildExecutionRequestResponses(executionRequests);
    }

    public List<ExecutionRequest> findFinishedErByProjectAndSortByFinishDate(UUID projectUuid) {
        PageRequest request = PageRequest.of((int)0, (int)this.limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FINISH_DATE_FILED_NAME}));
        return this.repository.findLimitRequestsByProjectIdAndExecutionStatusNotIn(projectUuid, Arrays.asList(ExecutionStatuses.IN_PROGRESS, ExecutionStatuses.NOT_STARTED), (Pageable)request);
    }

    public List<ExecutionRequest> findFinishedErByProjectAndSortByFinishDate(UUID projectUuid, Timestamp dateFilter) {
        PageRequest request = PageRequest.of((int)0, (int)this.limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FINISH_DATE_FILED_NAME}));
        return this.repository.findAllByProjectIdAndExecutionStatusNotInAndFinishDateAfter(projectUuid, Arrays.asList(ExecutionStatuses.IN_PROGRESS, ExecutionStatuses.NOT_STARTED), dateFilter, (Pageable)request);
    }

    public List<ExecutionRequest> findPageByTestPlanUuidAndSort(UUID testPlanUuid, int startIndex, int endIndex, String columnType, String sortType) {
        Sort.Direction type = !Sort.Direction.ASC.name().equals(sortType) && !Sort.Direction.DESC.name().equals(sortType) ? Sort.Direction.DESC : Sort.Direction.fromString((String)sortType);
        int countOnPage = endIndex - startIndex;
        int numOfPage = startIndex / countOnPage;
        PageRequest request = PageRequest.of((int)numOfPage, (int)countOnPage, (Sort)Sort.by((Sort.Direction)type, (String[])new String[]{this.prepareColumnType(columnType)}));
        return this.repository.findAllByTestPlanId(testPlanUuid, (Pageable)request);
    }

    public List<ExecutionRequestResponse> findResponsePageByTestPlanUuidAndSort(UUID testPlanUuid, int startIndex, int endIndex, String columnType, String sortType) {
        List<ExecutionRequest> executionRequests = this.findPageByTestPlanUuidAndSort(testPlanUuid, startIndex, endIndex, columnType, sortType);
        return this.buildExecutionRequestResponses(executionRequests);
    }

    public List<ExecutionRequestResponse> buildExecutionRequestResponses(List<ExecutionRequest> executionRequests) {
        List<Environment> environments = this.getExecutionRequestEnvironments(executionRequests);
        Map<UUID, Environment> environmentMap = StreamUtils.toKeyEntityMap(environments, Environment::getId);
        List<Label> labels = this.getExecutionRequestsLabels(executionRequests);
        Map<UUID, List<Label>> filteredByLabelsMap = this.getExecutionRequestsAndFilteredByLabelsMap(executionRequests, labels);
        List<ExecutionRequest> initialExecutionRequests = this.getInitialExecutionRequests(executionRequests);
        Map<UUID, ExecutionRequest> initialExecutionRequestMap = StreamUtils.toKeyEntityMap(initialExecutionRequests, RamObject::getUuid);
        return executionRequests.stream().map(request -> {
            ExecutionRequestResponse response = (ExecutionRequestResponse)this.modelMapper.map(request, ExecutionRequestResponse.class);
            response.setUuid(request.getUuid());
            Environment environment = (Environment)environmentMap.get(request.getEnvironmentId());
            response.setEnvironment(environment);
            response.setExecutor(new ExecutionRequestMainInfoResponse.Executor(request.getExecutorId(), request.getExecutorName()));
            response.setFilteredByLabels((List)filteredByLabelsMap.get(request.getUuid()));
            UUID initialErId = request.getInitialExecutionRequestId();
            if (Objects.nonNull(initialErId) && initialExecutionRequestMap.containsKey(initialErId)) {
                String initialErName = ((ExecutionRequest)initialExecutionRequestMap.get(initialErId)).getName();
                InitialExecutionRequest initialEr = new InitialExecutionRequest(initialErId, initialErName);
                response.setInitialExecutionRequest(initialEr);
            }
            return response;
        }).collect(Collectors.toList());
    }

    public List<Environment> getExecutionRequestEnvironments(UUID testPlanId) {
        List<ExecutionRequest> executionRequests = this.findByTestPlanId(testPlanId);
        return this.getExecutionRequestEnvironments(executionRequests);
    }

    public List<Environment> getExecutionRequestEnvironments(List<ExecutionRequest> executionRequests) {
        Set<UUID> envIds = StreamUtils.extractIds(executionRequests, ExecutionRequest::getEnvironmentId);
        BaseSearchRequest searchRequest = BaseSearchRequest.builder().ids(envIds).build();
        return this.environmentsService.searchEnvironments(searchRequest);
    }

    private List<ExecutionRequest> getInitialExecutionRequests(List<ExecutionRequest> executionRequests) {
        Set<UUID> initialExecutionRequestIds = StreamUtils.extractIds(executionRequests, ExecutionRequest::getInitialExecutionRequestId);
        return this.repository.findAllByUuidIn(initialExecutionRequestIds);
    }

    public List<Label> getExecutionRequestsLabels(List<ExecutionRequest> executionRequests) {
        Set<UUID> labelIds = StreamUtils.extractFlatIds(executionRequests, ExecutionRequest::getFilteredByLabels);
        return labelIds.isEmpty() ? Collections.emptyList() : this.labelsService.getLabels(labelIds);
    }

    public Map<UUID, List<Label>> getExecutionRequestsAndFilteredByLabelsMap(List<ExecutionRequest> executionRequests, List<Label> labels) {
        HashMap<UUID, List<Label>> executionRequestAndLabelsMap = new HashMap<UUID, List<Label>>();
        executionRequests.forEach(executionRequest -> {
            if (!CollectionUtils.isEmpty((Collection)executionRequest.getFilteredByLabels())) {
                executionRequestAndLabelsMap.put(executionRequest.getUuid(), labels.stream().filter(label -> executionRequest.getFilteredByLabels().contains(label.getUuid())).collect(Collectors.toList()));
            }
        });
        return executionRequestAndLabelsMap;
    }

    public List<ExecutionRequestMainInfoResponse.Executor> getExecutionRequestExecutors(UUID testPlanId) {
        List<ExecutionRequest> executionRequests = this.findByTestPlanId(testPlanId);
        return executionRequests.stream().map(executionRequest -> new ExecutionRequestMainInfoResponse.Executor(executionRequest.getExecutorId(), executionRequest.getExecutorName())).distinct().collect(Collectors.toList());
    }

    public List<ExecutionRequestMainInfoResponse.Executor> getExecutionRequestExecutors(Set<UUID> userIds) {
        return this.userService.getUserByIds(userIds).stream().map(this::mapUserInfoToExecutor).collect(Collectors.toList());
    }

    private String prepareColumnType(String column) {
        return DEFAULT_DATE_FILED_NAME.equalsIgnoreCase(column) ? START_DATE_FILED_NAME : column;
    }

    public List<ExecutionRequest> findPageByTestPlanUuidBetweenPeriodAndSort(UUID testPlanUuid, Timestamp startDate, Timestamp endDate, int startIndex, int endIndex, String columnType, String sortType) {
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.fromString((String)sortType), (String[])new String[]{this.prepareColumnType(columnType)});
        PageRequest request = PageRequest.of((int)startIndex, (int)(endIndex - startIndex), (Sort)sort);
        if (START_DATE_FILED_NAME.equalsIgnoreCase(columnType)) {
            return this.repository.findAllByTestPlanIdAndStartDateBetween(testPlanUuid, startDate, endDate, (Pageable)request);
        }
        return this.repository.findAllByTestPlanIdAndFinishDateBetween(testPlanUuid, startDate, endDate, (Pageable)request);
    }

    public void recursiveDeleteListRequests(List<UUID> requestsUuidList) {
        LinkedList<UUID> testRunsUuidList = new LinkedList<UUID>();
        requestsUuidList.forEach(requestsUuid -> testRunsUuidList.addAll(this.getAllTestRunUuidsByExecutionRequestId((UUID)requestsUuid)));
        this.testRunService.deleteListTestRuns(testRunsUuidList);
        this.repository.deleteAllByUuidIn(requestsUuidList);
    }

    private List<ComparisonExecutionRequest> getComparisonEr(List<ExecutionRequest> ers) {
        List<ComparisonExecutionRequest> compErs = this.getComparisonExecutionRequestWithTestRuns(ers);
        for (ComparisonExecutionRequest request : compErs) {
            Set<ComparisonTestRun> compTestRuns = this.setNonCompTestRunAndUpdateCompTestRun(compErs, request);
            request.setTestRuns(compTestRuns);
        }
        return compErs;
    }

    private List<ComparisonExecutionRequest> getComparisonErWithSteps(List<ExecutionRequest> ers) {
        List<ComparisonExecutionRequest> compErs = this.getComparisonExecutionRequestWithTestRuns(ers);
        for (ComparisonExecutionRequest request : compErs) {
            Set<ComparisonTestRun> compTestRuns = this.setNonCompTestRunAndUpdateCompTestRun(compErs, request);
            for (ComparisonTestRun testRun : compTestRuns) {
                List<LogRecord> logRecords = this.logRecordService.findLogRecordsWithSpecificFieldsByTestRunIdOrderByStartDateAsc(testRun.getId());
                if (logRecords.isEmpty()) continue;
                testRun.setSteps(logRecords.stream().filter(logRecord -> logRecord.isSection() && !logRecord.isCompaund()).map(logRecord -> {
                    ComparisonStep step = new ComparisonStep();
                    step.setStepName(logRecord.getName());
                    step.setStatuses(logRecord.getTestingStatus());
                    step.setDuration(logRecord.getDuration());
                    return step;
                }).collect(Collectors.toSet()));
            }
            request.setTestRuns(compTestRuns);
        }
        return compErs;
    }

    private List<ComparisonExecutionRequest> getComparisonExecutionRequestWithTestRuns(List<ExecutionRequest> ers) {
        ArrayList<ComparisonExecutionRequest> compErs = new ArrayList<ComparisonExecutionRequest>();
        for (ExecutionRequest executionRequest : ers) {
            ComparisonExecutionRequest request = new ComparisonExecutionRequest();
            request.setErName(executionRequest.getName());
            request.setTestRuns(this.getAllTestRuns(executionRequest.getUuid()).stream().filter(testRun -> !testRun.getName().equals(DefaultSuiteNames.EXECUTION_REQUESTS_LOGS.getName())).map(testRun -> {
                ComparisonTestRun compTr = new ComparisonTestRun();
                compTr.setTrName(testRun.getName());
                compTr.setTestCaseId(testRun.getTestCaseId());
                compTr.setStatuses(testRun.getTestingStatus());
                compTr.setDuration(testRun.getDuration());
                compTr.setId(testRun.getUuid());
                return compTr;
            }).collect(Collectors.toSet()));
            compErs.add(request);
        }
        return compErs;
    }

    private Set<ComparisonTestRun> setNonCompTestRunAndUpdateCompTestRun(List<ComparisonExecutionRequest> compErs, ComparisonExecutionRequest currentRequest) {
        ArrayList<ComparisonExecutionRequest> compErsWithoutCurrent = new ArrayList<ComparisonExecutionRequest>(compErs);
        compErsWithoutCurrent.remove(currentRequest);
        HashSet testCaseIds = new HashSet();
        compErsWithoutCurrent.forEach(er -> testCaseIds.addAll(er.getTestRuns().stream().map(ComparisonTestRun::getTestCaseId).collect(Collectors.toList())));
        Set compTestRuns = currentRequest.getTestRuns();
        currentRequest.setNonComparisonTestRuns(compTestRuns.stream().filter(testRun -> !testCaseIds.contains(testRun.getTestCaseId())).collect(Collectors.toSet()));
        compTestRuns.removeAll(currentRequest.getNonComparisonTestRuns());
        return compTestRuns;
    }

    public List<ExecutionRequest> getNotFinishedRequests() {
        return this.repository.findRequestsIdByExecutionStatusIn(Arrays.asList(ExecutionStatuses.NOT_STARTED, ExecutionStatuses.IN_PROGRESS));
    }

    @Deprecated
    public void stopExecutionRequest(ExecutionRequest er, long lastFinishDate) {
        List<TestRun> testRuns;
        UUID executionRequestId = er.getUuid();
        log.debug("Stop Execution Request: {}.", (Object)executionRequestId);
        er.setFinishDate(new Timestamp(lastFinishDate));
        ExecutionStatuses executionStatus = er.getExecutionStatus();
        log.trace("Execution Request: {} executionStatus {}", (Object)executionRequestId, (Object)executionStatus);
        if (executionStatus == null || executionStatus.getId() < ExecutionStatuses.FINISHED.getId()) {
            er.setExecutionStatus(ExecutionStatuses.FINISHED);
            log.trace("Execution Request: {} status was changed to {}", (Object)executionRequestId, (Object)ExecutionStatuses.FINISHED);
        }
        if (!(testRuns = this.testRunService.findAllByExecutionRequestId(executionRequestId)).isEmpty()) {
            log.debug("Start calculate rates for ER {}", (Object)executionRequestId);
            this.rateCalculator.calculateRates(er, testRuns);
            log.debug("Start calculate count of screenshots for every TR in ER {}", (Object)executionRequestId);
            this.logRecordService.saveCountScreenshots(executionRequestId, testRuns);
        }
        log.debug("Start calculate duration for ER {}", (Object)executionRequestId);
        this.calculateDuration(er);
        this.save(er);
        log.debug("Execution Request: {} was finished and calculate issues.", (Object)executionRequestId);
    }

    private void calculateDuration(ExecutionRequest er) {
        long finishTime = er.getFinishDate().getTime();
        long startTime = er.getStartDate().getTime();
        long duration = TimeUnit.MILLISECONDS.toSeconds(finishTime - startTime);
        er.setDuration(duration);
    }

    public List<ExecutionRequest> findAllByJointExecutionKey(String jointExecutionKey) {
        return this.repository.findAllByJointExecutionKey(jointExecutionKey);
    }

    public Project getProjectId(UUID executionRequestId) {
        ExecutionRequest executionRequest = (ExecutionRequest)this.get(executionRequestId);
        UUID projectId = executionRequest.getProjectId();
        return this.projectsService.getProjectById(projectId);
    }

    public UUID getProjectId(UUID projectId, UUID executionRequestId) {
        if (Objects.isNull(projectId)) {
            return this.getProjectIdByExecutionRequestId(executionRequestId);
        }
        return projectId;
    }

    public UUID getProjectIdByExecutionRequestId(UUID id) {
        ExecutionRequest executionRequest = this.repository.findProjectIdByUuid(id);
        if (Objects.isNull(executionRequest)) {
            throw new RamExecutionRequestIdNotFoundException(id);
        }
        return executionRequest.getProjectId();
    }

    public List<ExecutionRequest> getSortedExecutionRequestsForTestPlan(UUID testPlanUuid) {
        PageRequest request = PageRequest.of((int)0, (int)this.limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{START_DATE_FILED_NAME}));
        return this.repository.findAllByTestPlanId(testPlanUuid, (Pageable)request);
    }

    public ExecutionRequest updateExecutionStatus(UUID requestUuid, ExecutionStatuses executionStatus) {
        try {
            ExecutionRequest executionRequest = this.findById(requestUuid);
            executionRequest.setExecutionStatus(executionStatus);
            if (ExecutionStatuses.FINISHED.equals((Object)executionStatus) || ExecutionStatuses.TERMINATED.equals((Object)executionStatus) || ExecutionStatuses.TERMINATED_BY_TIMEOUT.equals((Object)executionStatus)) {
                this.testRunService.stopServiceTestRun(requestUuid);
                this.stopExecutionRequest(executionRequest, System.currentTimeMillis());
                this.testCaseService.updateCaseStatuses(this.getAllTestRuns(requestUuid));
            } else {
                this.save(executionRequest);
                log.trace("Set status {} for ER: {}", (Object)executionStatus.getName(), (Object)requestUuid);
            }
            if (ExecutionStatuses.FINISHED == executionStatus || ExecutionStatuses.TERMINATED_BY_TIMEOUT == executionStatus || ExecutionStatuses.TERMINATED == executionStatus) {
                try {
                    this.jiraIntegrationService.syncWithJira(executionRequest);
                }
                catch (Exception e) {
                    log.error("Unable synchronization with jira execution request: {}", (Object)requestUuid);
                }
            }
            return executionRequest;
        }
        catch (Exception e) {
            log.error("Unable update ER status", (Throwable)e);
            return new ExecutionRequest();
        }
    }

    public List<ExecutionRequest> findAllRequestsNotFinished(UUID projectId) {
        return this.repository.findAllByProjectIdAndExecutionStatusNotIn(projectId, Collections.singletonList(ExecutionStatuses.FINISHED));
    }

    public List<ExecutionRequest> findAllByUuidIn(List<UUID> uuids) {
        return this.repository.findAllByUuidIn(uuids);
    }

    public List<ExecutionRequest> findPageByTestPlanUuidBetweenPeriodAndAnalyzedByQa(UUID testPlanUuid, Timestamp startDate, Timestamp endDate, Boolean analyzedByQa, int startIndex, int endIndex) {
        PageRequest request = PageRequest.of((int)startIndex, (int)(endIndex - startIndex), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FINISH_DATE_FILED_NAME}));
        if (analyzedByQa == null) {
            return this.customRepository.getByTestPlanAndFinishDateBetweenOrEquals(testPlanUuid, startDate, endDate, (Pageable)request);
        }
        return this.customRepository.getByTestPlanAndFinishDateBetweenOrEqualsAndAnalyzedByQa(testPlanUuid, startDate, analyzedByQa, (Pageable)request);
    }

    public List<ExecutionRequest> findPageByTestPlanUuidAndAnalyzedByQa(UUID testPlanUuid, Boolean analyzedByQa, int startIndex, int endIndex) {
        PageRequest request = PageRequest.of((int)startIndex, (int)(endIndex - startIndex), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{FINISH_DATE_FILED_NAME}));
        if (analyzedByQa == null) {
            return this.repository.findAllByTestPlanId(testPlanUuid, (Pageable)request);
        }
        return this.repository.findAllByTestPlanIdAndAnalyzedByQaEquals(testPlanUuid, analyzedByQa, (Pageable)request);
    }

    public void updateAnalyzedByQa(Collection<UUID> executionRequestIds, boolean value) {
        log.info("Updating analyzed by qa parameter with value '{}' for ER's: {}", (Object)value, executionRequestIds);
        List<ExecutionRequest> executionRequests = this.getExecutionRequestsByIds(executionRequestIds);
        if (!CollectionUtils.isEmpty(executionRequests)) {
            log.debug("Found execution requests: {}", executionRequestIds);
            executionRequests.forEach(executionRequest -> executionRequest.setAnalyzedByQa(value));
            this.saveAll(executionRequests);
        }
    }

    public UUID getTestPlanIdByExecutionRequestId(UUID id) {
        ExecutionRequest executionRequest = this.repository.findByUuid(id);
        return executionRequest.getTestPlanId();
    }

    public String generateErLink(UUID executionRequestId, UUID projectId) {
        String erLink = this.catalogueUrl + "/" + PROJECT + "/" + projectId + "/" + RAM + "/" + EXECUTION_REQUEST + "/" + executionRequestId;
        return String.format("<a href=\"%s\">%s</a>", erLink, erLink);
    }

    public ExecutionRequestConfig getExecutionRequestConfig(UUID executionRequestId) {
        log.debug("Get config for execution request with id '{}'", (Object)executionRequestId);
        ExecutionRequest executionRequest = (ExecutionRequest)this.get(executionRequestId);
        return this.getExecutionRequestConfig(executionRequest);
    }

    public ExecutionRequestConfig getExecutionRequestConfig(ExecutionRequest executionRequest) {
        UUID executionRequestId = executionRequest.getUuid();
        ExecutionRequestConfig resultExecutionRequestConfig = (ExecutionRequestConfig)this.lockManager.executeWithLock("get_or_create_config_for_execution_request" + executionRequestId.toString(), this.lockDurationForCreatingConfigSec, () -> {
            log.debug("Get config for execution request with id '{}'", (Object)executionRequestId);
            ExecutionRequestConfig config = this.configRepository.findByExecutionRequestId(executionRequestId);
            if (Objects.nonNull(config)) {
                log.debug("Founded config: {}", (Object)config);
                return config;
            }
            ExecutionRequestConfig executionRequestConfig = new ExecutionRequestConfig();
            executionRequestConfig.setExecutionRequestId(executionRequestId);
            UUID widgetConfigTemplateId = executionRequest.getWidgetConfigTemplateId();
            if (Objects.nonNull(widgetConfigTemplateId)) {
                executionRequestConfig.setWidgetConfigTemplateId(widgetConfigTemplateId);
            }
            log.debug("Cannot found config, creating new one: {}", (Object)executionRequestConfig);
            return (ExecutionRequestConfig)this.configRepository.save(executionRequestConfig);
        }, () -> null);
        if (resultExecutionRequestConfig == null) {
            String message = String.format("Error occurred while obtain config lock for execution request %s", executionRequest.getUuid());
            log.error(message);
            throw new RuntimeException(message);
        }
        return resultExecutionRequestConfig;
    }

    public void updateExecutionRequestConfig(UUID executionRequestId, ExecutionRequestConfigUpdateRequest request) {
        ExecutionRequest executionRequest = (ExecutionRequest)this.get(executionRequestId);
        this.updateExecutionRequestConfig(executionRequest, request);
    }

    @Caching(evict={@CacheEvict(value={"ATP_RAM-REPORTS"}, key="{#executionRequest.getUuid(), #executionRequest.getCountLogRecords(), T(org.qubership.atp.ram.enums.ExecutionRequestWidgets).SUMMARY_STATISTIC}"), @CacheEvict(value={"ATP_RAM-REPORTS"}, key="{#executionRequest.getUuid(), #executionRequest.getCountLogRecords(), T(org.qubership.atp.ram.enums.ExecutionRequestWidgets).SUMMARY_STATISTIC_FOR_USAGES}"), @CacheEvict(value={"ATP_RAM-REPORTS"}, key="{#executionRequest.getUuid(), #executionRequest.getCountLogRecords(), T(org.qubership.atp.ram.enums.ExecutionRequestWidgets).SUMMARY_STATISTIC_SCENARIO_TYPE}"), @CacheEvict(value={"ATP_RAM-REPORTS"}, key="{#executionRequest.getUuid(), #executionRequest.getCountLogRecords(), T(org.qubership.atp.ram.enums.ExecutionRequestWidgets).TEST_CASES}"), @CacheEvict(value={"ATP_RAM-REPORTS"}, key="{#executionRequest.getUuid(), #executionRequest.getCountLogRecords(), T(org.qubership.atp.ram.enums.ExecutionRequestWidgets).TOP_ISSUES}")})
    public void updateExecutionRequestConfig(ExecutionRequest executionRequest, ExecutionRequestConfigUpdateRequest request) {
        log.debug("Update execution request '{}' config: {}", (Object)executionRequest.getUuid(), (Object)request);
        ExecutionRequestConfig existedConfig = this.configRepository.findByExecutionRequestId(executionRequest.getUuid());
        if (null != executionRequest.getWidgetConfigTemplateId()) {
            executionRequest.setWidgetConfigTemplateId(request.getWidgetConfigTemplateId());
            this.save(executionRequest);
        }
        existedConfig.setWidgetConfigTemplateId(request.getWidgetConfigTemplateId());
        this.checkDefaultLabelTemplateConfigOverride(existedConfig);
        this.configRepository.save(existedConfig);
    }

    private void checkDefaultLabelTemplateConfigOverride(ExecutionRequestConfig executionRequestConfig) {
        UUID widgetConfigTemplateId = executionRequestConfig.getWidgetConfigTemplateId();
        if (!executionRequestConfig.isDefaultLabelTemplateChanged() && Objects.nonNull(widgetConfigTemplateId)) {
            UUID executionRequestId = executionRequestConfig.getExecutionRequestId();
            WidgetConfigTemplate widgetConfigTemplate = (WidgetConfigTemplate)this.widgetConfigTemplateService.get(widgetConfigTemplateId);
            if (Objects.nonNull(widgetConfigTemplate)) {
                ExecutionRequest executionRequest = (ExecutionRequest)this.get(executionRequestId);
                UUID erLabelTemplateId = executionRequest.getLabelTemplateId();
                WidgetConfigTemplate.WidgetConfig summaryStatisticWidgetConfig = widgetConfigTemplate.getWidgetConfig(ExecutionRequestWidgets.SUMMARY_STATISTIC.getWidgetId());
                UUID summaryWidgetLabelTemplateId = summaryStatisticWidgetConfig.getLabelTemplateId();
                if (Objects.nonNull(summaryWidgetLabelTemplateId) && !summaryWidgetLabelTemplateId.equals(erLabelTemplateId)) {
                    executionRequestConfig.setDefaultLabelTemplateChanged(true);
                    executionRequest.setLabelTemplateId(null);
                    this.save(executionRequest);
                }
            }
        }
    }

    public PaginatedResponse<ExecutionRequest> getExecutionRequests(UUID testPlanUuid, ExecutionRequestSearchRequest request) {
        CriteriaDefinition searchCriteria = this.filteringService.buildSearchCriteria(testPlanUuid, request.getFilters());
        List requestSort = request.getSort();
        Sort sort = Objects.nonNull(requestSort) ? this.sortingService.buildSort(requestSort) : Sort.unsorted();
        Integer page = request.getPage();
        Integer size = request.getSize();
        PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)sort);
        List<ExecutionRequest> executionRequests = this.customRepository.searchExecutionRequests(searchCriteria, (Pageable)pageable);
        int totalCount = this.customRepository.getExecutionRequestsCountByCriteria(searchCriteria);
        return new PaginatedResponse(totalCount, executionRequests);
    }

    public PaginatedResponse<ExecutionRequestResponse> getExecutionRequestsResponse(UUID testPlanUuid, ExecutionRequestSearchRequest req) {
        PaginatedResponse<ExecutionRequest> executionRequests = this.getExecutionRequests(testPlanUuid, req);
        List<ExecutionRequestResponse> data = this.buildExecutionRequestResponses(executionRequests.getData());
        return new PaginatedResponse(executionRequests.getTotal(), data);
    }

    public ExecutionRequestRatesResponse getRates(UUID executionRequestId) {
        ExecutionRequest executionRequest = (ExecutionRequest)this.get(executionRequestId);
        ExecutionRequestRatesResponse response = StreamUtils.mapToClazz(executionRequest, ExecutionRequestRatesResponse.class);
        response.setTestCasesCount(executionRequest.getCountOfTestRuns());
        ExecutionRequestMainInfoResponse.Executor executor = new ExecutionRequestMainInfoResponse.Executor(executionRequest.getExecutorId(), executionRequest.getExecutorName());
        response.setExecutor(executor.getUsername());
        List<TestRun> testRuns = this.getAllTestRuns(executionRequestId);
        Map<TestingStatuses, RateCalculator.TestingStatusesStat> stats = this.rateCalculator.calculateTestRunsTestingStatusStats(executionRequest, testRuns);
        this.setStatusStat(response, TestingStatuses.PASSED, stats, ExecutionRequestRatesResponse::setPassedRateCount, ExecutionRequestRatesResponse::setPassedRate);
        this.setStatusStat(response, TestingStatuses.WARNING, stats, ExecutionRequestRatesResponse::setWarningRateCount, ExecutionRequestRatesResponse::setWarningRate);
        this.setStatusStat(response, TestingStatuses.FAILED, stats, ExecutionRequestRatesResponse::setFailedRateCount, ExecutionRequestRatesResponse::setFailedRate);
        this.setStatusStat(response, TestingStatuses.STOPPED, stats, ExecutionRequestRatesResponse::setStoppedRateCount, ExecutionRequestRatesResponse::setStoppedRate);
        this.setStatusStat(response, TestingStatuses.NOT_STARTED, stats, ExecutionRequestRatesResponse::setNotStartedRateCount, ExecutionRequestRatesResponse::setNotStartedRate);
        return response;
    }

    private void setStatusStat(ExecutionRequestRatesResponse response, TestingStatuses status, Map<TestingStatuses, RateCalculator.TestingStatusesStat> statsMap, BiConsumer<ExecutionRequestRatesResponse, Integer> countSetFunc, BiConsumer<ExecutionRequestRatesResponse, Float> rateSetFunc) {
        RateCalculator.TestingStatusesStat statusStats = statsMap.get(status);
        if (Objects.nonNull(statusStats)) {
            countSetFunc.accept(response, statusStats.getCount());
            rateSetFunc.accept(response, Float.valueOf(statusStats.getRate()));
        }
    }

    public LogRecordRegexSearchResponse searchFailedLogRecords(UUID executionRequestId, LogRecordRegexSearchRequest request) {
        log.info("Search failed log records for ER '{}' by request: {}", (Object)executionRequestId, (Object)request);
        List<TestRun> allFailedTestRuns = this.getAllFailedTestRuns(executionRequestId);
        Set<UUID> allFailedTestRunIds = StreamUtils.extractIds(allFailedTestRuns);
        log.debug("Found failed test runs: {}", allFailedTestRunIds);
        List<LogRecord> allFailedLogRecords = this.testRunService.getAllFailedLogRecords(allFailedTestRunIds);
        log.debug("Found failed log records: {}", (Object)allFailedLogRecords.size());
        Pattern pattern = Pattern.compile(request.getRegex());
        List matchedLogRecords = allFailedLogRecords.stream().filter(logRecord -> !StringUtils.isEmpty((Object)logRecord.getMessage())).filter(logRecord -> pattern.matcher(logRecord.getMessage()).find()).sorted(Comparator.comparing(LogRecord::getMessage)).collect(Collectors.toList());
        log.debug("Matched log records: {}", StreamUtils.extractIds(matchedLogRecords));
        Integer page = request.getPage();
        Integer size = request.getSize();
        List resultLogRecords = matchedLogRecords;
        if (Objects.nonNull(page) && Objects.nonNull(size)) {
            resultLogRecords = ListUtils.applyPagination(matchedLogRecords, page, size, null);
        }
        Map<UUID, TestRun> testRunMap = StreamUtils.toIdEntityMap(allFailedTestRuns);
        List<TestCaseLabelResponse> testRunTestCases = this.testCaseService.getTestCaseLabelsByIds(allFailedTestRuns);
        Map<UUID, TestCaseLabelResponse> testCaseMap = StreamUtils.toIdEntityMap(testRunTestCases);
        List logRecords = resultLogRecords.stream().map(logRecord -> {
            TestRun testRun = (TestRun)testRunMap.get(logRecord.getTestRunId());
            TestCaseLabelResponse testCase = (TestCaseLabelResponse)testCaseMap.get(testRun.getTestCaseId());
            return new LogRecordRegexSearchResponse.LogRecordResponse(testRun, logRecord, testCase);
        }).collect(Collectors.toList());
        return new LogRecordRegexSearchResponse(logRecords, matchedLogRecords.size());
    }

    public Map<UUID, List<TestRun>> getMapTestRunsForExecutionRequests(List<UUID> executionRequests) {
        HashMap<UUID, List<TestRun>> resultMap = new HashMap<UUID, List<TestRun>>();
        executionRequests.forEach(uuid -> {
            List<TestRun> testRuns = this.testRunService.findAllByExecutionRequestId((UUID)uuid);
            resultMap.put((UUID)uuid, testRuns);
        });
        return resultMap;
    }

    public Map<UUID, List<TestRun>> getMapTestRunsWithScreenShotsForExecutionRequests(List<UUID> executionRequests) {
        LinkedHashMap<UUID, List<TestRun>> resultMap = new LinkedHashMap<UUID, List<TestRun>>();
        executionRequests.forEach(uuid -> {
            List<TestRun> testRuns = this.testRunService.findTestRunsWithScreenshotsByExecutionRequestId((UUID)uuid);
            resultMap.put((UUID)uuid, testRuns);
        });
        return resultMap;
    }

    public TestRunsByValidationLabelsResponse searchTestRunsByValidationLabels(UUID id, TestRunsByValidationLabelsRequest testRunsRequest, Integer page, Integer size) {
        List<TestRunWithValidationLabelsResponse> responses = this.testRunService.findTestRunsByNamesLabelsValidationLabels(id, testRunsRequest);
        Integer totalSize = responses.size();
        HashSet validationLabels = new HashSet();
        responses.forEach(testRunResponse -> validationLabels.addAll(testRunResponse.getValidationLabels()));
        if (Objects.nonNull(page) && Objects.nonNull(size)) {
            responses = ListUtils.applyPagination(responses, page, size);
        }
        return new TestRunsByValidationLabelsResponse(validationLabels, responses, totalSize);
    }

    public Set<UUID> getProjectIdsByExecutionRequestIds(List<UUID> uuids) {
        List<ExecutionRequest> executionRequests = this.repository.findAllByUuidIn(uuids);
        return executionRequests.stream().map(ExecutionRequest::getProjectId).collect(Collectors.toSet());
    }

    public Set<UUID> getProjectIdsByExecutionRequestIds(String uuids) {
        List<UUID> ids = Splitter.on((char)',').trimResults().splitToList((CharSequence)uuids).stream().map(UUID::fromString).collect(Collectors.toList());
        return this.getProjectIdsByExecutionRequestIds(ids);
    }

    public UUID getProjectIdByTestScopeId(UUID testScopeId) {
        Optional executionRequest = this.findByTestScopeUuid(testScopeId).stream().findAny();
        return executionRequest.map(ExecutionRequest::getProjectId).orElse(null);
    }

    public List<ExecutionRequest> findByTestScopeUuid(UUID testScopeUuid) {
        return this.repository.findAllByTestScopeId(testScopeUuid);
    }

    public Collection<RootCause> getFailureReasons(UUID executionRequestId) {
        log.info("Get failure reasons for execution request with id '{}'", (Object)executionRequestId);
        List<TestRun> testRuns = this.testRunService.findAllByExecutionRequestId(executionRequestId);
        Set<UUID> failureReasonIds = StreamUtils.extractIds(testRuns, TestRun::getRootCauseId);
        log.debug("Found failure reasons: {}", failureReasonIds);
        if (CollectionUtils.isEmpty(failureReasonIds)) {
            return Collections.emptyList();
        }
        return this.rootCauseService.getByIds(failureReasonIds);
    }

    public List<ExecutionRequest> findExpireExecutionRequest(Timestamp qwe, UUID projectId) {
        List<ExecutionRequest> expired = this.repository.findAllByArrivedBetweenAndProjectId(qwe, projectId);
        return expired;
    }

    public void deleteAllExecutionRequestByExecutionRequestId(List<UUID> executionRequestIds) {
        this.repository.deleteAllByUuidIn(executionRequestIds);
    }

    public ExecutionRequestService(ExecutionRequestRepository repository, CustomExecutionRequestRepository customRepository, LogRecordService logRecordService, TestRunService testRunService, TestCaseService testCaseService, RateCalculator rateCalculator, ProjectsService projectsService, UserService userService, ModelMapper modelMapper, ExecutionRequestConfigRepository configRepository, WidgetConfigTemplateService widgetConfigTemplateService, ExecutionRequestFilteringService filteringService, ExecutionRequestSortingService sortingService, JiraIntegrationService jiraIntegrationService, EnvironmentsInfoService environmentsInfoService, OrchestratorService orchestratorService, EnvironmentsService environmentsService, LabelsService labelsService, LockManager lockManager, RootCauseService rootCauseService) {
        this.repository = repository;
        this.customRepository = customRepository;
        this.logRecordService = logRecordService;
        this.testRunService = testRunService;
        this.testCaseService = testCaseService;
        this.rateCalculator = rateCalculator;
        this.projectsService = projectsService;
        this.userService = userService;
        this.modelMapper = modelMapper;
        this.configRepository = configRepository;
        this.widgetConfigTemplateService = widgetConfigTemplateService;
        this.filteringService = filteringService;
        this.sortingService = sortingService;
        this.jiraIntegrationService = jiraIntegrationService;
        this.environmentsInfoService = environmentsInfoService;
        this.orchestratorService = orchestratorService;
        this.environmentsService = environmentsService;
        this.labelsService = labelsService;
        this.lockManager = lockManager;
        this.rootCauseService = rootCauseService;
    }
}

