/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.qubership.atp.ram.model.ExtendedFileData;
import org.qubership.atp.ram.model.FileData;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.TestRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FileNamesService {
    private static final Logger log = LoggerFactory.getLogger(FileNamesService.class);
    private final ObjectMapper objectMapper;

    public void renameFilesInPlaceIfCollisionsOccurs(List<ExtendedFileData> files, Map<UUID, LogRecord> logRecordMap, Map<UUID, TestRun> testRunMap) {
        this.logInputParametersIfNecessary(files, logRecordMap, testRunMap);
        this.prependFileNamesWithTestCaseNameIfCollisionInFileNamesOccurs(files, logRecordMap, testRunMap);
        this.normalizeFilesNames(files);
        this.appendFileNamesWithIndexesIfNameCollisionOccurs(files);
    }

    public List<String> getFileNamesFromFilesList(List<ExtendedFileData> files) {
        return files.stream().map(file -> file.getFileData().getSource()).collect(Collectors.toList());
    }

    private void logInputParametersIfNecessary(List<ExtendedFileData> files, Map<UUID, LogRecord> logRecordMap, Map<UUID, TestRun> testRunMap) {
        if (log.isDebugEnabled()) {
            this.logInputParameters(files, logRecordMap, testRunMap);
        }
    }

    private void logInputParameters(List<ExtendedFileData> files, Map<UUID, LogRecord> logRecordMap, Map<UUID, TestRun> testRunMap) {
        try {
            List<String> fileNames = this.getFileNamesFromFilesList(files);
            log.debug("renameFilesInPlaceIfCollisionsOccurs files: '{}' logRecordMap: '{}', testRunMap: '{}'", new Object[]{this.objectMapper.writeValueAsString(logRecordMap), this.objectMapper.writeValueAsString(testRunMap), this.objectMapper.writeValueAsString(fileNames)});
        }
        catch (JsonProcessingException exception) {
            log.error(exception.getMessage());
        }
    }

    private void normalizeFilesNames(List<ExtendedFileData> potFiles) {
        for (ExtendedFileData potFile : potFiles) {
            FileData file = potFile.getFileData();
            file.setSource(this.normalizeName(file.getSource()));
        }
    }

    private String normalizeName(String name) {
        return name.replaceAll("[!@#^$&~%(*){}'\":;><`]", "").replace(" ", "_").replace("/", "_");
    }

    private void appendFileNamesWithIndexesIfNameCollisionOccurs(List<ExtendedFileData> potFiles) {
        HashMap<String, Integer> nameIndexerMap = new HashMap<String, Integer>();
        for (ExtendedFileData extendedFileData : potFiles) {
            FileData file = extendedFileData.getFileData();
            if (nameIndexerMap.containsKey(file.getSource())) {
                Integer index;
                Integer n = index = (Integer)nameIndexerMap.get(file.getSource());
                index = index + 1;
                nameIndexerMap.put(file.getSource(), index);
                this.appendFileNameWithIndex(file, index);
                continue;
            }
            nameIndexerMap.put(file.getSource(), 0);
        }
    }

    private void appendFileNameWithIndex(FileData file, Integer index) {
        file.setSource(FilenameUtils.getBaseName((String)file.getSource()) + "_" + index + "." + FilenameUtils.getExtension((String)file.getSource()));
    }

    private void prependFileNamesWithTestCaseNameIfCollisionInFileNamesOccurs(List<ExtendedFileData> potFiles, Map<UUID, LogRecord> logRecordMap, Map<UUID, TestRun> testRunMap) {
        Set<String> duplicateNames = this.findDuplicateNames(potFiles);
        for (ExtendedFileData extendedFileData : potFiles) {
            FileData file = extendedFileData.getFileData();
            if (!duplicateNames.contains(file.getSource())) continue;
            this.prependTestRunNameToFileSourceName(logRecordMap, testRunMap, extendedFileData);
        }
    }

    private void prependTestRunNameToFileSourceName(Map<UUID, LogRecord> logRecordMap, Map<UUID, TestRun> testRunMap, ExtendedFileData extendedFileData) {
        FileData fileData = extendedFileData.getFileData();
        String testRunName = testRunMap.get(logRecordMap.get(extendedFileData.getLogRecordId()).getTestRunId()).getName();
        fileData.setSource(testRunName + "_" + fileData.getSource());
    }

    private Set<String> findDuplicateNames(List<ExtendedFileData> potFiles) {
        HashSet<String> namesAlreadyMet = new HashSet<String>();
        HashSet<String> duplicateNames = new HashSet<String>();
        for (ExtendedFileData potFile : potFiles) {
            FileData file = potFile.getFileData();
            if (namesAlreadyMet.contains(file.getSource())) {
                duplicateNames.add(file.getSource());
            }
            namesAlreadyMet.add(file.getSource());
        }
        return duplicateNames;
    }

    public FileNamesService(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

