/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.Arrays;
import org.qubership.atp.ram.model.FileData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class FileResponseEntityService {
    private static final Logger log = LoggerFactory.getLogger(FileResponseEntityService.class);
    private static final String ATTACHMENT = "attachment";

    public ResponseEntity<Resource> buildOctetStreamResponseEntity(FileData fileData) {
        if (fileData == null) {
            return ResponseEntity.notFound().build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(this.getHeaders(fileData, MediaType.APPLICATION_OCTET_STREAM))).body((Object)new ByteArrayResource(fileData.getContent()));
    }

    private HttpHeaders getHeaders(FileData fileData, MediaType contentType) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(contentType);
        headers.setContentLength((long)fileData.getContent().length);
        headers.setAccessControlExposeHeaders(Arrays.asList("Content-Disposition"));
        headers.setContentDisposition(ContentDisposition.builder((String)ATTACHMENT).filename(fileData.getSource()).build());
        return headers;
    }
}

