/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.qubership.atp.ram.dto.response.ExecutionRequestWidgetConfigTemplateResponse;
import org.qubership.atp.ram.entities.treenodes.ExecutionRequestTreeNode;
import org.qubership.atp.ram.entities.treenodes.LabelTemplateTreeNode;
import org.qubership.atp.ram.entities.treenodes.LogRecordTreeNode;
import org.qubership.atp.ram.entities.treenodes.ScopeGroupTreeNode;
import org.qubership.atp.ram.entities.treenodes.TestRunTreeNode;
import org.qubership.atp.ram.entities.treenodes.TreeNode;
import org.qubership.atp.ram.entities.treenodes.TreeNodeType;
import org.qubership.atp.ram.entities.treenodes.labelparams.CountReportLabelParam;
import org.qubership.atp.ram.entities.treenodes.labelparams.ReportLabelParam;
import org.qubership.atp.ram.entities.treenodes.labelparams.TestingReportLabelParam;
import org.qubership.atp.ram.enums.ExecutionRequestWidgets;
import org.qubership.atp.ram.enums.TestScopeSections;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.model.LogRecordFilteringRequest;
import org.qubership.atp.ram.model.datacontext.TestRunsDataContext;
import org.qubership.atp.ram.model.datacontext.TestRunsDataContextLoadOptions;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.LabelTemplate;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.models.ValidationLabelConfigTemplate;
import org.qubership.atp.ram.models.WidgetConfigTemplate;
import org.qubership.atp.ram.models.logrecords.parts.ValidationTable;
import org.qubership.atp.ram.models.logrecords.parts.ValidationTableLine;
import org.qubership.atp.ram.models.tree.TreeWalker;
import org.qubership.atp.ram.services.ExecutionRequestService;
import org.qubership.atp.ram.services.LabelTemplateNodeService;
import org.qubership.atp.ram.services.LogRecordService;
import org.qubership.atp.ram.services.TestRunService;
import org.qubership.atp.ram.services.ValidationLabelConfigTemplateService;
import org.qubership.atp.ram.services.WidgetConfigTemplateService;
import org.qubership.atp.ram.utils.PercentUtils;
import org.qubership.atp.ram.utils.StreamUtils;
import org.qubership.atp.ram.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TreeNodeService {
    private static final Logger log = LoggerFactory.getLogger(TreeNodeService.class);
    public static final String ER_SUFFIX = "-[ER]";
    public static final String AR_SUFFIX = "-[AR]";
    private TestRunService testRunService;
    private ExecutionRequestService executionRequestService;
    private LogRecordService logRecordService;
    private LabelTemplateNodeService labelTemplateNodeService;
    private WidgetConfigTemplateService widgetConfigTemplateService;
    private ValidationLabelConfigTemplateService validationLabelConfigTemplateService;
    private ObjectMapper objectMapper;
    private BiFunction<TestingReportLabelParam, TestingReportLabelParam, TestingReportLabelParam> statusMergeFunc = (oldLabel, newLabel) -> {
        TestingStatuses oldStatus = oldLabel.getStatus();
        TestingStatuses newStatus = newLabel.getStatus();
        if (TestingStatuses.FAILED.equals((Object)newStatus) || TestingStatuses.FAILED.equals((Object)oldStatus)) {
            return TestingStatuses.FAILED.equals((Object)newStatus) ? newLabel : oldLabel;
        }
        return newLabel;
    };

    public TreeNodeService(@Lazy TestRunService testRunService, @Lazy ExecutionRequestService executionRequestService, LogRecordService logRecordService, @Lazy LabelTemplateNodeService labelTemplateNodeService, @Lazy WidgetConfigTemplateService widgetConfigTemplateService, @Lazy ValidationLabelConfigTemplateService validationLabelConfigTemplateService, @Lazy ObjectMapper objectMapper) {
        this.testRunService = testRunService;
        this.executionRequestService = executionRequestService;
        this.logRecordService = logRecordService;
        this.labelTemplateNodeService = labelTemplateNodeService;
        this.widgetConfigTemplateService = widgetConfigTemplateService;
        this.validationLabelConfigTemplateService = validationLabelConfigTemplateService;
        this.objectMapper = objectMapper;
    }

    public UUID getProjectIdByExecutionRequestId(UUID id) {
        return this.executionRequestService.getProjectIdByExecutionRequestId(id);
    }

    public UUID getProjectIdByTestRunId(UUID testRunId) {
        return this.testRunService.getProjectIdByTestRunId(testRunId);
    }

    public TreeNode getExecutionRequestTree(UUID executionRequestId, UUID labelTemplateId, boolean includeAll) {
        log.info("Get tree for execution request with id '{}'", (Object)executionRequestId);
        ExecutionRequest executionRequest = this.executionRequestService.findById(executionRequestId);
        if (Objects.nonNull(labelTemplateId)) {
            return this.getExecutionRequestTree(executionRequest, labelTemplateId, null, false, includeAll);
        }
        labelTemplateId = executionRequest.getLabelTemplateId();
        ExecutionRequestWidgetConfigTemplateResponse configResponse = this.widgetConfigTemplateService.getWidgetConfigTemplateForEr(executionRequest);
        WidgetConfigTemplate widgetConfigTemplate = configResponse.getTemplate();
        boolean defaultLabelTemplateChanged = configResponse.isDefaultLabelTemplateChanged();
        if (Objects.nonNull(widgetConfigTemplate) && (defaultLabelTemplateChanged || Objects.isNull(labelTemplateId))) {
            UUID summaryStatisticWidgetId = ExecutionRequestWidgets.SUMMARY_STATISTIC.getWidgetId();
            labelTemplateId = widgetConfigTemplate.getWidgetConfig(summaryStatisticWidgetId).getLabelTemplateId();
        }
        return this.getExecutionRequestTree(executionRequest, labelTemplateId, null, false, includeAll);
    }

    public TreeNode getExecutionRequestTree(ExecutionRequest executionRequest, UUID labelTemplateId, ValidationLabelConfigTemplate validationTemplate, boolean isWidget, boolean includeAll) {
        UUID executionRequestId = executionRequest.getUuid();
        UUID testScopeId = executionRequest.getTestScopeId();
        log.info("Get tree for execution request '{}' with label validation template '{}'", (Object)executionRequest, (Object)labelTemplateId);
        List<TestRun> testRuns = this.testRunService.findAllByExecutionRequestId(executionRequestId);
        TestRunsDataContextLoadOptions dataContextLoadOptions = new TestRunsDataContextLoadOptions().includeRunValidationLogRecordsMap(isWidget).includeRunTestCasesMap().includeTestRunMap();
        TestRunsDataContext dataContext = this.testRunService.getTestRunsDataContext(testRuns, dataContextLoadOptions, executionRequest.isVirtual());
        ExecutionRequestTreeNode erRootNode = new ExecutionRequestTreeNode(executionRequest);
        boolean isScopeRun = Objects.nonNull(testScopeId);
        log.debug("Scope run: {}", (Object)isScopeRun);
        LabelTemplate labelTemplate = null;
        if (Objects.nonNull(labelTemplateId)) {
            labelTemplate = this.labelTemplateNodeService.getLabelTemplate(labelTemplateId);
            erRootNode.setLabelTemplateData(labelTemplate);
            log.debug("Label validationTemplate set: {}", (Object)labelTemplate);
        }
        TreeNode resultTree = isScopeRun && !isWidget ? this.getExecutionRequestScopeTree(erRootNode, dataContext, labelTemplate, isWidget, includeAll) : this.getExecutionRequestTree(erRootNode, dataContext, labelTemplate, validationTemplate, isWidget, includeAll);
        this.removeEmptyNodes(resultTree);
        if (erRootNode.isExecutionRequestVirtual()) {
            this.setVirtualForEachChildInResultTree(resultTree);
        }
        return resultTree;
    }

    public TreeNode getExecutionRequestTree(UUID executionRequestId, boolean includeTestRuns, boolean includeLogRecords) {
        ExecutionRequest executionRequest = this.executionRequestService.findById(executionRequestId);
        ExecutionRequestTreeNode executionRequestRootNode = new ExecutionRequestTreeNode(executionRequest);
        if (includeTestRuns) {
            List<TestRun> topLevelTestRuns = this.testRunService.findAllByExecutionRequestId(executionRequestId);
            List topLevelTestRunNodes = topLevelTestRuns.stream().map(testRun -> this.getTestRunNode((TestRun)testRun, includeLogRecords, null)).sorted(Comparator.comparing(TreeNode::getName)).collect(Collectors.toList());
            executionRequestRootNode.setChildren(topLevelTestRunNodes);
        }
        if (executionRequestRootNode.isExecutionRequestVirtual()) {
            this.setVirtualForEachChildInResultTree((TreeNode)executionRequestRootNode);
        }
        return executionRequestRootNode;
    }

    private TreeNode getExecutionRequestTree(ExecutionRequestTreeNode erRootNode, TestRunsDataContext dataContext, LabelTemplate labelTemplate, ValidationLabelConfigTemplate template, boolean isWidget, boolean includeAll) {
        List<TreeNode> topLevelLabelTreeNodes;
        log.debug("Create and fill ER sub node, root node '{}', label template '{}'", (Object)erRootNode, (Object)labelTemplate);
        UUID executionRequestId = erRootNode.getExecutionRequestId();
        Map<UUID, TestRun> testRunsMap = dataContext.getTestRunsMap();
        List<TestRun> testRuns = new ArrayList<TestRun>(testRunsMap.values()).stream().sorted(Comparator.comparing(RamObject::getName)).collect(Collectors.toList());
        if (Objects.nonNull(labelTemplate)) {
            LabelTemplate filledLabelTemplate = this.labelTemplateNodeService.populateLabelTemplateWithTestRuns(testRuns, labelTemplate);
            List topLevelLabelNodes = filledLabelTemplate.getLabelNodes();
            topLevelLabelTreeNodes = this.getTreeNodes(topLevelLabelNodes, null, topLevelNode -> this.convertToTreeNode(executionRequestId, (LabelTemplate.LabelTemplateNode)topLevelNode, template, dataContext, isWidget, includeAll));
        } else {
            topLevelLabelTreeNodes = this.getTreeNodes(testRuns, null, includeAll ? testRun -> this.getTestRunNodeIncludeAllSteps((TestRun)testRun, dataContext) : testRun -> this.getTestRunNode((TestRun)testRun, false, null, dataContext));
        }
        erRootNode.getChildren().addAll(topLevelLabelTreeNodes);
        this.setValidationLabelsOrder(erRootNode, template);
        return erRootNode;
    }

    private void setVirtualForEachChildInResultTree(TreeNode rootNode) {
        if (CollectionUtils.isEmpty((Collection)rootNode.getChildren())) {
            return;
        }
        rootNode.getChildren().forEach(childNode -> {
            childNode.setExecutionRequestVirtual(true);
            this.setVirtualForEachChildInResultTree((TreeNode)childNode);
        });
    }

    public void removeEmptyNodes(TreeNode rootNode) {
        TreeWalker treeWalker = new TreeWalker();
        Predicate<TreeNode> isLabelOrScopeTreeNode = treeNode -> treeNode instanceof LabelTemplateTreeNode || treeNode instanceof ScopeGroupTreeNode;
        treeWalker.walkWithPostProcess((Object)rootNode, TreeNode::getChildren, (root, child) -> {
            if (Objects.nonNull(root) && isLabelOrScopeTreeNode.test((TreeNode)child)) {
                List rootChildren = root.getChildren();
                List nodesWithNonEmptyChildren = rootChildren.stream().filter(rootChild -> rootChild instanceof TestRunTreeNode || isLabelOrScopeTreeNode.test((TreeNode)rootChild) && !CollectionUtils.isEmpty((Collection)rootChild.getChildren())).collect(Collectors.toList());
                root.setChildren(nodesWithNonEmptyChildren);
            }
        });
    }

    private void setValidationLabelsOrder(ExecutionRequestTreeNode erRootNode, ValidationLabelConfigTemplate template) {
        List children = erRootNode.getChildren();
        Set<String> reportLabelParams = this.getReportLabelParams(children);
        erRootNode.setValidationLabelsOrder(this.orderValidationLabels(reportLabelParams, template));
    }

    public List<String> orderValidationLabels(Set<String> reportLabelParams, ValidationLabelConfigTemplate template) {
        ArrayList<String> resultParams = new ArrayList<String>();
        if (Objects.nonNull(template)) {
            Function<ValidationLabelConfigTemplate.LabelConfig, String> labelNameResolveFunc = labelConfig -> StringUtils.isEmpty((Object)labelConfig.getColumnName()) ? labelConfig.resolveColumnName() : labelConfig.getColumnName();
            TreeSet templateLabels = template.getLabels();
            Set nonDisplayedParams = templateLabels.stream().filter(labelConfig -> !labelConfig.isDisplayed()).map(labelConfig -> ((String)labelNameResolveFunc.apply((ValidationLabelConfigTemplate.LabelConfig)labelConfig)).toLowerCase()).collect(Collectors.toSet());
            List<String> displayedTemplateParams = templateLabels.stream().filter(ValidationLabelConfigTemplate.LabelConfig::isDisplayed).map(labelNameResolveFunc).collect(Collectors.toList());
            Set templateOverrides = templateLabels.stream().filter(labelConfig -> !CollectionUtils.isEmpty((Collection)labelConfig.getLabelNames()) && labelConfig.getLabelNames().size() == 1).map(labelConfig -> (String)labelConfig.getLabelNames().stream().findFirst().get()).collect(Collectors.toSet());
            List templateParamsDiff = reportLabelParams.stream().filter(label -> !templateOverrides.contains(label) && !displayedTemplateParams.contains(label) && !nonDisplayedParams.contains(label.toLowerCase())).sorted().collect(Collectors.toList());
            Set displayedParamsWithErAr = templateLabels.stream().filter(labelConfig -> labelConfig.isDisplayed() && labelConfig.isDisplayErAr()).map(labelNameResolveFunc).collect(Collectors.toSet());
            ArrayList templateParams = new ArrayList();
            displayedTemplateParams.forEach(label -> {
                templateParams.add(label);
                if (displayedParamsWithErAr.contains(label)) {
                    templateParams.add(label + ER_SUFFIX);
                    templateParams.add(label + AR_SUFFIX);
                }
            });
            log.debug("Add labels [{}], template labels [{}]", templateParamsDiff, displayedTemplateParams);
            resultParams.addAll(templateParamsDiff);
            resultParams.addAll(templateParams);
        } else {
            log.debug("Add labels [{}]", reportLabelParams);
            resultParams.addAll(reportLabelParams);
        }
        return resultParams;
    }

    private Set<String> getReportLabelParams(List<TreeNode> children) {
        Set<String> labelTemplateNodesLabelNames = children.stream().filter(node -> node.getClass().equals(LabelTemplateTreeNode.class)).map(node -> (LabelTemplateTreeNode)node).flatMap(node -> node.getReportLabelParams().stream()).map(ReportLabelParam::getName).collect(Collectors.toSet());
        return labelTemplateNodesLabelNames;
    }

    public List<TestRun> sortScopeGroupTestRuns(List<TestRun> scopeGroupTestRuns) {
        log.debug("Sort test group test runs [{}]", StreamUtils.extractIds(scopeGroupTestRuns));
        scopeGroupTestRuns.sort(Comparator.comparingInt(o -> o.getOrder()));
        log.debug("Sorted test runs: [{}]", StreamUtils.extractIds(scopeGroupTestRuns));
        return scopeGroupTestRuns;
    }

    private <T> List<TreeNode> getTreeNodes(List<T> testRuns, Comparator<TreeNode> order, Function<T, TreeNode> convertFunc) {
        Stream<TreeNode> stream = testRuns.stream().map(convertFunc);
        if (Objects.nonNull(order)) {
            stream = stream.sorted(order);
        }
        return stream.collect(Collectors.toList());
    }

    public TreeNode getExecutionRequestScopeTree(ExecutionRequestTreeNode executionRequestRootNode, TestRunsDataContext dataContext, LabelTemplate labelTemplate, boolean isWidget, boolean includeAll) {
        log.debug("Get execution request tree grouped by scope sections");
        UUID executionRequestId = executionRequestRootNode.getExecutionRequestId();
        Map<UUID, TestRun> testRunsMap = dataContext.getTestRunsMap();
        ArrayList<TestRun> testRuns = Objects.nonNull(labelTemplate) ? new ArrayList<TestRun>(testRunsMap.values()) : new ArrayList<TestRun>(testRunsMap.values()).stream().sorted(Comparator.comparing(RamObject::getName)).collect(Collectors.toList());
        List<ScopeGroupTreeNode> scopeGroupTreeNodes = Arrays.asList(new ScopeGroupTreeNode(executionRequestId, TestScopeSections.PREREQUISITES.getName(), () -> StreamUtils.filterByTestScopeSection(testRuns, TestRun::getTestScopeSection, TestScopeSections.PREREQUISITES)), new ScopeGroupTreeNode(executionRequestId, TestScopeSections.EXECUTION.getName(), () -> StreamUtils.filterByTestScopeSection(testRuns, TestRun::getTestScopeSection, TestScopeSections.EXECUTION)), new ScopeGroupTreeNode(executionRequestId, TestScopeSections.VALIDATION.getName(), () -> StreamUtils.filterByTestScopeSection(testRuns, TestRun::getTestScopeSection, TestScopeSections.VALIDATION)));
        log.debug("Created test scope grouping sections: {}", scopeGroupTreeNodes);
        scopeGroupTreeNodes.forEach(node -> {
            List<TestRun> scopeGroupTestRuns = (List<TestRun>)node.getTestRunsFilterFunc().get();
            List<Object> topLevelLabelTreeNodes = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)scopeGroupTestRuns)) {
                if (Objects.nonNull(labelTemplate)) {
                    LabelTemplate filledLabelTemplate = this.labelTemplateNodeService.populateLabelTemplateWithTestRuns(scopeGroupTestRuns, labelTemplate.clone());
                    executionRequestRootNode.setLabelTemplateData(labelTemplate);
                    List topLevelNodes = filledLabelTemplate.getLabelNodes();
                    topLevelLabelTreeNodes = this.getTreeNodes(topLevelNodes, null, topLevelNode -> this.convertToTreeNode(executionRequestId, (LabelTemplate.LabelTemplateNode)topLevelNode, null, dataContext, isWidget, includeAll));
                } else {
                    scopeGroupTestRuns = this.sortScopeGroupTestRuns(scopeGroupTestRuns);
                    topLevelLabelTreeNodes = this.getTreeNodes(scopeGroupTestRuns, null, includeAll ? testRun -> this.getTestRunNodeIncludeAllSteps((TestRun)testRun, dataContext) : testRun -> this.getTestRunNode((TestRun)testRun, false, null, dataContext));
                }
            }
            node.setChildren(topLevelLabelTreeNodes);
            executionRequestRootNode.getChildren().add(node);
        });
        return executionRequestRootNode;
    }

    public Set<TreeNode> getExecutionRequestTreeNodesByName(UUID executionRequestId, String searchValue) {
        log.info("Get tree nodes for executionRequestId='{}' and name like '{}'", (Object)executionRequestId, (Object)searchValue);
        HashSet<TreeNode> treeNodes = new HashSet<TreeNode>();
        List<TestRun> allTestRuns = this.testRunService.findAllByExecutionRequestId(executionRequestId);
        allTestRuns.stream().filter(testRun -> testRun.getName().toLowerCase().contains(searchValue.toLowerCase())).forEach(matchedTestRun -> treeNodes.add((TreeNode)new TestRunTreeNode(matchedTestRun)));
        allTestRuns.forEach(testRun -> treeNodes.addAll(this.getLogRecordNodesByName((TestRun)testRun, searchValue)));
        return treeNodes;
    }

    private LabelTemplateTreeNode convertToTreeNode(UUID executionRequestId, LabelTemplate.LabelTemplateNode labelTemplateNode, ValidationLabelConfigTemplate template, TestRunsDataContext dataContext, boolean isWidget, boolean includeAll) {
        LabelTemplateTreeNode labelTreeNode = new LabelTemplateTreeNode(labelTemplateNode, executionRequestId);
        Map<UUID, TestRun> testRunsMap = dataContext.getTestRunsMap();
        List labelTemplateNodeChildren = labelTemplateNode.getChildren();
        this.setLabelTemplateTreeNodeChildren(labelTreeNode, labelTemplateNodeChildren, childNode -> this.convertToTreeNode(executionRequestId, (LabelTemplate.LabelTemplateNode)childNode, template, dataContext, isWidget, includeAll));
        List testRunIds = labelTemplateNode.getTestRunIds().stream().distinct().filter(testRunsMap::containsKey).sorted(Comparator.comparing(key -> ((TestRun)testRunsMap.get(key)).getName())).collect(Collectors.toList());
        this.setLabelTemplateTreeNodeChildren(labelTreeNode, testRunIds, includeAll ? testRunId -> this.getTestRunNodeIncludeAllSteps((TestRun)testRunsMap.get(testRunId), dataContext) : testRunId -> this.getTestRunNode((TestRun)testRunsMap.get(testRunId), false, null, dataContext));
        log.debug("convertLabelTemplateNodeToTreeNode: will be calculate params {}", (Object)isWidget);
        if (isWidget) {
            this.calculateReportLabelParams(labelTreeNode, template, dataContext);
        }
        return labelTreeNode;
    }

    private void calculateReportLabelParams(LabelTemplateTreeNode labelTreeNode, ValidationLabelConfigTemplate template, TestRunsDataContext dataContext) {
        Map<String, CountReportLabelParam> nodeLabelParamMap = labelTreeNode.getReportLabelParams().stream().collect(Collectors.toMap(ReportLabelParam::getName, Function.identity()));
        List children = labelTreeNode.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            this.calculateTestRunNodesReportLabelParams(children, template, nodeLabelParamMap, dataContext);
            this.calculateLabelNodesReportLabelParams(children, nodeLabelParamMap);
            nodeLabelParamMap.values().forEach(param -> {
                int passed = param.getPassedCount();
                int nodeTestRunCount = labelTreeNode.getTestRunCount();
                int passAndFailCountSum = param.getPassedCount() + param.getFailedCount();
                int total = Objects.nonNull(template) && template.isUseTcCount() ? nodeTestRunCount : passAndFailCountSum;
                param.setTotalCount(total);
                if (total > 0) {
                    param.setPassed(PercentUtils.round((double)passed * 100.0 / (double)total));
                }
            });
        }
        labelTreeNode.setReportLabelParams(new ArrayList(nodeLabelParamMap.values()));
    }

    private void calculateTestRunNodesReportLabelParams(List<TreeNode> childrenLabelNodes, ValidationLabelConfigTemplate template, Map<String, CountReportLabelParam> parentLabelNodeParamsMap, TestRunsDataContext dataContext) {
        Map<UUID, List<LogRecord>> testRunLogRecordsMap = dataContext.getTestRunValidationLogRecordsMap();
        childrenLabelNodes.stream().filter(node -> TreeNodeType.TEST_RUN_NODE.equals((Object)node.getNodeType())).map(node -> (TestRunTreeNode)node).forEach(testRunTreeNode -> {
            UUID testRunId = testRunTreeNode.getTestRunId();
            List<TestingReportLabelParam> labelParamsMap = this.getTestRunValidationLabels(testRunId, template, testRunLogRecordsMap);
            labelParamsMap.forEach(labelParam -> {
                String paramName = labelParam.getName();
                TestingStatuses paramStatus = labelParam.getStatus();
                CountReportLabelParam countLabelParam = (CountReportLabelParam)parentLabelNodeParamsMap.get(paramName);
                if (Objects.isNull(countLabelParam)) {
                    countLabelParam = new CountReportLabelParam(paramName);
                    parentLabelNodeParamsMap.put(paramName, countLabelParam);
                }
                if (TestingStatuses.PASSED.equals((Object)paramStatus)) {
                    countLabelParam.incrPassed();
                } else {
                    countLabelParam.incrFailed();
                }
            });
        });
    }

    private void calculateLabelNodesReportLabelParams(List<TreeNode> childrenTestRunNodes, Map<String, CountReportLabelParam> parentNodeLabelParamMap) {
        childrenTestRunNodes.stream().filter(node -> TreeNodeType.LABEL_TEMPLATE_NODE.equals((Object)node.getNodeType())).map(node -> (LabelTemplateTreeNode)node).flatMap(node -> node.getReportLabelParams().stream()).forEach(reportLabelParam -> {
            String paramName = reportLabelParam.getName();
            CountReportLabelParam reportLabelParamData = (CountReportLabelParam)parentNodeLabelParamMap.get(paramName);
            if (Objects.isNull(reportLabelParamData)) {
                reportLabelParamData = new CountReportLabelParam(paramName);
                parentNodeLabelParamMap.put(paramName, reportLabelParamData);
            }
            int failedCount = reportLabelParam.getFailedCount();
            reportLabelParamData.setFailedCount(reportLabelParamData.getFailedCount() + failedCount);
            int passedCount = reportLabelParam.getPassedCount();
            reportLabelParamData.setPassedCount(reportLabelParamData.getPassedCount() + passedCount);
        });
    }

    public List<TestingReportLabelParam> getTestRunValidationLabels(UUID testRunId, ValidationLabelConfigTemplate template, Map<UUID, List<LogRecord>> testRunLogRecordsMap) {
        log.debug("Get validation labels map for test run '{}'", (Object)testRunId);
        List<LogRecord> logRecords = testRunLogRecordsMap.getOrDefault(testRunId, Collections.emptyList());
        HashMap validationLabelMap = new HashMap();
        logRecords.forEach(logRecord -> {
            List validationSteps;
            ValidationTable validationTable;
            Set logRecordValidationLabels = logRecord.getValidationLabels();
            if (!CollectionUtils.isEmpty((Collection)logRecordValidationLabels)) {
                TestingStatuses status = logRecord.getTestingStatus();
                logRecordValidationLabels.forEach(label -> validationLabelMap.merge(label, new TestingReportLabelParam(label, status), this.statusMergeFunc));
                if (Objects.nonNull(template)) {
                    this.processValidationLabelTemplate(validationLabelMap, logRecordValidationLabels, status, template);
                }
            }
            if (Objects.nonNull(validationTable = logRecord.getValidationTable()) && !CollectionUtils.isEmpty((Collection)(validationSteps = validationTable.getSteps()))) {
                validationSteps.forEach(step -> {
                    Set stepValidationLabels = step.getValidationLabels();
                    TestingStatuses status = step.getStatus();
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)stepValidationLabels)) {
                        stepValidationLabels.forEach(label -> {
                            TestingReportLabelParam newLabelParam = new TestingReportLabelParam(label, status);
                            validationLabelMap.merge(label, newLabelParam, this.statusMergeFunc);
                        });
                    }
                    if (Objects.nonNull(template)) {
                        this.processValidationLabelTemplate((LogRecord)logRecord, (ValidationTableLine)step, validationLabelMap, status, template);
                    }
                });
            }
        });
        ArrayList<TestingReportLabelParam> labelParams = new ArrayList<TestingReportLabelParam>(validationLabelMap.values());
        log.debug("Result label params: {}", labelParams);
        return labelParams;
    }

    private <T> void setLabelTemplateTreeNodeChildren(LabelTemplateTreeNode labelTreeNode, Collection<T> entities, Function<T, TreeNode> childrenMapFunc) {
        if (!CollectionUtils.isEmpty(entities)) {
            List children = entities.stream().map(childrenMapFunc).collect(Collectors.toList());
            labelTreeNode.getChildren().addAll(children);
        }
    }

    private TreeNode getTestRunNode(TestRun testRun, boolean includeLogRecords, LogRecordFilteringRequest filteringRequest) {
        return this.getTestRunNode(testRun, includeLogRecords, filteringRequest, null);
    }

    private TreeNode getTestRunNode(TestRun testRun, boolean includeLogRecords, LogRecordFilteringRequest filteringRequest, TestRunsDataContext dataContext) {
        UUID testRunId = testRun.getUuid();
        boolean isTestCaseAlive = this.isTestCaseAlive(dataContext, testRun);
        TestRunTreeNode testRunTreeNode = new TestRunTreeNode(testRun, isTestCaseAlive);
        if (includeLogRecords) {
            List<LogRecord> topLevelLogRecords = this.testRunService.getTopLevelLogRecords(testRunId, null);
            List topLevelLogRecordNodes = topLevelLogRecords.stream().map(logRecord -> this.getLogRecordNode((LogRecord)logRecord, testRun.getExecutionRequestId(), filteringRequest)).filter(node -> !node.isLeaf() || this.filterLogRecordNodeByRequest((LogRecordTreeNode)node, filteringRequest)).collect(Collectors.toList());
            testRunTreeNode.setChildren(topLevelLogRecordNodes);
        }
        return testRunTreeNode;
    }

    private TreeNode getTestRunNodeIncludeAllSteps(TestRun testRun, TestRunsDataContext dataContext) {
        boolean isTestCaseAlive = this.isTestCaseAlive(dataContext, testRun);
        TestRunTreeNode testRunTreeNode = new TestRunTreeNode(testRun, isTestCaseAlive);
        List<LogRecord> topLevelLogRecords = this.testRunService.getTopLevelLogRecords(testRun.getUuid(), null);
        Map<UUID, List<LogRecord>> childrenLogRecords = this.testRunService.getAllLogRecordsByTestRunId(testRun.getUuid()).stream().filter(lr -> Objects.nonNull(lr.getParentRecordId())).collect(Collectors.groupingBy(LogRecord::getParentRecordId));
        List topLevelLogRecordNodes = topLevelLogRecords.stream().map(logRecord -> this.getLogRecordNode((LogRecord)logRecord, childrenLogRecords, testRun.getExecutionRequestId())).collect(Collectors.toList());
        testRunTreeNode.setChildren(topLevelLogRecordNodes);
        return testRunTreeNode;
    }

    private boolean isTestCaseAlive(TestRunsDataContext dataContext, TestRun testRun) {
        return dataContext != null && dataContext.getTestRunTestCasesMap() != null && dataContext.getTestRunTestCasesMap().containsKey(testRun.getTestCaseId());
    }

    private LogRecordTreeNode getLogRecordNode(LogRecord logRecord, UUID executionRequestId, LogRecordFilteringRequest filteringRequest) {
        UUID logRecordId = logRecord.getUuid();
        LogRecordTreeNode logRecordTreeNode = new LogRecordTreeNode(logRecord, executionRequestId);
        if (this.isFiltersSet(filteringRequest)) {
            Stream<LogRecord> logRecordChildren = this.logRecordService.getLogRecordChildren(logRecordId);
            if (logRecordChildren != null) {
                List logRecordChildrenNodes = logRecordChildren.map(childLogRecord -> this.getLogRecordNode((LogRecord)childLogRecord, executionRequestId, filteringRequest)).filter(logRecordNode -> {
                    if (logRecordNode.isLeaf()) {
                        boolean flag = this.filterLogRecordNodeByRequest((LogRecordTreeNode)logRecordNode, filteringRequest);
                        log.trace("filtering log record: nodeId {} status {} type {} flag {} ", new Object[]{logRecordNode.getId(), logRecordNode.getTestingStatus(), logRecordNode.getActionType(), flag});
                        return flag;
                    }
                    return true;
                }).collect(Collectors.toList());
                logRecordTreeNode.setChildren(logRecordChildrenNodes);
                if (CollectionUtils.isEmpty(logRecordChildrenNodes)) {
                    logRecordTreeNode.setLeaf(true);
                }
            } else {
                logRecordTreeNode.setLeaf(true);
            }
        } else {
            long countOfChild = this.logRecordService.getChildrenCount(logRecord);
            logRecordTreeNode.setChildren(Collections.emptyList());
            if (countOfChild == 0L) {
                logRecordTreeNode.setLeaf(true);
                log.debug("LogRecord {} isLeaf", (Object)logRecordId);
            }
        }
        return logRecordTreeNode;
    }

    private LogRecordTreeNode getLogRecordNode(LogRecord logRecord, Map<UUID, List<LogRecord>> childrenLogRecords, UUID executionRequestId) {
        LogRecordTreeNode logRecordTreeNode = new LogRecordTreeNode(logRecord, executionRequestId);
        List<LogRecord> logRecordChildren = childrenLogRecords.get(logRecord.getUuid());
        if (!CollectionUtils.isEmpty(logRecordChildren)) {
            List logRecordChildrenNodes = logRecordChildren.stream().map(childLogRecord -> this.getLogRecordNode((LogRecord)childLogRecord, childrenLogRecords, executionRequestId)).collect(Collectors.toList());
            logRecordTreeNode.setChildren(logRecordChildrenNodes);
        } else {
            logRecordTreeNode.setLeaf(true);
        }
        return logRecordTreeNode;
    }

    private boolean isFiltersSet(LogRecordFilteringRequest filteringRequest) {
        return Objects.nonNull(filteringRequest) && (filteringRequest.isShowNotAnalyzedItemsOnly() || !CollectionUtils.isEmpty(filteringRequest.getStatuses()) || !CollectionUtils.isEmpty(filteringRequest.getTypes()));
    }

    private List<TreeNode> getLogRecordNodesByName(TestRun testRun, String searchValue) {
        Stream<LogRecord> matchedLogRecords = this.logRecordService.getAllMatchesLogRecordsByTestRunIdCaseInsensitive(testRun.getUuid(), searchValue);
        return matchedLogRecords.map(logRecord -> new LogRecordTreeNode(logRecord, testRun.getExecutionRequestId())).collect(Collectors.toList());
    }

    private boolean filterLogRecordNodeByRequest(LogRecordTreeNode logRecordNode, LogRecordFilteringRequest filteringRequest) {
        if (filteringRequest == null) {
            return true;
        }
        return !(filteringRequest.getStatuses() != null && !filteringRequest.getStatuses().stream().anyMatch(status -> status.compareToIgnoreCase(logRecordNode.getTestingStatus().name()) == 0) || filteringRequest.getTypes() != null && !filteringRequest.getTypes().stream().anyMatch(type -> type.compareToIgnoreCase(logRecordNode.getActionType().name()) == 0) || filteringRequest.isShowNotAnalyzedItemsOnly() && logRecordNode.isRootCauseAvailable());
    }

    public TreeNode getExecutionRequestTestRunLogRecordsTree(UUID testRunId, LogRecordFilteringRequest filteringRequest) {
        TestRun testRun = this.testRunService.getTestRunForNodeTree(testRunId);
        return this.getTestRunNode(testRun, true, filteringRequest);
    }

    public TreeNode getExecutionRequestTestRunTree(UUID executionRequestId) {
        return this.getExecutionRequestTree(executionRequestId, true, false);
    }

    public TreeNode getExecutionRequestWidgetTree(UUID executionRequestId, UUID widgetId, UUID labelTemplateId, UUID validationTemplateId, boolean skipOverride, boolean refresh) {
        ExecutionRequest executionRequest = this.executionRequestService.findById(executionRequestId);
        return this.getExecutionRequestWidgetTree(executionRequest, widgetId, labelTemplateId, validationTemplateId, skipOverride, refresh);
    }

    private TreeNode getExecutionRequestWidgetTree(ExecutionRequest executionRequest, UUID widgetId, UUID labelTemplateId, UUID validationTemplateId, boolean skipOverride, boolean refresh) {
        log.debug("Get execution request '{}' widget '{}' tree with label template '{}' and validation template '{}'", new Object[]{executionRequest.getUuid(), widgetId, labelTemplateId, validationTemplateId});
        ExecutionRequestWidgetConfigTemplateResponse confResponse = this.widgetConfigTemplateService.getWidgetConfigTemplateForEr(executionRequest);
        WidgetConfigTemplate widgetConfigTemplate = confResponse.getTemplate();
        ValidationLabelConfigTemplate validationTemplate = null;
        WidgetConfigTemplate.WidgetConfig widgetConfig = null;
        UUID widgetValidationTemplateId = null;
        if (Objects.nonNull(widgetConfigTemplate)) {
            log.debug("Found widget config template: {}", (Object)widgetConfigTemplate);
            widgetConfig = widgetConfigTemplate.getWidgetConfig(widgetId);
            widgetValidationTemplateId = widgetConfig.getValidationTemplateId();
        }
        UUID uUID = validationTemplateId = Objects.isNull(validationTemplateId) ? widgetValidationTemplateId : validationTemplateId;
        if (Objects.nonNull(validationTemplateId)) {
            validationTemplate = (ValidationLabelConfigTemplate)this.validationLabelConfigTemplateService.get(validationTemplateId);
            log.debug("Found validation template: {}", (Object)validationTemplate);
        }
        if (ExecutionRequestWidgets.SUMMARY_STATISTIC.getWidgetId().equals(widgetId) || ExecutionRequestWidgets.SUMMARY_STATISTIC_FOR_USAGES.getWidgetId().equals(widgetId) || ExecutionRequestWidgets.SUMMARY_STATISTIC_SCENARIO_TYPE.getWidgetId().equals(widgetId)) {
            UUID erLabelTemplateId = executionRequest.getLabelTemplateId();
            boolean defaultLabelTemplateChanged = confResponse.isDefaultLabelTemplateChanged();
            if (!skipOverride) {
                if (Objects.nonNull(erLabelTemplateId)) {
                    labelTemplateId = erLabelTemplateId;
                }
                if (defaultLabelTemplateChanged && Objects.nonNull(widgetConfig)) {
                    labelTemplateId = widgetConfig.getLabelTemplateId();
                }
            }
            return this.getExecutionRequestTree(executionRequest, labelTemplateId, validationTemplate, true, false);
        }
        if (Objects.isNull(labelTemplateId) && Objects.nonNull(widgetConfig)) {
            labelTemplateId = widgetConfig.getLabelTemplateId();
        }
        log.debug("Found label validationTemplate with id '{}' from widget config", (Object)labelTemplateId);
        return this.getExecutionRequestTree(executionRequest, labelTemplateId, validationTemplate, true, false);
    }

    @Caching(evict={@CacheEvict(value={"ATP_RAM-REPORTS"}, key="{#executionRequestId, #countLr, #widgetId}", condition="#refresh || #skipOverride", beforeInvocation=true)}, cacheable={@Cacheable(value={"ATP_RAM-REPORTS"}, key="{#executionRequestId, #countLr, #widgetId}")})
    public String getSerializableExecutionRequestWidgetTree(UUID executionRequestId, UUID widgetId, UUID labelTemplateId, UUID validationTemplateId, boolean skipOverride, String[] fields, Long countLr, boolean refresh) throws JsonProcessingException {
        ExecutionRequest executionRequest = this.executionRequestService.findById(executionRequestId);
        TreeNode treeNode = this.getExecutionRequestWidgetTree(executionRequest, widgetId, labelTemplateId, validationTemplateId, skipOverride, refresh);
        executionRequest.setCountLogRecords(countLr);
        this.executionRequestService.save(executionRequest);
        return Utils.filterAllExceptFields(treeNode, fields, this.objectMapper, "TreeNode Json Filter");
    }

    private void processValidationLabelTemplate(LogRecord logRecord, ValidationTableLine step, Map<String, TestingReportLabelParam> resultMap, TestingStatuses status, ValidationLabelConfigTemplate template) {
        TreeSet labels = template.getLabels();
        Set stepLabels = step.getValidationLabels();
        Set logRecordValidationLabels = logRecord.getValidationLabels();
        HashSet allLabels = new HashSet(org.apache.commons.collections.CollectionUtils.union((Collection)logRecordValidationLabels, (Collection)stepLabels));
        if (!CollectionUtils.isEmpty((Collection)labels)) {
            for (ValidationLabelConfigTemplate.LabelConfig labelConfig : labels) {
                TestingReportLabelParam param;
                boolean displayErAr;
                Set templateLabels = labelConfig.getLabelNames();
                String columnName = labelConfig.getColumnName();
                if (StringUtils.isEmpty((Object)columnName)) {
                    columnName = String.join((CharSequence)",", templateLabels);
                }
                boolean isContains = (displayErAr = labelConfig.isDisplayErAr()) ? allLabels.containsAll(templateLabels) : stepLabels.containsAll(templateLabels);
                TestingReportLabelParam testingReportLabelParam = param = displayErAr ? new TestingReportLabelParam(columnName, status, step) : new TestingReportLabelParam(columnName, status);
                if (!isContains) continue;
                resultMap.merge(columnName, param, this.statusMergeFunc);
            }
        }
    }

    private void processValidationLabelTemplate(Map<String, TestingReportLabelParam> resultMap, Set<String> validationLabels, TestingStatuses status, ValidationLabelConfigTemplate template) {
        log.debug("Process validation label template '{}' with input labels [{}] and status '{}'", new Object[]{template.getUuid(), validationLabels, status});
        TreeSet labels = template.getLabels();
        if (!CollectionUtils.isEmpty((Collection)labels)) {
            for (ValidationLabelConfigTemplate.LabelConfig labelConfig : labels) {
                Set templateLabels = labelConfig.getLabelNames();
                boolean isContains = validationLabels.containsAll(templateLabels);
                if (!isContains) continue;
                String columnName = labelConfig.getColumnName();
                if (StringUtils.isEmpty((Object)columnName)) {
                    columnName = String.join((CharSequence)",", templateLabels);
                }
                log.debug("Put validation template label: {} = {}", (Object)columnName, (Object)status);
                resultMap.merge(columnName, new TestingReportLabelParam(columnName, status), this.statusMergeFunc);
            }
        }
    }

    public TreeNode getLogRecordsTreeForLogRecordParent(UUID parentLogRecordId, LogRecordFilteringRequest filteringRequest) {
        LogRecord logRecordParent = this.logRecordService.findLogRecordForTreeByUuid(parentLogRecordId);
        UUID executionRequestId = this.testRunService.findTestRunExecReqIdByUuid(logRecordParent.getTestRunId()).getExecutionRequestId();
        LogRecordTreeNode logRecordTreeNode = new LogRecordTreeNode(logRecordParent, executionRequestId);
        List<LogRecord> childLogRecords = this.logRecordService.findByTestRunIdAndParentUuid(logRecordParent.getTestRunId(), parentLogRecordId, filteringRequest);
        List topLevelLogRecordNodes = childLogRecords.stream().map(logRecord -> this.getLogRecordNode((LogRecord)logRecord, executionRequestId, filteringRequest)).filter(node -> !node.isLeaf() || this.filterLogRecordNodeByRequest((LogRecordTreeNode)node, filteringRequest)).collect(Collectors.toList());
        logRecordTreeNode.setChildren(topLevelLogRecordNodes);
        return logRecordTreeNode;
    }
}

