/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpEntityNotFoundException;
import org.qubership.atp.ram.models.UserInfo;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.json.JsonParser;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class UserService {
    private static final Logger log = LoggerFactory.getLogger(UserService.class);
    private String issuer;
    @Value(value="${keycloak.auth-server-url}")
    private String baseUrl;
    @Value(value="${keycloak.realm}")
    private String realm;
    @Qualifier(value="m2mRestTemplate")
    private RestTemplate m2mRestTemplate;

    @Autowired
    public UserService(RestTemplate m2mRestTemplate) {
        this.m2mRestTemplate = m2mRestTemplate;
    }

    @PostConstruct
    public void init() {
        this.issuer = this.baseUrl + "/admin/realms/" + this.realm;
    }

    public UserInfo getUserInfoById(UUID userId) {
        String url = this.issuer + "/users/" + userId;
        UserInfo userInfo = null;
        try {
            userInfo = (UserInfo)this.m2mRestTemplate.getForObject(url, UserInfo.class, new Object[0]);
        }
        catch (RestClientException e) {
            return new UserInfo("-");
        }
        if (Objects.isNull(userInfo)) {
            log.error("Failed to find User Info by id: {}", (Object)userId);
            throw new AtpEntityNotFoundException("User Info", (Object)userId);
        }
        return userInfo;
    }

    public List<UserInfo> getUserByIds(Set<UUID> userIds) {
        String url = this.issuer + "/users";
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url).queryParam("max", new Object[]{Integer.MAX_VALUE});
        UserInfo[] infos = (UserInfo[])this.m2mRestTemplate.getForObject(builder.toUriString(), UserInfo[].class, new Object[0]);
        if (Objects.nonNull(infos)) {
            return StreamUtils.filterList(Arrays.asList(infos), UserInfo::getId, userIds);
        }
        return Collections.emptyList();
    }

    public UUID getUserIdFromToken(String token) {
        UUID userId = null;
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                token = token.split(" ")[1];
                JsonParser parser = JsonParserFactory.getJsonParser();
                Map tokenData = parser.parseMap(JwtHelper.decode((String)token).getClaims());
                userId = UUID.fromString(tokenData.get("sub").toString());
            }
            catch (Exception e) {
                log.warn("Cannot parse token with error: ", (Throwable)e);
            }
        }
        return userId;
    }

    public UserInfo getUserInfoFromToken(String token) {
        UUID userId = this.getUserIdFromToken(token);
        return this.getUserInfoById(userId);
    }
}

