/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.qubership.atp.ram.dto.request.ValidationLabelConfigTemplateSearchRequest;
import org.qubership.atp.ram.models.ValidationLabelConfigTemplate;
import org.qubership.atp.ram.models.WidgetConfigTemplate;
import org.qubership.atp.ram.repositories.ValidationLabelConfigTemplateRepository;
import org.qubership.atp.ram.services.CrudService;
import org.qubership.atp.ram.services.WidgetConfigTemplateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ValidationLabelConfigTemplateService
extends CrudService<ValidationLabelConfigTemplate> {
    private static final Logger log = LoggerFactory.getLogger(ValidationLabelConfigTemplateService.class);
    private final ValidationLabelConfigTemplateRepository repository;
    private final WidgetConfigTemplateService widgetConfigTemplateService;

    @Override
    protected MongoRepository<ValidationLabelConfigTemplate, UUID> repository() {
        return this.repository;
    }

    public List<ValidationLabelConfigTemplate> getAll(ValidationLabelConfigTemplateSearchRequest searchRequest) {
        log.info("Find all validation label config templates, filters: '{}'", (Object)searchRequest);
        String name = searchRequest.getName();
        UUID projectId = searchRequest.getProjectId();
        if (!StringUtils.isEmpty((Object)name) && Objects.nonNull(projectId)) {
            return this.repository.findAllByProjectIdAndNameContains(projectId, name);
        }
        if (!StringUtils.isEmpty((Object)name)) {
            return this.repository.findAllByNameContains(name);
        }
        if (Objects.nonNull(projectId)) {
            return this.repository.findAllByProjectId(projectId);
        }
        return this.getAll();
    }

    public ValidationLabelConfigTemplate create(ValidationLabelConfigTemplate template) {
        log.info("Create new validation label config template: {}", (Object)template);
        return this.save(template);
    }

    public void delete(UUID validationTemplateId) {
        log.info("Delete validation label config template '{}'", (Object)validationTemplateId);
        this.repository.deleteById(validationTemplateId);
        List<WidgetConfigTemplate> referencedWidgetConfigTemplates = this.widgetConfigTemplateService.getWidgetConfigTemplatesWithValidationTemplateId(validationTemplateId);
        referencedWidgetConfigTemplates.stream().flatMap(template -> template.getWidgets().stream().filter(widgetConfig -> Objects.nonNull(widgetConfig.getValidationTemplateId()))).filter(widgetConfig -> validationTemplateId.equals(widgetConfig.getValidationTemplateId())).forEach(widgetConfig -> widgetConfig.setValidationTemplateId(null));
        this.widgetConfigTemplateService.updateAll(referencedWidgetConfigTemplates);
    }

    public ValidationLabelConfigTemplate update(UUID id, ValidationLabelConfigTemplate updatedTemplate) {
        log.info("Update validation label config template '{}' with new content: {}", (Object)id, (Object)updatedTemplate);
        return this.save(updatedTemplate);
    }

    public UUID getProjectIdByConfigId(UUID id) {
        Optional configTemplate = this.repository.findById(id);
        return configTemplate.map(ValidationLabelConfigTemplate::getProjectId).orElse(null);
    }

    public ValidationLabelConfigTemplateService(ValidationLabelConfigTemplateRepository repository, WidgetConfigTemplateService widgetConfigTemplateService) {
        this.repository = repository;
        this.widgetConfigTemplateService = widgetConfigTemplateService;
    }
}

