/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services.filtering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.qubership.atp.ram.dto.response.FailPatternResponse;
import org.qubership.atp.ram.dto.response.IssueResponse;
import org.qubership.atp.ram.pojo.IssueFilteringParams;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.stereotype.Service;

@Service
public class IssuesFilteringService {
    public CriteriaDefinition buildSearchCriteria(IssueFilteringParams issueFilteringParams) {
        if (issueFilteringParams == null) {
            return new Criteria();
        }
        ArrayList<Criteria> filters = new ArrayList<Criteria>();
        if (issueFilteringParams.getExecutionRequestId() != null) {
            filters.add(Criteria.where((String)"executionRequestId").is((Object)issueFilteringParams.getExecutionRequestId()));
        }
        if (issueFilteringParams.getLogRecordIds() != null) {
            filters.add(Criteria.where((String)"logRecordIds").all((Collection)issueFilteringParams.getLogRecordIds()));
        }
        if (issueFilteringParams.getPriority() != null) {
            filters.add(Criteria.where((String)"priority").is((Object)issueFilteringParams.getPriority().name()));
        }
        return new Criteria().andOperator(filters.toArray(new Criteria[0]));
    }

    public List<IssueResponse> applyAdditionalFiltering(List<IssueResponse> responses, IssueFilteringParams issueFilteringParams) {
        if (issueFilteringParams == null) {
            return responses;
        }
        List<Predicate<IssueResponse>> filterPredicates = this.buildAllFilterPredicates(issueFilteringParams);
        return responses.stream().filter(item -> this.allPredicatesMatch(filterPredicates, (IssueResponse)item)).collect(Collectors.toList());
    }

    private List<Predicate<IssueResponse>> buildAllFilterPredicates(IssueFilteringParams issueFilteringParams) {
        ArrayList<Predicate<IssueResponse>> predicates = new ArrayList<Predicate<IssueResponse>>();
        if (issueFilteringParams.getFailedTestRun() != null) {
            predicates.add(this.failedTestRunPredicate(issueFilteringParams.getFailedTestRun()));
        }
        if (issueFilteringParams.getFailReason() != null) {
            predicates.add(this.failReasonPredicate(issueFilteringParams.getFailReason()));
        }
        if (issueFilteringParams.getJiraTicket() != null) {
            predicates.add(this.jiraTicketPredicate(issueFilteringParams.getJiraTicket()));
        }
        if (issueFilteringParams.getFailPattern() != null) {
            predicates.add(this.failPatternPredicate(issueFilteringParams.getFailPattern()));
        }
        if (issueFilteringParams.getMessage() != null) {
            predicates.add(this.failMessagePredicate(issueFilteringParams.getMessage()));
        }
        return predicates;
    }

    private Predicate<IssueResponse> failMessagePredicate(String message) {
        return item -> {
            String issueMessage = item.getMessage();
            Boolean validation = this.checkMessageNullValidations(message, issueMessage);
            if (validation != null) {
                return validation;
            }
            return issueMessage.toLowerCase().contains(message.toLowerCase());
        };
    }

    private Boolean checkMessageNullValidations(String message, String issueMessage) {
        if (issueMessage == null) {
            return message == null;
        }
        if (message == null) {
            return false;
        }
        return null;
    }

    private Predicate<IssueResponse> failPatternPredicate(String failPattern) {
        return item -> {
            FailPatternResponse failPatternResponse = item.getFailPattern();
            if (failPatternResponse == null || failPatternResponse.getName() == null) {
                return false;
            }
            return failPatternResponse.getName().toLowerCase().contains(failPattern.toLowerCase());
        };
    }

    private Predicate<IssueResponse> jiraTicketPredicate(String jiraTicket) {
        return item -> {
            if (CollectionUtils.isEmpty((Collection)item.getJiraTickets())) {
                return false;
            }
            return item.getJiraTickets().stream().anyMatch(ticketName -> ticketName != null && ticketName.toLowerCase().contains(jiraTicket.toLowerCase()));
        };
    }

    private Predicate<IssueResponse> failReasonPredicate(String failReason) {
        return item -> {
            if (item.getFailReason() == null || item.getFailReason().getName() == null) {
                return false;
            }
            return item.getFailReason().getName().toLowerCase().contains(failReason.toLowerCase());
        };
    }

    private Predicate<IssueResponse> failedTestRunPredicate(String failedTestRun) {
        return item -> {
            if (CollectionUtils.isEmpty((Collection)item.getTestRuns())) {
                return false;
            }
            return item.getTestRuns().stream().anyMatch(testRun -> failedTestRun.equals(testRun.getName()));
        };
    }

    private boolean allPredicatesMatch(List<Predicate<IssueResponse>> predicates, IssueResponse item) {
        return predicates.stream().allMatch(predicate -> predicate.test(item));
    }
}

