/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.utils;

import com.google.common.base.Strings;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.exceptions.internal.RamJsonObjectParseMissedFieldException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JsonHelper.class);

    private JsonHelper() {
    }

    public static String getStringValue(JsonObject jsonObject, String key, String defaultValue) {
        if (jsonObject.has(key) && !Strings.isNullOrEmpty((String)jsonObject.get(key).getAsString())) {
            return jsonObject.get(key).getAsString();
        }
        LOG.debug("JSON has not string value by key {}", (Object)key);
        return Strings.nullToEmpty((String)defaultValue);
    }

    public static String getStringValue(JsonObject jsonObject, String key) {
        if (jsonObject.has(key) && !Strings.isNullOrEmpty((String)jsonObject.get(key).getAsString())) {
            return jsonObject.get(key).getAsString();
        }
        LOG.debug("JSON has not string value by key {}", (Object)key);
        return "";
    }

    public static List<String> getListString(JsonObject jsonObject, String key, List<String> defaultValue) {
        if (jsonObject.has(key) && !Strings.isNullOrEmpty((String)jsonObject.get(key).getAsString())) {
            ArrayList<String> result = new ArrayList<String>();
            List<String> valuesFromString = Arrays.asList(jsonObject.get(key).getAsString().split(";"));
            if (!valuesFromString.isEmpty()) {
                valuesFromString.forEach(elem -> result.add(elem.trim()));
            }
            return result;
        }
        LOG.debug("JSON has not string value by key {}", (Object)key);
        return defaultValue;
    }

    public static Long getLongValue(JsonObject jsonObject, String key) throws Exception {
        if (jsonObject.has(key)) {
            return jsonObject.get(key).getAsLong();
        }
        LOG.error("Failed to find a specified field '{}' in the JSON object", (Object)key);
        throw new RamJsonObjectParseMissedFieldException();
    }

    public static ExecutionStatuses getExecutionStatus(JsonObject jsonObject, String key, ExecutionStatuses defaultStatus) {
        if (jsonObject.has(key)) {
            String status = jsonObject.get(key).getAsString();
            ExecutionStatuses res = ExecutionStatuses.findByValue((String)status);
            if (res != null) {
                return res;
            }
            LOG.debug("Execution status {} not exist", (Object)status);
        } else {
            LOG.debug("JSON has not string value by key {}", (Object)key);
        }
        return defaultStatus;
    }

    public static TestingStatuses getTestingStatus(JsonObject jsonObject, String key, TestingStatuses defaultStatus) {
        if (jsonObject.has(key)) {
            String status = jsonObject.get(key).getAsString();
            TestingStatuses res = TestingStatuses.findByValue((String)status);
            if (res != null) {
                return res;
            }
            LOG.debug("Testing status {} not exist", (Object)status);
        } else {
            LOG.debug("JSON has not string value by key {}", (Object)key);
        }
        return defaultStatus;
    }

    public static boolean getBooleanValue(JsonObject request, String key) {
        return request.has(key) && request.get(key).getAsBoolean();
    }

    public static HashSet<String> getHashSet(JsonObject jsonObject, String key, HashSet<String> defaultValue) {
        HashSet<String> newSet = new HashSet<String>();
        if (jsonObject.has(key) && !jsonObject.getAsJsonArray(key).isEmpty()) {
            JsonArray jsonArray = jsonObject.getAsJsonArray(key);
            jsonArray.forEach(jsonElement -> newSet.add(jsonElement.getAsString()));
        }
        if (defaultValue == null || defaultValue.isEmpty()) {
            return newSet;
        }
        defaultValue.addAll(newSet);
        return defaultValue;
    }

    public static UUID getUuidValue(JsonObject jsonObject, String key) {
        String value = JsonHelper.getStringValue(jsonObject, key);
        return Strings.isNullOrEmpty((String)value) ? null : UUID.fromString(value);
    }
}

