/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.utils;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    public static final String DEFAULT_DATE_TIME_PATTERN = "dd.MM.yyyy, HH:mm:ss";

    private TimeUtils() {
    }

    public static long getDuration(Timestamp startDate, Timestamp finishDate) {
        if (startDate == null) {
            startDate = new Timestamp(System.currentTimeMillis());
        }
        if (finishDate == null) {
            finishDate = new Timestamp(System.currentTimeMillis());
        }
        long duration = finishDate.getTime() - startDate.getTime();
        return TimeUnit.MILLISECONDS.toSeconds(duration);
    }

    public static String formatDateTime(Timestamp timestamp, String pattern) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return timestamp.toLocalDateTime().format(formatter);
    }

    public static String formatDateTime(Timestamp timestamp, String pattern, String timezone) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timezone));
        return simpleDateFormat.format(timestamp);
    }
}

