package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.qubership.atp.ram.clients.api.dto.catalogue.ProjectDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScenarioDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ProjectEntitiesDto
 */

@JsonTypeName("ProjectEntities")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-03T13:16:55.988142455Z[Etc/UTC]")
public class ProjectEntitiesDto {

  @JsonProperty("project")
  private ProjectDto project;

  @JsonProperty("testPlan")
  private TestPlanDto testPlan;

  @JsonProperty("testScenario")
  private TestScenarioDto testScenario;

  public ProjectEntitiesDto project(ProjectDto project) {
    this.project = project;
    return this;
  }

  /**
   * Get project
   * @return project
  */
  @Valid 
  @Schema(name = "project", required = false)
  public ProjectDto getProject() {
    return project;
  }

  public void setProject(ProjectDto project) {
    this.project = project;
  }

  public ProjectEntitiesDto testPlan(TestPlanDto testPlan) {
    this.testPlan = testPlan;
    return this;
  }

  /**
   * Get testPlan
   * @return testPlan
  */
  @Valid 
  @Schema(name = "testPlan", required = false)
  public TestPlanDto getTestPlan() {
    return testPlan;
  }

  public void setTestPlan(TestPlanDto testPlan) {
    this.testPlan = testPlan;
  }

  public ProjectEntitiesDto testScenario(TestScenarioDto testScenario) {
    this.testScenario = testScenario;
    return this;
  }

  /**
   * Get testScenario
   * @return testScenario
  */
  @Valid 
  @Schema(name = "testScenario", required = false)
  public TestScenarioDto getTestScenario() {
    return testScenario;
  }

  public void setTestScenario(TestScenarioDto testScenario) {
    this.testScenario = testScenario;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProjectEntitiesDto projectEntities = (ProjectEntitiesDto) o;
    return Objects.equals(this.project, projectEntities.project) &&
        Objects.equals(this.testPlan, projectEntities.testPlan) &&
        Objects.equals(this.testScenario, projectEntities.testScenario);
  }

  @Override
  public int hashCode() {
    return Objects.hash(project, testPlan, testScenario);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProjectEntitiesDto {\n");
    sb.append("    project: ").append(toIndentedString(project)).append("\n");
    sb.append("    testPlan: ").append(toIndentedString(testPlan)).append("\n");
    sb.append("    testScenario: ").append(toIndentedString(testScenario)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

