package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ResponseEntityDto
 */

@JsonTypeName("ResponseEntity")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-03T13:16:56.491719164Z[Etc/UTC]")
public class ResponseEntityDto {

  @JsonProperty("body")
  private Object body;

  /**
   * Gets or Sets statusCode
   */
  public enum StatusCodeEnum {
    ACCEPTED("ACCEPTED"),
    
    ALREADY_REPORTED("ALREADY_REPORTED"),
    
    BAD_GATEWAY("BAD_GATEWAY"),
    
    BAD_REQUEST("BAD_REQUEST"),
    
    BANDWIDTH_LIMIT_EXCEEDED("BANDWIDTH_LIMIT_EXCEEDED"),
    
    CHECKPOINT("CHECKPOINT"),
    
    CONFLICT("CONFLICT"),
    
    CONTINUE("CONTINUE"),
    
    CREATED("CREATED"),
    
    DESTINATION_LOCKED("DESTINATION_LOCKED"),
    
    EXPECTATION_FAILED("EXPECTATION_FAILED"),
    
    FAILED_DEPENDENCY("FAILED_DEPENDENCY"),
    
    FORBIDDEN("FORBIDDEN"),
    
    FOUND("FOUND"),
    
    GATEWAY_TIMEOUT("GATEWAY_TIMEOUT"),
    
    GONE("GONE"),
    
    HTTP_VERSION_NOT_SUPPORTED("HTTP_VERSION_NOT_SUPPORTED"),
    
    IM_USED("IM_USED"),
    
    INSUFFICIENT_SPACE_ON_RESOURCE("INSUFFICIENT_SPACE_ON_RESOURCE"),
    
    INSUFFICIENT_STORAGE("INSUFFICIENT_STORAGE"),
    
    INTERNAL_SERVER_ERROR("INTERNAL_SERVER_ERROR"),
    
    I_AM_A_TEAPOT("I_AM_A_TEAPOT"),
    
    LENGTH_REQUIRED("LENGTH_REQUIRED"),
    
    LOCKED("LOCKED"),
    
    LOOP_DETECTED("LOOP_DETECTED"),
    
    METHOD_FAILURE("METHOD_FAILURE"),
    
    METHOD_NOT_ALLOWED("METHOD_NOT_ALLOWED"),
    
    MOVED_PERMANENTLY("MOVED_PERMANENTLY"),
    
    MOVED_TEMPORARILY("MOVED_TEMPORARILY"),
    
    MULTIPLE_CHOICES("MULTIPLE_CHOICES"),
    
    MULTI_STATUS("MULTI_STATUS"),
    
    NETWORK_AUTHENTICATION_REQUIRED("NETWORK_AUTHENTICATION_REQUIRED"),
    
    NON_AUTHORITATIVE_INFORMATION("NON_AUTHORITATIVE_INFORMATION"),
    
    NOT_ACCEPTABLE("NOT_ACCEPTABLE"),
    
    NOT_EXTENDED("NOT_EXTENDED"),
    
    NOT_FOUND("NOT_FOUND"),
    
    NOT_IMPLEMENTED("NOT_IMPLEMENTED"),
    
    NOT_MODIFIED("NOT_MODIFIED"),
    
    NO_CONTENT("NO_CONTENT"),
    
    OK("OK"),
    
    PARTIAL_CONTENT("PARTIAL_CONTENT"),
    
    PAYLOAD_TOO_LARGE("PAYLOAD_TOO_LARGE"),
    
    PAYMENT_REQUIRED("PAYMENT_REQUIRED"),
    
    PERMANENT_REDIRECT("PERMANENT_REDIRECT"),
    
    PRECONDITION_FAILED("PRECONDITION_FAILED"),
    
    PRECONDITION_REQUIRED("PRECONDITION_REQUIRED"),
    
    PROCESSING("PROCESSING"),
    
    PROXY_AUTHENTICATION_REQUIRED("PROXY_AUTHENTICATION_REQUIRED"),
    
    REQUESTED_RANGE_NOT_SATISFIABLE("REQUESTED_RANGE_NOT_SATISFIABLE"),
    
    REQUEST_ENTITY_TOO_LARGE("REQUEST_ENTITY_TOO_LARGE"),
    
    REQUEST_HEADER_FIELDS_TOO_LARGE("REQUEST_HEADER_FIELDS_TOO_LARGE"),
    
    REQUEST_TIMEOUT("REQUEST_TIMEOUT"),
    
    REQUEST_URI_TOO_LONG("REQUEST_URI_TOO_LONG"),
    
    RESET_CONTENT("RESET_CONTENT"),
    
    SEE_OTHER("SEE_OTHER"),
    
    SERVICE_UNAVAILABLE("SERVICE_UNAVAILABLE"),
    
    SWITCHING_PROTOCOLS("SWITCHING_PROTOCOLS"),
    
    TEMPORARY_REDIRECT("TEMPORARY_REDIRECT"),
    
    TOO_EARLY("TOO_EARLY"),
    
    TOO_MANY_REQUESTS("TOO_MANY_REQUESTS"),
    
    UNAUTHORIZED("UNAUTHORIZED"),
    
    UNAVAILABLE_FOR_LEGAL_REASONS("UNAVAILABLE_FOR_LEGAL_REASONS"),
    
    UNPROCESSABLE_ENTITY("UNPROCESSABLE_ENTITY"),
    
    UNSUPPORTED_MEDIA_TYPE("UNSUPPORTED_MEDIA_TYPE"),
    
    UPGRADE_REQUIRED("UPGRADE_REQUIRED"),
    
    URI_TOO_LONG("URI_TOO_LONG"),
    
    USE_PROXY("USE_PROXY"),
    
    VARIANT_ALSO_NEGOTIATES("VARIANT_ALSO_NEGOTIATES");

    private String value;

    StatusCodeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusCodeEnum fromValue(String value) {
      for (StatusCodeEnum b : StatusCodeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("statusCode")
  private StatusCodeEnum statusCode;

  @JsonProperty("statusCodeValue")
  private Integer statusCodeValue;

  public ResponseEntityDto body(Object body) {
    this.body = body;
    return this;
  }

  /**
   * Get body
   * @return body
  */
  
  @Schema(name = "body", required = false)
  public Object getBody() {
    return body;
  }

  public void setBody(Object body) {
    this.body = body;
  }

  public ResponseEntityDto statusCode(StatusCodeEnum statusCode) {
    this.statusCode = statusCode;
    return this;
  }

  /**
   * Get statusCode
   * @return statusCode
  */
  
  @Schema(name = "statusCode", required = false)
  public StatusCodeEnum getStatusCode() {
    return statusCode;
  }

  public void setStatusCode(StatusCodeEnum statusCode) {
    this.statusCode = statusCode;
  }

  public ResponseEntityDto statusCodeValue(Integer statusCodeValue) {
    this.statusCodeValue = statusCodeValue;
    return this;
  }

  /**
   * Get statusCodeValue
   * @return statusCodeValue
  */
  
  @Schema(name = "statusCodeValue", required = false)
  public Integer getStatusCodeValue() {
    return statusCodeValue;
  }

  public void setStatusCodeValue(Integer statusCodeValue) {
    this.statusCodeValue = statusCodeValue;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ResponseEntityDto responseEntity = (ResponseEntityDto) o;
    return Objects.equals(this.body, responseEntity.body) &&
        Objects.equals(this.statusCode, responseEntity.statusCode) &&
        Objects.equals(this.statusCodeValue, responseEntity.statusCodeValue);
  }

  @Override
  public int hashCode() {
    return Objects.hash(body, statusCode, statusCodeValue);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ResponseEntityDto {\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    statusCode: ").append(toIndentedString(statusCode)).append("\n");
    sb.append("    statusCodeValue: ").append(toIndentedString(statusCodeValue)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

