package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraComponentDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestCaseLabelResponseDto
 */

@JsonTypeName("TestCaseLabelResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-03T13:16:56.491719164Z[Etc/UTC]")
public class TestCaseLabelResponseDto {

  @JsonProperty("description")
  private String description;

  @JsonProperty("jiraTicket")
  private String jiraTicket;

  @JsonProperty("components")
  @Valid
  private List<JiraComponentDto> components = null;

  @JsonProperty("labels")
  @Valid
  private Set<LabelDto> labels = null;

  @JsonProperty("name")
  private String name;

  @JsonProperty("projectId")
  private UUID projectId;

  @JsonProperty("scenarioId")
  private UUID scenarioId;

  @JsonProperty("testPlanId")
  private UUID testPlanId;

  @JsonProperty("uuid")
  private UUID uuid;

  public TestCaseLabelResponseDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public TestCaseLabelResponseDto jiraTicket(String jiraTicket) {
    this.jiraTicket = jiraTicket;
    return this;
  }

  /**
   * Get jiraTicket
   * @return jiraTicket
  */
  
  @Schema(name = "jiraTicket", required = false)
  public String getJiraTicket() {
    return jiraTicket;
  }

  public void setJiraTicket(String jiraTicket) {
    this.jiraTicket = jiraTicket;
  }

  public TestCaseLabelResponseDto components(List<JiraComponentDto> components) {
    this.components = components;
    return this;
  }

  public TestCaseLabelResponseDto addComponentsItem(JiraComponentDto componentsItem) {
    if (this.components == null) {
      this.components = new ArrayList<>();
    }
    this.components.add(componentsItem);
    return this;
  }

  /**
   * Get components
   * @return components
  */
  @Valid 
  @Schema(name = "components", required = false)
  public List<JiraComponentDto> getComponents() {
    return components;
  }

  public void setComponents(List<JiraComponentDto> components) {
    this.components = components;
  }

  public TestCaseLabelResponseDto labels(Set<LabelDto> labels) {
    this.labels = labels;
    return this;
  }

  public TestCaseLabelResponseDto addLabelsItem(LabelDto labelsItem) {
    if (this.labels == null) {
      this.labels = new LinkedHashSet<>();
    }
    this.labels.add(labelsItem);
    return this;
  }

  /**
   * Get labels
   * @return labels
  */
  @Valid 
  @Schema(name = "labels", required = false)
  public Set<LabelDto> getLabels() {
    return labels;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setLabels(Set<LabelDto> labels) {
    this.labels = labels;
  }

  public TestCaseLabelResponseDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public TestCaseLabelResponseDto projectId(UUID projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Get projectId
   * @return projectId
  */
  @Valid 
  @Schema(name = "projectId", required = false)
  public UUID getProjectId() {
    return projectId;
  }

  public void setProjectId(UUID projectId) {
    this.projectId = projectId;
  }

  public TestCaseLabelResponseDto scenarioId(UUID scenarioId) {
    this.scenarioId = scenarioId;
    return this;
  }

  /**
   * Get scenarioId
   * @return scenarioId
  */
  @Valid 
  @Schema(name = "scenarioId", required = false)
  public UUID getScenarioId() {
    return scenarioId;
  }

  public void setScenarioId(UUID scenarioId) {
    this.scenarioId = scenarioId;
  }

  public TestCaseLabelResponseDto testPlanId(UUID testPlanId) {
    this.testPlanId = testPlanId;
    return this;
  }

  /**
   * Get testPlanId
   * @return testPlanId
  */
  @Valid 
  @Schema(name = "testPlanId", required = false)
  public UUID getTestPlanId() {
    return testPlanId;
  }

  public void setTestPlanId(UUID testPlanId) {
    this.testPlanId = testPlanId;
  }

  public TestCaseLabelResponseDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestCaseLabelResponseDto testCaseLabelResponse = (TestCaseLabelResponseDto) o;
    return Objects.equals(this.description, testCaseLabelResponse.description) &&
        Objects.equals(this.jiraTicket, testCaseLabelResponse.jiraTicket) &&
        Objects.equals(this.components, testCaseLabelResponse.components) &&
        Objects.equals(this.labels, testCaseLabelResponse.labels) &&
        Objects.equals(this.name, testCaseLabelResponse.name) &&
        Objects.equals(this.projectId, testCaseLabelResponse.projectId) &&
        Objects.equals(this.scenarioId, testCaseLabelResponse.scenarioId) &&
        Objects.equals(this.testPlanId, testCaseLabelResponse.testPlanId) &&
        Objects.equals(this.uuid, testCaseLabelResponse.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(description, jiraTicket, components, labels, name, projectId, scenarioId, testPlanId, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestCaseLabelResponseDto {\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    jiraTicket: ").append(toIndentedString(jiraTicket)).append("\n");
    sb.append("    components: ").append(toIndentedString(components)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    scenarioId: ").append(toIndentedString(scenarioId)).append("\n");
    sb.append("    testPlanId: ").append(toIndentedString(testPlanId)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

