package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompoundCopyItemDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestCasesCopyRequestDto
 */

@JsonTypeName("TestCasesCopyRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-10-03T13:16:56.491719164Z[Etc/UTC]")
public class TestCasesCopyRequestDto {

  @JsonProperty("sourceTestPlanId")
  private UUID sourceTestPlanId;

  @JsonProperty("targetTestPlanId")
  private UUID targetTestPlanId;

  @JsonProperty("targetScenarioFolderId")
  private UUID targetScenarioFolderId;

  @JsonProperty("targetCaseFolderId")
  private UUID targetCaseFolderId;

  @JsonProperty("testCaseIds")
  @Valid
  private List<String> testCaseIds = null;

  @JsonProperty("testCaseFolderIds")
  @Valid
  private List<String> testCaseFolderIds = null;

  @JsonProperty("compounds")
  @Valid
  private List<CompoundCopyItemDto> compounds = null;

  @JsonProperty("copyCompounds")
  private Boolean copyCompounds;

  @JsonProperty("copyDatasets")
  private Boolean copyDatasets;

  @JsonProperty("setPostfix")
  private Boolean setPostfix;

  @JsonProperty("postfix")
  private String postfix;

  public TestCasesCopyRequestDto sourceTestPlanId(UUID sourceTestPlanId) {
    this.sourceTestPlanId = sourceTestPlanId;
    return this;
  }

  /**
   * Get sourceTestPlanId
   * @return sourceTestPlanId
  */
  @Valid 
  @Schema(name = "sourceTestPlanId", required = false)
  public UUID getSourceTestPlanId() {
    return sourceTestPlanId;
  }

  public void setSourceTestPlanId(UUID sourceTestPlanId) {
    this.sourceTestPlanId = sourceTestPlanId;
  }

  public TestCasesCopyRequestDto targetTestPlanId(UUID targetTestPlanId) {
    this.targetTestPlanId = targetTestPlanId;
    return this;
  }

  /**
   * Get targetTestPlanId
   * @return targetTestPlanId
  */
  @Valid 
  @Schema(name = "targetTestPlanId", required = false)
  public UUID getTargetTestPlanId() {
    return targetTestPlanId;
  }

  public void setTargetTestPlanId(UUID targetTestPlanId) {
    this.targetTestPlanId = targetTestPlanId;
  }

  public TestCasesCopyRequestDto targetScenarioFolderId(UUID targetScenarioFolderId) {
    this.targetScenarioFolderId = targetScenarioFolderId;
    return this;
  }

  /**
   * Get targetScenarioFolderId
   * @return targetScenarioFolderId
  */
  @Valid 
  @Schema(name = "targetScenarioFolderId", required = false)
  public UUID getTargetScenarioFolderId() {
    return targetScenarioFolderId;
  }

  public void setTargetScenarioFolderId(UUID targetScenarioFolderId) {
    this.targetScenarioFolderId = targetScenarioFolderId;
  }

  public TestCasesCopyRequestDto targetCaseFolderId(UUID targetCaseFolderId) {
    this.targetCaseFolderId = targetCaseFolderId;
    return this;
  }

  /**
   * Get targetCaseFolderId
   * @return targetCaseFolderId
  */
  @Valid 
  @Schema(name = "targetCaseFolderId", required = false)
  public UUID getTargetCaseFolderId() {
    return targetCaseFolderId;
  }

  public void setTargetCaseFolderId(UUID targetCaseFolderId) {
    this.targetCaseFolderId = targetCaseFolderId;
  }

  public TestCasesCopyRequestDto testCaseIds(List<String> testCaseIds) {
    this.testCaseIds = testCaseIds;
    return this;
  }

  public TestCasesCopyRequestDto addTestCaseIdsItem(String testCaseIdsItem) {
    if (this.testCaseIds == null) {
      this.testCaseIds = new ArrayList<>();
    }
    this.testCaseIds.add(testCaseIdsItem);
    return this;
  }

  /**
   * Get testCaseIds
   * @return testCaseIds
  */
  
  @Schema(name = "testCaseIds", required = false)
  public List<String> getTestCaseIds() {
    return testCaseIds;
  }

  public void setTestCaseIds(List<String> testCaseIds) {
    this.testCaseIds = testCaseIds;
  }

  public TestCasesCopyRequestDto testCaseFolderIds(List<String> testCaseFolderIds) {
    this.testCaseFolderIds = testCaseFolderIds;
    return this;
  }

  public TestCasesCopyRequestDto addTestCaseFolderIdsItem(String testCaseFolderIdsItem) {
    if (this.testCaseFolderIds == null) {
      this.testCaseFolderIds = new ArrayList<>();
    }
    this.testCaseFolderIds.add(testCaseFolderIdsItem);
    return this;
  }

  /**
   * Get testCaseFolderIds
   * @return testCaseFolderIds
  */
  
  @Schema(name = "testCaseFolderIds", required = false)
  public List<String> getTestCaseFolderIds() {
    return testCaseFolderIds;
  }

  public void setTestCaseFolderIds(List<String> testCaseFolderIds) {
    this.testCaseFolderIds = testCaseFolderIds;
  }

  public TestCasesCopyRequestDto compounds(List<CompoundCopyItemDto> compounds) {
    this.compounds = compounds;
    return this;
  }

  public TestCasesCopyRequestDto addCompoundsItem(CompoundCopyItemDto compoundsItem) {
    if (this.compounds == null) {
      this.compounds = new ArrayList<>();
    }
    this.compounds.add(compoundsItem);
    return this;
  }

  /**
   * Get compounds
   * @return compounds
  */
  @Valid 
  @Schema(name = "compounds", required = false)
  public List<CompoundCopyItemDto> getCompounds() {
    return compounds;
  }

  public void setCompounds(List<CompoundCopyItemDto> compounds) {
    this.compounds = compounds;
  }

  public TestCasesCopyRequestDto copyCompounds(Boolean copyCompounds) {
    this.copyCompounds = copyCompounds;
    return this;
  }

  /**
   * Get copyCompounds
   * @return copyCompounds
  */
  
  @Schema(name = "copyCompounds", required = false)
  public Boolean getCopyCompounds() {
    return copyCompounds;
  }

  public void setCopyCompounds(Boolean copyCompounds) {
    this.copyCompounds = copyCompounds;
  }

  public TestCasesCopyRequestDto copyDatasets(Boolean copyDatasets) {
    this.copyDatasets = copyDatasets;
    return this;
  }

  /**
   * Get copyDatasets
   * @return copyDatasets
  */
  
  @Schema(name = "copyDatasets", required = false)
  public Boolean getCopyDatasets() {
    return copyDatasets;
  }

  public void setCopyDatasets(Boolean copyDatasets) {
    this.copyDatasets = copyDatasets;
  }

  public TestCasesCopyRequestDto setPostfix(Boolean setPostfix) {
    this.setPostfix = setPostfix;
    return this;
  }

  /**
   * Get setPostfix
   * @return setPostfix
  */
  
  @Schema(name = "setPostfix", required = false)
  public Boolean getSetPostfix() {
    return setPostfix;
  }

  public void setSetPostfix(Boolean setPostfix) {
    this.setPostfix = setPostfix;
  }

  public TestCasesCopyRequestDto postfix(String postfix) {
    this.postfix = postfix;
    return this;
  }

  /**
   * Get postfix
   * @return postfix
  */
  
  @Schema(name = "postfix", required = false)
  public String getPostfix() {
    return postfix;
  }

  public void setPostfix(String postfix) {
    this.postfix = postfix;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestCasesCopyRequestDto testCasesCopyRequest = (TestCasesCopyRequestDto) o;
    return Objects.equals(this.sourceTestPlanId, testCasesCopyRequest.sourceTestPlanId) &&
        Objects.equals(this.targetTestPlanId, testCasesCopyRequest.targetTestPlanId) &&
        Objects.equals(this.targetScenarioFolderId, testCasesCopyRequest.targetScenarioFolderId) &&
        Objects.equals(this.targetCaseFolderId, testCasesCopyRequest.targetCaseFolderId) &&
        Objects.equals(this.testCaseIds, testCasesCopyRequest.testCaseIds) &&
        Objects.equals(this.testCaseFolderIds, testCasesCopyRequest.testCaseFolderIds) &&
        Objects.equals(this.compounds, testCasesCopyRequest.compounds) &&
        Objects.equals(this.copyCompounds, testCasesCopyRequest.copyCompounds) &&
        Objects.equals(this.copyDatasets, testCasesCopyRequest.copyDatasets) &&
        Objects.equals(this.setPostfix, testCasesCopyRequest.setPostfix) &&
        Objects.equals(this.postfix, testCasesCopyRequest.postfix);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceTestPlanId, targetTestPlanId, targetScenarioFolderId, targetCaseFolderId, testCaseIds, testCaseFolderIds, compounds, copyCompounds, copyDatasets, setPostfix, postfix);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestCasesCopyRequestDto {\n");
    sb.append("    sourceTestPlanId: ").append(toIndentedString(sourceTestPlanId)).append("\n");
    sb.append("    targetTestPlanId: ").append(toIndentedString(targetTestPlanId)).append("\n");
    sb.append("    targetScenarioFolderId: ").append(toIndentedString(targetScenarioFolderId)).append("\n");
    sb.append("    targetCaseFolderId: ").append(toIndentedString(targetCaseFolderId)).append("\n");
    sb.append("    testCaseIds: ").append(toIndentedString(testCaseIds)).append("\n");
    sb.append("    testCaseFolderIds: ").append(toIndentedString(testCaseFolderIds)).append("\n");
    sb.append("    compounds: ").append(toIndentedString(compounds)).append("\n");
    sb.append("    copyCompounds: ").append(toIndentedString(copyCompounds)).append("\n");
    sb.append("    copyDatasets: ").append(toIndentedString(copyDatasets)).append("\n");
    sb.append("    setPostfix: ").append(toIndentedString(setPostfix)).append("\n");
    sb.append("    postfix: ").append(toIndentedString(postfix)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

