/*
 * # Copyright 2024-2025 NetCracker Technology Corporation
 * #
 * # Licensed under the Apache License, Version 2.0 (the "License");
 * # you may not use this file except in compliance with the License.
 * # You may obtain a copy of the License at
 * #
 * #      http://www.apache.org/licenses/LICENSE-2.0
 * #
 * # Unless required by applicable law or agreed to in writing, software
 * # distributed under the License is distributed on an "AS IS" BASIS,
 * # WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * # See the License for the specific language governing permissions and
 * # limitations under the License.
 */

package org.qubership.atp.ram.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import org.qubership.atp.ram.models.ExecutionRequest;

import lombok.Data;

@Data
public class TestResult {

    private ExecutionRequest executionRequest;
    private List<String> qaHosts;
    private List<String> taHosts;

    public TestResult(ExecutionRequest executionRequest) {
        this.executionRequest = executionRequest;
    }

    public void setQaHosts(List<String> qaHosts) {
        this.qaHosts = Objects.isNull(qaHosts) ? new ArrayList<>() : qaHosts;
    }

    public void setTaHosts(List<String> taHosts) {
        this.taHosts = Objects.isNull(taHosts) ? new ArrayList<>() : taHosts;
    }
}
