/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api.dto.catalogue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraComponentDto;

@JsonTypeName(value="BugTrackingSystemSynchronization")
public class BugTrackingSystemSynchronizationDto {
    @JsonProperty(value="authorizationKey")
    private String authorizationKey;
    @JsonProperty(value="components")
    @Valid
    private List<JiraComponentDto> components = null;
    @JsonProperty(value="defaultTestCaseMapping")
    private DefaultTestCaseMappingEnum defaultTestCaseMapping;
    @JsonProperty(value="projectKey")
    private String projectKey;
    @JsonProperty(value="projectName")
    private String projectName;
    @JsonProperty(value="synchronizationType")
    private SynchronizationTypeEnum synchronizationType;
    @JsonProperty(value="systemType")
    private SystemTypeEnum systemType;
    @JsonProperty(value="systemUrl")
    private String systemUrl;

    public BugTrackingSystemSynchronizationDto authorizationKey(String authorizationKey) {
        this.authorizationKey = authorizationKey;
        return this;
    }

    @Schema(name="authorizationKey", required=false)
    public String getAuthorizationKey() {
        return this.authorizationKey;
    }

    public void setAuthorizationKey(String authorizationKey) {
        this.authorizationKey = authorizationKey;
    }

    public BugTrackingSystemSynchronizationDto components(List<JiraComponentDto> components) {
        this.components = components;
        return this;
    }

    public BugTrackingSystemSynchronizationDto addComponentsItem(JiraComponentDto componentsItem) {
        if (this.components == null) {
            this.components = new ArrayList<JiraComponentDto>();
        }
        this.components.add(componentsItem);
        return this;
    }

    @Valid
    @Schema(name="components", required=false)
    public List<JiraComponentDto> getComponents() {
        return this.components;
    }

    public void setComponents(List<JiraComponentDto> components) {
        this.components = components;
    }

    public BugTrackingSystemSynchronizationDto defaultTestCaseMapping(DefaultTestCaseMappingEnum defaultTestCaseMapping) {
        this.defaultTestCaseMapping = defaultTestCaseMapping;
        return this;
    }

    @Schema(name="defaultTestCaseMapping", required=false)
    public DefaultTestCaseMappingEnum getDefaultTestCaseMapping() {
        return this.defaultTestCaseMapping;
    }

    public void setDefaultTestCaseMapping(DefaultTestCaseMappingEnum defaultTestCaseMapping) {
        this.defaultTestCaseMapping = defaultTestCaseMapping;
    }

    public BugTrackingSystemSynchronizationDto projectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    @Schema(name="projectKey", required=false)
    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public BugTrackingSystemSynchronizationDto projectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    @Schema(name="projectName", required=false)
    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public BugTrackingSystemSynchronizationDto synchronizationType(SynchronizationTypeEnum synchronizationType) {
        this.synchronizationType = synchronizationType;
        return this;
    }

    @Schema(name="synchronizationType", required=false)
    public SynchronizationTypeEnum getSynchronizationType() {
        return this.synchronizationType;
    }

    public void setSynchronizationType(SynchronizationTypeEnum synchronizationType) {
        this.synchronizationType = synchronizationType;
    }

    public BugTrackingSystemSynchronizationDto systemType(SystemTypeEnum systemType) {
        this.systemType = systemType;
        return this;
    }

    @Schema(name="systemType", required=false)
    public SystemTypeEnum getSystemType() {
        return this.systemType;
    }

    public void setSystemType(SystemTypeEnum systemType) {
        this.systemType = systemType;
    }

    public BugTrackingSystemSynchronizationDto systemUrl(String systemUrl) {
        this.systemUrl = systemUrl;
        return this;
    }

    @Schema(name="systemUrl", required=false)
    public String getSystemUrl() {
        return this.systemUrl;
    }

    public void setSystemUrl(String systemUrl) {
        this.systemUrl = systemUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BugTrackingSystemSynchronizationDto bugTrackingSystemSynchronization = (BugTrackingSystemSynchronizationDto)o;
        return Objects.equals(this.authorizationKey, bugTrackingSystemSynchronization.authorizationKey) && Objects.equals(this.components, bugTrackingSystemSynchronization.components) && Objects.equals((Object)this.defaultTestCaseMapping, (Object)bugTrackingSystemSynchronization.defaultTestCaseMapping) && Objects.equals(this.projectKey, bugTrackingSystemSynchronization.projectKey) && Objects.equals(this.projectName, bugTrackingSystemSynchronization.projectName) && Objects.equals((Object)this.synchronizationType, (Object)bugTrackingSystemSynchronization.synchronizationType) && Objects.equals((Object)this.systemType, (Object)bugTrackingSystemSynchronization.systemType) && Objects.equals(this.systemUrl, bugTrackingSystemSynchronization.systemUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorizationKey, this.components, this.defaultTestCaseMapping, this.projectKey, this.projectName, this.synchronizationType, this.systemType, this.systemUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BugTrackingSystemSynchronizationDto {\n");
        sb.append("    authorizationKey: ").append(this.toIndentedString(this.authorizationKey)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("    defaultTestCaseMapping: ").append(this.toIndentedString((Object)this.defaultTestCaseMapping)).append("\n");
        sb.append("    projectKey: ").append(this.toIndentedString(this.projectKey)).append("\n");
        sb.append("    projectName: ").append(this.toIndentedString(this.projectName)).append("\n");
        sb.append("    synchronizationType: ").append(this.toIndentedString((Object)this.synchronizationType)).append("\n");
        sb.append("    systemType: ").append(this.toIndentedString((Object)this.systemType)).append("\n");
        sb.append("    systemUrl: ").append(this.toIndentedString(this.systemUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DefaultTestCaseMappingEnum {
        E2E("E2E"),
        TEST_CASE("TEST_CASE");

        private String value;

        private DefaultTestCaseMappingEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DefaultTestCaseMappingEnum fromValue(String value) {
            for (DefaultTestCaseMappingEnum b : DefaultTestCaseMappingEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SynchronizationTypeEnum {
        AUTOMATIC("AUTOMATIC"),
        MANUAL("MANUAL");

        private String value;

        private SynchronizationTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SynchronizationTypeEnum fromValue(String value) {
            for (SynchronizationTypeEnum b : SynchronizationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum SystemTypeEnum {
        JIRA("JIRA"),
        INTERNAL_JIRA("INTERNAL_JIRA");

        private String value;

        private SystemTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SystemTypeEnum fromValue(String value) {
            for (SystemTypeEnum b : SystemTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

