/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ram.client.CatalogueExecuteRequestFeignClient;
import org.qubership.atp.ram.client.CatalogueIntegrationFeignClient;
import org.qubership.atp.ram.client.CatalogueIssueFeignClient;
import org.qubership.atp.ram.client.CatalogueLabelFeignClient;
import org.qubership.atp.ram.client.CatalogueLabelTemplateFeignClient;
import org.qubership.atp.ram.client.CatalogueProjectFeignClient;
import org.qubership.atp.ram.client.CatalogueTestCaseFeignClient;
import org.qubership.atp.ram.client.CatalogueTestPlanFeignClient;
import org.qubership.atp.ram.client.CatalogueTestScenarioFeignClient;
import org.qubership.atp.ram.client.CatalogueTestScopeFeignClient;
import org.qubership.atp.ram.clients.api.dto.catalogue.CaseSearchRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueCreateRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueSearchRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueSearchResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.RerunRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseLastStatusDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestRunToJiraInfoDto;
import org.qubership.atp.ram.converter.DtoConvertService;
import org.qubership.atp.ram.dto.response.ProjectDataResponse;
import org.qubership.atp.ram.dto.response.TestCaseLabelResponse;
import org.qubership.atp.ram.model.CaseSearchRequest;
import org.qubership.atp.ram.model.CheckSumResponse;
import org.qubership.atp.ram.model.TestRunToJiraInfo;
import org.qubership.atp.ram.model.jira.JiraIssueCreateRequest;
import org.qubership.atp.ram.model.jira.JiraIssueCreateResponse;
import org.qubership.atp.ram.model.jira.JiraIssueResponse;
import org.qubership.atp.ram.models.Issue;
import org.qubership.atp.ram.models.JiraComponent;
import org.qubership.atp.ram.models.Label;
import org.qubership.atp.ram.models.LabelTemplate;
import org.qubership.atp.ram.models.Scope;
import org.qubership.atp.ram.models.TestCase;
import org.qubership.atp.ram.models.TestCaseLastStatus;
import org.qubership.atp.ram.models.TestPlan;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CatalogueService {
    private static final Logger log = LoggerFactory.getLogger(CatalogueService.class);
    private final CatalogueTestScopeFeignClient catalogueTestScopeFeignClient;
    private final CatalogueProjectFeignClient catalogueProjectFeignClient;
    private final CatalogueIntegrationFeignClient catalogueIntegrationFeignClient;
    private final CatalogueTestPlanFeignClient catalogueTestPlanFeignClient;
    private final CatalogueTestCaseFeignClient catalogueTestCaseFeignClient;
    private final CatalogueTestScenarioFeignClient catalogueTestScenarioFeignClient;
    private final CatalogueLabelTemplateFeignClient catalogueLabelTemplateFeignClient;
    private final CatalogueLabelFeignClient catalogueLabelFeignClient;
    private final CatalogueIssueFeignClient catalogueIssueFeignClient;
    private final CatalogueExecuteRequestFeignClient catalogueExecuteRequestFeignClient;
    private final DtoConvertService dtoConvertService;

    public void autoSyncTestRunsWithJira(UUID projectId, UUID executionRequestId, boolean syncTestCases, boolean syncTestRuns, List<TestRunToJiraInfo> testRunToJiraInfos) {
        if (Objects.isNull(executionRequestId)) {
            log.warn("Sync with jira is impossible - execution request id is null");
            return;
        }
        if (!syncTestCases && !syncTestRuns) {
            log.info("Sync with jira not needed - sync test cases and test runs disabled");
            return;
        }
        this.catalogueIntegrationFeignClient.autoSyncTestRunsWithJira(projectId, executionRequestId, syncTestCases, syncTestRuns, this.dtoConvertService.convertList(testRunToJiraInfos, TestRunToJiraInfoDto.class));
    }

    public void updateCaseStatuses(List<TestRun> listTestRun) {
        List testCaseLastStatuses = listTestRun.stream().filter(testRun -> testRun.getTestCaseId() != null).map(testRun -> {
            TestCaseLastStatus status = new TestCaseLastStatus();
            status.setStatus(testRun.getTestingStatus().getName());
            status.setTestCaseId(testRun.getTestCaseId());
            return status;
        }).collect(Collectors.toList());
        if (!testCaseLastStatuses.isEmpty()) {
            this.catalogueTestCaseFeignClient.updateCaseStatuses(this.dtoConvertService.convertList(testCaseLastStatuses, TestCaseLastStatusDto.class));
        }
    }

    public UUID getScenarioIdByTestCaseId(UUID testCaseId) {
        if (Objects.isNull(testCaseId)) {
            return null;
        }
        return (UUID)this.catalogueTestCaseFeignClient.getScenarioIdByTestCaseId(testCaseId).getBody();
    }

    public CheckSumResponse checkHashSumForScenario(Map<UUID, String> hashSums) {
        if (Objects.isNull(hashSums)) {
            return null;
        }
        HashMap<String, String> hashSumsConverted = new HashMap<String, String>();
        for (Map.Entry<UUID, String> entry : hashSums.entrySet()) {
            hashSumsConverted.put(entry.getKey().toString(), entry.getValue());
        }
        return this.dtoConvertService.convert(this.catalogueTestScenarioFeignClient.checkHashSum(hashSumsConverted).getBody(), CheckSumResponse.class);
    }

    public ProjectDataResponse getProjectData(UUID projectId) {
        if (Objects.isNull(projectId)) {
            return null;
        }
        return this.dtoConvertService.convert(this.catalogueProjectFeignClient.getProjectById(projectId).getBody(), ProjectDataResponse.class);
    }

    public List<TestCaseLabelResponse> getTestCaseLabelsByIds(List<TestRun> testRuns) {
        if (Objects.isNull(testRuns)) {
            log.error("List of Test Runs is null.");
            return new ArrayList<TestCaseLabelResponse>();
        }
        Set<UUID> testCaseIds = StreamUtils.extractIds(testRuns, TestRun::getTestCaseId);
        log.debug("Found test runs test case references: {}", testCaseIds);
        if (testCaseIds.isEmpty()) {
            return new ArrayList<TestCaseLabelResponse>();
        }
        return this.dtoConvertService.convertList((List)this.catalogueTestCaseFeignClient.getCaseLabels(testCaseIds).getBody(), TestCaseLabelResponse.class);
    }

    public LabelTemplate getLabelTemplateById(UUID labelTemplateId) {
        if (Objects.isNull(labelTemplateId)) {
            return null;
        }
        return this.dtoConvertService.convert(this.catalogueLabelTemplateFeignClient.get(labelTemplateId).getBody(), LabelTemplate.class);
    }

    public void deleteLabelTemplateById(UUID labelTemplateId) {
        if (!Objects.isNull(labelTemplateId)) {
            this.catalogueLabelTemplateFeignClient.delete(labelTemplateId);
        }
    }

    public List<Issue> getIssues(List<UUID> issueIds) {
        if (Objects.isNull(issueIds)) {
            return null;
        }
        return this.dtoConvertService.convertList((List)this.catalogueIssueFeignClient.getByIds(issueIds).getBody(), Issue.class);
    }

    public TestPlan getTestPlan(UUID testPlanId) {
        if (Objects.isNull(testPlanId)) {
            return null;
        }
        return this.dtoConvertService.convert(this.catalogueTestPlanFeignClient.getTestPlanByUuid(testPlanId).getBody(), TestPlan.class);
    }

    public Scope getTestScope(UUID testScopeId) {
        if (Objects.isNull(testScopeId)) {
            return null;
        }
        return this.dtoConvertService.convert(this.catalogueTestScopeFeignClient.getTestScopeByUuid(testScopeId).getBody(), Scope.class);
    }

    public List<TestCase> getTestCases(CaseSearchRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        CaseSearchRequestDto caseSearchRequestDto = this.dtoConvertService.convert(request, CaseSearchRequestDto.class);
        return this.dtoConvertService.convertList((List)this.catalogueTestCaseFeignClient.getTestCasesByIds(caseSearchRequestDto).getBody(), TestCase.class);
    }

    public TestCase getTestCaseById(UUID testCaseId) {
        if (Objects.isNull(testCaseId)) {
            return null;
        }
        return this.dtoConvertService.convert(this.catalogueTestCaseFeignClient.getTestCaseWithLabelsByUuid(testCaseId).getBody(), TestCase.class);
    }

    public List<Label> getLabelsByIds(Set<UUID> labelIds) {
        if (Objects.isNull(labelIds)) {
            return null;
        }
        return this.dtoConvertService.convertList((List)this.catalogueLabelFeignClient.getLabelsByIds(labelIds).getBody(), Label.class);
    }

    public JiraIssueCreateResponse createJiraTicket(UUID testPlanId, JiraIssueCreateRequest request) {
        if (Objects.isNull(testPlanId)) {
            return null;
        }
        if (Objects.isNull(request)) {
            return null;
        }
        JiraIssueCreateRequestDto jiraIssueCreateRequestDto = this.dtoConvertService.convert(request, JiraIssueCreateRequestDto.class);
        return this.dtoConvertService.convert(this.catalogueIntegrationFeignClient.createJiraTicket(testPlanId, jiraIssueCreateRequestDto).getBody(), JiraIssueCreateResponse.class);
    }

    public JiraIssueResponse getJiraTicket(UUID testPlanId, String key) {
        if (Objects.isNull(testPlanId)) {
            return null;
        }
        if (Objects.isNull(key)) {
            return null;
        }
        return this.dtoConvertService.convert(this.catalogueIntegrationFeignClient.getJiraTicketByKey(testPlanId, key).getBody(), JiraIssueResponse.class);
    }

    public List<JiraComponent> getTestPlanJiraComponents(UUID testPlanId) {
        if (Objects.isNull(testPlanId)) {
            return null;
        }
        return this.dtoConvertService.convertList((List)this.catalogueIntegrationFeignClient.getTestPlanJiraComponents(testPlanId).getBody(), JiraComponent.class);
    }

    public UUID rerunExecutionRequest(RerunRequestDto rerunRequestDto) {
        return (UUID)this.catalogueExecuteRequestFeignClient.rerun(null, rerunRequestDto).getBody();
    }

    public List<JiraIssueDto> searchIssues(UUID testPlanId, Set<String> keys, Set<String> fields) {
        JiraIssueSearchRequestDto request = new JiraIssueSearchRequestDto();
        request.setTestPlanId(testPlanId);
        request.setFields(new ArrayList<String>(fields));
        request.setKeys(new ArrayList<String>(keys));
        JiraIssueSearchResponseDto response = (JiraIssueSearchResponseDto)this.catalogueIntegrationFeignClient.searchIssues(request).getBody();
        return Objects.nonNull(response) ? response.getIssues() : new ArrayList<JiraIssueDto>();
    }

    public CatalogueService(CatalogueTestScopeFeignClient catalogueTestScopeFeignClient, CatalogueProjectFeignClient catalogueProjectFeignClient, CatalogueIntegrationFeignClient catalogueIntegrationFeignClient, CatalogueTestPlanFeignClient catalogueTestPlanFeignClient, CatalogueTestCaseFeignClient catalogueTestCaseFeignClient, CatalogueTestScenarioFeignClient catalogueTestScenarioFeignClient, CatalogueLabelTemplateFeignClient catalogueLabelTemplateFeignClient, CatalogueLabelFeignClient catalogueLabelFeignClient, CatalogueIssueFeignClient catalogueIssueFeignClient, CatalogueExecuteRequestFeignClient catalogueExecuteRequestFeignClient, DtoConvertService dtoConvertService) {
        this.catalogueTestScopeFeignClient = catalogueTestScopeFeignClient;
        this.catalogueProjectFeignClient = catalogueProjectFeignClient;
        this.catalogueIntegrationFeignClient = catalogueIntegrationFeignClient;
        this.catalogueTestPlanFeignClient = catalogueTestPlanFeignClient;
        this.catalogueTestCaseFeignClient = catalogueTestCaseFeignClient;
        this.catalogueTestScenarioFeignClient = catalogueTestScenarioFeignClient;
        this.catalogueLabelTemplateFeignClient = catalogueLabelTemplateFeignClient;
        this.catalogueLabelFeignClient = catalogueLabelFeignClient;
        this.catalogueIssueFeignClient = catalogueIssueFeignClient;
        this.catalogueExecuteRequestFeignClient = catalogueExecuteRequestFeignClient;
        this.dtoConvertService = dtoConvertService;
    }
}

