/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ram.exceptions.potfiles.RamPotFilesArchiveDataCreationException;
import org.qubership.atp.ram.model.ArchiveData;
import org.qubership.atp.ram.model.ExtendedFileData;
import org.qubership.atp.ram.model.LogRecordWithParentResponse;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.PotsStatisticsPerAction;
import org.qubership.atp.ram.models.PotsStatisticsPerTestCase;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.models.logrecords.parts.FileMetadata;
import org.qubership.atp.ram.models.logrecords.parts.FileType;
import org.qubership.atp.ram.repositories.CustomLogRecordRepository;
import org.qubership.atp.ram.repositories.LogRecordRepository;
import org.qubership.atp.ram.repositories.TestRunRepository;
import org.qubership.atp.ram.services.ArchiveService;
import org.qubership.atp.ram.services.FileNamesService;
import org.qubership.atp.ram.services.GridFsService;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;

@Service
public class PotService {
    private static final Logger log = LoggerFactory.getLogger(PotService.class);
    private final LogRecordRepository logRecordRepository;
    private final TestRunRepository testRunRepository;
    private final GridFsService gridFsService;
    private final ArchiveService archiveService;
    private final FileNamesService fileNamesService;
    private final ObjectMapper objectMapper;
    private final CustomLogRecordRepository customLogRecordRepository;

    public List<PotsStatisticsPerTestCase> collectStatisticForExecutionRequest(UUID executionRequestId) {
        log.info("PotService request collectStatisticForExecutionRequest with id '{}'", (Object)executionRequestId);
        List<TestRun> testRuns = this.testRunRepository.findTestRunsByExecutionRequestAndHasLogRecordsWithFile(executionRequestId, FileType.POT);
        return testRuns.stream().map(this::buildPotStatisticPerTestCase).collect(Collectors.toList());
    }

    Map<UUID, List<LogRecord>> collectTrIdsToListOfReportRecordsMap(List<LogRecord> logRecords) {
        return logRecords.stream().collect(Collectors.groupingBy(LogRecord::getTestRunId));
    }

    void logPotsRecordsIfNecessary(Map<UUID, List<LogRecord>> testRunIdsToPotsLogRecordsMap) {
        if (log.isDebugEnabled()) {
            try {
                log.debug("testRunIdsToPotsLogRecordsMap: {}", (Object)this.objectMapper.writeValueAsString(testRunIdsToPotsLogRecordsMap));
            }
            catch (JsonProcessingException e) {
                log.error("Unable to write testRunIdsToPotsLogRecordsMap json: ", (Throwable)e);
            }
        }
    }

    PotsStatisticsPerTestCase buildPotStatisticPerTestCase(TestRun testRun) {
        return new PotsStatisticsPerTestCase(testRun.getTestingStatus(), testRun.getName(), testRun.getUuid());
    }

    PotsStatisticsPerAction buildPotStatisticPerAction(LogRecord logRecordPot, LogRecord parentLogRecord) {
        return new PotsStatisticsPerAction(parentLogRecord.getName(), parentLogRecord.getTestingStatus(), logRecordPot.getFileMetadata().stream().filter(file -> FileType.POT.equals((Object)file.getType())).findFirst().orElse(new FileMetadata()).getFileName(), logRecordPot.getUuid().toString());
    }

    LogRecord findParentSectionRecord(LogRecord logRecord, Map<UUID, LogRecord> logRecordMap) {
        LogRecord iterator = logRecord;
        while (!iterator.isSection()) {
            iterator = logRecordMap.get(iterator.getParentRecordId());
        }
        return iterator;
    }

    boolean recordHasPotFileMetadata(LogRecord logRecord) {
        return logRecord.getFileMetadata() != null && logRecord.getFileMetadata().stream().anyMatch(file -> FileType.POT.equals((Object)file.getType()));
    }

    public ArchiveData getArchiveWithPotsFiles(UUID executionRequestId) {
        byte[] archiveContent;
        String archiveName;
        List<TestRun> testRuns = this.testRunRepository.findTestRunsIdNameByExecutionRequestId(executionRequestId);
        List<UUID> testRunsIds = StreamUtils.extractIdsToList(testRuns);
        List<LogRecord> logRecords = this.logRecordRepository.findLogRecordsForArchivePotFileByTestRunIdIn(testRunsIds, FileType.POT);
        Map<UUID, List<LogRecord>> trIdToListOfPotRecordsMap = this.collectTrIdsToListOfReportRecordsMap(logRecords);
        List<LogRecord> potRecords = trIdToListOfPotRecordsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Map<UUID, TestRun> testRunMap = StreamUtils.toIdEntityMap(testRuns);
        Map<UUID, LogRecord> logRecordMap = StreamUtils.toIdEntityMap(logRecords);
        List<ExtendedFileData> files = this.gridFsService.downloadFilesByLogRecords(potRecords);
        this.fileNamesService.renameFilesInPlaceIfCollisionsOccurs(files, logRecordMap, testRunMap);
        try {
            File archive = this.archiveService.writeFileDataToArchive(files, executionRequestId);
            archiveName = archive.getName();
            archiveContent = FileCopyUtils.copyToByteArray((File)archive);
            Files.delete(Paths.get(archive.getAbsolutePath(), new String[0]));
        }
        catch (IOException exception) {
            log.error("Failed to create POT files archive data", (Throwable)exception);
            throw new RamPotFilesArchiveDataCreationException();
        }
        return new ArchiveData(archiveContent, archiveName);
    }

    public List<PotsStatisticsPerAction> collectStatisticForTestRun(UUID testRunId) {
        List<LogRecordWithParentResponse> parentChildLogRecords = this.customLogRecordRepository.getTopLogRecordsIdAndChildLogRecordsByFileTypeFilterLookup(testRunId, FileType.POT);
        ArrayList<PotsStatisticsPerAction> potsStatisticsPerActions = new ArrayList<PotsStatisticsPerAction>();
        parentChildLogRecords.forEach(logRecordLookupResponse -> potsStatisticsPerActions.add(this.buildPotStatisticPerAction(logRecordLookupResponse.getFileLogRecord(), logRecordLookupResponse.getParent())));
        return potsStatisticsPerActions;
    }

    public PotService(LogRecordRepository logRecordRepository, TestRunRepository testRunRepository, GridFsService gridFsService, ArchiveService archiveService, FileNamesService fileNamesService, ObjectMapper objectMapper, CustomLogRecordRepository customLogRecordRepository) {
        this.logRecordRepository = logRecordRepository;
        this.testRunRepository = testRunRepository;
        this.gridFsService = gridFsService;
        this.archiveService = archiveService;
        this.fileNamesService = fileNamesService;
        this.objectMapper = objectMapper;
        this.customLogRecordRepository = customLogRecordRepository;
    }
}

