/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.opencsv.CSVWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.qubership.atp.ram.RamConstants;
import org.qubership.atp.ram.dto.response.LabelNodeReportResponse;
import org.qubership.atp.ram.enums.ExecutionRequestWidgets;
import org.qubership.atp.ram.model.TestCaseWidgetCsvExportLine;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.TestCaseWidgetReportRequest;
import org.qubership.atp.ram.services.ExecutionRequestService;
import org.qubership.atp.ram.services.ReportService;
import org.qubership.atp.ram.services.WidgetConfigTemplateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReportExportService {
    private static final Logger log = LoggerFactory.getLogger(ReportExportService.class);
    private final ReportService reportService;
    private final ExecutionRequestService executionRequestService;
    private final WidgetConfigTemplateService widgetConfigTemplateService;
    private static final String TEST_CASES_CSV_FILE_NAME_SUFFIX = "Test_Cases.";
    private static final String CSV_EXT = ".csv";
    private static final String UNDERSCORE = "_";
    private static final String SPACE = " ";
    private static final String ATTACHMENT_HEADER_NAME = "attachment; filename=\"%s\"";
    private static final char CSV_EXPORT_SEPARATOR = '|';

    public void exportTestCasesWidgetIntoCsv(UUID executionRequestId, UUID labelTemplateId, UUID validationTemplateId, boolean isExecutionRequestsSummary, HttpServletResponse response, TestCaseWidgetReportRequest request) {
        LabelNodeReportResponse nodes = this.reportService.getTestCasesForExecutionRequest(executionRequestId, labelTemplateId, validationTemplateId, isExecutionRequestsSummary, request);
        UUID widgetId = ExecutionRequestWidgets.TEST_CASES.getWidgetId();
        Map<String, Boolean> columnVisibilityMap = this.widgetConfigTemplateService.getWidgetColumnVisibilityMap(executionRequestId, widgetId);
        ExecutionRequest executionRequest = (ExecutionRequest)this.executionRequestService.get(executionRequestId);
        String executionRequestName = executionRequest.getName().replaceAll(SPACE, UNDERSCORE);
        String fileName = TEST_CASES_CSV_FILE_NAME_SUFFIX + executionRequestName + CSV_EXT;
        response.setHeader("Content-Disposition", String.format(ATTACHMENT_HEADER_NAME, fileName));
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        try (CSVWriter writer = new CSVWriter((Writer)response.getWriter(), '|', '\u0000', '\"', "\n");){
            List validationLabels = nodes.getValidationLabelsOrder();
            this.setHeaders(writer, validationLabels, columnVisibilityMap);
            AtomicInteger depth = new AtomicInteger(0);
            List children = nodes.getChildren();
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                children.forEach(node -> this.printLabelNode((LabelNodeReportResponse)node, writer, validationLabels, columnVisibilityMap, depth));
            } else {
                List testRunNodes = nodes.getTestRuns();
                if (CollectionUtils.isNotEmpty((Collection)testRunNodes)) {
                    testRunNodes.forEach(testRunNode -> this.printTestRunNode((LabelNodeReportResponse.TestRunNodeResponse)testRunNode, writer, validationLabels, depth, columnVisibilityMap));
                }
            }
            response.flushBuffer();
        }
        catch (Exception e) {
            log.error("Failed to export csv file for Test Case widget for ER with id '{}'", (Object)executionRequestId);
        }
    }

    private void setHeaders(CSVWriter writer, List<String> validationLabels, Map<String, Boolean> columnVisibilityMap) {
        ArrayList<String> headerLine = new ArrayList<String>();
        RamConstants.DEFAULT_COLUMN_NAMES.forEach(columnName -> {
            if (this.isColumnVisible((String)columnName, columnVisibilityMap)) {
                headerLine.add((String)columnName);
            }
        });
        headerLine.addAll(validationLabels);
        writer.writeNext(headerLine.toArray(new String[0]));
    }

    private boolean isColumnVisible(String columnName, Map<String, Boolean> columnVisibilityMap) {
        return columnVisibilityMap.getOrDefault(columnName, true);
    }

    public void printLabelNode(LabelNodeReportResponse node, CSVWriter writer, List<String> validationLabels, Map<String, Boolean> columnVisibilityMap, AtomicInteger depth) {
        List testRunNodes;
        TestCaseWidgetCsvExportLine line = new TestCaseWidgetCsvExportLine(node, validationLabels, columnVisibilityMap, depth.get());
        writer.writeNext(line.getContent());
        List childrenLabelNodes = node.getChildren();
        int nextDepthValue = depth.incrementAndGet();
        AtomicInteger nextLevelDepth = new AtomicInteger(nextDepthValue);
        if (CollectionUtils.isNotEmpty((Collection)childrenLabelNodes)) {
            childrenLabelNodes.forEach(childLabelNode -> this.printLabelNode((LabelNodeReportResponse)childLabelNode, writer, validationLabels, columnVisibilityMap, nextLevelDepth));
        }
        if (CollectionUtils.isNotEmpty((Collection)(testRunNodes = node.getTestRuns()))) {
            testRunNodes.forEach(testRunNode -> this.printTestRunNode((LabelNodeReportResponse.TestRunNodeResponse)testRunNode, writer, validationLabels, depth, columnVisibilityMap));
        }
    }

    public void printTestRunNode(LabelNodeReportResponse.TestRunNodeResponse node, CSVWriter writer, List<String> validationLabels, AtomicInteger depth, Map<String, Boolean> columnVisibilityMap) {
        TestCaseWidgetCsvExportLine line = new TestCaseWidgetCsvExportLine(node, validationLabels, columnVisibilityMap, depth.get());
        writer.writeNext(line.getContent());
    }

    public ReportExportService(ReportService reportService, ExecutionRequestService executionRequestService, WidgetConfigTemplateService widgetConfigTemplateService) {
        this.reportService = reportService;
        this.executionRequestService = executionRequestService;
        this.widgetConfigTemplateService = widgetConfigTemplateService;
    }
}

