/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.auth.springbootstarter.utils.ExceptionUtils;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.ram.clients.api.dto.catalogue.RerunRequestDto;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.exceptions.testruns.RamTestRunsRerunNotAppropriateStatusException;
import org.qubership.atp.ram.mdc.MdcField;
import org.qubership.atp.ram.model.request.RerunRequest;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.services.CatalogueService;
import org.qubership.atp.ram.services.ExecutionRequestDetailsService;
import org.qubership.atp.ram.services.ExecutionRequestService;
import org.qubership.atp.ram.services.OrchestratorService;
import org.qubership.atp.ram.services.TestRunService;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RerunService {
    private static final Logger log = LoggerFactory.getLogger(RerunService.class);
    private final ExecutionRequestService executionRequestService;
    private final ExecutionRequestDetailsService executionRequestDetailsService;
    private final TestRunService testRunService;
    private final OrchestratorService orchestratorService;
    private final CatalogueService catalogueService;

    public List<UUID> getRequestsForRerun(List<UUID> executionRequestsIds) {
        return executionRequestsIds.stream().filter(executionRequestsId -> ExecutionStatuses.TERMINATED.equals((Object)this.executionRequestService.findById((UUID)executionRequestsId).getExecutionStatus()) || ExecutionStatuses.TERMINATED_BY_TIMEOUT.equals((Object)this.executionRequestService.findById((UUID)executionRequestsId).getExecutionStatus()) || ExecutionStatuses.FINISHED.equals((Object)this.executionRequestService.findById((UUID)executionRequestsId).getExecutionStatus())).collect(Collectors.toList());
    }

    public List<UUID> rerunExecutionRequests(List<UUID> uuidList) {
        List<UUID> requestsForRerun = this.getRequestsForRerun(uuidList);
        ArrayList<UUID> newExecutionRequests = new ArrayList<UUID>();
        requestsForRerun.forEach(erId -> {
            List<UUID> testRunIds = this.testRunService.findTestRunsUuidByExecutionRequestId((UUID)erId);
            if (!CollectionUtils.isEmpty(testRunIds)) {
                log.debug("rerunExecutionRequests: start rerun ER {}, TR ids [{}]", erId, testRunIds);
                newExecutionRequests.add(this.rerunTestRuns(testRunIds));
            }
        });
        UUID erId2 = (UUID)newExecutionRequests.get(0);
        MdcUtils.put((String)MdcField.EXECUTION_REQUEST_ID.toString(), (UUID)erId2);
        UUID projectId = this.executionRequestService.getProjectIdByExecutionRequestId(uuidList.get(0));
        String msg = "ER has been restarted.\nTestRuns were formed by ram for rerun.\nSource ER link: " + this.executionRequestService.generateErLink(erId2, projectId);
        this.executionRequestDetailsService.createDetails(erId2, TestingStatuses.UNKNOWN, msg);
        return newExecutionRequests;
    }

    public UUID rerunByFilter(RerunRequest request) {
        UUID executionRequestId = request.getExecutionRequestId();
        MdcUtils.put((String)MdcField.EXECUTION_REQUEST_ID.toString(), (UUID)executionRequestId);
        List<TestRun> testRuns = this.testRunService.getTestRunsIdByExecutionRequestIdAndTestingStatuses(executionRequestId, request.getStatuses());
        if (CollectionUtils.isEmpty(testRuns)) {
            String message = String.format("Test Runs with statuses %s for rerun ER %s were not found.", request.getStatuses(), executionRequestId);
            log.error(message);
            throw new AtpException(message);
        }
        ArrayList<UUID> testRunIds = new ArrayList<UUID>(StreamUtils.extractIds(testRuns, RamObject::getUuid));
        log.debug("Test Runs {} were found by statuses {}.", testRunIds, request.getStatuses());
        ExecutionRequest executionRequest = (ExecutionRequest)this.executionRequestService.get(executionRequestId);
        RerunRequestDto rerunRequestDto = new RerunRequestDto();
        rerunRequestDto.setExecutionRequestId(executionRequestId);
        rerunRequestDto.setProjectId(executionRequest.getProjectId());
        rerunRequestDto.setRecompilation(true);
        rerunRequestDto.setEnvironmentId(executionRequest.getEnvironmentId());
        rerunRequestDto.setScopeId(executionRequest.getTestScopeId());
        rerunRequestDto.setTaToolsGroupId(executionRequest.getTaToolsGroupId());
        rerunRequestDto.setThreads(executionRequest.getThreads());
        rerunRequestDto.setTestRunIds(testRunIds);
        return this.catalogueService.rerunExecutionRequest(rerunRequestDto);
    }

    public UUID rerunTestRuns(List<UUID> testRunIds) {
        List<TestRun> testRuns = this.getTestRunsForRerun(testRunIds);
        if (CollectionUtils.isEmpty(testRuns)) {
            ExceptionUtils.throwWithLog((Logger)log, (AtpException)new RamTestRunsRerunNotAppropriateStatusException());
        }
        UUID finalExecutionRequestId = testRuns.get(0).getExecutionRequestId();
        if (testRuns.stream().anyMatch(tr -> !tr.getExecutionRequestId().equals(finalExecutionRequestId))) {
            throw new RuntimeException("All selected testruns must have same ER id");
        }
        MdcUtils.put((String)MdcField.EXECUTION_REQUEST_ID.toString(), (UUID)finalExecutionRequestId);
        return this.orchestratorService.rerunTestRuns(finalExecutionRequestId, null, testRuns.stream().sorted(Comparator.comparingInt(TestRun::getOrder)).map(RamObject::getUuid).collect(Collectors.toList()));
    }

    public List<TestRun> getTestRunsForRerun(List<UUID> testRunIds) {
        return this.testRunService.findAllByUuidInAndExecutionStatusIn(testRunIds, Arrays.asList(ExecutionStatuses.TERMINATED, ExecutionStatuses.TERMINATED_BY_TIMEOUT, ExecutionStatuses.FINISHED));
    }

    public RerunService(ExecutionRequestService executionRequestService, ExecutionRequestDetailsService executionRequestDetailsService, TestRunService testRunService, OrchestratorService orchestratorService, CatalogueService catalogueService) {
        this.executionRequestService = executionRequestService;
        this.executionRequestDetailsService = executionRequestDetailsService;
        this.testRunService = testRunService;
        this.orchestratorService = orchestratorService;
        this.catalogueService = catalogueService;
    }
}

