/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.compress.utils.Sets;
import org.modelmapper.ModelMapper;
import org.qubership.atp.ram.client.DataSetListFeignClient;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraIssueDto;
import org.qubership.atp.ram.converter.DtoConvertService;
import org.qubership.atp.ram.dto.request.AnalyzedTestRunRequest;
import org.qubership.atp.ram.dto.request.JiraTicketUpdateRequest;
import org.qubership.atp.ram.dto.request.LabelRequest;
import org.qubership.atp.ram.dto.request.LabelsPathSearchRequest;
import org.qubership.atp.ram.dto.request.StatusUpdateRequest;
import org.qubership.atp.ram.dto.request.TestRunDefectsPropagationRequest;
import org.qubership.atp.ram.dto.request.TestRunsByValidationLabelsRequest;
import org.qubership.atp.ram.dto.request.TestingStatusUpdateRequest;
import org.qubership.atp.ram.dto.request.ValidationLabelFilterRequest;
import org.qubership.atp.ram.dto.response.AnalyzedTestRunResponse;
import org.qubership.atp.ram.dto.response.BaseEntityResponse;
import org.qubership.atp.ram.dto.response.CompareTreeTestRunResponse;
import org.qubership.atp.ram.dto.response.LabelNodeReportResponse;
import org.qubership.atp.ram.dto.response.LogRecordPreviewResponse;
import org.qubership.atp.ram.dto.response.NonGroupedTestRunResponse;
import org.qubership.atp.ram.dto.response.PaginationResponse;
import org.qubership.atp.ram.dto.response.SimpleTestRunResponse;
import org.qubership.atp.ram.dto.response.StatusUpdateResponse;
import org.qubership.atp.ram.dto.response.TestCaseLabelResponse;
import org.qubership.atp.ram.dto.response.TestRunDefectsPropagationResponse;
import org.qubership.atp.ram.dto.response.TestRunResponse;
import org.qubership.atp.ram.dto.response.TestRunTreeResponse;
import org.qubership.atp.ram.dto.response.TestRunWithValidationLabelsResponse;
import org.qubership.atp.ram.entities.treenodes.labelparams.TestingReportLabelParam;
import org.qubership.atp.ram.enums.DefaultRootCauseType;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.model.CaseSearchRequest;
import org.qubership.atp.ram.model.DatasetListDataSetsResponse;
import org.qubership.atp.ram.model.LogRecordFilteringRequest;
import org.qubership.atp.ram.model.LogRecordWithChildrenResponse;
import org.qubership.atp.ram.model.datacontext.TestRunsDataContext;
import org.qubership.atp.ram.model.datacontext.TestRunsDataContextLoadOptions;
import org.qubership.atp.ram.models.AnalyzedTestRunSortedColumns;
import org.qubership.atp.ram.models.BrowserInfo;
import org.qubership.atp.ram.models.Comment;
import org.qubership.atp.ram.models.EnrichedTestRun;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.Issue;
import org.qubership.atp.ram.models.JiraTicket;
import org.qubership.atp.ram.models.Label;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.Project;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.RootCause;
import org.qubership.atp.ram.models.SetBulkFinalTestRuns;
import org.qubership.atp.ram.models.TestCase;
import org.qubership.atp.ram.models.TestPlan;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.models.TestRunSearchRequest;
import org.qubership.atp.ram.models.TestRunStatistic;
import org.qubership.atp.ram.models.TestRunsCommentSetBulkRequest;
import org.qubership.atp.ram.models.TestRunsFailureReasonSetBulkRequest;
import org.qubership.atp.ram.models.ValidationLabelConfigTemplate;
import org.qubership.atp.ram.models.logrecords.parts.ContextVariable;
import org.qubership.atp.ram.models.logrecords.parts.ValidationTable;
import org.qubership.atp.ram.models.response.LogRecordRatesResponse;
import org.qubership.atp.ram.models.response.TestRunsRatesResponse;
import org.qubership.atp.ram.repositories.ExecutionRequestRepository;
import org.qubership.atp.ram.repositories.RootCauseRepository;
import org.qubership.atp.ram.repositories.TestRunRepository;
import org.qubership.atp.ram.services.CatalogueService;
import org.qubership.atp.ram.services.CrudService;
import org.qubership.atp.ram.services.IssueService;
import org.qubership.atp.ram.services.LabelsService;
import org.qubership.atp.ram.services.LogRecordService;
import org.qubership.atp.ram.services.ProjectsService;
import org.qubership.atp.ram.services.RootCauseService;
import org.qubership.atp.ram.services.TestCaseService;
import org.qubership.atp.ram.services.TestPlansService;
import org.qubership.atp.ram.services.TreeNodeService;
import org.qubership.atp.ram.utils.JsonHelper;
import org.qubership.atp.ram.utils.PatchHelper;
import org.qubership.atp.ram.utils.StreamUtils;
import org.qubership.atp.ram.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TestRunService
extends CrudService<TestRun> {
    private static final Logger log = LoggerFactory.getLogger(TestRunService.class);
    private static final String NOT_ANALYZED = "NOT ANALYZED";
    private static final String START_DATE = "${START_DATE}";
    private static final String END_DATE = "${END_DATE}";
    private static final String VALIDATION_LABEL_N_A = "N/A";
    @Value(value="${browser.monitoring.link}")
    private String browserMonitoringLinkTemplate;
    @Lazy
    private final MongoTemplate mongoTemplate;
    @Lazy
    private final LogRecordService logRecordService;
    private final TestRunRepository testRunRepository;
    private final RootCauseService rootCauseService;
    private final ProjectsService projectsService;
    private final TestPlansService testPlansService;
    private final ModelMapper modelMapper;
    private final CatalogueService catalogueService;
    private final DataSetListFeignClient dataSetListFeignClient;
    @Lazy
    private final ExecutionRequestRepository executionRequestRepository;
    private final RootCauseRepository rootCauseRepository;
    private final TreeNodeService treeNodeService;
    private final TestCaseService testCaseService;
    private final IssueService issueService;
    private final PatchHelper patchHelper;
    private final LabelsService labelsService;

    @Nonnull
    public TestRun getByUuid(UUID testRunId) {
        return (TestRun)this.get(testRunId);
    }

    public List<TestRun> getShortTestRunsByIds(Collection<UUID> ids) {
        return this.testRunRepository.findShortTestRunsByUuidIn(ids);
    }

    public List<TestRun> getByIds(Collection<UUID> ids) {
        return this.testRunRepository.findAllByUuidIn(ids);
    }

    @Override
    protected MongoRepository<TestRun, UUID> repository() {
        return this.testRunRepository;
    }

    public TestRun getByTestCase(UUID testCaseId) {
        return this.testRunRepository.findFirstByTestCaseIdOrderByStartDateDesc(testCaseId);
    }

    public List<TestRun> getAllInProgressTestRuns() {
        return this.testRunRepository.findAllByExecutionStatusOrderByStartDateDesc(ExecutionStatuses.IN_PROGRESS);
    }

    public LogRecord getLastInProgressLogRecord(UUID testRunId) {
        return this.logRecordService.findLastInProgressLogRecordByTestRunId(testRunId);
    }

    public LogRecord getLastInProgressOrcLogRecord(UUID testRunId) {
        return this.logRecordService.findLastInProgressOrcLogRecordByTestRunId(testRunId);
    }

    public void deleteByUuid(UUID uuid) {
        this.testRunRepository.deleteByUuid(uuid);
    }

    @Deprecated
    public TestRun create(Project newProject, TestPlan newTestPlan, TestRun testRun, ExecutionRequest newExecutionRequest) {
        Project project = this.projectsService.findByUuidNameOrCreateNew(newProject);
        TestPlan testPlan = this.testPlansService.findByUuidNameOrCreateNew(newTestPlan, project);
        ExecutionRequest executionRequest = this.findOrCreateRequest(project, testPlan, newExecutionRequest);
        return this.findOrCreateTestRun(testRun, executionRequest);
    }

    public TestRun patch(TestRun testRun) {
        log.debug("Patching test run with id {}", (Object)testRun.getUuid());
        TestRun testRunToPatch = this.testRunRepository.findByUuid(testRun.getUuid());
        if (testRun.getFinishDate() != null) {
            long duration = TimeUnit.MILLISECONDS.toSeconds(testRun.getFinishDate().getTime() - testRunToPatch.getStartDate().getTime());
            testRun.setDuration(duration);
        }
        this.patchHelper.partialUpdate(testRun, testRunToPatch, PatchHelper.nullProperties, PatchHelper.emptyCollectionsProperties, PatchHelper.emptyMapsPropertiesFilter);
        log.debug("Merge completed, result entity: {} will be stored in DB", (Object)testRunToPatch);
        return (TestRun)this.testRunRepository.save(testRunToPatch);
    }

    @Deprecated
    private ExecutionRequest findOrCreateRequest(Project project, TestPlan testPlan, ExecutionRequest request) {
        String name = request.getName();
        log.info("Start of search (or creating - if the Execution Request was not found) with name:\n{}.", (Object)name);
        log.trace("Request for ER : {}.", (Object)request);
        ExecutionRequest executionRequest = this.executionRequestRepository.findByUuid(request.getUuid());
        if (Objects.nonNull(executionRequest)) {
            log.debug("ER already exist {}.", (Object)name);
            return executionRequest;
        }
        executionRequest = request;
        executionRequest.setStartDate(new Timestamp(System.currentTimeMillis()));
        executionRequest.setExecutionStatus(ExecutionStatuses.IN_PROGRESS);
        executionRequest.setProjectId(project.getUuid());
        executionRequest.setTestPlanId(testPlan.getUuid());
        executionRequest.setDuration(0L);
        executionRequest.setPassedRate(0);
        executionRequest.setWarningRate(0);
        executionRequest.setFailedRate(0);
        this.executionRequestRepository.save(executionRequest);
        log.debug("ER: {} was created.", (Object)executionRequest.getUuid());
        return executionRequest;
    }

    public List<LogRecord> getAllSectionNotCompoundLogRecords(UUID testRunId) {
        return this.logRecordService.getAllSectionNotCompoundLogRecordsByTestRunId(testRunId);
    }

    public List<LogRecord> getAllLogRecordsByTestRunId(UUID id) {
        return this.logRecordService.findAllByTestRunIdOrderByStartDateAsc(id, null);
    }

    public List<LogRecord> getAllFilteredLogRecordsByTestRunId(UUID id, @Nullable LogRecordFilteringRequest filter) {
        return this.logRecordService.findAllByTestRunIdOrderByStartDateAsc(id, filter);
    }

    public List<LogRecord> getAllLogRecordsUuidByTestRunId(UUID testRunId) {
        return this.logRecordService.getAllLogRecordsUuidByTestRunId(testRunId);
    }

    public List<LogRecord> getAllFailedLogRecords(UUID testRunUuid) {
        return this.logRecordService.getAllFailedLogRecordsByTestRunId(testRunUuid);
    }

    public List<LogRecord> getAllFailedLogRecords(Set<UUID> testRunIds) {
        return this.logRecordService.getAllFailedLogRecordsByTestRunIds(testRunIds);
    }

    public List<LogRecord> getAllTestingStatusLogRecordsByTestRunId(UUID testRunUuid) {
        return this.logRecordService.getAllTestingStatusLogRecordsByTestRunId(testRunUuid);
    }

    public List<LogRecord> updateLogRecordsTestingStatus(UUID testRunUuid, TestingStatuses statuses) {
        List<LogRecord> allNotStartedLogRecordsByTestRunId = this.logRecordService.getAllNotStartedLogRecordsByTestRunId(testRunUuid);
        if (allNotStartedLogRecordsByTestRunId != null) {
            allNotStartedLogRecordsByTestRunId.forEach(logRecord -> {
                logRecord.setTestingStatus(statuses);
                this.logRecordService.save((LogRecord)logRecord);
            });
        }
        return allNotStartedLogRecordsByTestRunId;
    }

    public Map<UUID, TestRun> getDataForTestResultByExecutionRequestId(List<UUID> erId) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)new Criteria("executionRequests_id").is(erId)), Aggregation.unwind((String)"qaHost"), Aggregation.unwind((String)"taHost"), Aggregation.group((String[])new String[]{"executionRequests_id", "qaHost", "taHost"}), Aggregation.project((String[])new String[]{"executionRequests_id", "qaHost", "taHost"}).andExclude(new String[]{"_id"})});
        AggregationResults res = this.mongoTemplate.aggregate(aggregation, "testrun", TestRun.class);
        HashMap<UUID, TestRun> testRuns = new HashMap<UUID, TestRun>();
        res.iterator().forEachRemaining(testRun -> testRuns.put(testRun.getExecutionRequestId(), (TestRun)testRun));
        return testRuns;
    }

    public List<LogRecord> getTopLevelLogRecords(UUID uuid, LogRecordFilteringRequest filteringRequest) {
        return this.logRecordService.findByTestRunIdAndParentUuid(uuid, null, filteringRequest);
    }

    @Override
    public TestRun save(TestRun testRun) {
        return (TestRun)this.testRunRepository.save(testRun);
    }

    public void updateStatusesAndFinishDateTestRuns(UUID testRunId, ExecutionStatuses executionStatus, TestingStatuses testingStatus, Timestamp finishDate, long duration) {
        this.testRunRepository.updateStatusesAndFinishDateByTestRunId(testRunId, executionStatus, testingStatus, finishDate, duration);
    }

    public List<TestRun> findAllByExecutionRequestId(UUID executionRequestId) {
        List<TestRun> executionRequestTestRuns = this.testRunRepository.findAllByExecutionRequestId(executionRequestId);
        log.info("Found test run with ids '{}' for execution request with id '{}'", StreamUtils.extractIds(executionRequestTestRuns), (Object)executionRequestId);
        return executionRequestTestRuns;
    }

    public List<TestRun> findTestRunsForFdrByExecutionRequestId(UUID executionRequestId) {
        List<TestRun> executionRequestTestRuns = this.testRunRepository.findTestRunsForFdrByExecutionRequestId(executionRequestId);
        log.info("Found test run with ids '{}' for execution request with id '{}'", StreamUtils.extractIds(executionRequestTestRuns), (Object)executionRequestId);
        return executionRequestTestRuns;
    }

    public List<TestRun> findTestCaseIdsByExecutionRequestId(UUID executionRequestId) {
        List<TestRun> executionRequestTestRuns = this.testRunRepository.findTestCaseIdByExecutionRequestId(executionRequestId);
        log.info("Found test run with ids '{}' for execution request with id '{}'", StreamUtils.extractIds(executionRequestTestRuns), (Object)executionRequestId);
        return executionRequestTestRuns;
    }

    public List<TestRun> getTestRunChildren(UUID parentTestRunId) {
        return this.testRunRepository.findAllByParentTestRunId(parentTestRunId);
    }

    public List<TestRun> findSortedByExecutionRequestId(UUID erId) {
        return this.testRunRepository.findAllByExecutionRequestIdOrderByStartDateAsc(erId);
    }

    public void setFdrLink(UUID testRunId, String fdrLink) {
        TestRun testRun = this.getByUuid(testRunId);
        testRun.setFdrLink(fdrLink);
        this.save(testRun);
    }

    @Deprecated
    public String stopTestRun(JsonObject request) {
        UUID testRunUuid = UUID.fromString(JsonHelper.getStringValue(request, "testRunId"));
        log.debug("Start of stop Test Run {}.", (Object)testRunUuid);
        HashSet<String> urlToBrowserOrLogs = JsonHelper.getHashSet(request, "urlToBrowserOrLogs", new HashSet<String>());
        TestRun testRun = this.testRunRepository.findByUuid(testRunUuid);
        this.terminateTestRun(testRun);
        log.trace("Test run stopped, uuid = {}, url to browser log = {}.", (Object)testRunUuid, urlToBrowserOrLogs);
        TestingStatuses testingStatus = TestingStatuses.findByValue((String)JsonHelper.getStringValue(request, "testingStatus"));
        testRun.updateTestingStatus(testingStatus);
        Timestamp startDate = testRun.getStartDate();
        Timestamp finishDate = testRun.getFinishDate();
        testRun.setUrlToBrowserOrLogs(this.getUrlToBrowserLog(startDate, finishDate, urlToBrowserOrLogs));
        testRun.setLogCollectorData(JsonHelper.getStringValue(request, "logCollectorData"));
        this.testRunRepository.save(testRun);
        return testRun.getExecutionStatus().getName();
    }

    public TestRun saveRootCause(UUID uuid, UUID rootCauseId) {
        TestRun testRun = this.getByUuid(uuid);
        testRun.setRootCauseId(rootCauseId);
        this.save(testRun);
        return testRun;
    }

    public List<TestRun> saveRootCausesForListOfTestRuns(List<UUID> uuids, UUID rootCauseId) {
        ArrayList<TestRun> testRuns = new ArrayList<TestRun>();
        uuids.forEach(uuid -> {
            TestRun testRun = this.getByUuid((UUID)uuid);
            testRun.setRootCauseId(rootCauseId);
            this.save(testRun);
            testRuns.add(testRun);
        });
        return testRuns;
    }

    public void updateFieldRootCauseIdByTestRunsIds(List<UUID> listTestRunIds, UUID rootCauseId) {
        if (rootCauseId != null) {
            listTestRunIds.forEach(testRunId -> {
                HashMap<String, Object> fieldsToUpdate = new HashMap<String, Object>();
                fieldsToUpdate.put("rootCauseId", rootCauseId);
                this.updateAnyFieldsForTestRunsByUuid((UUID)testRunId, (Map<String, Object>)fieldsToUpdate, TestRun.class);
            });
        }
    }

    public void updateAnyFieldsForTestRunsByUuid(UUID testRunId, Map<String, Object> fieldsToUpdate, Class<?> entityClass) {
        this.testRunRepository.updateAnyFieldsRamObjectByIdDocument(testRunId, fieldsToUpdate, entityClass);
    }

    List<LogRecord> getAllMatchesLogRecords(UUID testRunUuid, String searchValue) {
        return this.logRecordService.getAllMatchesLogRecordsByTestRunId(testRunUuid, searchValue);
    }

    void deleteListTestRuns(List<UUID> testRunsUuidList) {
        log.debug("Start deleting the list of Test Runs: {}", testRunsUuidList);
        this.testRunRepository.deleteAllByUuidIn(testRunsUuidList);
    }

    public List<TestRun> getTestRunsForProject(UUID projectUuid) {
        List<UUID> executionRequestsId = this.executionRequestRepository.findUuidByProjectId(projectUuid).stream().map(RamObject::getUuid).collect(Collectors.toList());
        return this.testRunRepository.findAllByExecutionRequestIdIn(executionRequestsId);
    }

    public long countAllByExecutionRequestIdAndExecutionStatusIn(UUID uuid, List<ExecutionStatuses> executionStatuses) {
        return this.testRunRepository.countAllByExecutionRequestIdAndExecutionStatusIn(uuid, executionStatuses);
    }

    public Map<String, Integer> getTestRunsGroupedByRootCauses(UUID erId) {
        LinkedHashMap<String, Integer> rootCausesAndCount = new LinkedHashMap<String, Integer>();
        List<TestRun> testRuns = this.testRunRepository.findAllTestRunRootCausesByExecutionRequestId(erId);
        List<RootCause> rootCauses = this.rootCauseService.getAllRootCauses();
        for (TestRun testRun : testRuns) {
            Integer count;
            String rootCauseName;
            Optional<RootCause> foundRc = rootCauses.stream().filter(rootCause -> rootCause.getUuid().equals(testRun.getRootCauseId())).findFirst();
            String string = rootCauseName = foundRc.isPresent() ? foundRc.get().getName() : "";
            if (Strings.isNullOrEmpty((String)rootCauseName)) {
                rootCauseName = NOT_ANALYZED;
            }
            rootCausesAndCount.put(rootCauseName, (count = (Integer)rootCausesAndCount.get(rootCauseName)) == null ? 1 : count + 1);
        }
        return rootCausesAndCount;
    }

    public long getFinishDateOfLastTestRun(UUID requestUuid) {
        try {
            return this.testRunRepository.findFinishDateByExecutionRequestIdAndFinishDateIsNotNullOrderByFinishDateDesc(requestUuid).getFinishDate().getTime();
        }
        catch (Exception e) {
            log.error("Unable get finish date of TR, ER = " + requestUuid, (Throwable)e);
            return 0L;
        }
    }

    public List<TestRun> getTestCasesNamesForProject(UUID projectId) {
        List<UUID> requestsId = this.executionRequestRepository.findUuidByProjectId(projectId).stream().map(RamObject::getUuid).collect(Collectors.toList());
        return this.testRunRepository.findAllTestCasesNamesByExecutionRequestIdIn(requestsId);
    }

    public TestRun findByNameAndRequestUuidOrCreateNew(TestRun tr) {
        TestRun res = Objects.isNull(tr.getUuid()) ? this.testRunRepository.findByExecutionRequestIdAndName(tr.getExecutionRequestId(), tr.getName()) : this.testRunRepository.findByUuid(tr.getUuid());
        if (Objects.isNull(res)) {
            log.debug("Created Test Run: {}.", (Object)tr.getUuid());
            this.testRunRepository.save(tr);
            return tr;
        }
        log.debug("Test Run: {} already exist.", (Object)res.getUuid());
        return res;
    }

    public List<TestRun> findTestRunsWithFillStatusByRequestId(UUID executionRequestId) {
        return this.testRunRepository.findAllByExecutionRequestIdAndTestingStatusIsNotNull(executionRequestId);
    }

    public UUID getProjectIdByTestRunId(UUID id) {
        return this.testRunRepository.findProjectIdByTestRunId(id);
    }

    public UUID getProjectIdByTestRun(TestRun testRun) {
        UUID erId = testRun.getExecutionRequestId();
        return this.executionRequestRepository.findByUuid(erId).getProjectId();
    }

    public UUID getProjectIdByTestCaseId(UUID testCaseId) {
        return this.testRunRepository.findProjectIdByTestCaseId(testCaseId);
    }

    public UUID getProjectIdByTestRunIds(Set<UUID> testRuns) {
        UUID testRunId = testRuns.stream().findAny().orElse(null);
        if (Objects.isNull(testRunId)) {
            return null;
        }
        return this.getProjectIdByTestRunId(testRunId);
    }

    @Deprecated
    private TestRun findOrCreateTestRun(TestRun request, ExecutionRequest executionRequest) {
        log.trace("Request for create Test Run:\n{}", (Object)request);
        request.setExecutionRequestId(executionRequest.getUuid());
        request.setExecutionStatus(ExecutionStatuses.NOT_STARTED);
        request.updateTestingStatus(TestingStatuses.NOT_STARTED);
        return this.findByNameAndRequestUuidOrCreateNew(request);
    }

    @Deprecated
    private TestRun updateTestRun(TestRun testRun, JsonObject request) {
        long finishDate;
        testRun.setExecutionStatus(JsonHelper.getExecutionStatus(request, "executionStatus", ExecutionStatuses.IN_PROGRESS));
        testRun.updateTestingStatus(JsonHelper.getTestingStatus(request, "testingStatus", TestingStatuses.UNKNOWN));
        testRun.setSolutionBuild(JsonHelper.getListString(request, "solutionBuild", testRun.getSolutionBuild()));
        testRun.setTaHost(JsonHelper.getListString(request, "taHost", testRun.getTaHost()));
        testRun.setQaHost(JsonHelper.getListString(request, "qaHost", testRun.getQaHost()));
        testRun.setExecutor(JsonHelper.getStringValue(request, "executor", String.valueOf(testRun.getExecutionRequestId())));
        testRun.setDataSetUrl(JsonHelper.getStringValue(request, "dataSetUrl", testRun.getDataSetUrl()));
        testRun.setDataSetListUrl(JsonHelper.getStringValue(request, "dataSetListUrl", testRun.getDataSetListUrl()));
        try {
            finishDate = JsonHelper.getLongValue(request, "finishDate");
        }
        catch (Exception e) {
            log.warn("Can not get the finish date");
            finishDate = System.currentTimeMillis();
        }
        testRun.setFinishDate(new Timestamp(finishDate));
        testRun.setDuration(TimeUtils.getDuration(testRun.getStartDate(), testRun.getFinishDate()));
        testRun.setLogCollectorData(JsonHelper.getStringValue(request, "logCollectorData", testRun.getLogCollectorData()));
        this.save(testRun);
        return testRun;
    }

    @Deprecated
    private HashSet<String> getUrlToBrowserLog(Timestamp startDate, Timestamp finishDate, HashSet<String> urls) {
        if (!urls.isEmpty()) {
            String firstDate = startDate.toString().replace(" ", "T");
            String secondDate = finishDate.toString().replace(" ", "T");
            HashSet<String> newUrls = new HashSet<String>();
            for (String url : urls) {
                newUrls.add(url.replace(START_DATE, firstDate).replace(END_DATE, secondDate));
            }
            return newUrls;
        }
        return urls;
    }

    public List<UUID> getTestRunsForStoppingOrTerminating(List<UUID> testRunIds) {
        List<UUID> finishedListTestRuns = this.testRunRepository.findAllByUuidInAndExecutionStatusIn(testRunIds, Arrays.asList(ExecutionStatuses.IN_PROGRESS, ExecutionStatuses.NOT_STARTED)).stream().map(RamObject::getUuid).collect(Collectors.toList());
        log.debug("Test runs for stopping or terminating: {}", finishedListTestRuns);
        return finishedListTestRuns;
    }

    public List<UUID> getTestRunsForResuming(List<UUID> testRunIds) {
        return this.testRunRepository.findAllByUuidInAndExecutionStatusIn(testRunIds, Collections.singletonList(ExecutionStatuses.SUSPENDED)).stream().map(RamObject::getUuid).collect(Collectors.toList());
    }

    void stopServiceTestRun(UUID requestUuid) {
        log.debug("Stopping service Test Run for Execution Request: {}", (Object)requestUuid);
        TestRun testRunForSearch = new TestRun();
        testRunForSearch.setExecutionRequestId(requestUuid);
        testRunForSearch.setName("Execution Request's Logs");
        TestRun systemTestRun = this.testRunRepository.findByExecutionRequestIdAndName(testRunForSearch.getExecutionRequestId(), testRunForSearch.getName());
        if (Objects.isNull(systemTestRun)) {
            log.trace("Cannot find testrun 'Execution Request's Logs' for ER = {}", (Object)requestUuid);
            return;
        }
        if (ExecutionStatuses.FINISHED.equals((Object)systemTestRun.getExecutionStatus())) {
            log.trace("System testrun [id = {}] has execution status = {} already", (Object)systemTestRun.getUuid(), (Object)ExecutionStatuses.FINISHED);
            return;
        }
        systemTestRun.setExecutionStatus(ExecutionStatuses.FINISHED);
        systemTestRun.setFinishDate(new Timestamp(System.currentTimeMillis()));
        this.save(systemTestRun);
    }

    public void updateTestRunsStatusToTerminatedByErId(UUID executionRequestId) {
        log.debug("Terminate Test Runs for execution request {}", (Object)executionRequestId);
        List<TestRun> testRuns = this.testRunRepository.findAllByExecutionRequestIdAndExecutionStatusIn(executionRequestId, Arrays.asList(ExecutionStatuses.NOT_STARTED, ExecutionStatuses.IN_PROGRESS));
        if (testRuns.isEmpty()) {
            log.debug("Test runs don't exist for execution request {}", (Object)executionRequestId);
            return;
        }
        testRuns.forEach(testRun -> {
            testRun.setExecutionStatus(ExecutionStatuses.TERMINATED);
            testRun.setFinishDate(new Timestamp(System.currentTimeMillis()));
        });
        this.testRunRepository.saveAll(testRuns);
    }

    @Deprecated
    public UUID updateOrCreate(JsonObject request) {
        UUID testRunId = UUID.fromString(JsonHelper.getStringValue(request, "testRunId"));
        String erId = JsonHelper.getStringValue(request, "executionRequestId");
        log.debug("Update Test Run: {} for ER {}.", (Object)testRunId, (Object)erId);
        TestRun testRun = this.getByUuid(testRunId);
        log.debug("TestRunService: before update, testing status {} for ID {}", (Object)testRun.getTestingStatus(), (Object)testRunId);
        testRunId = this.updateTestRun(testRun, request).getUuid();
        log.debug("TestRunService: after update, testing status {} for ID {}", (Object)testRun.getTestingStatus(), (Object)testRunId);
        return testRunId;
    }

    List<TestRun> findNotPassedTestRunByErId(UUID erId) {
        return this.testRunRepository.findByExecutionRequestIdAndTestingStatus(erId, TestingStatuses.PASSED);
    }

    public List<TestRun> findTestRunsUuidAndTestingStatusByErId(UUID executionRequestId) {
        return this.testRunRepository.findTestRunsUuidAndTestingStatusByExecutionRequestId(executionRequestId);
    }

    List<TestRun> getAllMatchedTestRunsByRequestId(UUID requestId, String searchValue) {
        return this.testRunRepository.findAllByExecutionRequestIdAndNameContains(requestId, searchValue);
    }

    public TestRunTreeResponse getTestRunByIdWithParent(UUID uuid) {
        TestRun testRun = this.getByUuid(uuid);
        TestRunTreeResponse response = new TestRunTreeResponse();
        if (!testRun.isGroupedTestRun()) {
            SimpleTestRunResponse simpleTestRunResponse = this.preparingSimpleTestRun(testRun);
            response.setSimpleTestRun(simpleTestRunResponse);
        }
        return response;
    }

    private SimpleTestRunResponse preparingSimpleTestRun(TestRun testRun) {
        Long allLogRecordsByTestRunCount;
        SimpleTestRunResponse simpleTestRunResponse = (SimpleTestRunResponse)this.modelMapper.map((Object)testRun, SimpleTestRunResponse.class);
        simpleTestRunResponse.setTestCase(new BaseEntityResponse(testRun.getTestCaseId(), testRun.getTestCaseName()));
        UUID rootCauseId = testRun.getRootCauseId();
        if (Objects.nonNull(rootCauseId)) {
            String rootCause = this.rootCauseService.getRootCauseNameById(rootCauseId);
            simpleTestRunResponse.setRootCause(new BaseEntityResponse(rootCauseId, rootCause));
        }
        simpleTestRunResponse.setBrowserInfos(this.generateBrowserInfo(testRun));
        Set labelIds = testRun.getLabelIds();
        if (!CollectionUtils.isEmpty((Collection)labelIds)) {
            simpleTestRunResponse.setLabels(this.labelsService.getLabels(labelIds));
        }
        simpleTestRunResponse.setAllLogRecordsCount(Long.valueOf(Objects.nonNull(allLogRecordsByTestRunCount = this.logRecordService.countLrsByTestRunsId(Sets.newHashSet((Object[])new UUID[]{testRun.getUuid()}))) ? allLogRecordsByTestRunCount : 0L));
        Long passedLogRecordsByTestRunCount = this.logRecordService.countAllPassedLrByTestRunIds(Sets.newHashSet((Object[])new UUID[]{testRun.getUuid()}));
        simpleTestRunResponse.setPassedLogRecordsCount(Long.valueOf(Objects.nonNull(passedLogRecordsByTestRunCount) ? passedLogRecordsByTestRunCount : 0L));
        return simpleTestRunResponse;
    }

    private List<BrowserInfo> generateBrowserInfo(TestRun testRun) {
        if (Objects.isNull(testRun.getBrowserNames())) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)this.browserMonitoringLinkTemplate) || Objects.isNull(testRun.getStartDate())) {
            log.warn("Can't generate browser monitoring links for testrun '{}' due to empty template or testrun StartDate. Only browser names will be set. Template={}, StartDate={}, BrowserNames={},", new Object[]{testRun.getUuid(), this.browserMonitoringLinkTemplate, testRun.getStartDate(), testRun.getBrowserNames()});
            return testRun.getBrowserNames().stream().map(name -> new BrowserInfo(name, null)).collect(Collectors.toList());
        }
        long startInMillis = testRun.getStartDate().getTime();
        long finishInMillis = Objects.isNull(testRun.getFinishDate()) ? System.currentTimeMillis() : testRun.getFinishDate().getTime();
        String templateWithTimestamps = this.browserMonitoringLinkTemplate.replace("%{from_timestamp}", Long.toString(startInMillis)).replace("%{to_timestamp}", Long.toString(finishInMillis));
        return testRun.getBrowserNames().stream().map(name -> new BrowserInfo(name, templateWithTimestamps.replace("%{browser_pod}", (CharSequence)name))).collect(Collectors.toList());
    }

    private List<TestRun> getPreviousTestRunsWithNames(TestRun testRun) {
        ArrayList<TestRun> testRuns = new ArrayList<TestRun>();
        testRuns.add(testRun);
        while (Objects.nonNull(testRun.getParentTestRunId())) {
            testRun = this.testRunRepository.findNameParentIdByUuid(testRun.getParentTestRunId());
            testRuns.add(testRun);
        }
        return testRuns;
    }

    public List<LogRecordPreviewResponse> getAllLogRecordPreviews(UUID testRunId, LogRecordFilteringRequest filteringRequest) {
        return this.logRecordService.findLogRecordsWithPreviewByTestRunIdOrderByStartDateAsc(testRunId, filteringRequest).stream().filter(logRecord -> !Strings.isNullOrEmpty((String)logRecord.getPreview())).map(logRecord -> new LogRecordPreviewResponse(testRunId, logRecord.getUuid(), logRecord.getPreview(), logRecord.getTestingStatus())).collect(Collectors.toList());
    }

    public BaseEntityResponse getTestRunTestCase(UUID testRunId) {
        TestRun testRun = (TestRun)this.get(testRunId);
        return new BaseEntityResponse(testRun.getTestCaseId(), testRun.getTestCaseName());
    }

    public List<NonGroupedTestRunResponse> getNonGroupedTestRuns(UUID executionRequestId) {
        return this.testRunRepository.findAllByExecutionRequestIdAndIsGroupedTestRun(executionRequestId, Boolean.FALSE).stream().map(testRun -> new NonGroupedTestRunResponse(testRun.getUuid(), testRun.getName(), testRun.getTestingStatus())).collect(Collectors.toList());
    }

    public List<UUID> stopTestRuns(List<UUID> testRunUuids) {
        log.debug("Start of stop Test Runs {}.", testRunUuids);
        List<TestRun> testRuns = this.testRunRepository.findAllByUuidIn(testRunUuids);
        testRuns.forEach(this::terminateTestRun);
        this.testRunRepository.saveAll(testRuns);
        List<UUID> terminatedUuids = testRuns.stream().map(RamObject::getUuid).collect(Collectors.toList());
        log.debug("Finished terminating Test Runs {}", terminatedUuids);
        return terminatedUuids;
    }

    public List<UUID> finishTestRuns(List<UUID> testRunUuids, boolean isDelayed) {
        log.debug("Test runs {} are going to be finished. Delayed: {}", testRunUuids, (Object)isDelayed);
        List<TestRun> testRuns = this.testRunRepository.findAllByUuidIn(testRunUuids);
        testRuns.forEach(tr -> this.finishTestRun((TestRun)tr, isDelayed));
        this.testRunRepository.saveAll(testRuns);
        List<UUID> finishedUuids = testRuns.stream().map(RamObject::getUuid).collect(Collectors.toList());
        log.debug("Finished Test Runs {}", finishedUuids);
        return finishedUuids;
    }

    public List<EnrichedTestRun> getEnrichedTestRunsByExecutionRequestId(UUID executionRequestId) {
        List<EnrichedTestRun> executionRequestTestRuns = this.testRunRepository.findAllEnrichedTestRunsByExecutionRequestId(executionRequestId);
        log.debug("executionRequestTestRuns: {}", executionRequestTestRuns);
        ExecutionRequest executionRequest = this.executionRequestRepository.findByUuid(executionRequestId);
        if (!executionRequest.isVirtual()) {
            ArrayList<EnrichedTestRun> testRuns = new ArrayList<EnrichedTestRun>(executionRequestTestRuns);
            List<TestCaseLabelResponse> testCases = this.catalogueService.getTestCaseLabelsByIds(testRuns);
            log.debug("Found test run with ids '{}' for execution request with id '{}'", StreamUtils.extractIds(executionRequestTestRuns), (Object)executionRequestId);
            executionRequestTestRuns.forEach(enrichedTestRun -> enrichedTestRun.setLabels(this.getLabelsByTestCaseId(testCases, enrichedTestRun.getTestCaseId())));
        }
        return executionRequestTestRuns;
    }

    private List<Label> getLabelsByTestCaseId(List<TestCaseLabelResponse> testCases, UUID testCaseId) {
        if (testCaseId == null) {
            return new ArrayList<Label>();
        }
        Optional<TestCaseLabelResponse> testCaseLabel = testCases.stream().filter(testCase -> testCaseId.equals(testCase.getUuid())).findFirst();
        if (testCaseLabel.isPresent()) {
            return testCaseLabel.get().getLabels();
        }
        return new ArrayList<Label>();
    }

    private void terminateTestRun(TestRun testRun) {
        testRun.setFinishDate(new Timestamp(System.currentTimeMillis()));
        if (!this.isFinalStatus(testRun.getExecutionStatus())) {
            testRun.setExecutionStatus(ExecutionStatuses.TERMINATED);
        }
        Timestamp startDate = testRun.getStartDate();
        Timestamp finishDate = testRun.getFinishDate();
        long duration = TimeUtils.getDuration(startDate, finishDate);
        testRun.setDuration(duration);
    }

    public void upsertTestRunStatisticReportLabelParam(UUID testRunId, String paramName, TestRunStatistic.ReportLabelParameterData data) {
        TestRun testRun = this.getByUuid(testRunId);
        TestRunStatistic testRunStatistic = testRun.getStatistic();
        if (Objects.isNull(testRunStatistic)) {
            testRunStatistic = new TestRunStatistic();
            testRun.setStatistic(testRunStatistic);
        }
        Map reportLabelParams = testRunStatistic.getReportLabelParams();
        reportLabelParams.put(paramName, data);
        this.save(testRun);
    }

    public List<TestRun> findAllByExecutionRequestIdAndNameNotIs(UUID execReqId, String excludeName) {
        return this.testRunRepository.findAllByExecutionRequestIdAndNameNot(execReqId, excludeName);
    }

    public List<TestRun> findAllRatesByUuidIn(Collection<UUID> testRunsIds) {
        return this.testRunRepository.findAllRatesByUuidIn(testRunsIds);
    }

    public AnalyzedTestRunResponse getAnalyzedTestRuns(int startIndex, int endIndex, AnalyzedTestRunSortedColumns columnType, Sort.Direction sortType, TestRunSearchRequest filter) {
        UUID executionRequestId = filter.getExecutionRequestId();
        if (!CollectionUtils.isEmpty((Collection)filter.getLabelNames()) || !CollectionUtils.isEmpty((Collection)filter.getLabelNameContains())) {
            List<TestRun> executionRequestTestRuns = this.findTestCaseIdsByExecutionRequestId(executionRequestId);
            Set<UUID> filteredLabelIds = this.collectFilteredLabelIdsFromTestCases(executionRequestTestRuns, filter);
            if (CollectionUtils.isEmpty(filteredLabelIds)) {
                AnalyzedTestRunResponse response = new AnalyzedTestRunResponse();
                response.setTestRuns(new ArrayList());
                response.setTotalNumberOfEntities(Integer.valueOf(0));
                return response;
            }
            filter.setLabelIds(filteredLabelIds);
        }
        PaginationResponse<TestRun> paginationResponse = this.testRunRepository.findAllByFilter(startIndex, endIndex, columnType, sortType, filter);
        List testRuns = paginationResponse.getEntities();
        long totalNumberOfEntities = paginationResponse.getTotalCount();
        List<TestCaseLabelResponse> testCaseLabelResponses = this.catalogueService.getTestCaseLabelsByIds(testRuns);
        Map<UUID, TestCaseLabelResponse> testCaseLabelResponseMap = StreamUtils.toIdEntityMap(testCaseLabelResponses);
        Map rootCauseMap = StreamUtils.toIdEntityMap(this.rootCauseRepository.findAll());
        Set<UUID> testRunIds = StreamUtils.extractIds(testRuns);
        Map<UUID, Set<JiraTicket>> testRunsDefectsMap = this.getTestRunsIssuesMap(executionRequestId, testRunIds);
        List responseTestRuns = testRuns.stream().map(testRun -> {
            TestCaseLabelResponse testCaseLabelResponse = (TestCaseLabelResponse)testCaseLabelResponseMap.get(testRun.getTestCaseId());
            return this.toAnalyzedTestRunResponse((TestRun)testRun, testCaseLabelResponse, rootCauseMap, testRunsDefectsMap);
        }).collect(Collectors.toList());
        AnalyzedTestRunResponse response = new AnalyzedTestRunResponse();
        response.setTestRuns(responseTestRuns);
        response.setTotalNumberOfEntities(Integer.valueOf((int)totalNumberOfEntities));
        return response;
    }

    private Set<UUID> collectFilteredLabelIdsFromTestCases(List<TestRun> testRuns, TestRunSearchRequest filter) {
        List<TestCaseLabelResponse> testCaseLabelResponses = this.catalogueService.getTestCaseLabelsByIds(testRuns);
        List filterLabelNames = filter.getLabelNames();
        List filterLabelParts = filter.getLabelNameContains();
        HashSet<UUID> filteredLabelIds = new HashSet<UUID>();
        testCaseLabelResponses.forEach(testCaseLabelResponse -> {
            List labels = testCaseLabelResponse.getLabels();
            if (!CollectionUtils.isEmpty((Collection)filterLabelNames)) {
                filteredLabelIds.addAll(labels.stream().filter(label -> this.isLabelInFilteredLabelNames(label.getName(), filterLabelNames)).map(RamObject::getUuid).collect(Collectors.toSet()));
            }
            if (!CollectionUtils.isEmpty((Collection)filterLabelParts)) {
                filteredLabelIds.addAll(labels.stream().filter(label -> this.isLabelPartInLabelName(label.getName(), filterLabelParts)).map(RamObject::getUuid).collect(Collectors.toSet()));
            }
        });
        return filteredLabelIds;
    }

    private boolean isLabelInFilteredLabelNames(String labelName, List<String> filterLabelNames) {
        return filterLabelNames.stream().anyMatch(filteredLabel -> filteredLabel.equals(labelName));
    }

    private boolean isLabelPartInLabelName(String labelName, List<String> filterLabelParts) {
        return filterLabelParts.stream().anyMatch(labelName::contains);
    }

    public PaginationResponse<TestRun> search(TestRunSearchRequest filter, int page, int size) {
        return this.testRunRepository.findAllByFilter(page, size, null, null, filter);
    }

    public PaginationResponse<EnrichedTestRun> searchEnriched(TestRunSearchRequest filter, int page, int size) {
        PaginationResponse<TestRun> result = this.testRunRepository.findAllByFilter(page, size, null, null, filter);
        List testRuns = result.getEntities();
        EnrichedTestRun enrichedTestRuns = StreamUtils.mapToClazz(testRuns, EnrichedTestRun.class);
        Set<UUID> rootCauseIds = StreamUtils.extractIds(enrichedTestRuns, TestRun::getRootCauseId);
        List<RootCause> testRunRootCauses = this.rootCauseService.getByIds(rootCauseIds);
        Map<UUID, RootCause> rootCauseMap = StreamUtils.toIdEntityMap(testRunRootCauses);
        enrichedTestRuns.forEach(enrichedTestRun -> {
            UUID rootCauseId = enrichedTestRun.getRootCauseId();
            RootCause failureReason = (RootCause)rootCauseMap.get(rootCauseId);
            enrichedTestRun.setFailureReason(failureReason);
        });
        return new PaginationResponse((List)enrichedTestRuns, result.getTotalCount());
    }

    private AnalyzedTestRunResponse.AnalyzedTestRun toAnalyzedTestRunResponse(TestRun testRun, TestCaseLabelResponse labelResponses, Map<UUID, RootCause> rootCausesMap, Map<UUID, Set<JiraTicket>> defectsMap) {
        AnalyzedTestRunResponse.AnalyzedTestRun response = (AnalyzedTestRunResponse.AnalyzedTestRun)this.modelMapper.map((Object)testRun, AnalyzedTestRunResponse.AnalyzedTestRun.class);
        response.setTestRunJiraTicket(testRun.getJiraTicket());
        RootCause rootCause = rootCausesMap.get(testRun.getRootCauseId());
        if (Objects.nonNull(rootCause)) {
            response.setFailureReasonId(rootCause.getUuid());
        }
        if (Objects.nonNull(labelResponses)) {
            response.setProjectId(labelResponses.getProjectId());
            response.setTestPlanId(labelResponses.getTestPlanId());
            response.setScenarioId(labelResponses.getScenarioId());
            response.setLabels(labelResponses.getLabels());
            response.setJiraTicket(labelResponses.getJiraTicket());
        }
        Set<JiraTicket> defects = defectsMap.get(testRun.getUuid());
        response.setDefects(defects);
        return response;
    }

    public void updateAnalyzedTestRun(UUID testRunId, AnalyzedTestRunRequest analyzedTestRun) {
        TestRun testRun = (TestRun)this.get(testRunId);
        if (analyzedTestRun.getTestingStatus() != null) {
            this.updateStatusAndPropagateTestCase(testRun, analyzedTestRun.getTestingStatus());
        }
        if (analyzedTestRun.getJiraTicket() != null) {
            testRun.setJiraTicket(analyzedTestRun.getJiraTicket());
        }
        this.testRunRepository.save(testRun);
    }

    public Map<TestingStatuses, String> getTestStatuses() {
        return Arrays.stream(TestingStatuses.values()).collect(Collectors.toMap(testingStatus -> testingStatus, TestingStatuses::getName));
    }

    public Map<DefaultRootCauseType, String> getFailureReasons() {
        return Arrays.stream(DefaultRootCauseType.values()).collect(Collectors.toMap(failureReason -> failureReason, DefaultRootCauseType::getName));
    }

    public Long countAllByExecutionRequestId(UUID executionRequestId) {
        return this.testRunRepository.countAllByExecutionRequestId(executionRequestId);
    }

    public List<TestRun> findTestRunForExecutionSummaryByExecutionRequestId(UUID erId) {
        return this.testRunRepository.findTestRunForExecutionSummaryByExecutionRequestId(erId);
    }

    public TestRunsDataContext getTestRunsDataContext(List<TestRun> testRuns, TestRunsDataContextLoadOptions options, boolean isVirtual) {
        TestRunsDataContext.TestRunsDataContextBuilder builder = TestRunsDataContext.builder();
        if (options.isIncludeRunMap()) {
            builder.testRunsMap(StreamUtils.toIdEntityMap(testRuns));
        } else {
            builder.testRunsMap(new HashMap<UUID, TestRun>());
        }
        if (options.isIncludeRunTestCasesMap() && !isVirtual) {
            builder.testRunTestCasesMap(this.getTestRunTestCasesLabelsMap(testRuns));
        } else {
            builder.testRunTestCasesMap(new HashMap<UUID, TestCaseLabelResponse>());
        }
        if (options.isIncludeRunValidationLogRecordsMap() && options.isIncludeRunFailedLogRecordsMap()) {
            Set<UUID> testRunIds = StreamUtils.extractIds(testRuns);
            Supplier<Stream> testRunLogRecords = () -> this.logRecordService.findLogRecordsWithValidationParamsAndFailureByTestRunIds(testRunIds);
            List<LogRecord> logRecordsWithValidationParams = this.filterLogRecordsWithValidationParams(testRunLogRecords.get());
            Map<UUID, List<LogRecord>> logRecordsWithValidationParamsToTestRunMap = StreamUtils.toMapWithListEntitiesValues(logRecordsWithValidationParams, LogRecord::getTestRunId);
            builder.testRunValidationLogRecordsMap(logRecordsWithValidationParamsToTestRunMap);
            List<LogRecord> failedLogRecordsWithMetaInfo = this.filterFailedLogRecordsWithMetaInfo(testRunLogRecords.get());
            Map<UUID, List<LogRecord>> failedLogRecordsWithMetaInfoToTestRunMap = StreamUtils.toMapWithListEntitiesValues(failedLogRecordsWithMetaInfo, LogRecord::getTestRunId);
            builder.testRunFailedLogRecordsMap(failedLogRecordsWithMetaInfoToTestRunMap);
        } else if (options.isIncludeRunValidationLogRecordsMap()) {
            builder.testRunValidationLogRecordsMap(this.getTestRunValidationLogRecordsMap(testRuns));
            builder.testRunFailedLogRecordsMap(new HashMap<UUID, List<LogRecord>>());
        } else if (options.isIncludeRunFailedLogRecordsMap()) {
            builder.testRunFailedLogRecordsMap(this.getTestRunFailedLogRecordsMap(testRuns));
            builder.testRunValidationLogRecordsMap(new HashMap<UUID, List<LogRecord>>());
        } else {
            builder.testRunValidationLogRecordsMap(new HashMap<UUID, List<LogRecord>>());
            builder.testRunFailedLogRecordsMap(new HashMap<UUID, List<LogRecord>>());
        }
        if (options.isIncludeTestRunDslNamesMap()) {
            builder.testRunDslNamesMap(this.getTestRunDslNamesMap(testRuns));
        } else {
            builder.testRunDslNamesMap(new HashMap<String, String>());
        }
        if (options.isIncludeRootCausesMap()) {
            builder.rootCausesMap(this.getRootCauseNamesMap());
        } else {
            builder.rootCausesMap(new HashMap<UUID, String>());
        }
        return builder.build();
    }

    public Map<UUID, List<LogRecord>> getTestRunValidationLogRecordsMap(Collection<TestRun> testRuns) {
        Set<UUID> testRunIds = StreamUtils.extractIds(testRuns);
        List<LogRecord> testRunLogRecords = this.logRecordService.findLogRecordsWithValidationParamsByTestRunIds(testRunIds);
        return StreamUtils.toEntityListMap(testRunLogRecords, LogRecord::getTestRunId);
    }

    public Map<UUID, List<LogRecord>> getTestRunFailedLogRecordsMap(Collection<TestRun> testRuns) {
        Set<UUID> testRunIds = StreamUtils.extractIds(testRuns);
        List<LogRecord> testRunLogRecords = this.logRecordService.findFailedLogRecordsWithMetaInfoByTestRunIds(testRunIds);
        return StreamUtils.toEntityListMap(testRunLogRecords, LogRecord::getTestRunId);
    }

    public List<LogRecord> filterLogRecordsWithValidationParams(Stream<LogRecord> logRecords) {
        return logRecords.filter(logRecord -> {
            List steps;
            Set validationLabels = logRecord.getValidationLabels();
            ValidationTable validationTable = logRecord.getValidationTable();
            if (Objects.nonNull(validationTable) && !CollectionUtils.isEmpty((Collection)(steps = validationTable.getSteps()))) {
                List validationTableLabels = steps.stream().filter(step -> !CollectionUtils.isEmpty((Collection)step.getValidationLabels())).flatMap(step -> step.getValidationLabels().stream()).collect(Collectors.toList());
                return !CollectionUtils.isEmpty((Collection)validationLabels) || !CollectionUtils.isEmpty(validationTableLabels);
            }
            return !CollectionUtils.isEmpty((Collection)validationLabels);
        }).collect(Collectors.toList());
    }

    public List<LogRecord> filterFailedLogRecordsWithMetaInfo(Stream<LogRecord> logRecords) {
        return logRecords.filter(logRecord -> Objects.nonNull(logRecord.getMetaInfo()) && TestingStatuses.FAILED.equals((Object)logRecord.getTestingStatus())).collect(Collectors.toList());
    }

    public Map<UUID, TestCaseLabelResponse> getTestRunTestCasesLabelsMap(List<TestRun> testRuns) {
        List<TestCaseLabelResponse> testCases = this.catalogueService.getTestCaseLabelsByIds(testRuns);
        return StreamUtils.toIdEntityMap(testCases);
    }

    public Map<UUID, String> getRootCauseNamesMap() {
        return this.rootCauseService.getAll().stream().collect(Collectors.toMap(RamObject::getUuid, RamObject::getName));
    }

    public Map<UUID, String> getRootCauseNamesMap(Set<UUID> rootCausesId) {
        return this.rootCauseService.getByIds(rootCausesId).stream().collect(Collectors.toMap(RamObject::getUuid, RamObject::getName));
    }

    public Map<String, String> getTestRunDslNamesMap(List<TestRun> testRuns) {
        List<UUID> dslIds = StreamUtils.extractFields(testRuns, TestRun::getDataSetListUrl).stream().map(UUID::fromString).collect(Collectors.toList());
        List<DatasetListDataSetsResponse> dslResponse = new DtoConvertService(new ModelMapper()).convertList((List)this.dataSetListFeignClient.getDataSetsWithNameAndDataSetList(dslIds).getBody(), DatasetListDataSetsResponse.class);
        return dslResponse.stream().collect(Collectors.toMap(response -> response.getDataSetId().toString(), DatasetListDataSetsResponse::getDataSetName));
    }

    public Map<UUID, Set<JiraTicket>> getTestRunsIssuesMap(UUID executionRequestId, Collection<UUID> testRunIds) {
        List<Issue> testRunIssues = this.issueService.getAllIssuesByTestRunIds(executionRequestId, testRunIds);
        Map<UUID, Set<JiraTicket>> issuesMap = testRunIds.stream().collect(Collectors.toMap(Function.identity(), uuid -> new HashSet()));
        testRunIssues.stream().filter(issue -> !CollectionUtils.isEmpty((Collection)issue.getJiraDefects()) && !CollectionUtils.isEmpty((Collection)issue.getFailedTestRunIds())).forEach(issue -> issue.getFailedTestRunIds().forEach(testRunId -> issuesMap.merge((UUID)testRunId, new HashSet(issue.getJiraDefects()), (old, newOne) -> {
            old.addAll(newOne);
            return old;
        })));
        return issuesMap;
    }

    public List<LabelNodeReportResponse.TestRunNodeResponse> getTestRunNodeWithFailedLogRecords(List<TestRun> testRuns, ValidationLabelConfigTemplate template, TestRunsDataContext context) {
        UUID executionRequestId = context.getExecutionRequestId();
        Set<UUID> testRunIds = StreamUtils.extractIds(testRuns, RamObject::getUuid);
        List<TestCaseLabelResponse> testCases = this.catalogueService.getTestCaseLabelsByIds(testRuns);
        Map<UUID, TestCaseLabelResponse> testCasesMap = StreamUtils.toKeyEntityMap(testCases, RamObject::getUuid);
        Map<UUID, Set<JiraTicket>> issuesMap = this.getTestRunsIssuesMap(executionRequestId, testRunIds);
        List<LabelNodeReportResponse.TestRunNodeResponse> testRunNodes = testRuns.stream().map(testRun -> {
            TestCaseLabelResponse testCase;
            UUID testRunId = testRun.getUuid();
            LabelNodeReportResponse.TestRunNodeResponse treeNode = (LabelNodeReportResponse.TestRunNodeResponse)this.modelMapper.map(testRun, LabelNodeReportResponse.TestRunNodeResponse.class);
            treeNode.setFailureReason(context.getRootCausesMap().get(testRun.getRootCauseId()));
            List<LogRecord> failedLogRecords = context.getTestRunFailedLogRecordsMap().get(testRunId);
            if (Objects.nonNull(failedLogRecords) && !failedLogRecords.isEmpty()) {
                LogRecord firstFailedStep = this.getFirstFailedStep(failedLogRecords, failedLogRecords.get(0));
                treeNode.setFailedStep(Collections.singletonList((LabelNodeReportResponse.FailedLogRecordNodeResponse)this.modelMapper.map((Object)firstFailedStep, LabelNodeReportResponse.FailedLogRecordNodeResponse.class)));
            }
            if (Objects.nonNull(testCase = (TestCaseLabelResponse)testCasesMap.get(testRun.getTestCaseId()))) {
                treeNode.setJiraTicket(testCase.getJiraTicket());
                treeNode.setLabels(testCase.getLabels());
            }
            Set issues = issuesMap.getOrDefault(testRunId, new HashSet());
            Set<String> issueUrls = StreamUtils.extractFields(issues, JiraTicket::getUrl);
            treeNode.setIssues(issueUrls);
            treeNode.setComment(testRun.getComment());
            String dataSetName = context.getTestRunDslNamesMap().get(testRun.getDataSetUrl());
            treeNode.setDataSetName(dataSetName);
            List<TestingReportLabelParam> validationLabelParams = this.treeNodeService.getTestRunValidationLabels(testRunId, template, context.getTestRunValidationLogRecordsMap());
            treeNode.setLabelParams(validationLabelParams);
            return treeNode;
        }).collect(Collectors.toList());
        return testRunNodes;
    }

    private LogRecord getFirstFailedStep(List<LogRecord> logRecords, LogRecord firstLogRecord) {
        Optional<LogRecord> optionalLogRecord = logRecords.stream().filter(record -> firstLogRecord.getUuid().equals(record.getParentRecordId())).findFirst();
        return optionalLogRecord.isPresent() ? this.getFirstFailedStep(logRecords, optionalLogRecord.get()) : firstLogRecord;
    }

    public LogRecord getFirstFailedStep(UUID testRunId) {
        log.debug("Get first failed log record for test run with id '{}'", (Object)testRunId);
        List<LogRecord> failedLogRecords = this.logRecordService.getAllFailedLogRecordsByTestRunId(testRunId);
        List<LogRecord> failedRootLogRecords = StreamUtils.filterList(failedLogRecords, logRecord -> logRecord.getParentRecordId() == null, Comparator.comparingLong(LogRecord::getCreatedDateStamp));
        return this.getFirstFailedStep(failedLogRecords, failedRootLogRecords.get(0));
    }

    public List<CompareTreeTestRunResponse> compareByExecutionRequestIds(List<UUID> executionRequestIds) {
        return this.testRunRepository.compareByExecutionRequestIds(executionRequestIds);
    }

    public List<BaseEntityResponse> getTestRunsNotInExecutionRequestCompareTable(List<UUID> executionRequestIds) {
        return this.testRunRepository.getTestRunsNotInExecutionRequestCompareTable(executionRequestIds);
    }

    public List<TestRun> findByExecutionRequestIdAndName(UUID executionRequestId, String searchValue) {
        List<TestRun> executionRequestTestRuns = this.testRunRepository.findAllByExecutionRequestIdAndNameContains(executionRequestId, searchValue);
        log.info("Found test run with ids '{}' for execution request with id '{}'", StreamUtils.extractIds(executionRequestTestRuns), (Object)executionRequestId);
        return executionRequestTestRuns;
    }

    public StatusUpdateResponse getStatusUpdate(StatusUpdateRequest request) {
        Date lastLoaded = request.getLastLoaded();
        if (Objects.isNull(lastLoaded)) {
            lastLoaded = new Date();
        }
        List testRunIds = request.getTestRunsIds();
        log.info("Get status update for test runs '{}' with last update date after '{}'", (Object)testRunIds, (Object)lastLoaded);
        List<TestRun> testRuns = this.testRunRepository.findShortTestRunsByUuidIn(testRunIds);
        log.debug("Founded test runs: {}", StreamUtils.extractIds(testRuns));
        List<LogRecord> logRecords = this.logRecordService.findAllByLastUpdatedAfterAndTestRunIdIn(lastLoaded, testRunIds);
        log.debug("Founded log records: {}", StreamUtils.extractIds(logRecords));
        Map<UUID, List<LogRecord>> testRunToLogRecordMap = logRecords.stream().collect(Collectors.groupingBy(LogRecord::getTestRunId));
        List testRunStatusUpdateResponses = testRuns.stream().map(testRun -> new StatusUpdateResponse.TestRunStatusUpdateResponse(testRun, (List)testRunToLogRecordMap.get(testRun.getUuid()))).collect(Collectors.toList());
        log.debug("Test run status update responses: {}", testRunStatusUpdateResponses);
        Date currentLastLoadedDate = new Date();
        log.debug("Current last loaded date: {}", (Object)currentLastLoadedDate);
        return new StatusUpdateResponse(currentLastLoadedDate, testRunStatusUpdateResponses);
    }

    public TestRun updTestingStatus(UUID testRunId, boolean isReplaceTestRunStatus) {
        log.info("start updTestingStatus(testRunId: {}, isReplaceTestRunStatus: {})", (Object)testRunId, (Object)isReplaceTestRunStatus);
        List<LogRecord> logRecords = this.logRecordService.getAllSectionNotCompoundLogRecordsByTestRunId(testRunId);
        log.debug("logRecords size = {}", (Object)logRecords.size());
        TestRun testRun = this.getByUuid(testRunId);
        TestingStatuses finalTestingStatus = TestingStatuses.UNKNOWN;
        for (LogRecord logRecord : logRecords) {
            if (logRecord.getParentRecordId() != null) continue;
            finalTestingStatus = TestingStatuses.compareAndGetPriority((TestingStatuses)logRecord.getTestingStatus(), (TestingStatuses)finalTestingStatus);
        }
        if (!isReplaceTestRunStatus) {
            finalTestingStatus = TestingStatuses.compareAndGetPriority((TestingStatuses)finalTestingStatus, (TestingStatuses)testRun.getTestingStatus());
        }
        log.debug("finalTestingStatus  = {}", (Object)finalTestingStatus);
        testRun.setTestingStatus(finalTestingStatus);
        testRun = this.save(testRun);
        log.debug("testRun = {}", (Object)testRun);
        return testRun;
    }

    public LogRecord revertTestingStatusForLogRecord(UUID logRecordId) {
        LogRecord logRecord = this.logRecordService.revertTestingStatusForLogRecord(logRecordId);
        log.debug("revertTestingStatusForLogRecord: update testing status for {}", (Object)logRecordId);
        this.updTestingStatus(logRecord.getTestRunId(), false);
        return logRecord;
    }

    public List<UUID> findTestRunsUuidByExecutionRequestId(UUID executionRequestId) {
        return this.testRunRepository.findTestRunsUuidByExecutionRequestId(executionRequestId).stream().map(RamObject::getUuid).collect(Collectors.toList());
    }

    public TestRun getTestRunForNodeTree(UUID testRunId) {
        return this.testRunRepository.findTestRunForTreeNodeByUuid(testRunId);
    }

    public TestRun findTestRunExecReqIdByUuid(UUID testRunId) {
        return this.testRunRepository.findTestRunExecReqIdByUuid(testRunId);
    }

    public void updateTestRunsWithJiraTickets(List<JiraTicketUpdateRequest> updateRequests) {
        List<UUID> testRunIds = updateRequests.stream().map(JiraTicketUpdateRequest::getTestRunId).distinct().collect(Collectors.toList());
        Map<UUID, String> runIdToJiraKeyMap = updateRequests.stream().collect(Collectors.toMap(JiraTicketUpdateRequest::getTestRunId, JiraTicketUpdateRequest::getJiraTicket));
        List<TestRun> testRuns = this.testRunRepository.findAllByUuidIn(testRunIds);
        testRuns.forEach(testRun -> testRun.setJiraTicket((String)runIdToJiraKeyMap.get(testRun.getUuid())));
        this.testRunRepository.saveAll(testRuns);
    }

    public List<LogRecord> findLogRecordsWithValidationParamsAndStatusByTrId(UUID testRunId) {
        return this.logRecordService.findLogRecordsWithValidationParamsAndStatusByTrId(testRunId);
    }

    public List<TestingReportLabelParam> getTestRunValidationLabels(UUID testRunId) {
        log.debug("Get validation labels map for test run '{}'", (Object)testRunId);
        List<LogRecord> logRecords = this.getAllLogRecordsByTestRunId(testRunId);
        HashMap validationLabelMap = new HashMap();
        BiFunction<TestingStatuses, TestingStatuses, TestingStatuses> statusMergeFunc = (oldStatus, newStatus) -> {
            if (TestingStatuses.FAILED.equals(newStatus) || TestingStatuses.FAILED.equals(oldStatus)) {
                return TestingStatuses.FAILED;
            }
            return newStatus;
        };
        logRecords.forEach(logRecord -> {
            List validationSteps;
            ValidationTable validationTable;
            Set logRecordValidationLabels = logRecord.getValidationLabels();
            if (!CollectionUtils.isEmpty((Collection)logRecordValidationLabels)) {
                logRecordValidationLabels.forEach(label -> validationLabelMap.merge(label, logRecord.getTestingStatus(), statusMergeFunc));
            }
            if (Objects.nonNull(validationTable = logRecord.getValidationTable()) && !CollectionUtils.isEmpty((Collection)(validationSteps = validationTable.getSteps()))) {
                validationSteps.stream().filter(step -> !CollectionUtils.isEmpty((Collection)step.getValidationLabels())).forEach(step -> step.getValidationLabels().forEach(label -> validationLabelMap.merge(label, step.getStatus(), statusMergeFunc)));
            }
        });
        List<TestingReportLabelParam> validationLabelsMap = validationLabelMap.entrySet().stream().map(entry -> new TestingReportLabelParam((String)entry.getKey(), (TestingStatuses)entry.getValue())).collect(Collectors.toList());
        log.debug("Result map: {}", validationLabelsMap);
        return validationLabelsMap;
    }

    public void unsetRootCauseForLinkedTestRuns(UUID rootCauseId) {
        log.debug("Unset root cause '{}' for linked test runs", (Object)rootCauseId);
        List updTestRuns = this.testRunRepository.findAllByRootCauseId(rootCauseId).stream().peek(testRun -> testRun.setRootCauseId(null)).collect(Collectors.toList());
        this.testRunRepository.saveAll(updTestRuns);
    }

    public List<TestRun> getTestRunsIdByExecutionRequestIdAndTestingStatus(UUID executionRequestId, TestingStatuses testingStatuses) {
        return this.testRunRepository.findTestRunsIdByExecutionRequestIdAndTestingStatus(executionRequestId, testingStatuses);
    }

    public List<TestRun> getTestRunsIdByExecutionRequestIdAndTestingStatuses(UUID executionRequestId, List<TestingStatuses> testingStatuses) {
        return this.testRunRepository.findTestRunsByExecutionRequestIdAndTestingStatusIn(executionRequestId, testingStatuses);
    }

    public List<TestRun> getTestRunsUuidTestingStatusErIdByUuidIn(List<UUID> testRunIds, TestingStatuses testingStatuses) {
        return this.testRunRepository.findTestRunsUuidErIdByTestingStatusAndUuidIn(testingStatuses, testRunIds);
    }

    public List<TestRun> getTestRunsUuidErIdByTestingStatusesAndUuidIn(List<UUID> testRunIds, List<TestingStatuses> testingStatuses) {
        return this.testRunRepository.findTestRunsUuidErIdByTestingStatusInAndUuidIn(testingStatuses, testRunIds);
    }

    public List<TestRun> setFailureReasonToTestRuns(TestRunsFailureReasonSetBulkRequest request) {
        Set testRunIds = request.getTestRunIds();
        UUID failureReasonId = request.getFailureReasonId();
        log.info("Set failure reason '{}' to test runs: {}", (Object)failureReasonId, (Object)testRunIds);
        List<TestRun> testRuns = this.testRunRepository.findAllByUuidIn(testRunIds);
        testRuns.forEach(testRun -> testRun.setRootCauseId(failureReasonId));
        return this.testRunRepository.saveAll(testRuns);
    }

    public void updateTestRunsTestingStatus(List<TestingStatusUpdateRequest> testingStatusUpdateRequests) {
        Map<UUID, String> testingStatusesUpdMap = testingStatusUpdateRequests.stream().collect(Collectors.toMap(TestingStatusUpdateRequest::getTestRunId, TestingStatusUpdateRequest::getTestingStatus));
        List<TestRun> testRuns = this.testRunRepository.findAllByUuidIn(new ArrayList<UUID>(testingStatusesUpdMap.keySet()));
        for (TestRun testRun : testRuns) {
            TestingStatuses status = TestingStatuses.findByValue((String)testingStatusesUpdMap.get(testRun.getUuid()));
            testRun.setTestingStatus(status);
        }
        this.testRunRepository.saveAll(testRuns);
    }

    public TestRun updTestingStatusHard(UUID uuid, TestingStatuses testingStatuses) {
        TestRun testRun = this.getByUuid(uuid);
        log.info("Status update for Test Run [{}]. Old status [{}]. New status [{}].", new Object[]{uuid, testRun.getTestingStatus(), testingStatuses});
        this.updateStatusAndPropagateTestCase(testRun, testingStatuses);
        return this.save(testRun);
    }

    public TestRun updTestingStatusHardAndBrowserNames(TestRun testRun, TestingStatuses testingStatuses, List<String> browserNames) {
        this.updateStatusAndPropagateTestCase(testRun, testingStatuses);
        testRun.setBrowserNames(browserNames);
        return this.save(testRun);
    }

    private void updateStatusAndPropagateTestCase(TestRun testRun, TestingStatuses testingStatuses) {
        testRun.setTestingStatus(testingStatuses);
        TestRun lastRun = this.getByTestCase(testRun.getTestCaseId());
        if (testRun.getUuid().equals(lastRun.getUuid())) {
            this.testCaseService.updateCaseStatuses(Collections.singletonList(testRun));
        }
    }

    public List<TestRunsRatesResponse> getTestRunsRatesWithFailedLr(UUID executionRequestId) {
        List<TestRunsRatesResponse> response = this.testRunRepository.findTestRunsRatesResponseByExecutionRequestId(executionRequestId);
        Map<UUID, String> rootCauseMap = this.getRootCauseNamesMap(StreamUtils.extractIds(response, TestRunsRatesResponse::getRootCauseId));
        Map<UUID, TestCase> testCaseMap = this.getTestRunTestCasesMap(StreamUtils.extractIds(response, TestRunsRatesResponse::getTestCaseId));
        response.forEach(testRun -> {
            TestCase testCase;
            testRun.setLinkToTestRunJira(testRun.getJiraTicket());
            testRun.setEndDate(testRun.getFinishDate());
            String rootCauseName = (String)rootCauseMap.get(testRun.getRootCauseId());
            if (Objects.nonNull(rootCauseName)) {
                testRun.setFailureReason(rootCauseName);
            }
            if (Objects.nonNull(testCase = (TestCase)testCaseMap.get(testRun.getTestCaseId()))) {
                testRun.setLinkToTestRunJira(testCase.getJiraTicket());
                testRun.setTestScenarioId(testCase.getTestScenarioUuid());
            }
            testRun.setFirstFailedLogrecord(this.getFailedLogRecord(testRun.getUuid()));
        });
        return response;
    }

    private LogRecordRatesResponse getFailedLogRecord(UUID testRunId) {
        LogRecordWithChildrenResponse parentLr = this.logRecordService.getLogRecordWithChildrenByTrIdAndStatus(testRunId, TestingStatuses.FAILED);
        if (parentLr == null) {
            return new LogRecordRatesResponse();
        }
        parentLr.setMessage(parentLr.getChildren().getMessage());
        return parentLr;
    }

    private Map<UUID, TestCase> getTestRunTestCasesMap(Set<UUID> testRunsId) {
        List<TestCase> testCases;
        CaseSearchRequest caseSearchRequest = new CaseSearchRequest(testRunsId);
        try {
            testCases = this.catalogueService.getTestCases(caseSearchRequest);
        }
        catch (Exception e) {
            log.error("Cannot collect test cases from catalog.", (Throwable)e);
            testCases = new ArrayList<TestCase>();
        }
        return StreamUtils.toIdEntityMap(testCases, RamObject::getUuid);
    }

    public List<TestRun> findAllByUuidInAndExecutionStatusIn(List<UUID> testRunIds, List<ExecutionStatuses> list) {
        return this.testRunRepository.findAllByUuidInAndExecutionStatusIn(testRunIds, list);
    }

    public void finishTestRun(TestRun testRun, boolean isDelayed) {
        if (!this.isFinalStatus(testRun.getExecutionStatus())) {
            testRun.setExecutionStatus(ExecutionStatuses.FINISHED);
        }
        log.trace("Test Run {} execution status is set to {}", (Object)testRun.getUuid(), (Object)testRun.getExecutionStatus());
        if (!isDelayed) {
            testRun.setFinishDate(new Timestamp(System.currentTimeMillis()));
            testRun.setDuration(TimeUtils.getDuration(testRun.getStartDate(), testRun.getFinishDate()));
            log.trace("Finish date {} and duration {} are set for Test Run {}", new Object[]{testRun.getFinishDate(), testRun.getDuration(), testRun.getUuid()});
        }
    }

    private boolean isFinalStatus(ExecutionStatuses executionStatus) {
        return ExecutionStatuses.FINISHED == executionStatus || ExecutionStatuses.TERMINATED == executionStatus || ExecutionStatuses.TERMINATED_BY_TIMEOUT == executionStatus;
    }

    public void setCommentToTestRuns(TestRunsCommentSetBulkRequest request) {
        List testRunIds = request.getTestRunIds();
        Comment comment = request.getComment();
        List<TestRun> testRuns = this.getByIds(testRunIds);
        if (!CollectionUtils.isEmpty(testRuns)) {
            testRuns.forEach(testRun -> testRun.setComment(comment));
            this.testRunRepository.saveAll(testRuns);
        }
    }

    public void setFinalTestRuns(SetBulkFinalTestRuns request) {
        List testRunIds = request.getTestRunIds();
        List<TestRun> updateTestRunsList = this.getByIds(testRunIds);
        UUID executionRequestId = request.getExecutionRequestId();
        ArrayList testCasesList = new ArrayList();
        if (!CollectionUtils.isEmpty(updateTestRunsList)) {
            updateTestRunsList.forEach(testRun -> {
                testRun.setFinalTestRun(true);
                testCasesList.add(testRun.getTestCaseId());
            });
        }
        ArrayList<ExecutionRequest> targetExecutionRequests = new ArrayList<ExecutionRequest>();
        ExecutionRequest executionRequest = this.executionRequestRepository.findByUuid(executionRequestId);
        UUID initialExecutionRequestId = executionRequest.getInitialExecutionRequestId();
        if (Objects.nonNull(initialExecutionRequestId)) {
            List<ExecutionRequest> rerunExecutionRequests = this.executionRequestRepository.findAllByInitialExecutionRequestId(initialExecutionRequestId);
            ExecutionRequest initialExecutionRequest = this.executionRequestRepository.findByUuid(initialExecutionRequestId);
            targetExecutionRequests.addAll(rerunExecutionRequests);
            targetExecutionRequests.add(initialExecutionRequest);
            targetExecutionRequests.remove(executionRequest);
        } else {
            List<ExecutionRequest> rerunExecutionRequests = this.executionRequestRepository.findAllByInitialExecutionRequestId(executionRequestId);
            targetExecutionRequests.addAll(rerunExecutionRequests);
        }
        if (!CollectionUtils.isEmpty(targetExecutionRequests)) {
            targetExecutionRequests.forEach(execRequest -> {
                List<TestRun> intermediateTestRunsList = this.testRunRepository.findAllByExecutionRequestId(execRequest.getUuid()).stream().filter(testRun -> testRun.isFinalTestRun() && testCasesList.contains(testRun.getTestCaseId())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(intermediateTestRunsList)) {
                    intermediateTestRunsList.forEach(testRun -> {
                        testRun.setFinalTestRun(false);
                        updateTestRunsList.add((TestRun)testRun);
                    });
                }
            });
        }
        this.testRunRepository.saveAll(updateTestRunsList);
    }

    public Long getCountLrsForCurrentEr(UUID executionRequestId) {
        List<TestRun> testRuns = this.testRunRepository.findTestRunsIdByExecutionRequestId(executionRequestId);
        Set<UUID> testRunIds = StreamUtils.extractIds(testRuns);
        return this.logRecordService.countLrsByTestRunsId(testRunIds);
    }

    public List<TestRun> findTestRunsWithScreenshotsByExecutionRequestId(UUID executionRequestId) {
        return this.testRunRepository.findTestRunsByExecutionRequestId(executionRequestId);
    }

    @Cacheable(value={"testRunsInfo"})
    public List<TestRunWithValidationLabelsResponse> findTestRunsByNamesLabelsValidationLabels(UUID executionRequestId, TestRunsByValidationLabelsRequest filter) {
        ArrayList<UUID> labelIds = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)filter.getLabelsPath())) {
            labelIds = filter.getLabelsPath().stream().map(LabelRequest::getId).collect(Collectors.toList());
        }
        log.debug("Get test runs by execution request {} and labels {}", (Object)executionRequestId, (Object)filter.getLabelsPath());
        List<TestRun> testRuns = this.testRunRepository.findTestRunsByExecutionRequestIdAndNamesAndLabelIds(executionRequestId, filter.getTestRunNames(), labelIds);
        List<UUID> testRunIds = StreamUtils.extractIdsToList(testRuns);
        log.debug("Get log records for test runs {}", testRunIds);
        List<LogRecord> logRecords = this.logRecordService.getAllLogRecordsByTestRunIds(testRunIds);
        HashMap testRunIdAndValidationLabelsMap = new HashMap();
        for (TestRun testRun2 : testRuns) {
            List testRunLogRecords = logRecords.stream().filter(logRecord -> testRun2.getUuid().equals(logRecord.getTestRunId())).collect(Collectors.toList());
            HashSet validationLabels = new HashSet();
            for (LogRecord logRecord2 : testRunLogRecords) {
                if (CollectionUtils.isEmpty((Collection)logRecord2.getValidationLabels())) continue;
                validationLabels.addAll(logRecord2.getValidationLabels());
            }
            testRunIdAndValidationLabelsMap.put(testRun2.getUuid(), validationLabels);
        }
        ArrayList<TestRunWithValidationLabelsResponse> result = new ArrayList<TestRunWithValidationLabelsResponse>();
        if (!CollectionUtils.isEmpty((Collection)filter.getValidationLabelFilters())) {
            testRuns.forEach(testRun -> {
                Set testRunValidationLabels;
                if (testRunIdAndValidationLabelsMap.containsKey(testRun.getUuid()) && this.isTestRunMatchesValidationLabelsFilter((TestRun)testRun, testRunValidationLabels = (Set)testRunIdAndValidationLabelsMap.get(testRun.getUuid()), filter.getValidationLabelFilters())) {
                    result.add(new TestRunWithValidationLabelsResponse(testRun, testRunValidationLabels));
                }
            });
        } else {
            testRuns.forEach(testRun -> {
                if (testRunIdAndValidationLabelsMap.containsKey(testRun.getUuid())) {
                    Set testRunValidationLabels = (Set)testRunIdAndValidationLabelsMap.get(testRun.getUuid());
                    result.add(new TestRunWithValidationLabelsResponse(testRun, testRunValidationLabels));
                } else {
                    result.add(new TestRunWithValidationLabelsResponse(testRun, new HashSet()));
                }
            });
        }
        return result;
    }

    private boolean isTestRunMatchesValidationLabelsFilter(TestRun testRun, Set<String> testRunValidationLabels, List<ValidationLabelFilterRequest> validationLabelFilters) {
        for (ValidationLabelFilterRequest validationLabelFilter : validationLabelFilters) {
            if (!validationLabelFilter.getStatuses().contains(VALIDATION_LABEL_N_A)) {
                if (!testRunValidationLabels.contains(validationLabelFilter.getName())) {
                    return false;
                }
                if (!validationLabelFilter.getStatuses().contains(testRun.getTestingStatus().getName().toUpperCase())) {
                    return false;
                }
            }
            if (!testRunValidationLabels.contains(validationLabelFilter.getName()) || validationLabelFilter.getStatuses().contains(testRun.getTestingStatus().getName().toUpperCase())) continue;
            return false;
        }
        return true;
    }

    public List<TestRunResponse> labelsPathSearch(LabelsPathSearchRequest searchRequest) {
        List<UUID> labelIds = searchRequest.getLabelsPath().stream().map(LabelRequest::getId).collect(Collectors.toList());
        List<TestRun> testRuns = this.testRunRepository.findTestRunsIdNameByExecutionRequestIdAndLabelIds(searchRequest.getExecutionRequestId(), labelIds);
        return testRuns.stream().map(testRun -> new TestRunResponse(testRun.getUuid(), testRun.getName())).collect(Collectors.toList());
    }

    public List<ContextVariable> getAllContextVariables(UUID testRunId) {
        List<LogRecord> logRecords = this.logRecordService.getAllLogRecordsUuidByTestRunId(testRunId);
        if (CollectionUtils.isEmpty(logRecords)) {
            return Collections.emptyList();
        }
        return this.logRecordService.getContextVariablesByIds(logRecords.stream().map(RamObject::getUuid).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public TestRunDefectsPropagationResponse propagateDefectsToComments(TestRunDefectsPropagationRequest request) {
        List<TestRun> testRuns;
        UUID executionRequestId = request.getExecutionRequestId();
        UUID testPlanId = this.executionRequestRepository.findByUuid(executionRequestId).getTestPlanId();
        Set<UUID> testRunIds = request.getTestRunIds();
        if (CollectionUtils.isEmpty((Collection)testRunIds)) {
            testRuns = this.findAllByExecutionRequestId(executionRequestId);
            testRunIds = StreamUtils.extractIds(testRuns);
        } else {
            testRuns = this.getByIds((Collection<UUID>)testRunIds);
        }
        TestRunDefectsPropagationResponse response = new TestRunDefectsPropagationResponse();
        Map<UUID, Set<JiraTicket>> testRunsIssuesMap = this.getTestRunsIssuesMap(executionRequestId, testRunIds);
        Map<String, JiraIssueDto> testRunsJiraIssuesMap = this.getTestRunJiraIssuesMap(testRunsIssuesMap, testPlanId);
        testRuns.forEach(testRun -> {
            try {
                Set issues = (Set)testRunsIssuesMap.get(testRun.getUuid());
                if (CollectionUtils.isEmpty((Collection)issues)) {
                    return;
                }
                Set<String> issueKeys = issues.stream().map(JiraTicket::getKey).collect(Collectors.toSet());
                Comment comment = testRun.getComment();
                if (comment == null) {
                    comment = new Comment();
                    testRun.setComment(comment);
                }
                String issueSummaries = this.getIssueSummary(issueKeys, testRunsJiraIssuesMap, issue -> issue.getKey() + " " + issue.getFields().getSummary());
                String text = comment.getText();
                text = (text != null ? text + "\n" : "") + issueSummaries;
                comment.setText(text);
                String issueHtmlSummaries = this.getIssueSummary(issueKeys, testRunsJiraIssuesMap, issue -> this.getIssueHtmlLink((JiraIssueDto)issue) + " " + issue.getFields().getSummary());
                String html = comment.getHtml();
                html = (html != null ? html + "\n" : "") + issueHtmlSummaries;
                comment.setHtml(html);
                this.save((TestRun)testRun);
                response.addSuccess(testRun);
            }
            catch (Exception e) {
                log.error("Error while updating comment for Test Run '{}'", (Object)testRun.getUuid(), (Object)e);
                response.addFailed(testRun);
            }
        });
        return response;
    }

    private Map<String, JiraIssueDto> getTestRunJiraIssuesMap(Map<UUID, Set<JiraTicket>> testRunsIssuesMap, UUID testPlanId) {
        Set<String> allIssueKeys = testRunsIssuesMap.values().stream().flatMap(Collection::stream).map(JiraTicket::getKey).collect(Collectors.toSet());
        HashSet fields = Sets.newHashSet((Object[])new String[]{"summary"});
        List<JiraIssueDto> jiraIssues = this.catalogueService.searchIssues(testPlanId, allIssueKeys, fields);
        return jiraIssues.stream().collect(Collectors.toMap(JiraIssueDto::getKey, Function.identity()));
    }

    private String getIssueSummary(Set<String> issueKeys, Map<String, JiraIssueDto> jiraIssuesMap, Function<JiraIssueDto, String> func) {
        return issueKeys.stream().map(jiraIssuesMap::get).filter(Objects::nonNull).map(func).collect(Collectors.joining("\n"));
    }

    private String getIssueHtmlLink(JiraIssueDto issue) {
        String self = issue.getSelf();
        String host = self.substring(0, self.indexOf("/rest"));
        String fullUrl = host + "/browse/" + issue.getKey();
        String htmlLinkPattern = "<a href=\"%s\" target=\"_blank\">%s</a>";
        return String.format("<a href=\"%s\" target=\"_blank\">%s</a>", fullUrl, issue.getKey());
    }

    public TestRunService(MongoTemplate mongoTemplate, LogRecordService logRecordService, TestRunRepository testRunRepository, RootCauseService rootCauseService, ProjectsService projectsService, TestPlansService testPlansService, ModelMapper modelMapper, CatalogueService catalogueService, DataSetListFeignClient dataSetListFeignClient, ExecutionRequestRepository executionRequestRepository, RootCauseRepository rootCauseRepository, TreeNodeService treeNodeService, TestCaseService testCaseService, IssueService issueService, PatchHelper patchHelper, LabelsService labelsService) {
        this.mongoTemplate = mongoTemplate;
        this.logRecordService = logRecordService;
        this.testRunRepository = testRunRepository;
        this.rootCauseService = rootCauseService;
        this.projectsService = projectsService;
        this.testPlansService = testPlansService;
        this.modelMapper = modelMapper;
        this.catalogueService = catalogueService;
        this.dataSetListFeignClient = dataSetListFeignClient;
        this.executionRequestRepository = executionRequestRepository;
        this.rootCauseRepository = rootCauseRepository;
        this.treeNodeService = treeNodeService;
        this.testCaseService = testCaseService;
        this.issueService = issueService;
        this.patchHelper = patchHelper;
        this.labelsService = labelsService;
    }
}

