/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services.sorting;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.qubership.atp.ram.comparators.ComplexListComparator;
import org.qubership.atp.ram.dto.response.FailPatternResponse;
import org.qubership.atp.ram.dto.response.IssueResponse;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class IssuesSortingService {
    private static final Logger log = LoggerFactory.getLogger(IssuesSortingService.class);
    private static final ComplexListComparator<String> STRING_LIST_COMPARATOR = new ComplexListComparator(Comparator.naturalOrder());
    private final Map<String, Comparator<IssueResponse>> fieldToAscComparatorMap = ImmutableMap.builder().put((Object)"message", Comparator.comparing(IssueResponse::getMessage)).put((Object)"priority", Comparator.comparing(IssueResponse::getPriority)).put((Object)"failPattern", Comparator.comparing(IssuesSortingService::getFailPatternNameForComparator)).put((Object)"failReason", Comparator.comparing(IssuesSortingService::getFailReasonNameForComparator)).put((Object)"failedCasesCount", Comparator.comparing(resp -> resp.getTestRuns().size())).put((Object)"failedTestRuns", (first, second) -> STRING_LIST_COMPARATOR.compare(StreamUtils.extractNames(first.getTestRuns()), StreamUtils.extractNames(second.getTestRuns()))).put((Object)"jiraTickets", (first, second) -> STRING_LIST_COMPARATOR.compare(first.getJiraTickets(), second.getJiraTickets())).build();
    private final Map<String, Function<IssueResponse, Object>> fieldNameToFieldMethodMap = ImmutableMap.builder().put((Object)"message", IssueResponse::getMessage).put((Object)"priority", IssueResponse::getPriority).put((Object)"failPattern", IssueResponse::getFailPattern).put((Object)"failReason", IssueResponse::getFailReason).put((Object)"failedCasesCount", resp -> resp.getTestRuns().size()).put((Object)"failedTestRuns", resp -> StreamUtils.extractNames(resp.getTestRuns())).put((Object)"jiraTickets", IssueResponse::getJiraTickets).build();

    public List<IssueResponse> applySorting(List<IssueResponse> responses, String columnType, Sort.Direction sortDirection) {
        List<IssueResponse> result = responses;
        if (columnType != null) {
            Comparator<IssueResponse> comparator = this.fieldToAscComparatorMap.get(columnType);
            Map<Boolean, List<IssueResponse>> listByFieldIsNullPartition = this.partitionListByFieldIsNull(responses, columnType);
            List<IssueResponse> issuesWithSortFieldIsNull = listByFieldIsNullPartition.get(true);
            List<IssueResponse> issuesWithSortFieldIsNotNull = listByFieldIsNullPartition.get(false);
            this.applySortingToItemsWithNotNullField(issuesWithSortFieldIsNotNull, columnType, sortDirection, comparator);
            result = new ArrayList<IssueResponse>(issuesWithSortFieldIsNotNull);
            result.addAll(issuesWithSortFieldIsNull);
        }
        return result;
    }

    private void applySortingToItemsWithNotNullField(List<IssueResponse> responses, String columnType, Sort.Direction sortDirection, Comparator<IssueResponse> comparator) {
        if (comparator != null) {
            if (sortDirection == Sort.Direction.DESC) {
                comparator = comparator.reversed();
            }
            responses.sort(comparator);
        } else {
            log.warn("Cannot sort issues by {}, skipping sorting...", (Object)columnType);
        }
    }

    private Map<Boolean, List<IssueResponse>> partitionListByFieldIsNull(List<IssueResponse> responses, String columnType) {
        Function<IssueResponse, Object> fieldExtractor = this.fieldNameToFieldMethodMap.get(columnType);
        return responses.stream().collect(Collectors.partitioningBy(item -> fieldExtractor.apply((IssueResponse)item) == null));
    }

    private static String getFailPatternNameForComparator(IssueResponse issueResponse) {
        return issueResponse.getFailPattern() != null ? issueResponse.getFailPattern().getName() : "";
    }

    private static String getFailReasonNameForComparator(IssueResponse issueResponse) {
        FailPatternResponse failPattern = issueResponse.getFailPattern();
        boolean failReasonExists = failPattern != null && failPattern.getFailReason() != null;
        return failReasonExists ? failPattern.getFailReason().getName() : "";
    }
}

