/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.utils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ListUtils {
    public static <T> List<T> applyPagination(List<T> data, Integer page, Integer size) {
        return ListUtils.applyPagination(data, page, size, null);
    }

    public static <T> List<T> applyPagination(List<T> data, Integer page, Integer size, Integer shift) {
        if (Objects.nonNull(shift)) {
            data = data.subList(shift, data.size());
        }
        int startIndex = page * size;
        int endIndex = startIndex + size;
        return ListUtils.applyPaginationByIndexes(data, startIndex, endIndex);
    }

    public static <T> List<T> applyPaginationByIndexes(List<T> data, Integer startIndex, Integer endIndex) {
        if (startIndex > data.size()) {
            return Collections.emptyList();
        }
        return data.subList(startIndex, Math.min(data.size(), endIndex));
    }
}

